"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MessageParserRunner = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

class MessageParserRunner {
  constructor(messageParsers) {
    this.messageParsers = messageParsers;
  }
  async run(interaction, options) {
    const sortedParsers = [...this.messageParsers];
    sortedParsers.sort((parserA, parserB) => {
      const {
        order: orderA = 999
      } = parserA;
      const {
        order: orderB = 999
      } = parserB;
      return orderA - orderB;
    });
    let results = [];
    /**
     * Use a variable to record the index.
     */
    let messageIndex = -1;
    for (const messageParser of sortedParsers) {
      let tempResult = [];
      try {
        tempResult = await messageParser.parserProvider(interaction, options);
        /**
         * Make sure the tempResult is an array.
         */
        if (!Array.isArray(tempResult)) {
          tempResult = [];
        }
      } catch (e) {
        tempResult = [];
      }
      results = [...results, ...tempResult.map(item => {
        messageIndex++;
        return {
          ...item,
          messageId: `${interaction.interaction_id}_${messageIndex}`
        };
      })];
    }
    return results;
  }
}
exports.MessageParserRunner = MessageParserRunner;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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