"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.computeChartDimensions = void 0;
var axes_sizes_1 = require("../axes/axes_sizes");
function computeChartDimensions(parentDimensions, theme, axisDimensions, axesStyles, axisSpecs, smSpec) {
    if (parentDimensions.width <= 0 || parentDimensions.height <= 0) {
        return {
            chartDimensions: {
                width: 0,
                height: 0,
                left: 0,
                top: 0,
            },
            leftMargin: 0,
        };
    }
    var axisSizes = axes_sizes_1.computeAxesSizes(theme, axisDimensions, axesStyles, axisSpecs, smSpec);
    var chartWidth = parentDimensions.width - axisSizes.left - axisSizes.right;
    var chartHeight = parentDimensions.height - axisSizes.top - axisSizes.bottom;
    var chartPaddings = theme.chartPaddings;
    var top = axisSizes.top + chartPaddings.top;
    var left = axisSizes.left + chartPaddings.left;
    return {
        leftMargin: axisSizes.margin.left,
        chartDimensions: {
            top: top,
            left: left,
            width: chartWidth - chartPaddings.left - chartPaddings.right,
            height: chartHeight - chartPaddings.top - chartPaddings.bottom,
        },
    };
}
exports.computeChartDimensions = computeChartDimensions;
//# sourceMappingURL=dimensions.js.map