/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.library.types;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Set;
import javax.measure.Quantity;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.items.GroupFunction;
import org.openhab.core.items.GroupItem;
import org.openhab.core.items.Item;
import org.openhab.core.library.items.NumberItem;
import org.openhab.core.library.types.QuantityType;
import org.openhab.core.types.PrimitiveType;
import org.openhab.core.types.State;
import org.openhab.core.types.UnDefType;

@NonNullByDefault
public interface QuantityTypeArithmeticGroupFunction
extends GroupFunction {

    public static class Avg
    extends DimensionalGroupFunction {
        public Avg(Class<? extends Quantity<?>> dimension) {
            super(dimension);
        }

        @Override
        public State calculate(@Nullable Set<Item> items) {
            if (items == null || items.isEmpty()) {
                return UnDefType.UNDEF;
            }
            QuantityType sum = null;
            int count = 0;
            for (Item item : items) {
                QuantityType itemState;
                if (!this.isSameDimension(item) || (itemState = item.getStateAs(QuantityType.class)) == null) continue;
                if (sum == null) {
                    sum = itemState;
                    ++count;
                    continue;
                }
                if ((itemState = itemState.toInvertibleUnit(sum.getUnit())) == null) continue;
                sum = sum.add(itemState);
                ++count;
            }
            if (sum != null && count > 0) {
                BigDecimal result = sum.toBigDecimal().divide(BigDecimal.valueOf(count), MathContext.DECIMAL128);
                return new QuantityType(result, sum.getUnit());
            }
            return UnDefType.UNDEF;
        }
    }

    public static abstract class DimensionalGroupFunction
    implements GroupFunction {
        protected final Class<? extends Quantity<?>> dimension;

        public DimensionalGroupFunction(Class<? extends Quantity<?>> dimension) {
            this.dimension = dimension;
        }

        @Override
        public <T extends State> @Nullable T getStateAs(@Nullable Set<Item> items, Class<T> stateClass) {
            State state = this.calculate(items);
            if (stateClass.isInstance(state)) {
                return (T)((State)stateClass.cast(state));
            }
            return null;
        }

        @Override
        public State[] getParameters() {
            return new State[0];
        }

        /*
         * WARNING - void declaration
         */
        protected boolean isSameDimension(@Nullable Item item) {
            Item item2 = item;
            if (item2 instanceof GroupItem) {
                void groupItem;
                GroupItem groupItem2 = (GroupItem)item2;
                GroupItem cfr_ignored_0 = (GroupItem)item2;
                return this.isSameDimension(groupItem.getBaseItem());
            }
            Item item3 = item;
            if (item3 instanceof NumberItem) {
                void ni;
                NumberItem numberItem = (NumberItem)item3;
                NumberItem cfr_ignored_1 = (NumberItem)item3;
                if (this.dimension.equals(ni.getDimension())) {
                    return true;
                }
            }
            return false;
        }
    }

    public static class Max
    extends DimensionalGroupFunction {
        public Max(Class<? extends Quantity<?>> dimension) {
            super(dimension);
        }

        @Override
        public State calculate(@Nullable Set<Item> items) {
            if (items == null || items.isEmpty()) {
                return UnDefType.UNDEF;
            }
            PrimitiveType max = null;
            for (Item item : items) {
                QuantityType itemState;
                if (!this.isSameDimension(item) || (itemState = item.getStateAs(QuantityType.class)) == null || max != null && (!((QuantityType)max).getUnit().isCompatible(itemState.getUnit()) || ((QuantityType)max).compareTo(itemState) >= 0)) continue;
                max = itemState;
            }
            return max != null ? max : UnDefType.UNDEF;
        }
    }

    public static class Min
    extends DimensionalGroupFunction {
        public Min(Class<? extends Quantity<?>> dimension) {
            super(dimension);
        }

        @Override
        public State calculate(@Nullable Set<Item> items) {
            if (items == null || items.isEmpty()) {
                return UnDefType.UNDEF;
            }
            PrimitiveType min = null;
            for (Item item : items) {
                QuantityType itemState;
                if (!this.isSameDimension(item) || (itemState = item.getStateAs(QuantityType.class)) == null || min != null && (!((QuantityType)min).getUnit().isCompatible(itemState.getUnit()) || ((QuantityType)min).compareTo(itemState) <= 0)) continue;
                min = itemState;
            }
            return min != null ? min : UnDefType.UNDEF;
        }
    }

    public static class Sum
    extends DimensionalGroupFunction {
        public Sum(Class<? extends Quantity<?>> dimension) {
            super(dimension);
        }

        @Override
        public State calculate(@Nullable Set<Item> items) {
            if (items == null || items.isEmpty()) {
                return UnDefType.UNDEF;
            }
            PrimitiveType sum = null;
            for (Item item : items) {
                QuantityType itemState;
                if (!this.isSameDimension(item) || (itemState = item.getStateAs(QuantityType.class)) == null) continue;
                if (sum == null) {
                    sum = itemState;
                    continue;
                }
                if ((itemState = itemState.toUnit(((QuantityType)sum).getUnit())) == null) continue;
                sum = ((QuantityType)sum).add(itemState);
            }
            return sum != null ? sum : UnDefType.UNDEF;
        }
    }
}

