/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class FastByteArrayOutputStream
extends OutputStream {
    protected int count;
    protected byte[] buf;
    public static final int DEFAULT_SIZE = 512;

    public FastByteArrayOutputStream() {
        this.buf = new byte[512];
    }

    public FastByteArrayOutputStream(int bufferSize) {
        this.buf = new byte[bufferSize];
    }

    public FastByteArrayOutputStream(byte[] buf) {
        this.buf = buf;
    }

    @Override
    public void close() {
    }

    public void reset() {
        this.count = 0;
    }

    public int size() {
        return this.count;
    }

    public byte[] toByteArray() {
        byte[] buf = new byte[this.count];
        System.arraycopy(this.buf, 0, buf, 0, this.count);
        return buf;
    }

    public String toString() {
        return new String(this.buf, 0, this.count);
    }

    public String toString(String enc) throws UnsupportedEncodingException {
        return new String(this.buf, 0, this.count, enc);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        this.ensureCapacity(this.count + len);
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count += len;
    }

    @Override
    public void write(int b) {
        this.ensureCapacity(this.count + 1);
        this.buf[this.count++] = (byte)b;
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this.buf, 0, this.count);
    }

    @Override
    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public final void ensureCapacity(int minCapacity) {
        if (minCapacity < this.buf.length) {
            return;
        }
        byte[] newbuf = new byte[minCapacity];
        System.arraycopy(this.buf, 0, newbuf, 0, this.count);
        this.buf = newbuf;
    }

    public void toByteArray(byte[] b, int offset) {
        if (offset >= b.length) {
            throw new IndexOutOfBoundsException();
        }
        int len = this.count - offset;
        if (len > b.length) {
            System.arraycopy(this.buf, offset, b, offset, b.length);
        } else {
            System.arraycopy(this.buf, offset, b, offset, len);
        }
    }

    public byte[] getBuffer() {
        return this.buf;
    }
}

