/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.rest.transform.internal;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.io.rest.RESTResource;
import org.openhab.core.io.rest.Stream2JSONInputStream;
import org.openhab.core.io.rest.transform.TransformationDTO;
import org.openhab.core.transform.ManagedTransformationProvider;
import org.openhab.core.transform.Transformation;
import org.openhab.core.transform.TransformationRegistry;
import org.openhab.core.transform.TransformationService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JSONRequired;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsApplicationSelect;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsName;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="transformations")
@RolesAllowed(value={"administrator"})
@SecurityRequirement(name="oauth2", scopes={"admin"})
@Tag(name="transformations")
@Component(immediate=true)
@JaxrsResource
@JaxrsName(value="transformations")
@JaxrsApplicationSelect(value="(osgi.jaxrs.name=openhab)")
@JSONRequired
@NonNullByDefault
public class TransformationResource
implements RESTResource {
    public static final String PATH_TRANSFORMATIONS = "transformations";
    private final Logger logger = LoggerFactory.getLogger(TransformationResource.class);
    private final TransformationRegistry transformationRegistry;
    private final ManagedTransformationProvider managedTransformationProvider;
    private final BundleContext bundleContext;
    @Context
    @NonNullByDefault(value={})
    private UriInfo uriInfo;

    @Activate
    public TransformationResource(@Reference TransformationRegistry transformationRegistry, @Reference ManagedTransformationProvider managedTransformationProvider, BundleContext bundleContext) {
        this.transformationRegistry = transformationRegistry;
        this.managedTransformationProvider = managedTransformationProvider;
        this.bundleContext = bundleContext;
    }

    @GET
    @Produces(value={"application/json"})
    @Operation(operationId="getTransformations", summary="Get a list of all transformations", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=TransformationDTO.class)))})})
    public Response getTransformations() {
        this.logger.debug("Received HTTP GET request at '{}'", (Object)this.uriInfo.getPath());
        Stream<TransformationDTO> stream = this.transformationRegistry.stream().map(TransformationDTO::new).peek(c -> {
            boolean bl = c.editable = this.isEditable(c.uid);
        });
        return Response.ok((Object)new Stream2JSONInputStream(stream)).build();
    }

    @GET
    @Path(value="services")
    @Produces(value={"application/json"})
    @Operation(operationId="getTransformationServices", summary="Get all transformation services", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=String.class)))})})
    public Response getTransformationServices() {
        try {
            Collection refs = this.bundleContext.getServiceReferences(TransformationService.class, null);
            Stream<String> services = refs.stream().map(ref -> (String)ref.getProperty("openhab.transform")).filter(Objects::nonNull).map(Objects::requireNonNull).sorted();
            return Response.ok((Object)new Stream2JSONInputStream(services)).build();
        }
        catch (InvalidSyntaxException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="{uid}")
    @Produces(value={"application/json"})
    @Operation(operationId="getTransformation", summary="Get a single transformation", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=Transformation.class))}), @ApiResponse(responseCode="404", description="Not found")})
    public Response getTransformation(@PathParam(value="uid") @Parameter(description="Transformation UID") String uid) {
        this.logger.debug("Received HTTP GET request at '{}'", (Object)this.uriInfo.getPath());
        Transformation transformation = (Transformation)this.transformationRegistry.get((Object)uid);
        if (transformation == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        TransformationDTO dto = new TransformationDTO(transformation);
        dto.editable = this.isEditable(uid);
        return Response.ok((Object)dto).build();
    }

    @PUT
    @Path(value="{uid}")
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    @Operation(operationId="putTransformation", summary="Put a single transformation", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="400", description="Bad Request (content missing or invalid)"), @ApiResponse(responseCode="405", description="Transformation not editable")})
    public Response putTransformation(@PathParam(value="uid") @Parameter(description="Transformation UID") String uid, @Parameter(description="transformation", required=true) @Nullable TransformationDTO newTransformation) {
        this.logger.debug("Received HTTP PUT request at '{}'", (Object)this.uriInfo.getPath());
        Transformation oldTransformation = (Transformation)this.transformationRegistry.get((Object)uid);
        if (oldTransformation != null && !this.isEditable(uid)) {
            return Response.status((Response.Status)Response.Status.METHOD_NOT_ALLOWED).build();
        }
        if (newTransformation == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Content missing.").build();
        }
        if (!uid.equals(newTransformation.uid)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"UID of transformation and path not matching.").build();
        }
        Transformation transformation = new Transformation(newTransformation.uid, newTransformation.label, newTransformation.type, newTransformation.configuration);
        try {
            if (oldTransformation != null) {
                this.managedTransformationProvider.update(transformation);
            } else {
                this.managedTransformationProvider.add(transformation);
            }
        }
        catch (IllegalArgumentException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)Objects.requireNonNullElse(e.getMessage(), "")).build();
        }
        return Response.ok().build();
    }

    @DELETE
    @Path(value="{uid}")
    @Produces(value={"text/plain"})
    @Operation(operationId="deleteTransformation", summary="Get a single transformation", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="UID not found"), @ApiResponse(responseCode="405", description="Transformation not editable")})
    public Response deleteTransformation(@PathParam(value="uid") @Parameter(description="Transformation UID") String uid) {
        this.logger.debug("Received HTTP DELETE request at '{}'", (Object)this.uriInfo.getPath());
        Transformation oldTransformation = (Transformation)this.transformationRegistry.get((Object)uid);
        if (oldTransformation == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (!this.isEditable(uid)) {
            return Response.status((Response.Status)Response.Status.METHOD_NOT_ALLOWED).build();
        }
        this.managedTransformationProvider.remove((Object)uid);
        return Response.ok().build();
    }

    private boolean isEditable(String uid) {
        return this.managedTransformationProvider.get((Object)uid) != null;
    }
}

