/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.datatypes;

import io.netty.buffer.ByteBuf;
import org.jetbrains.annotations.NotNull;

public final class MqttVariableByteInteger {
    public static final int NOT_ENOUGH_BYTES = -1;
    public static final int TOO_LARGE = -2;
    public static final int NOT_MINIMUM_BYTES = -3;
    private static final int CONTINUATION_BIT_MASK = 128;
    private static final int VALUE_MASK = 127;
    private static final byte VALUE_BITS = 7;
    private static final int MAX_SHIFT = 21;
    private static final int ONE_BYTE_MAX_VALUE = 127;
    private static final int TWO_BYTES_MAX_VALUE = 16383;
    private static final int THREE_BYTES_MAX_VALUE = 0x1FFFFF;
    public static final int FOUR_BYTES_MAX_VALUE = 0xFFFFFFF;
    public static final int MAXIMUM_PACKET_SIZE_LIMIT = 0x10000004;

    public static int decode(@NotNull ByteBuf byteBuf) {
        byte encodedByte;
        int value = 0;
        int shift = 0;
        do {
            if (shift > 21) {
                return -2;
            }
            if (!byteBuf.isReadable()) {
                return -1;
            }
            encodedByte = byteBuf.readByte();
            int encodedByteValue = encodedByte & 0x7F;
            value += encodedByteValue << shift;
            shift = (byte)(shift + 7);
        } while ((encodedByte & 0x80) != 0);
        if (shift > 7 && encodedByte == 0) {
            return -3;
        }
        return value;
    }

    public static void encode(int value, @NotNull ByteBuf byteBuf) {
        do {
            int encodedByte = value & 0x7F;
            if ((value >>>= 7) > 0) {
                encodedByte |= 0x80;
            }
            byteBuf.writeByte(encodedByte);
        } while (value > 0);
    }

    public static boolean isInRange(int value) {
        return value >= 0 && value <= 0xFFFFFFF;
    }

    public static int encodedLength(int value) {
        int length = 1;
        if (value > 127) {
            ++length;
            if (value > 16383) {
                ++length;
                if (value > 0x1FFFFF) {
                    ++length;
                }
            }
        }
        return length;
    }

    private MqttVariableByteInteger() {
    }
}

