/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j.adapters;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.List;
import org.eclipse.lsp4j.ClientCapabilities;
import org.eclipse.lsp4j.ClientInfo;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.WorkspaceFolder;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class InitializeParamsTypeAdapter
extends TypeAdapter<InitializeParams> {
    private static final TypeToken<Either<String, Integer>> WORKDONETOKEN_TYPE_TOKEN = new TypeToken<Either<String, Integer>>(){};
    private static final TypeToken<List<WorkspaceFolder>> WORKSPACEFOLDERS_TYPE_TOKEN = new TypeToken<List<WorkspaceFolder>>(){};
    private final Gson gson;

    protected Object readInitializationOptions(JsonReader in) throws IOException {
        return this.gson.getAdapter(JsonElement.class).read(in);
    }

    protected void writeProcessId(JsonWriter out, Integer value) throws IOException {
        if (value == null) {
            boolean previousSerializeNulls = out.getSerializeNulls();
            out.setSerializeNulls(true);
            out.nullValue();
            out.setSerializeNulls(previousSerializeNulls);
        } else {
            out.value((Number)value);
        }
    }

    protected void writeRootUri(JsonWriter out, String value) throws IOException {
        if (value == null) {
            boolean previousSerializeNulls = out.getSerializeNulls();
            out.setSerializeNulls(true);
            out.nullValue();
            out.setSerializeNulls(previousSerializeNulls);
        } else {
            out.value(value);
        }
    }

    public InitializeParamsTypeAdapter(Gson gson) {
        this.gson = gson;
    }

    public InitializeParams read(JsonReader in) throws IOException {
        JsonToken nextToken = in.peek();
        if (nextToken == JsonToken.NULL) {
            return null;
        }
        InitializeParams result = new InitializeParams();
        in.beginObject();
        block24: while (in.hasNext()) {
            String name;
            switch (name = in.nextName()) {
                case "workDoneToken": {
                    result.setWorkDoneToken(this.readWorkDoneToken(in));
                    continue block24;
                }
                case "processId": {
                    result.setProcessId(this.readProcessId(in));
                    continue block24;
                }
                case "rootPath": {
                    result.setRootPath(this.readRootPath(in));
                    continue block24;
                }
                case "rootUri": {
                    result.setRootUri(this.readRootUri(in));
                    continue block24;
                }
                case "initializationOptions": {
                    result.setInitializationOptions(this.readInitializationOptions(in));
                    continue block24;
                }
                case "capabilities": {
                    result.setCapabilities(this.readCapabilities(in));
                    continue block24;
                }
                case "clientInfo": {
                    result.setClientInfo(this.readClientInfo(in));
                    continue block24;
                }
                case "locale": {
                    result.setLocale(this.readLocale(in));
                    continue block24;
                }
                case "trace": {
                    result.setTrace(this.readTrace(in));
                    continue block24;
                }
                case "workspaceFolders": {
                    result.setWorkspaceFolders(this.readWorkspaceFolders(in));
                    continue block24;
                }
            }
            in.skipValue();
        }
        in.endObject();
        return result;
    }

    protected Either<String, Integer> readWorkDoneToken(JsonReader in) throws IOException {
        return (Either)this.gson.fromJson(in, WORKDONETOKEN_TYPE_TOKEN.getType());
    }

    protected Integer readProcessId(JsonReader in) throws IOException {
        return (Integer)this.gson.fromJson(in, Integer.class);
    }

    protected String readRootPath(JsonReader in) throws IOException {
        return (String)this.gson.fromJson(in, String.class);
    }

    protected String readRootUri(JsonReader in) throws IOException {
        return (String)this.gson.fromJson(in, String.class);
    }

    protected ClientCapabilities readCapabilities(JsonReader in) throws IOException {
        return (ClientCapabilities)this.gson.fromJson(in, ClientCapabilities.class);
    }

    protected ClientInfo readClientInfo(JsonReader in) throws IOException {
        return (ClientInfo)this.gson.fromJson(in, ClientInfo.class);
    }

    protected String readLocale(JsonReader in) throws IOException {
        return (String)this.gson.fromJson(in, String.class);
    }

    protected String readTrace(JsonReader in) throws IOException {
        return (String)this.gson.fromJson(in, String.class);
    }

    protected List<WorkspaceFolder> readWorkspaceFolders(JsonReader in) throws IOException {
        return (List)this.gson.fromJson(in, WORKSPACEFOLDERS_TYPE_TOKEN.getType());
    }

    public void write(JsonWriter out, InitializeParams value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        out.beginObject();
        out.name("workDoneToken");
        this.writeWorkDoneToken(out, value.getWorkDoneToken());
        out.name("processId");
        this.writeProcessId(out, value.getProcessId());
        out.name("rootPath");
        this.writeRootPath(out, value.getRootPath());
        out.name("rootUri");
        this.writeRootUri(out, value.getRootUri());
        out.name("initializationOptions");
        this.writeInitializationOptions(out, value.getInitializationOptions());
        out.name("capabilities");
        this.writeCapabilities(out, value.getCapabilities());
        out.name("clientInfo");
        this.writeClientInfo(out, value.getClientInfo());
        out.name("locale");
        this.writeLocale(out, value.getLocale());
        out.name("trace");
        this.writeTrace(out, value.getTrace());
        out.name("workspaceFolders");
        this.writeWorkspaceFolders(out, value.getWorkspaceFolders());
        out.endObject();
    }

    protected void writeWorkDoneToken(JsonWriter out, Either<String, Integer> value) throws IOException {
        this.gson.toJson(value, WORKDONETOKEN_TYPE_TOKEN.getType(), out);
    }

    protected void writeRootPath(JsonWriter out, String value) throws IOException {
        out.value(value);
    }

    protected void writeInitializationOptions(JsonWriter out, Object value) throws IOException {
        if (value == null) {
            out.nullValue();
        } else {
            this.gson.toJson(value, value.getClass(), out);
        }
    }

    protected void writeCapabilities(JsonWriter out, ClientCapabilities value) throws IOException {
        this.gson.toJson((Object)value, ClientCapabilities.class, out);
    }

    protected void writeClientInfo(JsonWriter out, ClientInfo value) throws IOException {
        this.gson.toJson((Object)value, ClientInfo.class, out);
    }

    protected void writeLocale(JsonWriter out, String value) throws IOException {
        out.value(value);
    }

    protected void writeTrace(JsonWriter out, String value) throws IOException {
        out.value(value);
    }

    protected void writeWorkspaceFolders(JsonWriter out, List<WorkspaceFolder> value) throws IOException {
        this.gson.toJson(value, WORKSPACEFOLDERS_TYPE_TOKEN.getType(), out);
    }

    public static class Factory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            if (!InitializeParams.class.isAssignableFrom(typeToken.getRawType())) {
                return null;
            }
            return new InitializeParamsTypeAdapter(gson);
        }
    }
}

