// This file is generated by kconfig_compiler_kf6 from messageviewer.kcfg.
// All changes you do to this file will be lost.
#ifndef MESSAGEVIEWER_MESSAGEVIEWERSETTINGSBASE_H
#define MESSAGEVIEWER_MESSAGEVIEWERSETTINGSBASE_H

#include <qapplication.h>
#include "messageviewer_export.h"
#include <MimeTreeParser/Enums>
#include "messageviewer_debug.h"

#include <kconfigskeleton.h>
#include <QCoreApplication>
#include <QDebug>

#include <QFontDatabase>

namespace MessageViewer {

class MESSAGEVIEWER_EXPORT MessageViewerSettingsBase : public KConfigSkeleton
{
  public:
    class EnumMimeTreeMode2
    {
      public:
      enum type { Never, Always, COUNT };
    };
    class EnumAskForCommentWhenReactingToInvitation
    {
      public:
      enum type { NeverAsk, AskForAllButAcceptance, AlwaysAsk, COUNT };
    };
    class EnumSaveKey
    {
      public:
      enum type { NotSaving, Save, SaveAndCompare, COUNT };
    };
    class EnumPublicRsaTooSmall
    {
      public:
      enum type { Nothing, Warning, Error, COUNT };
    };
    class EnumPolicyRsaSha1
    {
      public:
      enum type { Nothing, Warning, Error, COUNT };
    };

    static MessageViewerSettingsBase *self();
    ~MessageViewerSettingsBase() override;

    /**
      Set Only print selected text in viewer
    */
    static
    void setPrintSelectedText( bool v )
    {
      if (!self()->isPrintSelectedTextImmutable())
        self()->mPrintSelectedText = v;
    }

    /**
      Get Only print selected text in viewer
    */
    static
    bool printSelectedText()
    {
      return self()->mPrintSelectedText;
    }

    /**
      Is Only print selected text in viewer Immutable
    */
    static
    bool isPrintSelectedTextImmutable()
    {
      return self()->isImmutable( QStringLiteral( "PrintSelectedText" ) );
    }

    /**
      Get Item object corresponding to PrintSelectedText()
    */
    ItemBool *printSelectedTextItem()
    {
      return mPrintSelectedTextItem;
    }

    /**
      Set Respect expand/collapse quote mark which is defined in settings during printing.
    */
    static
    void setRespectExpandCollapseSettings( bool v )
    {
      if (!self()->isRespectExpandCollapseSettingsImmutable())
        self()->mRespectExpandCollapseSettings = v;
    }

    /**
      Get Respect expand/collapse quote mark which is defined in settings during printing.
    */
    static
    bool respectExpandCollapseSettings()
    {
      return self()->mRespectExpandCollapseSettings;
    }

    /**
      Is Respect expand/collapse quote mark which is defined in settings during printing. Immutable
    */
    static
    bool isRespectExpandCollapseSettingsImmutable()
    {
      return self()->isImmutable( QStringLiteral( "RespectExpandCollapseSettings" ) );
    }

    /**
      Get Item object corresponding to RespectExpandCollapseSettings()
    */
    ItemBool *respectExpandCollapseSettingsItem()
    {
      return mRespectExpandCollapseSettingsItem;
    }

    /**
      Set Specifies whether the background color and images are also drawn when the page is printed.
    */
    static
    void setPrintBackgroundColorImages( bool v )
    {
      if (!self()->isPrintBackgroundColorImagesImmutable())
        self()->mPrintBackgroundColorImages = v;
    }

    /**
      Get Specifies whether the background color and images are also drawn when the page is printed.
    */
    static
    bool printBackgroundColorImages()
    {
      return self()->mPrintBackgroundColorImages;
    }

    /**
      Is Specifies whether the background color and images are also drawn when the page is printed. Immutable
    */
    static
    bool isPrintBackgroundColorImagesImmutable()
    {
      return self()->isImmutable( QStringLiteral( "PrintBackgroundColorImages" ) );
    }

    /**
      Get Item object corresponding to PrintBackgroundColorImages()
    */
    ItemBool *printBackgroundColorImagesItem()
    {
      return mPrintBackgroundColorImagesItem;
    }

    /**
      Set Always show encryption/signature details when we print message
    */
    static
    void setAlwaysShowEncryptionSignatureDetails( bool v )
    {
      if (!self()->isAlwaysShowEncryptionSignatureDetailsImmutable())
        self()->mAlwaysShowEncryptionSignatureDetails = v;
    }

    /**
      Get Always show encryption/signature details when we print message
    */
    static
    bool alwaysShowEncryptionSignatureDetails()
    {
      return self()->mAlwaysShowEncryptionSignatureDetails;
    }

    /**
      Is Always show encryption/signature details when we print message Immutable
    */
    static
    bool isAlwaysShowEncryptionSignatureDetailsImmutable()
    {
      return self()->isImmutable( QStringLiteral( "AlwaysShowEncryptionSignatureDetails" ) );
    }

    /**
      Get Item object corresponding to AlwaysShowEncryptionSignatureDetails()
    */
    ItemBool *alwaysShowEncryptionSignatureDetailsItem()
    {
      return mAlwaysShowEncryptionSignatureDetailsItem;
    }

    /**
      Set fixed-font
    */
    static
    void setFixedFont( const QFont & v )
    {
      if (!self()->isFixedFontImmutable())
        self()->mFixedFont = v;
    }

    /**
      Get fixed-font
    */
    static
    QFont fixedFont()
    {
      return self()->mFixedFont;
    }

    /**
      Is fixed-font Immutable
    */
    static
    bool isFixedFontImmutable()
    {
      return self()->isImmutable( QStringLiteral( "FixedFont" ) );
    }

    /**
      Get Item object corresponding to FixedFont()
    */
    ItemFont *fixedFontItem()
    {
      return mFixedFontItem;
    }

    /**
      Set When we render html do not use font size inferior to minimum size.
    */
    static
    void setMinimumFontSize( int v )
    {
      if (!self()->isMinimumFontSizeImmutable())
        self()->mMinimumFontSize = v;
    }

    /**
      Get When we render html do not use font size inferior to minimum size.
    */
    static
    int minimumFontSize()
    {
      return self()->mMinimumFontSize;
    }

    /**
      Is When we render html do not use font size inferior to minimum size. Immutable
    */
    static
    bool isMinimumFontSizeImmutable()
    {
      return self()->isImmutable( QStringLiteral( "MinimumFontSize" ) );
    }

    /**
      Get Item object corresponding to MinimumFontSize()
    */
    ItemInt *minimumFontSizeItem()
    {
      return mMinimumFontSizeItem;
    }

    /**
      Set Specifies the font to use for the message body
    */
    static
    void setBodyFont( const QFont & v )
    {
      if (!self()->isBodyFontImmutable())
        self()->mBodyFont = v;
    }

    /**
      Get Specifies the font to use for the message body
    */
    static
    QFont bodyFont()
    {
      return self()->mBodyFont;
    }

    /**
      Is Specifies the font to use for the message body Immutable
    */
    static
    bool isBodyFontImmutable()
    {
      return self()->isImmutable( QStringLiteral( "BodyFont" ) );
    }

    /**
      Get Item object corresponding to BodyFont()
    */
    ItemFont *bodyFontItem()
    {
      return mBodyFontItem;
    }

    /**
      Set Specifies the font to use for printing
    */
    static
    void setPrintFont( const QFont & v )
    {
      if (!self()->isPrintFontImmutable())
        self()->mPrintFont = v;
    }

    /**
      Get Specifies the font to use for printing
    */
    static
    QFont printFont()
    {
      return self()->mPrintFont;
    }

    /**
      Is Specifies the font to use for printing Immutable
    */
    static
    bool isPrintFontImmutable()
    {
      return self()->isImmutable( QStringLiteral( "PrintFont" ) );
    }

    /**
      Get Item object corresponding to PrintFont()
    */
    ItemFont *printFontItem()
    {
      return mPrintFontItem;
    }

    /**
      Set Check if url can be a phishing
    */
    static
    void setCheckPhishingUrl( bool v )
    {
      if (!self()->isCheckPhishingUrlImmutable())
        self()->mCheckPhishingUrl = v;
    }

    /**
      Get Check if url can be a phishing
    */
    static
    bool checkPhishingUrl()
    {
      return self()->mCheckPhishingUrl;
    }

    /**
      Is Check if url can be a phishing Immutable
    */
    static
    bool isCheckPhishingUrlImmutable()
    {
      return self()->isImmutable( QStringLiteral( "CheckPhishingUrl" ) );
    }

    /**
      Get Item object corresponding to CheckPhishingUrl()
    */
    ItemBool *checkPhishingUrlItem()
    {
      return mCheckPhishingUrlItem;
    }

    /**
      Set Close message window after replying or forwarding
    */
    static
    void setCloseAfterReplyOrForward( bool v )
    {
      if (!self()->isCloseAfterReplyOrForwardImmutable())
        self()->mCloseAfterReplyOrForward = v;
    }

    /**
      Get Close message window after replying or forwarding
    */
    static
    bool closeAfterReplyOrForward()
    {
      return self()->mCloseAfterReplyOrForward;
    }

    /**
      Is Close message window after replying or forwarding Immutable
    */
    static
    bool isCloseAfterReplyOrForwardImmutable()
    {
      return self()->isImmutable( QStringLiteral( "CloseAfterReplyOrForward" ) );
    }

    /**
      Get Item object corresponding to CloseAfterReplyOrForward()
    */
    ItemBool *closeAfterReplyOrForwardItem()
    {
      return mCloseAfterReplyOrForwardItem;
    }

    /**
      Set ZoomFactor
    */
    static
    void setZoomFactor( double v )
    {
      if (!self()->isZoomFactorImmutable())
        self()->mZoomFactor = v;
    }

    /**
      Get ZoomFactor
    */
    static
    double zoomFactor()
    {
      return self()->mZoomFactor;
    }

    /**
      Is ZoomFactor Immutable
    */
    static
    bool isZoomFactorImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ZoomFactor" ) );
    }

    /**
      Get Item object corresponding to ZoomFactor()
    */
    ItemDouble *zoomFactorItem()
    {
      return mZoomFactorItem;
    }

    /**
      Set ShowEmoticons
    */
    static
    void setShowEmoticons( bool v )
    {
      if (!self()->isShowEmoticonsImmutable())
        self()->mShowEmoticons = v;
    }

    /**
      Get ShowEmoticons
    */
    static
    bool showEmoticons()
    {
      return self()->mShowEmoticons;
    }

    /**
      Is ShowEmoticons Immutable
    */
    static
    bool isShowEmoticonsImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ShowEmoticons" ) );
    }

    /**
      Get Item object corresponding to ShowEmoticons()
    */
    ItemBool *showEmoticonsItem()
    {
      return mShowEmoticonsItem;
    }

    /**
      Set AutoImportKeys
    */
    static
    void setAutoImportKeys( bool v )
    {
      if (!self()->isAutoImportKeysImmutable())
        self()->mAutoImportKeys = v;
    }

    /**
      Get AutoImportKeys
    */
    static
    bool autoImportKeys()
    {
      return self()->mAutoImportKeys;
    }

    /**
      Is AutoImportKeys Immutable
    */
    static
    bool isAutoImportKeysImmutable()
    {
      return self()->isImmutable( QStringLiteral( "AutoImportKeys" ) );
    }

    /**
      Get Item object corresponding to AutoImportKeys()
    */
    ItemBool *autoImportKeysItem()
    {
      return mAutoImportKeysItem;
    }

    /**
      Set Show expand/collapse quote marks
    */
    static
    void setShowExpandQuotesMark( bool v )
    {
      if (!self()->isShowExpandQuotesMarkImmutable())
        self()->mShowExpandQuotesMark = v;
    }

    /**
      Get Show expand/collapse quote marks
    */
    static
    bool showExpandQuotesMark()
    {
      return self()->mShowExpandQuotesMark;
    }

    /**
      Is Show expand/collapse quote marks Immutable
    */
    static
    bool isShowExpandQuotesMarkImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ShowExpandQuotesMark" ) );
    }

    /**
      Get Item object corresponding to ShowExpandQuotesMark()
    */
    ItemBool *showExpandQuotesMarkItem()
    {
      return mShowExpandQuotesMarkItem;
    }

    /**
      Set Automatic collapse level:
    */
    static
    void setCollapseQuoteLevelSpin( int v )
    {
      if (v < 0)
      {
        qCDebug(MESSAGEVIEWER_LOG) << "setCollapseQuoteLevelSpin: value " << v << " is less than the minimum value of 0";
        v = 0;
      }

      if (v > 10)
      {
        qCDebug(MESSAGEVIEWER_LOG) << "setCollapseQuoteLevelSpin: value " << v << " is greater than the maximum value of 10";
        v = 10;
      }

      if (!self()->isCollapseQuoteLevelSpinImmutable())
        self()->mCollapseQuoteLevelSpin = v;
    }

    /**
      Get Automatic collapse level:
    */
    static
    int collapseQuoteLevelSpin()
    {
      return self()->mCollapseQuoteLevelSpin;
    }

    /**
      Is Automatic collapse level: Immutable
    */
    static
    bool isCollapseQuoteLevelSpinImmutable()
    {
      return self()->isImmutable( QStringLiteral( "CollapseQuoteLevelSpin" ) );
    }

    /**
      Get Item object corresponding to CollapseQuoteLevelSpin()
    */
    ItemInt *collapseQuoteLevelSpinItem()
    {
      return mCollapseQuoteLevelSpinItem;
    }

    /**
      Set Reduce font size for quoted text
    */
    static
    void setShrinkQuotes( bool v )
    {
      if (!self()->isShrinkQuotesImmutable())
        self()->mShrinkQuotes = v;
    }

    /**
      Get Reduce font size for quoted text
    */
    static
    bool shrinkQuotes()
    {
      return self()->mShrinkQuotes;
    }

    /**
      Is Reduce font size for quoted text Immutable
    */
    static
    bool isShrinkQuotesImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ShrinkQuotes" ) );
    }

    /**
      Get Item object corresponding to ShrinkQuotes()
    */
    ItemBool *shrinkQuotesItem()
    {
      return mShrinkQuotesItem;
    }

    /**
      Set Always decrypt messages when viewing or ask before decrypting
    */
    static
    void setAlwaysDecrypt( bool v )
    {
      if (!self()->isAlwaysDecryptImmutable())
        self()->mAlwaysDecrypt = v;
    }

    /**
      Get Always decrypt messages when viewing or ask before decrypting
    */
    static
    bool alwaysDecrypt()
    {
      return self()->mAlwaysDecrypt;
    }

    /**
      Is Always decrypt messages when viewing or ask before decrypting Immutable
    */
    static
    bool isAlwaysDecryptImmutable()
    {
      return self()->isImmutable( QStringLiteral( "AlwaysDecrypt" ) );
    }

    /**
      Get Item object corresponding to AlwaysDecrypt()
    */
    ItemBool *alwaysDecryptItem()
    {
      return mAlwaysDecryptItem;
    }

    /**
      Set Message Structure Viewer
    */
    static
    void setMimeTreeMode2( int v )
    {
      if (!self()->isMimeTreeMode2Immutable())
        self()->mMimeTreeMode2 = v;
    }

    /**
      Get Message Structure Viewer
    */
    static
    int mimeTreeMode2()
    {
      return self()->mMimeTreeMode2;
    }

    /**
      Is Message Structure Viewer Immutable
    */
    static
    bool isMimeTreeMode2Immutable()
    {
      return self()->isImmutable( QStringLiteral( "MimeTreeMode2" ) );
    }

    /**
      Get Item object corresponding to MimeTreeMode2()
    */
    ItemEnum *mimeTreeMode2Item()
    {
      return mMimeTreeMode2Item;
    }

    /**
      Set MimePaneHeight
    */
    static
    void setMimePaneHeight( int v )
    {
      if (!self()->isMimePaneHeightImmutable())
        self()->mMimePaneHeight = v;
    }

    /**
      Get MimePaneHeight
    */
    static
    int mimePaneHeight()
    {
      return self()->mMimePaneHeight;
    }

    /**
      Is MimePaneHeight Immutable
    */
    static
    bool isMimePaneHeightImmutable()
    {
      return self()->isImmutable( QStringLiteral( "MimePaneHeight" ) );
    }

    /**
      Get Item object corresponding to MimePaneHeight()
    */
    ItemInt *mimePaneHeightItem()
    {
      return mMimePaneHeightItem;
    }

    /**
      Set MessagePaneHeight
    */
    static
    void setMessagePaneHeight( int v )
    {
      if (!self()->isMessagePaneHeightImmutable())
        self()->mMessagePaneHeight = v;
    }

    /**
      Get MessagePaneHeight
    */
    static
    int messagePaneHeight()
    {
      return self()->mMessagePaneHeight;
    }

    /**
      Is MessagePaneHeight Immutable
    */
    static
    bool isMessagePaneHeightImmutable()
    {
      return self()->isImmutable( QStringLiteral( "MessagePaneHeight" ) );
    }

    /**
      Get Item object corresponding to MessagePaneHeight()
    */
    ItemInt *messagePaneHeightItem()
    {
      return mMessagePaneHeightItem;
    }

    /**
      Set What style of headers should be displayed
    */
    static
    void setHeaderPluginStyleName( const QString & v )
    {
      if (!self()->isHeaderPluginStyleNameImmutable())
        self()->mHeaderPluginStyleName = v;
    }

    /**
      Get What style of headers should be displayed
    */
    static
    QString headerPluginStyleName()
    {
      return self()->mHeaderPluginStyleName;
    }

    /**
      Is What style of headers should be displayed Immutable
    */
    static
    bool isHeaderPluginStyleNameImmutable()
    {
      return self()->isImmutable( QStringLiteral( "headerPluginStyleName" ) );
    }

    /**
      Get Item object corresponding to headerPluginStyleName()
    */
    ItemString *headerPluginStyleNameItem()
    {
      return mHeaderPluginStyleNameItem;
    }

    /**
      Set What style of headers should be displayed
    */
    static
    void setHeaderStyle( const QString & v )
    {
      if (!self()->isHeaderStyleImmutable())
        self()->mHeaderStyle = v;
    }

    /**
      Get What style of headers should be displayed
    */
    static
    QString headerStyle()
    {
      return self()->mHeaderStyle;
    }

    /**
      Is What style of headers should be displayed Immutable
    */
    static
    bool isHeaderStyleImmutable()
    {
      return self()->isImmutable( QStringLiteral( "headerStyle" ) );
    }

    /**
      Get Item object corresponding to headerStyle()
    */
    ItemString *headerStyleItem()
    {
      return mHeaderStyleItem;
    }

    /**
      Set How much of headers should be displayed
    */
    static
    void setHeaderSetDisplayed( const QString & v )
    {
      if (!self()->isHeaderSetDisplayedImmutable())
        self()->mHeaderSetDisplayed = v;
    }

    /**
      Get How much of headers should be displayed
    */
    static
    QString headerSetDisplayed()
    {
      return self()->mHeaderSetDisplayed;
    }

    /**
      Is How much of headers should be displayed Immutable
    */
    static
    bool isHeaderSetDisplayedImmutable()
    {
      return self()->isImmutable( QStringLiteral( "headerSetDisplayed" ) );
    }

    /**
      Get Item object corresponding to headerSetDisplayed()
    */
    ItemString *headerSetDisplayedItem()
    {
      return mHeaderSetDisplayedItem;
    }

    /**
      Set Prefer HTML to plain text
    */
    static
    void setHtmlMail( bool v )
    {
      if (!self()->isHtmlMailImmutable())
        self()->mHtmlMail = v;
    }

    /**
      Get Prefer HTML to plain text
    */
    static
    bool htmlMail()
    {
      return self()->mHtmlMail;
    }

    /**
      Is Prefer HTML to plain text Immutable
    */
    static
    bool isHtmlMailImmutable()
    {
      return self()->isImmutable( QStringLiteral( "htmlMail" ) );
    }

    /**
      Get Item object corresponding to htmlMail()
    */
    ItemBool *htmlMailItem()
    {
      return mHtmlMailItem;
    }

    /**
      Set Allow messages to load external references from the Internet
    */
    static
    void setHtmlLoadExternal( bool v )
    {
      if (!self()->isHtmlLoadExternalImmutable())
        self()->mHtmlLoadExternal = v;
    }

    /**
      Get Allow messages to load external references from the Internet
    */
    static
    bool htmlLoadExternal()
    {
      return self()->mHtmlLoadExternal;
    }

    /**
      Is Allow messages to load external references from the Internet Immutable
    */
    static
    bool isHtmlLoadExternalImmutable()
    {
      return self()->isImmutable( QStringLiteral( "htmlLoadExternal" ) );
    }

    /**
      Get Item object corresponding to htmlLoadExternal()
    */
    ItemBool *htmlLoadExternalItem()
    {
      return mHtmlLoadExternalItem;
    }

    /**
      Set How attachments are shown
    */
    static
    void setAttachmentStrategy( const QString & v )
    {
      if (!self()->isAttachmentStrategyImmutable())
        self()->mAttachmentStrategy = v;
    }

    /**
      Get How attachments are shown
    */
    static
    QString attachmentStrategy()
    {
      return self()->mAttachmentStrategy;
    }

    /**
      Is How attachments are shown Immutable
    */
    static
    bool isAttachmentStrategyImmutable()
    {
      return self()->isImmutable( QStringLiteral( "attachmentStrategy" ) );
    }

    /**
      Get Item object corresponding to attachmentStrategy()
    */
    ItemString *attachmentStrategyItem()
    {
      return mAttachmentStrategyItem;
    }

    /**
      Set Specifies whether to reuse the quote color, beyond the 3rd level
    */
    static
    void setRecycleQuoteColors( bool v )
    {
      if (!self()->isRecycleQuoteColorsImmutable())
        self()->mRecycleQuoteColors = v;
    }

    /**
      Get Specifies whether to reuse the quote color, beyond the 3rd level
    */
    static
    bool recycleQuoteColors()
    {
      return self()->mRecycleQuoteColors;
    }

    /**
      Is Specifies whether to reuse the quote color, beyond the 3rd level Immutable
    */
    static
    bool isRecycleQuoteColorsImmutable()
    {
      return self()->isImmutable( QStringLiteral( "RecycleQuoteColors" ) );
    }

    /**
      Get Item object corresponding to RecycleQuoteColors()
    */
    ItemBool *recycleQuoteColorsItem()
    {
      return mRecycleQuoteColorsItem;
    }

    /**
      Set Activate Access Key
    */
    static
    void setAccessKeyEnabled( bool v )
    {
      if (!self()->isAccessKeyEnabledImmutable())
        self()->mAccessKeyEnabled = v;
    }

    /**
      Get Activate Access Key
    */
    static
    bool accessKeyEnabled()
    {
      return self()->mAccessKeyEnabled;
    }

    /**
      Is Activate Access Key Immutable
    */
    static
    bool isAccessKeyEnabledImmutable()
    {
      return self()->isImmutable( QStringLiteral( "AccessKeyEnabled" ) );
    }

    /**
      Get Item object corresponding to AccessKeyEnabled()
    */
    ItemBool *accessKeyEnabledItem()
    {
      return mAccessKeyEnabledItem;
    }

    /**
      Set KMail can analyze messages for suspected email scams by looking for common techniques used to deceive you
    */
    static
    void setScamDetectionEnabled( bool v )
    {
      if (!self()->isScamDetectionEnabledImmutable())
        self()->mScamDetectionEnabled = v;
    }

    /**
      Get KMail can analyze messages for suspected email scams by looking for common techniques used to deceive you
    */
    static
    bool scamDetectionEnabled()
    {
      return self()->mScamDetectionEnabled;
    }

    /**
      Is KMail can analyze messages for suspected email scams by looking for common techniques used to deceive you Immutable
    */
    static
    bool isScamDetectionEnabledImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ScamDetectionEnabled" ) );
    }

    /**
      Get Item object corresponding to ScamDetectionEnabled()
    */
    ItemBool *scamDetectionEnabledItem()
    {
      return mScamDetectionEnabledItem;
    }

    /**
      Set List of emails in scam white list
    */
    static
    void setScamDetectionWhiteList( const QStringList & v )
    {
      if (!self()->isScamDetectionWhiteListImmutable())
        self()->mScamDetectionWhiteList = v;
    }

    /**
      Get List of emails in scam white list
    */
    static
    QStringList scamDetectionWhiteList()
    {
      return self()->mScamDetectionWhiteList;
    }

    /**
      Is List of emails in scam white list Immutable
    */
    static
    bool isScamDetectionWhiteListImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ScamDetectionWhiteList" ) );
    }

    /**
      Get Item object corresponding to ScamDetectionWhiteList()
    */
    ItemStringList *scamDetectionWhiteListItem()
    {
      return mScamDetectionWhiteListItem;
    }

    /**
      Set Scan emails for tracking URLs
    */
    static
    void setMailTrackingUrlEnabled( bool v )
    {
      if (!self()->isMailTrackingUrlEnabledImmutable())
        self()->mMailTrackingUrlEnabled = v;
    }

    /**
      Get Scan emails for tracking URLs
    */
    static
    bool mailTrackingUrlEnabled()
    {
      return self()->mMailTrackingUrlEnabled;
    }

    /**
      Is Scan emails for tracking URLs Immutable
    */
    static
    bool isMailTrackingUrlEnabledImmutable()
    {
      return self()->isImmutable( QStringLiteral( "MailTrackingUrlEnabled" ) );
    }

    /**
      Get Item object corresponding to MailTrackingUrlEnabled()
    */
    ItemBool *mailTrackingUrlEnabledItem()
    {
      return mMailTrackingUrlEnabledItem;
    }

    /**
      Set Do not send MDNs in response to encrypted messages
    */
    static
    void setNotSendWhenEncrypted( bool v )
    {
      if (!self()->isNotSendWhenEncryptedImmutable())
        self()->mNotSendWhenEncrypted = v;
    }

    /**
      Get Do not send MDNs in response to encrypted messages
    */
    static
    bool notSendWhenEncrypted()
    {
      return self()->mNotSendWhenEncrypted;
    }

    /**
      Is Do not send MDNs in response to encrypted messages Immutable
    */
    static
    bool isNotSendWhenEncryptedImmutable()
    {
      return self()->isImmutable( QStringLiteral( "notSendWhenEncrypted" ) );
    }

    /**
      Get Item object corresponding to notSendWhenEncrypted()
    */
    ItemBool *notSendWhenEncryptedItem()
    {
      return mNotSendWhenEncryptedItem;
    }

    /**
      Set Specifies the default policy to use, for the Message Disposition Notifications (for internal use only)
    */
    static
    void setDefaultPolicy( int v )
    {
      if (!self()->isDefaultPolicyImmutable())
        self()->mDefaultPolicy = v;
    }

    /**
      Get Specifies the default policy to use, for the Message Disposition Notifications (for internal use only)
    */
    static
    int defaultPolicy()
    {
      return self()->mDefaultPolicy;
    }

    /**
      Is Specifies the default policy to use, for the Message Disposition Notifications (for internal use only) Immutable
    */
    static
    bool isDefaultPolicyImmutable()
    {
      return self()->isImmutable( QStringLiteral( "DefaultPolicy" ) );
    }

    /**
      Get Item object corresponding to DefaultPolicy()
    */
    ItemInt *defaultPolicyItem()
    {
      return mDefaultPolicyItem;
    }

    /**
      Set Specifies the default quoting action to take, when replying to a message (for internal use only)
    */
    static
    void setQuoteMessage( int v )
    {
      if (!self()->isQuoteMessageImmutable())
        self()->mQuoteMessage = v;
    }

    /**
      Get Specifies the default quoting action to take, when replying to a message (for internal use only)
    */
    static
    int quoteMessage()
    {
      return self()->mQuoteMessage;
    }

    /**
      Is Specifies the default quoting action to take, when replying to a message (for internal use only) Immutable
    */
    static
    bool isQuoteMessageImmutable()
    {
      return self()->isImmutable( QStringLiteral( "QuoteMessage" ) );
    }

    /**
      Get Item object corresponding to QuoteMessage()
    */
    ItemInt *quoteMessageItem()
    {
      return mQuoteMessageItem;
    }

    /**
      Set DelayedMarkAsRead
    */
    static
    void setDelayedMarkAsRead( bool v )
    {
      if (!self()->isDelayedMarkAsReadImmutable())
        self()->mDelayedMarkAsRead = v;
    }

    /**
      Get DelayedMarkAsRead
    */
    static
    bool delayedMarkAsRead()
    {
      return self()->mDelayedMarkAsRead;
    }

    /**
      Is DelayedMarkAsRead Immutable
    */
    static
    bool isDelayedMarkAsReadImmutable()
    {
      return self()->isImmutable( QStringLiteral( "DelayedMarkAsRead" ) );
    }

    /**
      Get Item object corresponding to DelayedMarkAsRead()
    */
    ItemBool *delayedMarkAsReadItem()
    {
      return mDelayedMarkAsReadItem;
    }

    /**
      Set DelayedMarkTime
    */
    static
    void setDelayedMarkTime( uint v )
    {
      if (!self()->isDelayedMarkTimeImmutable())
        self()->mDelayedMarkTime = v;
    }

    /**
      Get DelayedMarkTime
    */
    static
    uint delayedMarkTime()
    {
      return self()->mDelayedMarkTime;
    }

    /**
      Is DelayedMarkTime Immutable
    */
    static
    bool isDelayedMarkTimeImmutable()
    {
      return self()->isImmutable( QStringLiteral( "DelayedMarkTime" ) );
    }

    /**
      Get Item object corresponding to DelayedMarkTime()
    */
    ItemUInt *delayedMarkTimeItem()
    {
      return mDelayedMarkTimeItem;
    }

    /**
      Set Mangle From:/To: headers in replies to replies
    */
    static
    void setLegacyMangleFromToHeaders( bool v )
    {
      if (!self()->isLegacyMangleFromToHeadersImmutable())
        self()->mLegacyMangleFromToHeaders = v;
    }

    /**
      Get Mangle From:/To: headers in replies to replies
    */
    static
    bool legacyMangleFromToHeaders()
    {
      return self()->mLegacyMangleFromToHeaders;
    }

    /**
      Is Mangle From:/To: headers in replies to replies Immutable
    */
    static
    bool isLegacyMangleFromToHeadersImmutable()
    {
      return self()->isImmutable( QStringLiteral( "LegacyMangleFromToHeaders" ) );
    }

    /**
      Get Item object corresponding to LegacyMangleFromToHeaders()
    */
    ItemBool *legacyMangleFromToHeadersItem()
    {
      return mLegacyMangleFromToHeadersItem;
    }

    /**
      Set Send groupware invitations in the mail body
    */
    static
    void setLegacyBodyInvites( bool v )
    {
      if (!self()->isLegacyBodyInvitesImmutable())
        self()->mLegacyBodyInvites = v;
    }

    /**
      Get Send groupware invitations in the mail body
    */
    static
    bool legacyBodyInvites()
    {
      return self()->mLegacyBodyInvites;
    }

    /**
      Is Send groupware invitations in the mail body Immutable
    */
    static
    bool isLegacyBodyInvitesImmutable()
    {
      return self()->isImmutable( QStringLiteral( "LegacyBodyInvites" ) );
    }

    /**
      Get Item object corresponding to LegacyBodyInvites()
    */
    ItemBool *legacyBodyInvitesItem()
    {
      return mLegacyBodyInvitesItem;
    }

    /**
      Set Exchange-compatible invitation naming
    */
    static
    void setExchangeCompatibleInvitations( bool v )
    {
      if (!self()->isExchangeCompatibleInvitationsImmutable())
        self()->mExchangeCompatibleInvitations = v;
    }

    /**
      Get Exchange-compatible invitation naming
    */
    static
    bool exchangeCompatibleInvitations()
    {
      return self()->mExchangeCompatibleInvitations;
    }

    /**
      Is Exchange-compatible invitation naming Immutable
    */
    static
    bool isExchangeCompatibleInvitationsImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ExchangeCompatibleInvitations" ) );
    }

    /**
      Get Item object corresponding to ExchangeCompatibleInvitations()
    */
    ItemBool *exchangeCompatibleInvitationsItem()
    {
      return mExchangeCompatibleInvitationsItem;
    }

    /**
      Set Automatic invitation sending
    */
    static
    void setAutomaticSending( bool v )
    {
      if (!self()->isAutomaticSendingImmutable())
        self()->mAutomaticSending = v;
    }

    /**
      Get Automatic invitation sending
    */
    static
    bool automaticSending()
    {
      return self()->mAutomaticSending;
    }

    /**
      Is Automatic invitation sending Immutable
    */
    static
    bool isAutomaticSendingImmutable()
    {
      return self()->isImmutable( QStringLiteral( "AutomaticSending" ) );
    }

    /**
      Get Item object corresponding to AutomaticSending()
    */
    ItemBool *automaticSendingItem()
    {
      return mAutomaticSendingItem;
    }

    /**
      Set Delete invitation emails after the reply to them has been sent
    */
    static
    void setDeleteInvitationEmailsAfterSendingReply( bool v )
    {
      if (!self()->isDeleteInvitationEmailsAfterSendingReplyImmutable())
        self()->mDeleteInvitationEmailsAfterSendingReply = v;
    }

    /**
      Get Delete invitation emails after the reply to them has been sent
    */
    static
    bool deleteInvitationEmailsAfterSendingReply()
    {
      return self()->mDeleteInvitationEmailsAfterSendingReply;
    }

    /**
      Is Delete invitation emails after the reply to them has been sent Immutable
    */
    static
    bool isDeleteInvitationEmailsAfterSendingReplyImmutable()
    {
      return self()->isImmutable( QStringLiteral( "DeleteInvitationEmailsAfterSendingReply" ) );
    }

    /**
      Get Item object corresponding to DeleteInvitationEmailsAfterSendingReply()
    */
    ItemBool *deleteInvitationEmailsAfterSendingReplyItem()
    {
      return mDeleteInvitationEmailsAfterSendingReplyItem;
    }

    /**
      Set AskForCommentWhenReactingToInvitation
    */
    static
    void setAskForCommentWhenReactingToInvitation( int v )
    {
      if (!self()->isAskForCommentWhenReactingToInvitationImmutable())
        self()->mAskForCommentWhenReactingToInvitation = v;
    }

    /**
      Get AskForCommentWhenReactingToInvitation
    */
    static
    int askForCommentWhenReactingToInvitation()
    {
      return self()->mAskForCommentWhenReactingToInvitation;
    }

    /**
      Is AskForCommentWhenReactingToInvitation Immutable
    */
    static
    bool isAskForCommentWhenReactingToInvitationImmutable()
    {
      return self()->isImmutable( QStringLiteral( "AskForCommentWhenReactingToInvitation" ) );
    }

    /**
      Get Item object corresponding to AskForCommentWhenReactingToInvitation()
    */
    ItemEnum *askForCommentWhenReactingToInvitationItem()
    {
      return mAskForCommentWhenReactingToInvitationItem;
    }

    /**
      Set Use Fi&xed Font
    */
    static
    void setUseFixedFont( bool v )
    {
      if (!self()->isUseFixedFontImmutable())
        self()->mUseFixedFont = v;
    }

    /**
      Get Use Fi&xed Font
    */
    static
    bool useFixedFont()
    {
      return self()->mUseFixedFont;
    }

    /**
      Is Use Fi&xed Font Immutable
    */
    static
    bool isUseFixedFontImmutable()
    {
      return self()->isImmutable( QStringLiteral( "UseFixedFont" ) );
    }

    /**
      Get Item object corresponding to UseFixedFont()
    */
    ItemBool *useFixedFontItem()
    {
      return mUseFixedFontItem;
    }

    /**
      Set LastSelectedFolder
    */
    static
    void setLastSelectedFolder( qint64 v )
    {
      if (!self()->isLastSelectedFolderImmutable())
        self()->mLastSelectedFolder = v;
    }

    /**
      Get LastSelectedFolder
    */
    static
    qint64 lastSelectedFolder()
    {
      return self()->mLastSelectedFolder;
    }

    /**
      Is LastSelectedFolder Immutable
    */
    static
    bool isLastSelectedFolderImmutable()
    {
      return self()->isImmutable( QStringLiteral( "LastSelectedFolder" ) );
    }

    /**
      Get Item object corresponding to LastSelectedFolder()
    */
    ItemLongLong *lastSelectedFolderItem()
    {
      return mLastSelectedFolderItem;
    }

    /**
      Set LastEventSelectedFolder
    */
    static
    void setLastEventSelectedFolder( qint64 v )
    {
      if (!self()->isLastEventSelectedFolderImmutable())
        self()->mLastEventSelectedFolder = v;
    }

    /**
      Get LastEventSelectedFolder
    */
    static
    qint64 lastEventSelectedFolder()
    {
      return self()->mLastEventSelectedFolder;
    }

    /**
      Is LastEventSelectedFolder Immutable
    */
    static
    bool isLastEventSelectedFolderImmutable()
    {
      return self()->isImmutable( QStringLiteral( "LastEventSelectedFolder" ) );
    }

    /**
      Get Item object corresponding to LastEventSelectedFolder()
    */
    ItemLongLong *lastEventSelectedFolderItem()
    {
      return mLastEventSelectedFolderItem;
    }

    /**
      Set LastNoteSelectedFolder
    */
    static
    void setLastNoteSelectedFolder( qint64 v )
    {
      if (!self()->isLastNoteSelectedFolderImmutable())
        self()->mLastNoteSelectedFolder = v;
    }

    /**
      Get LastNoteSelectedFolder
    */
    static
    qint64 lastNoteSelectedFolder()
    {
      return self()->mLastNoteSelectedFolder;
    }

    /**
      Is LastNoteSelectedFolder Immutable
    */
    static
    bool isLastNoteSelectedFolderImmutable()
    {
      return self()->isImmutable( QStringLiteral( "LastNoteSelectedFolder" ) );
    }

    /**
      Get Item object corresponding to LastNoteSelectedFolder()
    */
    ItemLongLong *lastNoteSelectedFolderItem()
    {
      return mLastNoteSelectedFolderItem;
    }

    /**
      Set EnabledDkim
    */
    static
    void setEnabledDkim( bool v )
    {
      if (!self()->isEnabledDkimImmutable())
        self()->mEnabledDkim = v;
    }

    /**
      Get EnabledDkim
    */
    static
    bool enabledDkim()
    {
      return self()->mEnabledDkim;
    }

    /**
      Is EnabledDkim Immutable
    */
    static
    bool isEnabledDkimImmutable()
    {
      return self()->isImmutable( QStringLiteral( "EnabledDkim" ) );
    }

    /**
      Get Item object corresponding to EnabledDkim()
    */
    ItemBool *enabledDkimItem()
    {
      return mEnabledDkimItem;
    }

    /**
      Set SaveDkimResult
    */
    static
    void setSaveDkimResult( bool v )
    {
      if (!self()->isSaveDkimResultImmutable())
        self()->mSaveDkimResult = v;
    }

    /**
      Get SaveDkimResult
    */
    static
    bool saveDkimResult()
    {
      return self()->mSaveDkimResult;
    }

    /**
      Is SaveDkimResult Immutable
    */
    static
    bool isSaveDkimResultImmutable()
    {
      return self()->isImmutable( QStringLiteral( "SaveDkimResult" ) );
    }

    /**
      Get Item object corresponding to SaveDkimResult()
    */
    ItemBool *saveDkimResultItem()
    {
      return mSaveDkimResultItem;
    }

    /**
      Set SaveKey
    */
    static
    void setSaveKey( int v )
    {
      if (!self()->isSaveKeyImmutable())
        self()->mSaveKey = v;
    }

    /**
      Get SaveKey
    */
    static
    int saveKey()
    {
      return self()->mSaveKey;
    }

    /**
      Is SaveKey Immutable
    */
    static
    bool isSaveKeyImmutable()
    {
      return self()->isImmutable( QStringLiteral( "SaveKey" ) );
    }

    /**
      Get Item object corresponding to SaveKey()
    */
    ItemEnum *saveKeyItem()
    {
      return mSaveKeyItem;
    }

    /**
      Set CheckIfEmailShouldBeSigned
    */
    static
    void setCheckIfEmailShouldBeSigned( bool v )
    {
      if (!self()->isCheckIfEmailShouldBeSignedImmutable())
        self()->mCheckIfEmailShouldBeSigned = v;
    }

    /**
      Get CheckIfEmailShouldBeSigned
    */
    static
    bool checkIfEmailShouldBeSigned()
    {
      return self()->mCheckIfEmailShouldBeSigned;
    }

    /**
      Is CheckIfEmailShouldBeSigned Immutable
    */
    static
    bool isCheckIfEmailShouldBeSignedImmutable()
    {
      return self()->isImmutable( QStringLiteral( "CheckIfEmailShouldBeSigned" ) );
    }

    /**
      Get Item object corresponding to CheckIfEmailShouldBeSigned()
    */
    ItemBool *checkIfEmailShouldBeSignedItem()
    {
      return mCheckIfEmailShouldBeSignedItem;
    }

    /**
      Set UseDMarc
    */
    static
    void setUseDMarc( bool v )
    {
      if (!self()->isUseDMarcImmutable())
        self()->mUseDMarc = v;
    }

    /**
      Get UseDMarc
    */
    static
    bool useDMarc()
    {
      return self()->mUseDMarc;
    }

    /**
      Is UseDMarc Immutable
    */
    static
    bool isUseDMarcImmutable()
    {
      return self()->isImmutable( QStringLiteral( "UseDMarc" ) );
    }

    /**
      Get Item object corresponding to UseDMarc()
    */
    ItemBool *useDMarcItem()
    {
      return mUseDMarcItem;
    }

    /**
      Set UseDefaultRules
    */
    static
    void setUseDefaultRules( bool v )
    {
      if (!self()->isUseDefaultRulesImmutable())
        self()->mUseDefaultRules = v;
    }

    /**
      Get UseDefaultRules
    */
    static
    bool useDefaultRules()
    {
      return self()->mUseDefaultRules;
    }

    /**
      Is UseDefaultRules Immutable
    */
    static
    bool isUseDefaultRulesImmutable()
    {
      return self()->isImmutable( QStringLiteral( "UseDefaultRules" ) );
    }

    /**
      Get Item object corresponding to UseDefaultRules()
    */
    ItemBool *useDefaultRulesItem()
    {
      return mUseDefaultRulesItem;
    }

    /**
      Set AutogenerateRule
    */
    static
    void setAutogenerateRule( bool v )
    {
      if (!self()->isAutogenerateRuleImmutable())
        self()->mAutogenerateRule = v;
    }

    /**
      Get AutogenerateRule
    */
    static
    bool autogenerateRule()
    {
      return self()->mAutogenerateRule;
    }

    /**
      Is AutogenerateRule Immutable
    */
    static
    bool isAutogenerateRuleImmutable()
    {
      return self()->isImmutable( QStringLiteral( "AutogenerateRule" ) );
    }

    /**
      Get Item object corresponding to AutogenerateRule()
    */
    ItemBool *autogenerateRuleItem()
    {
      return mAutogenerateRuleItem;
    }

    /**
      Set AutogenerateRuleOnlyIfSenderOnSDID
    */
    static
    void setAutogenerateRuleOnlyIfSenderOnSDID( bool v )
    {
      if (!self()->isAutogenerateRuleOnlyIfSenderOnSDIDImmutable())
        self()->mAutogenerateRuleOnlyIfSenderOnSDID = v;
    }

    /**
      Get AutogenerateRuleOnlyIfSenderOnSDID
    */
    static
    bool autogenerateRuleOnlyIfSenderOnSDID()
    {
      return self()->mAutogenerateRuleOnlyIfSenderOnSDID;
    }

    /**
      Is AutogenerateRuleOnlyIfSenderOnSDID Immutable
    */
    static
    bool isAutogenerateRuleOnlyIfSenderOnSDIDImmutable()
    {
      return self()->isImmutable( QStringLiteral( "AutogenerateRuleOnlyIfSenderOnSDID" ) );
    }

    /**
      Get Item object corresponding to AutogenerateRuleOnlyIfSenderOnSDID()
    */
    ItemBool *autogenerateRuleOnlyIfSenderOnSDIDItem()
    {
      return mAutogenerateRuleOnlyIfSenderOnSDIDItem;
    }

    /**
      Set UseAuthenticationResults
    */
    static
    void setUseAuthenticationResults( bool v )
    {
      if (!self()->isUseAuthenticationResultsImmutable())
        self()->mUseAuthenticationResults = v;
    }

    /**
      Get UseAuthenticationResults
    */
    static
    bool useAuthenticationResults()
    {
      return self()->mUseAuthenticationResults;
    }

    /**
      Is UseAuthenticationResults Immutable
    */
    static
    bool isUseAuthenticationResultsImmutable()
    {
      return self()->isImmutable( QStringLiteral( "UseAuthenticationResults" ) );
    }

    /**
      Get Item object corresponding to UseAuthenticationResults()
    */
    ItemBool *useAuthenticationResultsItem()
    {
      return mUseAuthenticationResultsItem;
    }

    /**
      Set UseRelaxedParsingAuthenticationResults
    */
    static
    void setUseRelaxedParsingAuthenticationResults( bool v )
    {
      if (!self()->isUseRelaxedParsingAuthenticationResultsImmutable())
        self()->mUseRelaxedParsingAuthenticationResults = v;
    }

    /**
      Get UseRelaxedParsingAuthenticationResults
    */
    static
    bool useRelaxedParsingAuthenticationResults()
    {
      return self()->mUseRelaxedParsingAuthenticationResults;
    }

    /**
      Is UseRelaxedParsingAuthenticationResults Immutable
    */
    static
    bool isUseRelaxedParsingAuthenticationResultsImmutable()
    {
      return self()->isImmutable( QStringLiteral( "UseRelaxedParsingAuthenticationResults" ) );
    }

    /**
      Get Item object corresponding to UseRelaxedParsingAuthenticationResults()
    */
    ItemBool *useRelaxedParsingAuthenticationResultsItem()
    {
      return mUseRelaxedParsingAuthenticationResultsItem;
    }

    /**
      Set UseOnlyAuthenticationResults
    */
    static
    void setUseOnlyAuthenticationResults( bool v )
    {
      if (!self()->isUseOnlyAuthenticationResultsImmutable())
        self()->mUseOnlyAuthenticationResults = v;
    }

    /**
      Get UseOnlyAuthenticationResults
    */
    static
    bool useOnlyAuthenticationResults()
    {
      return self()->mUseOnlyAuthenticationResults;
    }

    /**
      Is UseOnlyAuthenticationResults Immutable
    */
    static
    bool isUseOnlyAuthenticationResultsImmutable()
    {
      return self()->isImmutable( QStringLiteral( "UseOnlyAuthenticationResults" ) );
    }

    /**
      Get Item object corresponding to UseOnlyAuthenticationResults()
    */
    ItemBool *useOnlyAuthenticationResultsItem()
    {
      return mUseOnlyAuthenticationResultsItem;
    }

    /**
      Set PublicRsaTooSmall
    */
    static
    void setPublicRsaTooSmall( int v )
    {
      if (!self()->isPublicRsaTooSmallImmutable())
        self()->mPublicRsaTooSmall = v;
    }

    /**
      Get PublicRsaTooSmall
    */
    static
    int publicRsaTooSmall()
    {
      return self()->mPublicRsaTooSmall;
    }

    /**
      Is PublicRsaTooSmall Immutable
    */
    static
    bool isPublicRsaTooSmallImmutable()
    {
      return self()->isImmutable( QStringLiteral( "PublicRsaTooSmall" ) );
    }

    /**
      Get Item object corresponding to PublicRsaTooSmall()
    */
    ItemEnum *publicRsaTooSmallItem()
    {
      return mPublicRsaTooSmallItem;
    }

    /**
      Set PolicyRsaSha1
    */
    static
    void setPolicyRsaSha1( int v )
    {
      if (!self()->isPolicyRsaSha1Immutable())
        self()->mPolicyRsaSha1 = v;
    }

    /**
      Get PolicyRsaSha1
    */
    static
    int policyRsaSha1()
    {
      return self()->mPolicyRsaSha1;
    }

    /**
      Is PolicyRsaSha1 Immutable
    */
    static
    bool isPolicyRsaSha1Immutable()
    {
      return self()->isImmutable( QStringLiteral( "PolicyRsaSha1" ) );
    }

    /**
      Get Item object corresponding to PolicyRsaSha1()
    */
    ItemEnum *policyRsaSha1Item()
    {
      return mPolicyRsaSha1Item;
    }

    /**
      Set VerifySignatureWhenOnlyTest
    */
    static
    void setVerifySignatureWhenOnlyTest( bool v )
    {
      if (!self()->isVerifySignatureWhenOnlyTestImmutable())
        self()->mVerifySignatureWhenOnlyTest = v;
    }

    /**
      Get VerifySignatureWhenOnlyTest
    */
    static
    bool verifySignatureWhenOnlyTest()
    {
      return self()->mVerifySignatureWhenOnlyTest;
    }

    /**
      Is VerifySignatureWhenOnlyTest Immutable
    */
    static
    bool isVerifySignatureWhenOnlyTestImmutable()
    {
      return self()->isImmutable( QStringLiteral( "VerifySignatureWhenOnlyTest" ) );
    }

    /**
      Get Item object corresponding to VerifySignatureWhenOnlyTest()
    */
    ItemBool *verifySignatureWhenOnlyTestItem()
    {
      return mVerifySignatureWhenOnlyTestItem;
    }

  protected:
    MessageViewerSettingsBase();
    friend class MessageViewerSettingsBaseHelper;


    // Print
    bool mPrintSelectedText;
    bool mRespectExpandCollapseSettings;
    bool mPrintBackgroundColorImages;
    bool mAlwaysShowEncryptionSignatureDetails;

    // Fonts
    QFont mFixedFont;
    int mMinimumFontSize;
    QFont mBodyFont;
    QFont mPrintFont;

    // Security
    bool mCheckPhishingUrl;

    // Reader
    bool mCloseAfterReplyOrForward;
    double mZoomFactor;
    bool mShowEmoticons;
    bool mAutoImportKeys;
    bool mShowExpandQuotesMark;
    int mCollapseQuoteLevelSpin;
    bool mShrinkQuotes;
    bool mAlwaysDecrypt;
    int mMimeTreeMode2;
    int mMimePaneHeight;
    int mMessagePaneHeight;
    QString mHeaderPluginStyleName;
    QString mHeaderStyle;
    QString mHeaderSetDisplayed;
    bool mHtmlMail;
    bool mHtmlLoadExternal;
    QString mAttachmentStrategy;
    bool mRecycleQuoteColors;
    bool mAccessKeyEnabled;
    bool mScamDetectionEnabled;
    QStringList mScamDetectionWhiteList;
    bool mMailTrackingUrlEnabled;

    // MDN
    bool mNotSendWhenEncrypted;
    int mDefaultPolicy;
    int mQuoteMessage;

    // Behaviour
    bool mDelayedMarkAsRead;
    uint mDelayedMarkTime;

    // Invitations
    bool mLegacyMangleFromToHeaders;
    bool mLegacyBodyInvites;
    bool mExchangeCompatibleInvitations;
    bool mAutomaticSending;
    bool mDeleteInvitationEmailsAfterSendingReply;
    int mAskForCommentWhenReactingToInvitation;

    // Composer
    bool mUseFixedFont;

    // Todo
    qint64 mLastSelectedFolder;

    // Event
    qint64 mLastEventSelectedFolder;

    // Note
    qint64 mLastNoteSelectedFolder;

    // DKIM
    bool mEnabledDkim;
    bool mSaveDkimResult;
    int mSaveKey;
    bool mCheckIfEmailShouldBeSigned;
    bool mUseDMarc;
    bool mUseDefaultRules;
    bool mAutogenerateRule;
    bool mAutogenerateRuleOnlyIfSenderOnSDID;
    bool mUseAuthenticationResults;
    bool mUseRelaxedParsingAuthenticationResults;
    bool mUseOnlyAuthenticationResults;
    int mPublicRsaTooSmall;
    int mPolicyRsaSha1;
    bool mVerifySignatureWhenOnlyTest;

  private:
    ItemBool *mPrintSelectedTextItem;
    ItemBool *mRespectExpandCollapseSettingsItem;
    ItemBool *mPrintBackgroundColorImagesItem;
    ItemBool *mAlwaysShowEncryptionSignatureDetailsItem;
    ItemFont *mFixedFontItem;
    ItemInt *mMinimumFontSizeItem;
    ItemFont *mBodyFontItem;
    ItemFont *mPrintFontItem;
    ItemBool *mCheckPhishingUrlItem;
    ItemBool *mCloseAfterReplyOrForwardItem;
    ItemDouble *mZoomFactorItem;
    ItemBool *mShowEmoticonsItem;
    ItemBool *mAutoImportKeysItem;
    ItemBool *mShowExpandQuotesMarkItem;
    ItemInt *mCollapseQuoteLevelSpinItem;
    ItemBool *mShrinkQuotesItem;
    ItemBool *mAlwaysDecryptItem;
    ItemEnum *mMimeTreeMode2Item;
    ItemInt *mMimePaneHeightItem;
    ItemInt *mMessagePaneHeightItem;
    ItemString *mHeaderPluginStyleNameItem;
    ItemString *mHeaderStyleItem;
    ItemString *mHeaderSetDisplayedItem;
    ItemBool *mHtmlMailItem;
    ItemBool *mHtmlLoadExternalItem;
    ItemString *mAttachmentStrategyItem;
    ItemBool *mRecycleQuoteColorsItem;
    ItemBool *mAccessKeyEnabledItem;
    ItemBool *mScamDetectionEnabledItem;
    ItemStringList *mScamDetectionWhiteListItem;
    ItemBool *mMailTrackingUrlEnabledItem;
    ItemBool *mNotSendWhenEncryptedItem;
    ItemInt *mDefaultPolicyItem;
    ItemInt *mQuoteMessageItem;
    ItemBool *mDelayedMarkAsReadItem;
    ItemUInt *mDelayedMarkTimeItem;
    ItemBool *mLegacyMangleFromToHeadersItem;
    ItemBool *mLegacyBodyInvitesItem;
    ItemBool *mExchangeCompatibleInvitationsItem;
    ItemBool *mAutomaticSendingItem;
    ItemBool *mDeleteInvitationEmailsAfterSendingReplyItem;
    ItemEnum *mAskForCommentWhenReactingToInvitationItem;
    ItemBool *mUseFixedFontItem;
    ItemLongLong *mLastSelectedFolderItem;
    ItemLongLong *mLastEventSelectedFolderItem;
    ItemLongLong *mLastNoteSelectedFolderItem;
    ItemBool *mEnabledDkimItem;
    ItemBool *mSaveDkimResultItem;
    ItemEnum *mSaveKeyItem;
    ItemBool *mCheckIfEmailShouldBeSignedItem;
    ItemBool *mUseDMarcItem;
    ItemBool *mUseDefaultRulesItem;
    ItemBool *mAutogenerateRuleItem;
    ItemBool *mAutogenerateRuleOnlyIfSenderOnSDIDItem;
    ItemBool *mUseAuthenticationResultsItem;
    ItemBool *mUseRelaxedParsingAuthenticationResultsItem;
    ItemBool *mUseOnlyAuthenticationResultsItem;
    ItemEnum *mPublicRsaTooSmallItem;
    ItemEnum *mPolicyRsaSha1Item;
    ItemBool *mVerifySignatureWhenOnlyTestItem;
};

}

#endif

