/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkBuffer;
import org.lwjgl.nuklear.NkConvertConfig;
import org.lwjgl.nuklear.NkHandle;
import org.lwjgl.nuklear.NkRect;
import org.lwjgl.nuklear.NkVec2;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_draw_list")
public class NkDrawList
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CLIP_RECT;
    public static final int CIRCLE_VTX;
    public static final int CONFIG;
    public static final int BUFFER;
    public static final int VERTICES;
    public static final int ELEMENTS;
    public static final int ELEMENT_COUNT;
    public static final int VERTEX_COUNT;
    public static final int CMD_COUNT;
    public static final int CMD_OFFSET;
    public static final int PATH_COUNT;
    public static final int PATH_OFFSET;
    public static final int LINE_AA;
    public static final int SHAPE_AA;
    public static final int USERDATA;

    public NkDrawList(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), NkDrawList.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct nk_rect")
    public NkRect clip_rect() {
        return NkDrawList.nclip_rect(this.address());
    }

    @NativeType(value="struct nk_vec2[12]")
    public NkVec2.Buffer circle_vtx() {
        return NkDrawList.ncircle_vtx(this.address());
    }

    @NativeType(value="struct nk_vec2")
    public NkVec2 circle_vtx(int index) {
        return NkDrawList.ncircle_vtx(this.address(), index);
    }

    @NativeType(value="struct nk_convert_config")
    public NkConvertConfig config() {
        return NkDrawList.nconfig(this.address());
    }

    @Nullable
    @NativeType(value="struct nk_buffer *")
    public NkBuffer buffer() {
        return NkDrawList.nbuffer(this.address());
    }

    @Nullable
    @NativeType(value="struct nk_buffer *")
    public NkBuffer vertices() {
        return NkDrawList.nvertices(this.address());
    }

    @Nullable
    @NativeType(value="struct nk_buffer *")
    public NkBuffer elements() {
        return NkDrawList.nelements(this.address());
    }

    @NativeType(value="unsigned int")
    public int element_count() {
        return NkDrawList.nelement_count(this.address());
    }

    @NativeType(value="unsigned int")
    public int vertex_count() {
        return NkDrawList.nvertex_count(this.address());
    }

    @NativeType(value="unsigned int")
    public int cmd_count() {
        return NkDrawList.ncmd_count(this.address());
    }

    @NativeType(value="nk_size")
    public long cmd_offset() {
        return NkDrawList.ncmd_offset(this.address());
    }

    @NativeType(value="unsigned int")
    public int path_count() {
        return NkDrawList.npath_count(this.address());
    }

    @NativeType(value="unsigned int")
    public int path_offset() {
        return NkDrawList.npath_offset(this.address());
    }

    @NativeType(value="enum nk_anti_aliasing")
    public int line_AA() {
        return NkDrawList.nline_AA(this.address());
    }

    @NativeType(value="enum nk_anti_aliasing")
    public int shape_AA() {
        return NkDrawList.nshape_AA(this.address());
    }

    @NativeType(value="nk_handle")
    public NkHandle userdata() {
        return NkDrawList.nuserdata(this.address());
    }

    public static NkDrawList malloc() {
        return (NkDrawList)NkDrawList.wrap(NkDrawList.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static NkDrawList calloc() {
        return (NkDrawList)NkDrawList.wrap(NkDrawList.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static NkDrawList create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (NkDrawList)NkDrawList.wrap(NkDrawList.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static NkDrawList create(long address) {
        return (NkDrawList)NkDrawList.wrap(NkDrawList.class, (long)address);
    }

    @Nullable
    public static NkDrawList createSafe(long address) {
        return address == 0L ? null : (NkDrawList)NkDrawList.wrap(NkDrawList.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)NkDrawList.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)NkDrawList.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)NkDrawList.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NkDrawList.__create((int)capacity, (int)SIZEOF);
        return (Buffer)NkDrawList.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)NkDrawList.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)NkDrawList.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static NkDrawList mallocStack() {
        return NkDrawList.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkDrawList callocStack() {
        return NkDrawList.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkDrawList mallocStack(MemoryStack stack) {
        return NkDrawList.malloc(stack);
    }

    @Deprecated
    public static NkDrawList callocStack(MemoryStack stack) {
        return NkDrawList.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return NkDrawList.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return NkDrawList.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkDrawList.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkDrawList.calloc(capacity, stack);
    }

    public static NkDrawList malloc(MemoryStack stack) {
        return (NkDrawList)NkDrawList.wrap(NkDrawList.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NkDrawList calloc(MemoryStack stack) {
        return (NkDrawList)NkDrawList.wrap(NkDrawList.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)NkDrawList.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)NkDrawList.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static NkRect nclip_rect(long struct) {
        return NkRect.create(struct + (long)CLIP_RECT);
    }

    public static NkVec2.Buffer ncircle_vtx(long struct) {
        return NkVec2.create(struct + (long)CIRCLE_VTX, 12);
    }

    public static NkVec2 ncircle_vtx(long struct, int index) {
        return NkVec2.create(struct + (long)CIRCLE_VTX + Checks.check((int)index, (int)12) * (long)NkVec2.SIZEOF);
    }

    public static NkConvertConfig nconfig(long struct) {
        return NkConvertConfig.create(struct + (long)CONFIG);
    }

    @Nullable
    public static NkBuffer nbuffer(long struct) {
        return NkBuffer.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)BUFFER)));
    }

    @Nullable
    public static NkBuffer nvertices(long struct) {
        return NkBuffer.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)VERTICES)));
    }

    @Nullable
    public static NkBuffer nelements(long struct) {
        return NkBuffer.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)ELEMENTS)));
    }

    public static int nelement_count(long struct) {
        return UNSAFE.getInt(null, struct + (long)ELEMENT_COUNT);
    }

    public static int nvertex_count(long struct) {
        return UNSAFE.getInt(null, struct + (long)VERTEX_COUNT);
    }

    public static int ncmd_count(long struct) {
        return UNSAFE.getInt(null, struct + (long)CMD_COUNT);
    }

    public static long ncmd_offset(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)CMD_OFFSET));
    }

    public static int npath_count(long struct) {
        return UNSAFE.getInt(null, struct + (long)PATH_COUNT);
    }

    public static int npath_offset(long struct) {
        return UNSAFE.getInt(null, struct + (long)PATH_OFFSET);
    }

    public static int nline_AA(long struct) {
        return UNSAFE.getInt(null, struct + (long)LINE_AA);
    }

    public static int nshape_AA(long struct) {
        return UNSAFE.getInt(null, struct + (long)SHAPE_AA);
    }

    public static NkHandle nuserdata(long struct) {
        return NkHandle.create(struct + (long)USERDATA);
    }

    static {
        Struct.Layout layout = NkDrawList.__struct((Struct.Member[])new Struct.Member[]{NkDrawList.__member((int)NkRect.SIZEOF, (int)NkRect.ALIGNOF), NkDrawList.__array((int)NkVec2.SIZEOF, (int)NkVec2.ALIGNOF, (int)12), NkDrawList.__member((int)NkConvertConfig.SIZEOF, (int)NkConvertConfig.ALIGNOF), NkDrawList.__member((int)POINTER_SIZE), NkDrawList.__member((int)POINTER_SIZE), NkDrawList.__member((int)POINTER_SIZE), NkDrawList.__member((int)4), NkDrawList.__member((int)4), NkDrawList.__member((int)4), NkDrawList.__member((int)POINTER_SIZE), NkDrawList.__member((int)4), NkDrawList.__member((int)4), NkDrawList.__member((int)4), NkDrawList.__member((int)4), NkDrawList.__member((int)NkHandle.SIZEOF, (int)NkHandle.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        CLIP_RECT = layout.offsetof(0);
        CIRCLE_VTX = layout.offsetof(1);
        CONFIG = layout.offsetof(2);
        BUFFER = layout.offsetof(3);
        VERTICES = layout.offsetof(4);
        ELEMENTS = layout.offsetof(5);
        ELEMENT_COUNT = layout.offsetof(6);
        VERTEX_COUNT = layout.offsetof(7);
        CMD_COUNT = layout.offsetof(8);
        CMD_OFFSET = layout.offsetof(9);
        PATH_COUNT = layout.offsetof(10);
        PATH_OFFSET = layout.offsetof(11);
        LINE_AA = layout.offsetof(12);
        SHAPE_AA = layout.offsetof(13);
        USERDATA = layout.offsetof(14);
    }

    public static class Buffer
    extends StructBuffer<NkDrawList, Buffer>
    implements NativeResource {
        private static final NkDrawList ELEMENT_FACTORY = NkDrawList.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected NkDrawList getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="struct nk_rect")
        public NkRect clip_rect() {
            return NkDrawList.nclip_rect(this.address());
        }

        @NativeType(value="struct nk_vec2[12]")
        public NkVec2.Buffer circle_vtx() {
            return NkDrawList.ncircle_vtx(this.address());
        }

        @NativeType(value="struct nk_vec2")
        public NkVec2 circle_vtx(int index) {
            return NkDrawList.ncircle_vtx(this.address(), index);
        }

        @NativeType(value="struct nk_convert_config")
        public NkConvertConfig config() {
            return NkDrawList.nconfig(this.address());
        }

        @Nullable
        @NativeType(value="struct nk_buffer *")
        public NkBuffer buffer() {
            return NkDrawList.nbuffer(this.address());
        }

        @Nullable
        @NativeType(value="struct nk_buffer *")
        public NkBuffer vertices() {
            return NkDrawList.nvertices(this.address());
        }

        @Nullable
        @NativeType(value="struct nk_buffer *")
        public NkBuffer elements() {
            return NkDrawList.nelements(this.address());
        }

        @NativeType(value="unsigned int")
        public int element_count() {
            return NkDrawList.nelement_count(this.address());
        }

        @NativeType(value="unsigned int")
        public int vertex_count() {
            return NkDrawList.nvertex_count(this.address());
        }

        @NativeType(value="unsigned int")
        public int cmd_count() {
            return NkDrawList.ncmd_count(this.address());
        }

        @NativeType(value="nk_size")
        public long cmd_offset() {
            return NkDrawList.ncmd_offset(this.address());
        }

        @NativeType(value="unsigned int")
        public int path_count() {
            return NkDrawList.npath_count(this.address());
        }

        @NativeType(value="unsigned int")
        public int path_offset() {
            return NkDrawList.npath_offset(this.address());
        }

        @NativeType(value="enum nk_anti_aliasing")
        public int line_AA() {
            return NkDrawList.nline_AA(this.address());
        }

        @NativeType(value="enum nk_anti_aliasing")
        public int shape_AA() {
            return NkDrawList.nshape_AA(this.address());
        }

        @NativeType(value="nk_handle")
        public NkHandle userdata() {
            return NkDrawList.nuserdata(this.address());
        }
    }
}

