/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.llvm.LLVMJITSymbolFlags;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class LLVMJITEvaluatedSymbol
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ADDRESS;
    public static final int FLAGS;

    public LLVMJITEvaluatedSymbol(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), LLVMJITEvaluatedSymbol.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="LLVMOrcExecutorAddress")
    public long Address() {
        return LLVMJITEvaluatedSymbol.nAddress(this.address());
    }

    public LLVMJITSymbolFlags Flags() {
        return LLVMJITEvaluatedSymbol.nFlags(this.address());
    }

    public LLVMJITEvaluatedSymbol Address(@NativeType(value="LLVMOrcExecutorAddress") long value) {
        LLVMJITEvaluatedSymbol.nAddress(this.address(), value);
        return this;
    }

    public LLVMJITEvaluatedSymbol Flags(LLVMJITSymbolFlags value) {
        LLVMJITEvaluatedSymbol.nFlags(this.address(), value);
        return this;
    }

    public LLVMJITEvaluatedSymbol Flags(Consumer<LLVMJITSymbolFlags> consumer) {
        consumer.accept(this.Flags());
        return this;
    }

    public LLVMJITEvaluatedSymbol set(long Address, LLVMJITSymbolFlags Flags) {
        this.Address(Address);
        this.Flags(Flags);
        return this;
    }

    public LLVMJITEvaluatedSymbol set(LLVMJITEvaluatedSymbol src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static LLVMJITEvaluatedSymbol malloc() {
        return (LLVMJITEvaluatedSymbol)LLVMJITEvaluatedSymbol.wrap(LLVMJITEvaluatedSymbol.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static LLVMJITEvaluatedSymbol calloc() {
        return (LLVMJITEvaluatedSymbol)LLVMJITEvaluatedSymbol.wrap(LLVMJITEvaluatedSymbol.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static LLVMJITEvaluatedSymbol create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (LLVMJITEvaluatedSymbol)LLVMJITEvaluatedSymbol.wrap(LLVMJITEvaluatedSymbol.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static LLVMJITEvaluatedSymbol create(long address) {
        return (LLVMJITEvaluatedSymbol)LLVMJITEvaluatedSymbol.wrap(LLVMJITEvaluatedSymbol.class, (long)address);
    }

    @Nullable
    public static LLVMJITEvaluatedSymbol createSafe(long address) {
        return address == 0L ? null : (LLVMJITEvaluatedSymbol)LLVMJITEvaluatedSymbol.wrap(LLVMJITEvaluatedSymbol.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)LLVMJITEvaluatedSymbol.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)LLVMJITEvaluatedSymbol.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)LLVMJITEvaluatedSymbol.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = LLVMJITEvaluatedSymbol.__create((int)capacity, (int)SIZEOF);
        return (Buffer)LLVMJITEvaluatedSymbol.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)LLVMJITEvaluatedSymbol.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)LLVMJITEvaluatedSymbol.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static LLVMJITEvaluatedSymbol malloc(MemoryStack stack) {
        return (LLVMJITEvaluatedSymbol)LLVMJITEvaluatedSymbol.wrap(LLVMJITEvaluatedSymbol.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static LLVMJITEvaluatedSymbol calloc(MemoryStack stack) {
        return (LLVMJITEvaluatedSymbol)LLVMJITEvaluatedSymbol.wrap(LLVMJITEvaluatedSymbol.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)LLVMJITEvaluatedSymbol.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)LLVMJITEvaluatedSymbol.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static long nAddress(long struct) {
        return UNSAFE.getLong(null, struct + (long)ADDRESS);
    }

    public static LLVMJITSymbolFlags nFlags(long struct) {
        return LLVMJITSymbolFlags.create(struct + (long)FLAGS);
    }

    public static void nAddress(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)ADDRESS, value);
    }

    public static void nFlags(long struct, LLVMJITSymbolFlags value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)FLAGS), (long)LLVMJITSymbolFlags.SIZEOF);
    }

    static {
        Struct.Layout layout = LLVMJITEvaluatedSymbol.__struct((Struct.Member[])new Struct.Member[]{LLVMJITEvaluatedSymbol.__member((int)8), LLVMJITEvaluatedSymbol.__member((int)LLVMJITSymbolFlags.SIZEOF, (int)LLVMJITSymbolFlags.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ADDRESS = layout.offsetof(0);
        FLAGS = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<LLVMJITEvaluatedSymbol, Buffer>
    implements NativeResource {
        private static final LLVMJITEvaluatedSymbol ELEMENT_FACTORY = LLVMJITEvaluatedSymbol.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected LLVMJITEvaluatedSymbol getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="LLVMOrcExecutorAddress")
        public long Address() {
            return LLVMJITEvaluatedSymbol.nAddress(this.address());
        }

        public LLVMJITSymbolFlags Flags() {
            return LLVMJITEvaluatedSymbol.nFlags(this.address());
        }

        public Buffer Address(@NativeType(value="LLVMOrcExecutorAddress") long value) {
            LLVMJITEvaluatedSymbol.nAddress(this.address(), value);
            return this;
        }

        public Buffer Flags(LLVMJITSymbolFlags value) {
            LLVMJITEvaluatedSymbol.nFlags(this.address(), value);
            return this;
        }

        public Buffer Flags(Consumer<LLVMJITSymbolFlags> consumer) {
            consumer.accept(this.Flags());
            return this;
        }
    }
}

