/*
 * Decompiled with CFR 0.152.
 */
package liquibase;

import liquibase.database.Database;
import liquibase.structure.core.Catalog;
import liquibase.structure.core.Schema;
import liquibase.util.StringUtils;

public class CatalogAndSchema {
    private String catalogName;
    private String schemaName;
    public static final CatalogAndSchema DEFAULT = new CatalogAndSchema(null, null);

    public CatalogAndSchema(String catalogName, String schemaName) {
        this.catalogName = catalogName;
        this.schemaName = schemaName;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public boolean equals(CatalogAndSchema catalogAndSchema, Database accordingTo) {
        if (!accordingTo.supportsCatalogs()) {
            return true;
        }
        catalogAndSchema = catalogAndSchema.customize(accordingTo);
        CatalogAndSchema thisCatalogAndSchema = this.customize(accordingTo);
        boolean catalogMatches = catalogAndSchema.getCatalogName() == null ? thisCatalogAndSchema.getCatalogName() == null : catalogAndSchema.getCatalogName().equalsIgnoreCase(thisCatalogAndSchema.getCatalogName());
        if (!catalogMatches) {
            return false;
        }
        if (accordingTo.supportsSchemas()) {
            if (catalogAndSchema.getSchemaName() == null) {
                return thisCatalogAndSchema.getSchemaName() == null;
            }
            return catalogAndSchema.getSchemaName().equalsIgnoreCase(thisCatalogAndSchema.getSchemaName());
        }
        return true;
    }

    public CatalogAndSchema standardize(Database accordingTo) {
        String catalogName = StringUtils.trimToNull(this.getCatalogName());
        String schemaName = StringUtils.trimToNull(this.getSchemaName());
        if (!accordingTo.supportsCatalogs()) {
            return new CatalogAndSchema(null, null);
        }
        if (accordingTo.supportsSchemas()) {
            if (schemaName != null && schemaName.equalsIgnoreCase(accordingTo.getDefaultSchemaName())) {
                schemaName = null;
            }
        } else {
            if (catalogName == null && schemaName != null) {
                catalogName = schemaName;
            }
            schemaName = catalogName;
        }
        if (catalogName != null && catalogName.equalsIgnoreCase(accordingTo.getDefaultCatalogName())) {
            catalogName = null;
        }
        if (schemaName != null && schemaName.equalsIgnoreCase(accordingTo.getDefaultSchemaName())) {
            schemaName = null;
        }
        if (!accordingTo.supportsSchemas() && catalogName != null && schemaName != null && !catalogName.equals(schemaName)) {
            schemaName = null;
        }
        if (catalogName != null) {
            catalogName = catalogName.toUpperCase();
        }
        if (schemaName != null) {
            schemaName = schemaName.toUpperCase();
        }
        return new CatalogAndSchema(catalogName, schemaName);
    }

    public CatalogAndSchema customize(Database accordingTo) {
        CatalogAndSchema standard = this.standardize(accordingTo);
        String catalogName = standard.getCatalogName();
        String schemaName = standard.getSchemaName();
        if (catalogName == null) {
            if (!accordingTo.supportsSchemas() && schemaName != null) {
                return new CatalogAndSchema(accordingTo.correctObjectName(schemaName, Catalog.class), null);
            }
            catalogName = accordingTo.getDefaultCatalogName();
        }
        if (schemaName == null) {
            schemaName = accordingTo.getDefaultSchemaName();
        }
        if (catalogName != null) {
            catalogName = accordingTo.correctObjectName(catalogName, Catalog.class);
        }
        if (schemaName != null) {
            schemaName = accordingTo.correctObjectName(schemaName, Schema.class);
        }
        return new CatalogAndSchema(catalogName, schemaName);
    }

    public String toString() {
        String catalogName = this.getCatalogName();
        String schemaName = this.getSchemaName();
        if (catalogName == null) {
            catalogName = "DEFAULT";
        }
        if (schemaName == null) {
            schemaName = "DEFAULT";
        }
        return catalogName + "." + schemaName;
    }
}

