/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.normalizer;

import java.io.IOException;
import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.State;
import org.jfree.layouting.StateException;
import org.jfree.layouting.StatefullComponent;
import org.jfree.layouting.input.style.PseudoPage;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.normalizer.content.NormalizationException;
import org.jfree.layouting.normalizer.content.Normalizer;
import org.jfree.layouting.renderer.ChainingRenderer;
import org.jfree.layouting.renderer.Renderer;
import org.jfree.layouting.util.AttributeMap;
import org.jfree.layouting.util.ChainingCallException;

public class ChainingNormalizer
implements Normalizer {
    private Normalizer chainedNormalizer;

    public ChainingNormalizer(Normalizer normalizer) {
        if (normalizer == null) {
            throw new NullPointerException();
        }
        this.chainedNormalizer = normalizer;
    }

    @Override
    public void startDocument() throws NormalizationException, IOException {
        this.chainedNormalizer.startDocument();
        this.commitCalls();
    }

    public synchronized void commitCalls() throws NormalizationException {
        ChainingRenderer chainingRenderer = (ChainingRenderer)this.chainedNormalizer.getRenderer();
        if (chainingRenderer != null) {
            try {
                chainingRenderer.replay(chainingRenderer.getRenderer());
            }
            catch (ChainingCallException chainingCallException) {
                throw new NormalizationException("Failed to dispatch calls", (Exception)((Object)chainingCallException));
            }
        }
    }

    @Override
    public void startElement(String string, String string2, AttributeMap attributeMap) throws NormalizationException, IOException {
        this.chainedNormalizer.startElement(string, string2, attributeMap);
        this.commitCalls();
    }

    @Override
    public void addText(String string) throws NormalizationException, IOException {
        this.chainedNormalizer.addText(string);
        this.commitCalls();
    }

    @Override
    public void endElement() throws NormalizationException, IOException {
        this.chainedNormalizer.endElement();
        this.commitCalls();
    }

    @Override
    public void endDocument() throws NormalizationException, IOException {
        this.chainedNormalizer.endDocument();
        this.commitCalls();
    }

    @Override
    public void handlePageBreak(CSSValue cSSValue, PseudoPage[] pseudoPageArray) throws NormalizationException {
        this.chainedNormalizer.handlePageBreak(cSSValue, pseudoPageArray);
        this.commitCalls();
    }

    @Override
    public State saveState() throws StateException {
        ChainingNormalizerState chainingNormalizerState = new ChainingNormalizerState();
        chainingNormalizerState.setChainedNormalizerState(this.chainedNormalizer.saveState());
        return chainingNormalizerState;
    }

    @Override
    public Renderer getRenderer() {
        return this.chainedNormalizer.getRenderer();
    }

    private static class ChainingNormalizerState
    implements State {
        private State chainedNormalizerState;

        private ChainingNormalizerState() {
        }

        public State getChainedNormalizerState() {
            return this.chainedNormalizerState;
        }

        public void setChainedNormalizerState(State state) {
            this.chainedNormalizerState = state;
        }

        @Override
        public StatefullComponent restore(LayoutProcess layoutProcess) throws StateException {
            Normalizer normalizer = (Normalizer)this.chainedNormalizerState.restore(layoutProcess);
            return new ChainingNormalizer(normalizer);
        }
    }
}

