---
id: Modal
section: components
cssPrefix: pf-v5-c-modal-box
---import './ModalBox.css'

## Examples

### Basic

```html isFullscreen
<div
  class="pf-v5-c-modal-box"
  role="dialog"
  aria-modal="true"
  aria-labelledby="modal-title"
  aria-describedby="modal-description"
>
  <div class="pf-v5-c-modal-box__close">
    <button class="pf-v5-c-button pf-m-plain" type="button" aria-label="Close">
      <i class="fas fa-times" aria-hidden="true"></i>
    </button>
  </div>
  <header class="pf-v5-c-modal-box__header">
    <h1 class="pf-v5-c-modal-box__title" id="modal-title">Modal title</h1>
  </header>
  <div
    class="pf-v5-c-modal-box__body"
    id="modal-description"
  >To support screen reader user awareness of the dialog text, the dialog text is wrapped in a div that is referenced by aria-describedby.</div>
  <footer class="pf-v5-c-modal-box__footer">Modal footer</footer>
</div>

```

### With help button

```html isFullscreen
<div
  class="pf-v5-c-modal-box"
  role="dialog"
  aria-modal="true"
  aria-labelledby="modal-help-title"
  aria-describedby="modal-help-description"
>
  <div class="pf-v5-c-modal-box__close">
    <button class="pf-v5-c-button pf-m-plain" type="button" aria-label="Close">
      <i class="fas fa-times" aria-hidden="true"></i>
    </button>
  </div>
  <header class="pf-v5-c-modal-box__header pf-m-help">
    <div class="pf-v5-c-modal-box__header-main">
      <h1
        class="pf-v5-c-modal-box__title"
        id="modal-help-title"
      >Modal title Modal title Modal title Modal title Modal title Modal title Modal title Modal title</h1>
      <div
        class="pf-v5-c-modal-box__description"
        id="modal-help-description"
      >A description is used when you want to provide more info about the modal than the title is able to describe. The content in the description is static and will not scroll with the rest of the modal body.</div>
    </div>
    <div class="pf-v5-c-modal-box__header-help">
      <button class="pf-v5-c-button pf-m-plain" type="button" aria-label="Help">
        <i class="pf-v5-pficon pf-v5-pficon-help" aria-hidden="true"></i>
      </button>
    </div>
  </header>
  <div
    class="pf-v5-c-modal-box__body"
  >To support screen reader user awareness of the dialog text, the dialog text is wrapped in a div that is referenced by aria-describedby.</div>
  <footer class="pf-v5-c-modal-box__footer">Modal footer</footer>
</div>

```

### Small

```html isFullscreen
<div
  class="pf-v5-c-modal-box pf-m-sm"
  role="dialog"
  aria-modal="true"
  aria-labelledby="modal-sm-title"
  aria-describedby="modal-sm-description"
>
  <div class="pf-v5-c-modal-box__close">
    <button class="pf-v5-c-button pf-m-plain" type="button" aria-label="Close">
      <i class="fas fa-times" aria-hidden="true"></i>
    </button>
  </div>
  <header class="pf-v5-c-modal-box__header">
    <h1 class="pf-v5-c-modal-box__title" id="modal-sm-title">Modal title</h1>
  </header>
  <div class="pf-v5-c-modal-box__body" id="modal-sm-description">
    Static text describing modal purpose. Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod
    tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam,
    quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo
    consequat.
  </div>
  <footer class="pf-v5-c-modal-box__footer">Modal footer</footer>
</div>

```

### Medium

```html isFullscreen
<div
  class="pf-v5-c-modal-box pf-m-md"
  role="dialog"
  aria-modal="true"
  aria-labelledby="modal-md-title"
  aria-describedby="modal-md-description"
>
  <div class="pf-v5-c-modal-box__close">
    <button class="pf-v5-c-button pf-m-plain" type="button" aria-label="Close">
      <i class="fas fa-times" aria-hidden="true"></i>
    </button>
  </div>
  <header class="pf-v5-c-modal-box__header">
    <h1 class="pf-v5-c-modal-box__title" id="modal-md-title">Modal title</h1>
  </header>
  <div class="pf-v5-c-modal-box__body" id="modal-md-description">
    Static text describing modal purpose. Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod
    tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam,
    quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo
    consequat.
  </div>
  <footer class="pf-v5-c-modal-box__footer">Modal footer</footer>
</div>

```

### Large

```html isFullscreen
<div
  class="pf-v5-c-modal-box pf-m-lg"
  role="dialog"
  aria-modal="true"
  aria-labelledby="modal-lg-title"
  aria-describedby="modal-lg-description"
>
  <div class="pf-v5-c-modal-box__close">
    <button class="pf-v5-c-button pf-m-plain" type="button" aria-label="Close">
      <i class="fas fa-times" aria-hidden="true"></i>
    </button>
  </div>
  <header class="pf-v5-c-modal-box__header">
    <h1 class="pf-v5-c-modal-box__title" id="modal-lg-title">Modal title</h1>
  </header>
  <div class="pf-v5-c-modal-box__body" id="modal-lg-description">
    Static text describing modal purpose. Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod
    tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam,
    quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo
    consequat.
  </div>
  <footer class="pf-v5-c-modal-box__footer">Modal footer</footer>
</div>

```

### Without title

```html isFullscreen
<div
  class="pf-v5-c-modal-box"
  role="dialog"
  aria-modal="true"
  aria-label="Example of a modal without a title"
  aria-describedby="modal-no-title-description"
>
  <div class="pf-v5-c-modal-box__close">
    <button class="pf-v5-c-button pf-m-plain" type="button" aria-label="Close">
      <i class="fas fa-times" aria-hidden="true"></i>
    </button>
  </div>
  <div class="pf-v5-c-modal-box__body">
    <span
      id="modal-no-title-description"
    >When static text describing the modal is available, it can be wrapped with an ID referring to the modal's aria-describedby value. Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</span> Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.
  </div>
  <footer class="pf-v5-c-modal-box__footer">Modal footer</footer>
</div>

```

### With description

```html isFullscreen
<div
  class="pf-v5-c-modal-box"
  role="dialog"
  aria-modal="true"
  aria-labelledby="modal-with-description-title"
  aria-describedby="modal-with-description-description"
>
  <div class="pf-v5-c-modal-box__close">
    <button class="pf-v5-c-button pf-m-plain" type="button" aria-label="Close">
      <i class="fas fa-times" aria-hidden="true"></i>
    </button>
  </div>
  <header class="pf-v5-c-modal-box__header">
    <h1
      class="pf-v5-c-modal-box__title"
      id="modal-with-description-title"
    >Modal title</h1>
    <div
      class="pf-v5-c-modal-box__description"
      id="modal-with-description-description"
    >A description is used when you want to provide more info about the modal than the title is able to describe. The content in the description is static and will not scroll with the rest of the modal body.</div>
  </header>
  <div
    class="pf-v5-c-modal-box__body"
  >To support screen reader user awareness of the dialog text, the dialog text is wrapped in a div that is referenced by aria-describedby.</div>
  <footer class="pf-v5-c-modal-box__footer">Modal footer</footer>
</div>

```

### Custom title

```html isFullscreen
<div
  class="pf-v5-c-modal-box"
  role="dialog"
  aria-modal="true"
  aria-labelledby="modal-custom-title"
  aria-describedby="modal-custom-description"
>
  <div class="pf-v5-c-modal-box__close">
    <button class="pf-v5-c-button pf-m-plain" type="button" aria-label="Close">
      <i class="fas fa-times" aria-hidden="true"></i>
    </button>
  </div>
  <header class="pf-v5-c-modal-box__header">
    <h1 class="pf-v5-c-title pf-m-4xl" id="modal-custom-title">Custom title</h1>
  </header>
  <div
    class="pf-v5-c-modal-box__body"
    id="modal-custom-description"
  >To support screen reader user awareness of the dialog text, the dialog text is wrapped in a div that is referenced by aria-describedby.</div>
  <footer class="pf-v5-c-modal-box__footer">Modal footer</footer>
</div>

```

### Modal box as generic container

```html isFullscreen
<div
  class="pf-v5-c-modal-box"
  role="dialog"
  aria-modal="true"
  aria-labelledby="modal-generic-container-description"
>
  <p
    id="modal-generic-container-description"
  >The modal box children elements can be removed, and the modal serves as a generic modal container. One use case of this is when creating a wizard in a modal.</p>
</div>

```

### Icon

```html isFullscreen
<div
  class="pf-v5-c-modal-box"
  role="dialog"
  aria-modal="true"
  aria-labelledby="icon-title"
  aria-describedby="icon-description"
>
  <div class="pf-v5-c-modal-box__close">
    <button class="pf-v5-c-button pf-m-plain" type="button" aria-label="Close">
      <i class="fas fa-times" aria-hidden="true"></i>
    </button>
  </div>
  <header class="pf-v5-c-modal-box__header">
    <h1 class="pf-v5-c-modal-box__title pf-m-icon" id="icon-title">
      <span class="pf-v5-c-modal-box__title-icon">
        <i class="fas fa-fw fa-bullhorn" aria-hidden="true"></i>
      </span>
      <span class="pf-v5-c-modal-box__title-text">Modal with icon title</span>
    </h1>
  </header>
  <div class="pf-v5-c-modal-box__body" id="icon-description">Modal description</div>
  <footer class="pf-v5-c-modal-box__footer">Modal footer</footer>
</div>

```

### Custom alert

```html isFullscreen
<div
  class="pf-v5-c-modal-box pf-m-custom"
  role="dialog"
  aria-modal="true"
  aria-labelledby="custom-alert-title"
  aria-describedby="custom-alert-description"
>
  <div class="pf-v5-c-modal-box__close">
    <button class="pf-v5-c-button pf-m-plain" type="button" aria-label="Close">
      <i class="fas fa-times" aria-hidden="true"></i>
    </button>
  </div>
  <header class="pf-v5-c-modal-box__header">
    <h1 class="pf-v5-c-modal-box__title pf-m-icon" id="custom-alert-title">
      <span class="pf-v5-c-modal-box__title-icon">
        <i class="fas fa-fw fa-bell" aria-hidden="true"></i>
      </span>
      <span class="pf-v5-u-screen-reader">
        Default
        alert:
      </span>
      <span class="pf-v5-c-modal-box__title-text">Custom alert modal title</span>
    </h1>
  </header>
  <div
    class="pf-v5-c-modal-box__body"
    id="custom-alert-description"
  >Modal description</div>
  <footer class="pf-v5-c-modal-box__footer">Modal footer</footer>
</div>

```

### Info alert

```html isFullscreen
<div
  class="pf-v5-c-modal-box pf-m-info"
  role="dialog"
  aria-modal="true"
  aria-labelledby="info-alert-title"
  aria-describedby="info-alert-description"
>
  <div class="pf-v5-c-modal-box__close">
    <button class="pf-v5-c-button pf-m-plain" type="button" aria-label="Close">
      <i class="fas fa-times" aria-hidden="true"></i>
    </button>
  </div>
  <header class="pf-v5-c-modal-box__header">
    <h1 class="pf-v5-c-modal-box__title pf-m-icon" id="info-alert-title">
      <span class="pf-v5-c-modal-box__title-icon">
        <i class="fas fa-fw fa-info-circle" aria-hidden="true"></i>
      </span>
      <span class="pf-v5-u-screen-reader">
        Info
        alert:
      </span>
      <span class="pf-v5-c-modal-box__title-text">Info alert modal title</span>
    </h1>
  </header>
  <div
    class="pf-v5-c-modal-box__body"
    id="info-alert-description"
  >Modal description</div>
  <footer class="pf-v5-c-modal-box__footer">Modal footer</footer>
</div>

```

### Success alert

```html isFullscreen
<div
  class="pf-v5-c-modal-box pf-m-success"
  role="dialog"
  aria-modal="true"
  aria-labelledby="success-alert-title"
  aria-describedby="success-alert-description"
>
  <div class="pf-v5-c-modal-box__close">
    <button class="pf-v5-c-button pf-m-plain" type="button" aria-label="Close">
      <i class="fas fa-times" aria-hidden="true"></i>
    </button>
  </div>
  <header class="pf-v5-c-modal-box__header">
    <h1 class="pf-v5-c-modal-box__title pf-m-icon" id="success-alert-title">
      <span class="pf-v5-c-modal-box__title-icon">
        <i class="fas fa-fw fa-check-circle" aria-hidden="true"></i>
      </span>
      <span class="pf-v5-u-screen-reader">
        Success
        alert:
      </span>
      <span class="pf-v5-c-modal-box__title-text">Success alert modal title</span>
    </h1>
  </header>
  <div
    class="pf-v5-c-modal-box__body"
    id="success-alert-description"
  >Modal description</div>
  <footer class="pf-v5-c-modal-box__footer">Modal footer</footer>
</div>

```

### Warning alert

```html isFullscreen
<div
  class="pf-v5-c-modal-box pf-m-warning"
  role="dialog"
  aria-modal="true"
  aria-labelledby="warning-alert-title"
  aria-describedby="warning-alert-description"
>
  <div class="pf-v5-c-modal-box__close">
    <button class="pf-v5-c-button pf-m-plain" type="button" aria-label="Close">
      <i class="fas fa-times" aria-hidden="true"></i>
    </button>
  </div>
  <header class="pf-v5-c-modal-box__header">
    <h1 class="pf-v5-c-modal-box__title pf-m-icon" id="warning-alert-title">
      <span class="pf-v5-c-modal-box__title-icon">
        <i class="fas fa-fw fa-exclamation-triangle" aria-hidden="true"></i>
      </span>
      <span class="pf-v5-u-screen-reader">
        Warning
        alert:
      </span>
      <span class="pf-v5-c-modal-box__title-text">Warning alert modal title</span>
    </h1>
  </header>
  <div
    class="pf-v5-c-modal-box__body"
    id="warning-alert-description"
  >Modal description</div>
  <footer class="pf-v5-c-modal-box__footer">Modal footer</footer>
</div>

```

### Danger alert

```html isFullscreen
<div
  class="pf-v5-c-modal-box pf-m-danger"
  role="dialog"
  aria-modal="true"
  aria-labelledby="danger-alert-title"
  aria-describedby="danger-alert-description"
>
  <div class="pf-v5-c-modal-box__close">
    <button class="pf-v5-c-button pf-m-plain" type="button" aria-label="Close">
      <i class="fas fa-times" aria-hidden="true"></i>
    </button>
  </div>
  <header class="pf-v5-c-modal-box__header">
    <h1 class="pf-v5-c-modal-box__title pf-m-icon" id="danger-alert-title">
      <span class="pf-v5-c-modal-box__title-icon">
        <i class="fas fa-fw fa-exclamation-circle" aria-hidden="true"></i>
      </span>
      <span class="pf-v5-u-screen-reader">
        Danger
        alert:
      </span>
      <span class="pf-v5-c-modal-box__title-text">Danger alert modal title</span>
    </h1>
  </header>
  <div
    class="pf-v5-c-modal-box__body"
    id="danger-alert-description"
  >To support screen reader user awareness of the dialog text, the dialog text is wrapped in a div that is referenced by aria-describedby.</div>
  <footer class="pf-v5-c-modal-box__footer">Modal footer</footer>
</div>

```

### Danger alert with modifier on modal title

The status modifier classes can be applied directly to the modal title element, instead of the parent modal.

```html isFullscreen isBeta
<div
  class="pf-v5-c-modal-box"
  role="dialog"
  aria-modal="true"
  aria-labelledby="danger-alert-title-title"
  aria-describedby="danger-alert-title-description"
>
  <div class="pf-v5-c-modal-box__close">
    <button class="pf-v5-c-button pf-m-plain" type="button" aria-label="Close">
      <i class="fas fa-times" aria-hidden="true"></i>
    </button>
  </div>
  <header class="pf-v5-c-modal-box__header">
    <h1
      class="pf-v5-c-modal-box__title pf-m-icon pf-m-danger"
      id="danger-alert-title-title"
    >
      <span class="pf-v5-c-modal-box__title-icon">
        <i class="fas fa-fw fa-exclamation-circle" aria-hidden="true"></i>
      </span>
      <span class="pf-v5-u-screen-reader">
        Danger
        alert:
      </span>
      <span class="pf-v5-c-modal-box__title-text">Danger alert modal title</span>
    </h1>
  </header>
  <div
    class="pf-v5-c-modal-box__body"
    id="danger-alert-title-description"
  >To support screen reader user awareness of the dialog text, the dialog text is wrapped in a div that is referenced by aria-describedby.</div>
  <footer class="pf-v5-c-modal-box__footer">Modal footer</footer>
</div>

```

## Documentation

### Overview

A modal box is a generic rectangular container that can be used to build modals. A modal box can have the following sections: header, title, description, body, and footer. With normal use of the modal, a title or body is required. Alternatively, no child elements can be used, and the `.pf-v5-c-modal-box` container will  serve as a generic container with no padding for custom modal content. If no `.pf-v5-c-modal-box__title` is used, `aria-label="[title of modal]"` must be provided for `.pf-v5-c-modal-box`.

### Accessibility

| Attribute | Applies to | Outcome |
| -- | -- | -- |
| `role="dialog"` | `.pf-v5-c-modal-box` | Identifies the element that serves as the modal container. **Required** |
| `aria-labelledby="[id value of .pf-v5-c-modal-box__title or custom modal title]"` | `.pf-v5-c-modal-box` | Gives the modal an accessible name by referring to the element that provides the dialog title. **Required when .pf-v5-c-title is present** |
| `aria-label="[title of modal]"` | `.pf-v5-c-modal-box` | Gives the modal an accessible name. **Required when `.pf-v5-c-modal-box__title` is *not* present** |
| `aria-describedby="[id value of applicable content]"` | `.pf-v5-c-modal-box` | Gives the modal an accessible description by referring to the modal content that describes the primary message or purpose of the dialog. Not used if there is no static text that describes the modal. |
| `aria-modal="true"` | `.pf-v5-c-modal-box` | Tells assistive technologies that the windows underneath the current modal are not available for interaction. **Required**|
| `aria-label="Close"` | `.pf-v5-c-modal-box__close .pf-v5-c-button` | Provides an accessible name for the close button as it uses an icon instead of text. **Required**|
| `aria-hidden="true"` | Parent element containing the page contents when modal is open | Hides main contents of the page from screen readers. The element with `.pf-v5-c-modal-box` must not be a descendent of the element with `aria-hidden="true"`. For more info see [trapping focus](/accessibility/product-development-guide#trapping-focus). **Required** |
| `form="[id of form in modal body]"` | `.pf-v5-c-modal-box__footer .pf-v5-c-button` | Associates a submit button in the modal footer with a form in the modal body. For use when the submit button is outside of the `<form>` that the button submits. |
| `tabindex="0"` | `.pf-v5-c-modal-box__body` | If a modal box body has overflow content that triggers a scrollbar, to ensure that the content is keyboard accessible, the body must include either a focusable element within the scrollable region or the body itself must be focusable by adding `tabindex="0"`. |

### Usage

| Class | Applied | Outcome |
| -- | -- | -- |
| `.pf-v5-c-modal-box` | `<div>` | Initiates a modal box. **Required** |
| `.pf-v5-c-modal-box__close` | `<div>` | Creates a container for the modal box close button. **Required** if there is a close button. |
| `.pf-v5-c-button.pf-m-plain` | `<button>` | Initiates a modal box close button. |
| `.pf-v5-c-modal-box__header` | `<header>` | Initiates a modal box header. **Required** if using a `.pf-v5-c-modal-box__title`. |
| `.pf-v5-c-modal-box__header-main` | `<div>` | Initiates a modal box header main container. **Required** when `pf-v5-c-modal-box__header-help` is used. |
| `.pf-v5-c-modal-box__header-help` | `<div>` | Initiates the help button container in the modal box header actions. |
| `.pf-v5-c-modal-box__title` | `<h1>`,`<h2>`,`<h3>`,`<h4>`,`<h5>`,`<h6>`, `<div>` | Initiates a modal box title. **Required** if using a modal description. |
| `.pf-v5-c-modal-box__title-icon` | `<span>` | Initiates a container for the modal box title icon. |
| `.pf-v5-c-modal-box__title-text` | `<span>` | Initiates a container for the modal box title text. |
| `.pf-v5-c-modal-box__description` | `<div>` | Initiates a modal box description. |
| `.pf-v5-c-modal-box__body` | `<div>` | Initiates a modal box body. |
| `.pf-v5-c-modal-box__footer` | `<footer>` | Initiates a modal box footer. |
| `.pf-m-sm` | `.pf-v5-c-modal-box` | Modifies for a small modal box width. |
| `.pf-m-md` | `.pf-v5-c-modal-box` | Modifies for a medium modal box width. |
| `.pf-m-lg` | `.pf-v5-c-modal-box` | Modifies for a large modal box width. |
| `.pf-m-align-top` | `.pf-v5-c-modal-box` | Modifies for top alignment.  |
| `.pf-m-icon` | `.pf-v5-c-modal-box__title` | Modifies the title layout to accommodate an icon. |
| `.pf-m-custom` | `.pf-v5-c-modal-box`, `.pf-v5-c-modal-box__title` | Modifies for the custom alert state. |
| `.pf-m-info` | `.pf-v5-c-modal-box`, `.pf-v5-c-modal-box__title` | Modifies for the info alert state. |
| `.pf-m-success` | `.pf-v5-c-modal-box`, `.pf-v5-c-modal-box__title` | Modifies for the success alert state. |
| `.pf-m-warning` | `.pf-v5-c-modal-box`, `.pf-v5-c-modal-box__title` | Modifies for the warning alert state. |
| `.pf-m-danger` | `.pf-v5-c-modal-box`, `.pf-v5-c-modal-box__title` | Modifies for the danger alert state. |
| `.pf-m-help` | `.pf-v5-c-modal-box__header` | Modifies the modal box header to support the help action |
