/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.key;

import java.security.Key;
import java.util.Arrays;
import javax.crypto.interfaces.PBEKey;
import org.wildfly.security.key.RawKey;

class RawPBEKey
extends RawKey
implements PBEKey {
    private static final long serialVersionUID = 9196265211940105324L;
    private final char[] password;
    private final byte[] salt;
    private final int iterationCount;

    RawPBEKey(PBEKey original) {
        super(original);
        char[] password = original.getPassword();
        this.password = password == null ? null : (char[])password.clone();
        byte[] salt = original.getSalt();
        this.salt = salt == null ? null : (byte[])salt.clone();
        this.iterationCount = original.getIterationCount();
    }

    RawPBEKey(Key key) {
        this((PBEKey)key);
    }

    @Override
    public char[] getPassword() {
        char[] password = this.password;
        return password == null ? null : (char[])password.clone();
    }

    @Override
    public byte[] getSalt() {
        byte[] salt = this.salt;
        return salt == null ? null : (byte[])salt.clone();
    }

    @Override
    public int getIterationCount() {
        return this.iterationCount;
    }

    @Override
    boolean isEqual(Key key) {
        return key instanceof PBEKey && this.isEqual((PBEKey)key);
    }

    boolean isEqual(PBEKey key) {
        return super.isEqual(key) && Arrays.equals(this.password, key.getPassword()) && Arrays.equals(this.salt, key.getSalt()) && this.iterationCount == key.getIterationCount();
    }
}

