/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.cli.common;

import java.io.PrintWriter;
import org.keycloak.client.cli.common.BaseGlobalOptionsCmd;
import org.keycloak.client.cli.common.ExecutionExceptionHandler;
import org.keycloak.client.cli.common.ShortErrorMessageHandler;
import org.keycloak.client.cli.util.ClassLoaderUtil;
import org.keycloak.common.crypto.CryptoIntegration;
import picocli.CommandLine;

public class Globals {
    public static boolean dumpTrace = false;
    public static boolean help = false;

    public static void main(String[] args, BaseGlobalOptionsCmd rootCommand, String command, String defaultConfigFile) {
        String libDir = System.getProperty("kc.lib.dir");
        if (libDir == null) {
            throw new RuntimeException("System property kc.lib.dir needs to be set");
        }
        ClassLoader cl = ClassLoaderUtil.resolveClassLoader(libDir);
        Thread.currentThread().setContextClassLoader(cl);
        CryptoIntegration.init(cl);
        System.setProperty("default.config.path.string", defaultConfigFile);
        CommandLine cli = Globals.createCommandLine(rootCommand, command);
        int exitCode = cli.execute(args);
        System.exit(exitCode);
    }

    public static CommandLine createCommandLine(BaseGlobalOptionsCmd rootCommand, String command) {
        CommandLine.Model.CommandSpec spec = CommandLine.Model.CommandSpec.forAnnotatedObject(rootCommand).name(command);
        CommandLine cmd = new CommandLine(spec);
        cmd.setExecutionExceptionHandler(new ExecutionExceptionHandler());
        cmd.setParameterExceptionHandler(new ShortErrorMessageHandler());
        cmd.setErr(new PrintWriter(System.err, true));
        return cmd;
    }
}

