/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.provider;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.provider.Spi;

public class KeycloakDeploymentInfo {
    private String name;
    private boolean services;
    private boolean themes;
    private boolean themeResources;
    private Map<Class<? extends Spi>, List<ProviderFactory>> providers = new HashMap<Class<? extends Spi>, List<ProviderFactory>>();

    public boolean isProvider() {
        return this.services || this.themes || this.themeResources || !this.providers.isEmpty();
    }

    public boolean hasServices() {
        return this.services;
    }

    public static KeycloakDeploymentInfo create() {
        return new KeycloakDeploymentInfo();
    }

    private KeycloakDeploymentInfo() {
    }

    public KeycloakDeploymentInfo name(String name) {
        this.name = name;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public KeycloakDeploymentInfo services() {
        this.services = true;
        return this;
    }

    public boolean hasThemes() {
        return this.themes;
    }

    public KeycloakDeploymentInfo themes() {
        this.themes = true;
        return this;
    }

    public boolean hasThemeResources() {
        return this.themeResources;
    }

    public KeycloakDeploymentInfo themeResources() {
        this.themeResources = true;
        return this;
    }

    public void addProvider(Class<? extends Spi> spi, ProviderFactory factory) {
        this.providers.computeIfAbsent(spi, key -> new ArrayList()).add(factory);
    }

    public Map<Class<? extends Spi>, List<ProviderFactory>> getProviders() {
        return this.providers;
    }
}

