/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.embeddable.internal;

import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.embeddable.EmbeddableInitializer;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public interface AggregateEmbeddableInitializer
extends EmbeddableInitializer {
    public int[] getAggregateValuesArrayPositions();

    default public Object[] getJdbcValues(RowProcessingState processingState) {
        int[] aggregateValuesArrayPositions = this.getAggregateValuesArrayPositions();
        Object[] jdbcValue = (Object[])processingState.getJdbcValue(aggregateValuesArrayPositions[0]);
        for (int i = 1; i < aggregateValuesArrayPositions.length && jdbcValue != null; ++i) {
            jdbcValue = (Object[])jdbcValue[aggregateValuesArrayPositions[i]];
        }
        return jdbcValue;
    }

    public static int[] determineAggregateValuesArrayPositions(FetchParentAccess fetchParentAccess, SqlSelection structSelection) {
        if (fetchParentAccess instanceof AggregateEmbeddableInitializer) {
            int[] parentAggregateValuesArrayPositions = ((AggregateEmbeddableInitializer)fetchParentAccess).getAggregateValuesArrayPositions();
            int[] aggregateValuesArrayPositions = new int[parentAggregateValuesArrayPositions.length + 1];
            System.arraycopy(parentAggregateValuesArrayPositions, 0, aggregateValuesArrayPositions, 0, parentAggregateValuesArrayPositions.length);
            aggregateValuesArrayPositions[aggregateValuesArrayPositions.length - 1] = structSelection.getValuesArrayPosition();
            return aggregateValuesArrayPositions;
        }
        if (fetchParentAccess instanceof EmbeddableInitializer) {
            FetchParentAccess parentFetchParentAccess = fetchParentAccess.getFetchParentAccess();
            return AggregateEmbeddableInitializer.determineAggregateValuesArrayPositions(parentFetchParentAccess, structSelection);
        }
        return new int[]{structSelection.getValuesArrayPosition()};
    }
}

