/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import java.util.ArrayList;
import org.hibernate.LockOptions;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.BatchFetchQueue;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.SubselectFetch;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.loader.ast.internal.ExecutionContextWithSubselectFetchHandler;
import org.hibernate.loader.ast.internal.LoaderSelectBuilder;
import org.hibernate.loader.ast.spi.CollectionLoader;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.internal.ResultsHelper;
import org.hibernate.sql.results.internal.RowTransformerStandardImpl;
import org.hibernate.sql.results.spi.ListResultsConsumer;

public class CollectionLoaderSubSelectFetch
implements CollectionLoader {
    private final PluralAttributeMapping attributeMapping;
    private final SubselectFetch subselect;
    private final SelectStatement sqlAst;

    public CollectionLoaderSubSelectFetch(PluralAttributeMapping attributeMapping, DomainResult<?> cachedDomainResult, SubselectFetch subselect, SharedSessionContractImplementor session) {
        this.attributeMapping = attributeMapping;
        this.subselect = subselect;
        this.sqlAst = LoaderSelectBuilder.createSubSelectFetchSelect(attributeMapping, subselect, cachedDomainResult, session.getLoadQueryInfluencers(), LockOptions.NONE, jdbcParameter -> {}, session.getFactory());
        QuerySpec querySpec = this.sqlAst.getQueryPart().getFirstQuerySpec();
        TableGroup tableGroup = querySpec.getFromClause().getRoots().get(0);
        attributeMapping.applySoftDeleteRestrictions(tableGroup, querySpec::applyPredicate);
    }

    @Override
    public PluralAttributeMapping getLoadable() {
        return this.attributeMapping;
    }

    protected SelectStatement getSqlAst() {
        return this.sqlAst;
    }

    @Override
    public PersistentCollection<?> load(Object triggerKey, SharedSessionContractImplementor session) {
        EntityKey triggerKeyOwnerKey;
        SubselectFetch registeredFetch;
        CollectionKey collectionKey = new CollectionKey(this.attributeMapping.getCollectionDescriptor(), triggerKey);
        SessionFactoryImplementor sessionFactory = session.getFactory();
        JdbcServices jdbcServices = sessionFactory.getJdbcServices();
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        SqlAstTranslatorFactory sqlAstTranslatorFactory = jdbcEnvironment.getSqlAstTranslatorFactory();
        PersistenceContext persistenceContext = session.getPersistenceContext();
        PersistentCollection<?> collection = persistenceContext.getCollection(collectionKey);
        this.attributeMapping.getCollectionDescriptor().getCollectionType().getKeyOfOwner(collection.getOwner(), session);
        BatchFetchQueue batchFetchQueue = persistenceContext.getBatchFetchQueue();
        EntityEntry ownerEntry = persistenceContext.getEntry(collection.getOwner());
        ArrayList<PersistentCollection> subSelectFetchedCollections = null;
        if (ownerEntry != null && (registeredFetch = batchFetchQueue.getSubselect(triggerKeyOwnerKey = ownerEntry.getEntityKey())) != null) {
            subSelectFetchedCollections = CollectionHelper.arrayList(registeredFetch.getResultingEntityKeys().size());
            for (EntityKey key : registeredFetch.getResultingEntityKeys()) {
                PersistentCollection<?> containedCollection = persistenceContext.getCollection(new CollectionKey(this.attributeMapping.getCollectionDescriptor(), key.getIdentifier()));
                if (containedCollection == null || containedCollection == collection) continue;
                containedCollection.beginRead();
                containedCollection.beforeInitialize(this.getLoadable().getCollectionDescriptor(), -1);
                subSelectFetchedCollections.add(containedCollection);
            }
        }
        JdbcOperationQuerySelect jdbcSelect = sqlAstTranslatorFactory.buildSelectTranslator(sessionFactory, this.sqlAst).translate(this.subselect.getLoadingJdbcParameterBindings(), QueryOptions.NONE);
        SubselectFetch.RegistrationHandler subSelectFetchableKeysHandler = SubselectFetch.createRegistrationHandler(batchFetchQueue, this.sqlAst, this.subselect.getLoadingJdbcParameters(), this.subselect.getLoadingJdbcParameterBindings());
        jdbcServices.getJdbcSelectExecutor().list(jdbcSelect, this.subselect.getLoadingJdbcParameterBindings(), new ExecutionContextWithSubselectFetchHandler(session, subSelectFetchableKeysHandler), RowTransformerStandardImpl.instance(), ListResultsConsumer.UniqueSemantic.NONE);
        if (subSelectFetchedCollections != null && !subSelectFetchedCollections.isEmpty()) {
            subSelectFetchedCollections.forEach(c -> {
                if (c.wasInitialized()) {
                    return;
                }
                c.initializeEmptyCollection(this.getLoadable().getCollectionDescriptor());
                ResultsHelper.finalizeCollectionLoading(persistenceContext, this.getLoadable().getCollectionDescriptor(), c, c.getKey(), true);
            });
            subSelectFetchedCollections.clear();
        }
        return collection;
    }
}

