/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.exportimport.dir;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.exportimport.AbstractFileBasedImportProvider;
import org.keycloak.exportimport.Strategy;
import org.keycloak.exportimport.util.ExportImportSessionTask;
import org.keycloak.exportimport.util.ImportUtils;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakSessionTask;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.platform.Platform;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.util.JsonSerialization;

public class DirImportProvider
extends AbstractFileBasedImportProvider {
    private final Strategy strategy;
    private final KeycloakSessionFactory factory;
    private static final Logger logger = Logger.getLogger(DirImportProvider.class);
    private File rootDirectory;
    private String realmName;

    public DirImportProvider(KeycloakSessionFactory factory, Strategy strategy) {
        this.factory = factory;
        this.strategy = strategy;
    }

    public DirImportProvider withDir(String dir) {
        this.rootDirectory = new File(dir);
        if (!this.rootDirectory.exists()) {
            throw new IllegalStateException("Directory " + this.rootDirectory + " doesn't exist");
        }
        logger.infof("Importing from directory %s", (Object)this.rootDirectory.getAbsolutePath());
        return this;
    }

    public DirImportProvider withRealmName(String realmName) {
        this.realmName = realmName;
        return this;
    }

    private File getRootDirectory() {
        if (this.rootDirectory == null) {
            this.rootDirectory = new File(Platform.getPlatform().getTmpDirectory(), "keycloak-export");
            if (!this.rootDirectory.exists()) {
                throw new IllegalStateException("Directory " + this.rootDirectory + " doesn't exist");
            }
            logger.infof("Importing from directory %s", (Object)this.rootDirectory.getAbsolutePath());
        }
        return this.rootDirectory;
    }

    public void importModel() throws IOException {
        if (this.realmName != null) {
            ServicesLogger.LOGGER.realmImportRequested(this.realmName, this.strategy.toString());
            this.importRealm(this.realmName, this.strategy);
        } else {
            ServicesLogger.LOGGER.fullModelImport(this.strategy.toString());
            List<String> realmNames = this.getRealmsToImport();
            for (String realmName : realmNames) {
                this.importRealm(realmName, this.strategy);
            }
        }
        ServicesLogger.LOGGER.importSuccess();
    }

    public boolean isMasterRealmExported() {
        List<String> realmNames = this.getRealmsToImport();
        return realmNames.contains(Config.getAdminRealm());
    }

    private List<String> getRealmsToImport() {
        File[] realmFiles = this.getRootDirectory().listFiles((dir, name) -> name.endsWith("-realm.json"));
        Objects.requireNonNull(realmFiles, "Directory not found: " + this.getRootDirectory().getName());
        ArrayList<String> realmNames = new ArrayList<String>();
        for (File file : realmFiles) {
            String fileName = file.getName();
            String realmName = fileName.substring(0, fileName.length() - 11);
            if (Config.getAdminRealm().equals(realmName)) {
                realmNames.add(0, realmName);
                continue;
            }
            realmNames.add(realmName);
        }
        return realmNames;
    }

    public void importRealm(final String realmName, final Strategy strategy) throws IOException {
        File realmFile = new File(this.getRootDirectory() + File.separator + realmName + "-realm.json");
        File[] userFiles = this.getRootDirectory().listFiles((dir, name) -> name.matches(realmName + "-users-[0-9]+\\.json"));
        Objects.requireNonNull(userFiles, "directory not found: " + this.getRootDirectory().getName());
        File[] federatedUserFiles = this.getRootDirectory().listFiles((dir, name) -> name.matches(realmName + "-federated-users-[0-9]+\\.json"));
        Objects.requireNonNull(federatedUserFiles, "directory not found: " + this.getRootDirectory().getName());
        InputStream is = this.parseFile(realmFile);
        final RealmRepresentation realmRep = (RealmRepresentation)JsonSerialization.readValue((InputStream)is, RealmRepresentation.class);
        final AtomicBoolean realmImported = new AtomicBoolean();
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)this.factory, (KeycloakSessionTask)new ExportImportSessionTask(){

            @Override
            public void runExportImportTask(KeycloakSession session) {
                boolean imported = ImportUtils.importRealm(session, realmRep, strategy, true);
                realmImported.set(imported);
            }
        });
        if (realmImported.get()) {
            InputStream fis;
            for (final File userFile : userFiles) {
                fis = this.parseFile(userFile);
                try {
                    KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)this.factory, (KeycloakSessionTask)new ExportImportSessionTask(){

                        @Override
                        protected void runExportImportTask(KeycloakSession session) throws IOException {
                            session.getContext().setRealm(session.realms().getRealmByName(realmName));
                            ImportUtils.importUsersFromStream(session, realmName, JsonSerialization.mapper, fis);
                            logger.infof("Imported users from %s", (Object)userFile.getAbsolutePath());
                        }
                    });
                }
                finally {
                    if (fis != null) {
                        fis.close();
                    }
                }
            }
            for (final File userFile : federatedUserFiles) {
                fis = this.parseFile(userFile);
                try {
                    KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)this.factory, (KeycloakSessionTask)new ExportImportSessionTask(){

                        @Override
                        protected void runExportImportTask(KeycloakSession session) throws IOException {
                            session.getContext().setRealm(session.realms().getRealmByName(realmName));
                            ImportUtils.importFederatedUsersFromStream(session, realmName, JsonSerialization.mapper, fis);
                            logger.infof("Imported federated users from %s", (Object)userFile.getAbsolutePath());
                        }
                    });
                }
                finally {
                    if (fis != null) {
                        fis.close();
                    }
                }
            }
        }
        if (realmImported.get()) {
            KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)this.factory, (KeycloakSessionTask)new ExportImportSessionTask(){

                @Override
                public void runExportImportTask(KeycloakSession session) {
                    session.getContext().setRealm(session.realms().getRealmByName(realmName));
                    RealmManager realmManager = new RealmManager(session);
                    realmManager.setupClientServiceAccountsAndAuthorizationOnImport(realmRep, false);
                }
            });
        }
    }

    public void close() {
    }
}

