/*
 * Decompiled with CFR 0.152.
 */
package biz.paluch.logging.gelf.intern;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

abstract class OutputAccessor {
    OutputAccessor() {
    }

    public abstract void write(int var1);

    public abstract void write(byte[] var1);

    public abstract void write(byte[] var1, int var2, int var3);

    public static OutputAccessor from(OutputStream outputStream) {
        return new OutputStreamAccessor(outputStream);
    }

    public static OutputAccessor from(ByteBuffer byteBuffer) {
        ByteBufferOutputAccessor accessor = new ByteBufferOutputAccessor();
        accessor.byteBuffer = byteBuffer;
        return accessor;
    }

    public static OutputAccessor from(OutputAccessorPoolHolder poolHolder, ByteBuffer byteBuffer) {
        ByteBufferOutputAccessor accessor = poolHolder.getByteBufferOutputAccessor();
        accessor.byteBuffer = byteBuffer;
        return accessor;
    }

    public static OutputStream pooledStream(OutputAccessorPoolHolder poolHolder) {
        return poolHolder.getByteBufferOutputStream();
    }

    public static OutputStream asStream(OutputAccessorPoolHolder poolHolder, ByteBuffer byteBuffer) {
        ByteBufferOutputStream accessor = poolHolder.getByteBufferOutputStream();
        accessor.byteBuffer = byteBuffer;
        return accessor;
    }

    static class OutputAccessorPoolHolder {
        private final ThreadLocal<ByteBufferOutputAccessor> accessorPool = new ThreadLocal<ByteBufferOutputAccessor>(){

            @Override
            protected ByteBufferOutputAccessor initialValue() {
                return new ByteBufferOutputAccessor();
            }
        };
        private final ThreadLocal<ByteBufferOutputStream> streamPool = new ThreadLocal<ByteBufferOutputStream>(){

            @Override
            protected ByteBufferOutputStream initialValue() {
                return new ByteBufferOutputStream(null);
            }
        };

        OutputAccessorPoolHolder() {
        }

        public ByteBufferOutputAccessor getByteBufferOutputAccessor() {
            return this.accessorPool.get();
        }

        public ByteBufferOutputStream getByteBufferOutputStream() {
            return this.streamPool.get();
        }
    }

    static class OutputStreamAccessor
    extends OutputAccessor {
        private final OutputStream delegate;

        public OutputStreamAccessor(OutputStream delegate) {
            this.delegate = delegate;
        }

        @Override
        public void write(byte[] b, int off, int len) {
            try {
                this.delegate.write(b, off, len);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public void write(byte[] b) {
            try {
                this.delegate.write(b);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public void write(int b) {
            try {
                this.delegate.write(b);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    static class ByteBufferOutputStream
    extends OutputStream {
        private ByteBuffer byteBuffer;

        public ByteBufferOutputStream(ByteBuffer byteBuffer) {
            this.byteBuffer = byteBuffer;
        }

        @Override
        public void write(byte[] b, int off, int len) {
            this.byteBuffer.put(b, off, len);
        }

        @Override
        public void write(byte[] b) {
            this.byteBuffer.put(b);
        }

        @Override
        public void write(int b) {
            this.byteBuffer.put((byte)b);
        }
    }

    static class ByteBufferOutputAccessor
    extends OutputAccessor {
        private ByteBuffer byteBuffer;

        ByteBufferOutputAccessor() {
        }

        @Override
        public void write(byte[] b, int off, int len) {
            this.byteBuffer.put(b, off, len);
        }

        @Override
        public void write(byte[] b) {
            this.byteBuffer.put(b);
        }

        @Override
        public void write(int b) {
            this.byteBuffer.put((byte)b);
        }
    }
}

