/*
 * Decompiled with CFR 0.152.
 */
package biz.paluch.logging;

import biz.paluch.logging.RuntimeContainerProperties;
import biz.paluch.logging.gelf.intern.Closer;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;

public class StackTraceFilter {
    public static final String VERBOSE_LOGGING_PROPERTY = "logstash-gelf.StackTraceFilter.verbose";
    public static final String FILTER_SETTINGS = "/" + StackTraceFilter.class.getSimpleName() + ".packages";
    private static final String INDENT = "\t";
    private static final boolean VERBOSE_LOGGING = Boolean.parseBoolean(RuntimeContainerProperties.getProperty("logstash-gelf.StackTraceFilter.verbose", "false"));
    private static final Pattern AT_PATTERN = Pattern.compile("(\t)+at");
    private static final Pattern SURPRESSED_PATTERN = Pattern.compile("(\t)+Suppressed\\:");
    private static Set<String> suppressedPackages;

    public static void loadSetttings(String resourceName) {
        InputStream is = null;
        try {
            is = StackTraceFilter.getStream(resourceName);
            if (is == null) {
                StackTraceFilter.verboseLog("No " + resourceName + " resource present, using defaults");
                suppressedPackages = new HashSet<String>(StackTraceFilter.getDefaults());
            } else {
                Properties p = new Properties();
                p.load(is);
                suppressedPackages = p.keySet();
            }
        }
        catch (IOException e) {
            StackTraceFilter.verboseLog("Could not parse " + resourceName + " resource, using defaults");
            suppressedPackages = new HashSet<String>(StackTraceFilter.getDefaults());
        }
        finally {
            Closer.close(is);
        }
    }

    private static InputStream getStream(String resourceName) {
        Thread thread = Thread.currentThread();
        InputStream is = StackTraceFilter.class.getResourceAsStream(resourceName);
        if (is == null && thread.getContextClassLoader() != null) {
            is = thread.getContextClassLoader().getResourceAsStream(resourceName);
        }
        return is;
    }

    public static List<String> getDefaults() {
        return Arrays.asList("org.h2", "org.apache.catalina", "org.apache.coyote", "org.apache.tomcat", "com.arjuna", "org.apache.cxf", "org.hibernate", "org.junit", "org.jboss", "java.lang.reflect.Method", "sun.", "com.sun", "org.eclipse", "junit.framework", "com.sun.faces", "javax.faces", "org.richfaces", "org.apache.el", "javax.servlet");
    }

    private StackTraceFilter() {
    }

    public static String getFilteredStackTrace(Throwable t) {
        return StackTraceFilter.getFilteredStackTrace(t, true);
    }

    @Deprecated
    public static String getFilteredStackTrace(Throwable t, boolean shouldFilter) {
        if (shouldFilter) {
            return StackTraceFilter.getFilteredStackTrace(t, 0);
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.close();
        return sw.getBuffer().toString();
    }

    public static String getFilteredStackTrace(Throwable t, int ref) {
        StringWriter sw = new StringWriter();
        StackTraceFilterWriter filterWriter = new StackTraceFilterWriter(sw);
        StackTraceFilter.printStackTrace(t, filterWriter, ref);
        return sw.getBuffer().toString();
    }

    public static String getStackTrace(Throwable t) {
        return StackTraceFilter.getStackTrace(t, 0);
    }

    public static String getStackTrace(Throwable t, int ref) {
        StringWriter sw = new StringWriter();
        StackTraceFilter.printStackTrace(t, sw, ref);
        return sw.getBuffer().toString();
    }

    private static void printStackTrace(Throwable t, Writer writer, int ref) {
        List<Throwable> throwables = StackTraceFilter.getThrowables(t);
        PrintWriter exceptionWriter = new PrintWriter(writer);
        Throwable subject = ref == 0 ? throwables.get(ref) : StackTraceFilter.getThrowable(throwables, ref);
        boolean first = true;
        for (Throwable throwable : throwables) {
            if (subject == throwable) break;
            if (!first) {
                exceptionWriter.print("Caused by: ");
            }
            first = false;
            exceptionWriter.print(throwable.toString());
            exceptionWriter.println();
        }
        if (ref != 0) {
            exceptionWriter.print("Caused by: ");
        }
        subject.printStackTrace(exceptionWriter);
    }

    public static Throwable getThrowable(Throwable throwable, int ref) {
        return StackTraceFilter.getThrowable(StackTraceFilter.getThrowables(throwable), ref);
    }

    private static Throwable getThrowable(List<Throwable> throwables, int ref) {
        if (ref >= 0) {
            return throwables.get(Math.min(ref, throwables.size() - 1));
        }
        return throwables.get(Math.max(throwables.size() + ref, 0));
    }

    private static List<Throwable> getThrowables(Throwable t) {
        ArrayList<Throwable> throwables = new ArrayList<Throwable>();
        Throwable current = t;
        do {
            throwables.add(current);
        } while ((current = current.getCause()) != null && !throwables.contains(current));
        return throwables;
    }

    private static int getIndentation(String traceElement) {
        int index = traceElement.indexOf(INDENT);
        int indentationLevel = 0;
        while (index != -1) {
            ++indentationLevel;
            index = traceElement.indexOf(INDENT, index + 1);
        }
        return indentationLevel;
    }

    private static String getSkippedPackagesMessage(Set<String> skippedPackages, int skippedLines, int indentationLevel) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < 2 + indentationLevel; ++i) {
            stringBuilder.append(INDENT);
        }
        stringBuilder.append(skippedLines).append(" line").append(skippedLines == 1 ? "" : "s").append(" skipped for ").append(skippedPackages);
        return stringBuilder.toString();
    }

    private static String tryGetForbiddenPackageName(String classAndMethod) {
        for (String pkg : suppressedPackages) {
            if (!classAndMethod.startsWith(pkg)) continue;
            return pkg;
        }
        return null;
    }

    private static void verboseLog(String message) {
        if (VERBOSE_LOGGING) {
            System.out.println(message);
        }
    }

    static {
        StackTraceFilter.loadSetttings(FILTER_SETTINGS);
    }

    static class StackTraceFilterWriter
    extends FilterWriter {
        private static final String traceElementPrefix = "\tat ";
        Set<String> skippedPackages = new HashSet<String>();
        int skippedLines;
        boolean endsWithNewLine;
        boolean first = true;
        int indentationLevel;
        private final String lineSeparator = System.getProperty("line.separator");

        public StackTraceFilterWriter(Writer s) {
            super(s);
        }

        @Override
        public void write(String str, int off, int len) throws IOException {
            String toWrite = str.substring(off, len);
            if (this.skippedLines > 0 && toWrite.equals(this.lineSeparator) && this.endsWithNewLine) {
                return;
            }
            if (toWrite.equals(this.lineSeparator)) {
                this.endsWithNewLine = true;
                super.write(str, off, len);
                return;
            }
            if (SURPRESSED_PATTERN.matcher(toWrite).find()) {
                this.first = true;
            }
            if (this.endsWithNewLine && AT_PATTERN.matcher(toWrite).find()) {
                String traceElement = this.getTraceElement(toWrite);
                String forbiddenPackageName = null;
                if (!this.first) {
                    forbiddenPackageName = StackTraceFilter.tryGetForbiddenPackageName(traceElement);
                }
                this.first = false;
                if (forbiddenPackageName == null) {
                    this.afterFiltering();
                    super.write(str, off, len);
                } else {
                    this.indentationLevel = StackTraceFilter.getIndentation(toWrite);
                    ++this.skippedLines;
                    this.skippedPackages.add(forbiddenPackageName);
                }
                return;
            }
            this.afterFiltering();
            super.write(str, off, len);
            this.endsWithNewLine = str.equals(this.lineSeparator);
        }

        private void afterFiltering() throws IOException {
            if (!this.skippedPackages.isEmpty()) {
                String skippedPackagesMessage = StackTraceFilter.getSkippedPackagesMessage(this.skippedPackages, this.skippedLines, this.indentationLevel);
                this.skippedPackages.clear();
                this.skippedLines = 0;
                this.write(skippedPackagesMessage);
                this.write(this.lineSeparator);
                this.indentationLevel = 0;
            }
        }

        private String getTraceElement(String toWrite) {
            return toWrite.substring(toWrite.indexOf(traceElementPrefix) + traceElementPrefix.length());
        }

        @Override
        public void close() throws IOException {
            if (this.skippedLines > 0) {
                this.write(StackTraceFilter.getSkippedPackagesMessage(this.skippedPackages, this.skippedLines, this.indentationLevel));
            }
            super.close();
        }
    }
}

