/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.Booleans;
import io.quarkus.qute.CompletedStage;
import io.quarkus.qute.EvalContext;
import io.quarkus.qute.Expression;
import io.quarkus.qute.Mapper;
import io.quarkus.qute.RawString;
import io.quarkus.qute.Results;
import io.quarkus.qute.ValueResolver;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;

public final class ValueResolvers {
    static final String THIS = "this";
    static final String ELVIS = "?:";
    static final String COLON = ":";
    public static final String OR = "or";

    public static ValueResolver rawResolver() {
        return new ValueResolver(){

            @Override
            public boolean appliesTo(EvalContext context) {
                return context.getBase() != null && (context.getName().equals("raw") || context.getName().equals("safe"));
            }

            @Override
            public CompletionStage<Object> resolve(EvalContext context) {
                return CompletedStage.of(new RawString(context.getBase().toString()));
            }
        };
    }

    public static ValueResolver listResolver() {
        return new ValueResolver(){

            @Override
            public int getPriority() {
                return 2;
            }

            @Override
            public boolean appliesTo(EvalContext context) {
                return ValueResolver.matchClass(context, List.class);
            }

            @Override
            public CompletionStage<Object> resolve(EvalContext context) {
                return ValueResolvers.listResolveAsync(context);
            }
        };
    }

    public static ValueResolver collectionResolver() {
        return new ValueResolver(){

            @Override
            public boolean appliesTo(EvalContext context) {
                return ValueResolver.matchClass(context, Collection.class);
            }

            @Override
            public CompletionStage<Object> resolve(EvalContext context) {
                return ValueResolvers.collectionResolveAsync(context);
            }
        };
    }

    public static ValueResolver thisResolver() {
        return new ValueResolver(){

            @Override
            public boolean appliesTo(EvalContext context) {
                return context.getBase() != null && ValueResolvers.THIS.equals(context.getName());
            }

            @Override
            public CompletionStage<Object> resolve(EvalContext context) {
                return CompletedStage.of(context.getBase());
            }
        };
    }

    public static ValueResolver orResolver() {
        return new ValueResolver(){

            @Override
            public boolean appliesTo(EvalContext context) {
                if (context.getParams().size() != 1) {
                    return false;
                }
                String name = context.getName();
                return name.equals(ValueResolvers.ELVIS) || name.equals(ValueResolvers.OR) || name.equals(ValueResolvers.COLON);
            }

            @Override
            public CompletionStage<Object> resolve(EvalContext context) {
                Object base = context.getBase();
                if (base == null || Results.isNotFound(base) || base instanceof Optional && ((Optional)base).isEmpty()) {
                    return context.evaluate(context.getParams().get(0));
                }
                return CompletedStage.of(base);
            }
        };
    }

    public static ValueResolver orEmpty() {
        final CompletedStage empty = CompletedStage.of(Collections.emptyList());
        return new ValueResolver(){

            @Override
            public boolean appliesTo(EvalContext context) {
                return context.getParams().isEmpty() && context.getName().equals("orEmpty");
            }

            @Override
            public CompletionStage<Object> resolve(EvalContext context) {
                if (context.getBase() == null || Results.isNotFound(context.getBase())) {
                    return empty;
                }
                return CompletedStage.of(context.getBase());
            }
        };
    }

    public static ValueResolver trueResolver() {
        return new ValueResolver(){

            @Override
            public boolean appliesTo(EvalContext context) {
                if (context.getParams().size() != 1) {
                    return false;
                }
                String name = context.getName();
                return name.equals("?") || name.equals("ifTruthy");
            }

            @Override
            public CompletionStage<Object> resolve(EvalContext context) {
                if (Booleans.isFalsy(context.getBase())) {
                    return Results.notFound(context);
                }
                return context.evaluate(context.getParams().get(0));
            }
        };
    }

    public static ValueResolver mapEntryResolver() {
        return new ValueResolver(){

            @Override
            public boolean appliesTo(EvalContext context) {
                return ValueResolver.matchClass(context, Map.Entry.class);
            }

            @Override
            public CompletionStage<Object> resolve(EvalContext context) {
                Map.Entry entry = (Map.Entry)context.getBase();
                return CompletedStage.of(ValueResolvers.entryResolve(entry, context.getName()));
            }
        };
    }

    public static ValueResolver mapResolver() {
        return new ValueResolver(){

            @Override
            public boolean appliesTo(EvalContext context) {
                return ValueResolver.matchClass(context, Map.class);
            }

            @Override
            public CompletionStage<Object> resolve(EvalContext context) {
                return ValueResolvers.mapResolveAsync(context);
            }
        };
    }

    public static ValueResolver mapperResolver() {
        return new ValueResolver(){

            @Override
            public boolean appliesTo(EvalContext context) {
                if (context.getBase() instanceof Mapper && context.getParams().isEmpty()) {
                    return ((Mapper)context.getBase()).appliesTo(context.getName());
                }
                return false;
            }

            @Override
            public int getPriority() {
                return 15;
            }

            @Override
            public CompletionStage<Object> resolve(EvalContext context) {
                Mapper mapper = (Mapper)context.getBase();
                return mapper.getAsync(context.getName());
            }
        };
    }

    public static ValueResolver logicalAndResolver() {
        return new ValueResolver(){

            @Override
            public boolean appliesTo(EvalContext context) {
                return context.getBase() != null && context.getParams().size() == 1 && "&&".equals(context.getName());
            }

            @Override
            public CompletionStage<Object> resolve(EvalContext context) {
                boolean baseIsFalsy = Booleans.isFalsy(context.getBase());
                return baseIsFalsy ? CompletedStage.of(false) : context.evaluate(context.getParams().get(0)).thenApply(new Function<Object, Object>(){

                    @Override
                    public Object apply(Object booleanParam) {
                        return !Booleans.isFalsy(booleanParam);
                    }
                });
            }
        };
    }

    public static ValueResolver logicalOrResolver() {
        return new ValueResolver(){

            @Override
            public boolean appliesTo(EvalContext context) {
                return context.getBase() != null && context.getParams().size() == 1 && "||".equals(context.getName());
            }

            @Override
            public CompletionStage<Object> resolve(EvalContext context) {
                boolean baseIsFalsy = Booleans.isFalsy(context.getBase());
                return !baseIsFalsy ? CompletedStage.of(true) : context.evaluate(context.getParams().get(0)).thenApply(new Function<Object, Object>(){

                    @Override
                    public Object apply(Object booleanParam) {
                        return !Booleans.isFalsy(booleanParam);
                    }
                });
            }
        };
    }

    public static ValueResolver arrayResolver() {
        return new ValueResolver(){

            @Override
            public boolean appliesTo(EvalContext context) {
                return context.getBase() != null && context.getBase().getClass().isArray();
            }

            @Override
            public CompletionStage<Object> resolve(EvalContext context) {
                int index;
                String name = context.getName();
                if (name.equals("length") || name.equals("size")) {
                    return CompletedStage.of(Array.getLength(context.getBase()));
                }
                if (name.equals("take")) {
                    if (context.getParams().isEmpty()) {
                        throw new IllegalArgumentException("n-th parameter is missing");
                    }
                    Expression indexExpr = context.getParams().get(0);
                    if (indexExpr.isLiteral()) {
                        Object literalValue = indexExpr.getLiteral();
                        if (literalValue instanceof Integer) {
                            return CompletedStage.of(ValueResolvers.takeArray((Integer)literalValue, context.getBase()));
                        }
                        return Results.notFound(context);
                    }
                    return context.evaluate(indexExpr).thenCompose(n -> {
                        if (n instanceof Integer) {
                            return CompletedStage.of(ValueResolvers.takeArray((Integer)n, context.getBase()));
                        }
                        return Results.notFound(context);
                    });
                }
                if (name.equals("takeLast")) {
                    if (context.getParams().isEmpty()) {
                        throw new IllegalArgumentException("n-th parameter is missing");
                    }
                    Expression indexExpr = context.getParams().get(0);
                    if (indexExpr.isLiteral()) {
                        Object literalValue = indexExpr.getLiteral();
                        if (literalValue instanceof Integer) {
                            return CompletedStage.of(ValueResolvers.takeLastArray((Integer)literalValue, context.getBase()));
                        }
                        return Results.notFound(context);
                    }
                    return context.evaluate(indexExpr).thenCompose(n -> {
                        if (n instanceof Integer) {
                            return CompletedStage.of(ValueResolvers.takeLastArray((Integer)n, context.getBase()));
                        }
                        return Results.notFound(context);
                    });
                }
                if (name.equals("get")) {
                    if (context.getParams().isEmpty()) {
                        throw new IllegalArgumentException("Index parameter is missing");
                    }
                    Expression indexExpr = context.getParams().get(0);
                    if (indexExpr.isLiteral()) {
                        Object literalValue = indexExpr.getLiteral();
                        if (literalValue instanceof Integer) {
                            return CompletedStage.of(Array.get(context.getBase(), (Integer)literalValue));
                        }
                        return Results.notFound(context);
                    }
                    return context.evaluate(indexExpr).thenCompose(idx -> {
                        if (idx instanceof Integer) {
                            return CompletedStage.of(Array.get(context.getBase(), (Integer)idx));
                        }
                        return Results.notFound(context);
                    });
                }
                try {
                    index = Integer.parseInt(name);
                }
                catch (NumberFormatException e) {
                    return Results.notFound(context);
                }
                return CompletedStage.of(Array.get(context.getBase(), index));
            }
        };
    }

    public static ValueResolver numberValueResolver() {
        return new ValueResolver(){

            @Override
            public boolean appliesTo(EvalContext context) {
                Object base = context.getBase();
                String name = context.getName();
                return base != null && base instanceof Number && context.getParams().isEmpty() && ("intValue".equals(name) || "longValue".equals(name) || "floatValue".equals(name) || "doubleValue".equals(name) || "byteValue".equals(name) || "shortValue".equals(name));
            }

            @Override
            public CompletionStage<Object> resolve(EvalContext context) {
                switch (context.getName()) {
                    case "intValue": {
                        return CompletedStage.of(((Number)context.getBase()).intValue());
                    }
                    case "longValue": {
                        return CompletedStage.of(((Number)context.getBase()).longValue());
                    }
                    case "floatValue": {
                        return CompletedStage.of(Float.valueOf(((Number)context.getBase()).floatValue()));
                    }
                    case "doubleValue": {
                        return CompletedStage.of(((Number)context.getBase()).doubleValue());
                    }
                    case "byteValue": {
                        return CompletedStage.of(((Number)context.getBase()).byteValue());
                    }
                    case "shortValue": {
                        return CompletedStage.of(((Number)context.getBase()).shortValue());
                    }
                }
                throw new IllegalArgumentException();
            }
        };
    }

    public static ValueResolver plusResolver() {
        return new IntArithmeticResolver(){

            @Override
            protected boolean appliesToName(String name) {
                return "plus".equals(name) || "+".equals(name);
            }

            @Override
            protected Object compute(Long op1, Long op2) {
                return op1 + op2;
            }

            @Override
            protected Object compute(Integer op1, Long op2) {
                return (long)op1.intValue() + op2;
            }

            @Override
            protected Object compute(Long op1, Integer op2) {
                return op1 + (long)op2.intValue();
            }

            @Override
            protected Object compute(Integer op1, Integer op2) {
                return op1 + op2;
            }
        };
    }

    public static ValueResolver minusResolver() {
        return new IntArithmeticResolver(){

            @Override
            protected boolean appliesToName(String name) {
                return "minus".equals(name) || "-".equals(name);
            }

            @Override
            protected Object compute(Long op1, Long op2) {
                return op1 - op2;
            }

            @Override
            protected Object compute(Integer op1, Long op2) {
                return (long)op1.intValue() - op2;
            }

            @Override
            protected Object compute(Long op1, Integer op2) {
                return op1 - (long)op2.intValue();
            }

            @Override
            protected Object compute(Integer op1, Integer op2) {
                return op1 - op2;
            }
        };
    }

    public static ValueResolver modResolver() {
        return new IntArithmeticResolver(){

            @Override
            protected boolean appliesToName(String name) {
                return "mod".equals(name);
            }

            @Override
            protected Object compute(Long op1, Long op2) {
                return op1 % op2;
            }

            @Override
            protected Object compute(Integer op1, Long op2) {
                return (long)op1.intValue() % op2;
            }

            @Override
            protected Object compute(Long op1, Integer op2) {
                return op1 % (long)op2.intValue();
            }

            @Override
            protected Object compute(Integer op1, Integer op2) {
                return op1 % op2;
            }
        };
    }

    private static Object takeArray(int n, Object sourceArray) {
        int size = Array.getLength(sourceArray);
        if (n < 1 || n > size) {
            throw new IndexOutOfBoundsException(n);
        }
        Object targetArray = Array.newInstance(sourceArray.getClass().getComponentType(), n);
        System.arraycopy(sourceArray, 0, targetArray, 0, n);
        return targetArray;
    }

    private static Object takeLastArray(int n, Object sourceArray) {
        int size = Array.getLength(sourceArray);
        if (n < 1 || n > size) {
            throw new IndexOutOfBoundsException(n);
        }
        Object targetArray = Array.newInstance(sourceArray.getClass().getComponentType(), n);
        System.arraycopy(sourceArray, size - n, targetArray, 0, n);
        return targetArray;
    }

    private static CompletionStage<Object> collectionResolveAsync(EvalContext context) {
        Collection collection = (Collection)context.getBase();
        switch (context.getName()) {
            case "size": {
                return CompletedStage.of(collection.size());
            }
            case "isEmpty": 
            case "empty": {
                return CompletedStage.of(collection.isEmpty());
            }
            case "contains": {
                if (context.getParams().size() != 1) break;
                return context.evaluate(context.getParams().get(0)).thenCompose(e -> CompletedStage.of(collection.contains(e)));
            }
        }
        return Results.notFound(context);
    }

    private static CompletionStage<Object> listResolveAsync(EvalContext context) {
        int index;
        String name;
        List list = (List)context.getBase();
        switch (name = context.getName()) {
            case "get": {
                if (context.getParams().size() == 1) {
                    return context.evaluate(context.getParams().get(0)).thenApply(r -> {
                        try {
                            int n = r instanceof Integer ? (Integer)r : Integer.parseInt(r.toString());
                            return list.get(n);
                        }
                        catch (NumberFormatException e) {
                            return Results.NotFound.from(context);
                        }
                    });
                }
            }
            case "take": {
                if (context.getParams().size() == 1) {
                    return context.evaluate(context.getParams().get(0)).thenApply(r -> {
                        try {
                            int n = r instanceof Integer ? (Integer)r : Integer.valueOf(r.toString());
                            if (n < 1 || n > list.size()) {
                                throw new IndexOutOfBoundsException(n);
                            }
                            return list.subList(0, n);
                        }
                        catch (NumberFormatException e) {
                            return Results.NotFound.from(context);
                        }
                    });
                }
            }
            case "takeLast": {
                if (context.getParams().size() == 1) {
                    return context.evaluate(context.getParams().get(0)).thenApply(r -> {
                        try {
                            int n = r instanceof Integer ? (Integer)r : Integer.valueOf(r.toString());
                            if (n < 1 || n > list.size()) {
                                throw new IndexOutOfBoundsException(n);
                            }
                            return list.subList(list.size() - n, list.size());
                        }
                        catch (NumberFormatException e) {
                            return Results.NotFound.from(context);
                        }
                    });
                }
            }
            case "first": {
                if (list.isEmpty()) {
                    throw new NoSuchElementException();
                }
                return CompletedStage.of(list.get(0));
            }
            case "last": {
                if (list.isEmpty()) {
                    throw new NoSuchElementException();
                }
                return CompletedStage.of(list.get(list.size() - 1));
            }
        }
        try {
            index = Integer.parseInt(name);
        }
        catch (NumberFormatException e) {
            return Results.notFound(context);
        }
        return CompletedStage.of(list.get(index));
    }

    private static Object entryResolve(Map.Entry<?, ?> entry, String name) {
        switch (name) {
            case "key": 
            case "getKey": {
                return entry.getKey();
            }
            case "value": 
            case "getValue": {
                return entry.getValue();
            }
        }
        return Results.NotFound.from(name);
    }

    private static CompletionStage<Object> mapResolveAsync(EvalContext context) {
        String name;
        Map map = (Map)context.getBase();
        switch (name = context.getName()) {
            case "keys": 
            case "keySet": {
                return CompletedStage.of(map.keySet());
            }
            case "values": {
                return CompletedStage.of(map.values());
            }
            case "entrySet": {
                return CompletedStage.of(map.entrySet());
            }
            case "size": {
                return CompletedStage.of(map.size());
            }
            case "empty": 
            case "isEmpty": {
                return map.isEmpty() ? Results.TRUE : Results.FALSE;
            }
            case "get": {
                if (context.getParams().size() == 1) {
                    return context.evaluate(context.getParams().get(0)).thenCompose(k -> CompletedStage.of(map.get(k)));
                }
            }
            case "containsKey": {
                if (context.getParams().size() != 1) break;
                return context.evaluate(context.getParams().get(0)).thenCompose(k -> CompletedStage.of(map.containsKey(k)));
            }
        }
        Object val = map.get(name);
        if (val == null) {
            return map.containsKey(name) ? Results.NULL : Results.notFound(context);
        }
        return CompletedStage.of(val);
    }

    static abstract class IntArithmeticResolver
    implements ValueResolver {
        IntArithmeticResolver() {
        }

        @Override
        public boolean appliesTo(EvalContext context) {
            Object base = context.getBase();
            return base != null && (base instanceof Integer || base instanceof Long) && context.getParams().size() == 1 && this.appliesToName(context.getName());
        }

        @Override
        public CompletionStage<Object> resolve(final EvalContext context) {
            return context.evaluate(context.getParams().get(0)).thenApply(new Function<Object, Object>(){

                @Override
                public Object apply(Object param) {
                    Object base = context.getBase();
                    if (param instanceof Integer) {
                        Integer intParam = (Integer)param;
                        if (base instanceof Integer) {
                            return this.compute((Integer)base, intParam);
                        }
                        if (base instanceof Long) {
                            return this.compute((Long)base, intParam);
                        }
                        throw new IllegalStateException("Unsupported base operand: " + base.getClass());
                    }
                    if (param instanceof Long) {
                        Long longParam = (Long)param;
                        if (base instanceof Integer) {
                            return this.compute((Integer)base, longParam);
                        }
                        if (base instanceof Long) {
                            return this.compute((Long)base, longParam);
                        }
                        throw new IllegalStateException("Unsupported base operand: " + base.getClass());
                    }
                    return Results.notFound(context);
                }
            });
        }

        protected abstract boolean appliesToName(String var1);

        protected abstract Object compute(Integer var1, Integer var2);

        protected abstract Object compute(Long var1, Integer var2);

        protected abstract Object compute(Integer var1, Long var2);

        protected abstract Object compute(Long var1, Long var2);
    }
}

