/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.Expression;
import io.quarkus.qute.ParameterDeclaration;
import io.quarkus.qute.ResolutionContext;
import io.quarkus.qute.ResultNode;
import io.quarkus.qute.Variant;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletionStage;

public interface TemplateNode {
    public CompletionStage<ResultNode> resolve(ResolutionContext var1);

    default public List<Expression> getExpressions() {
        return Collections.emptyList();
    }

    default public List<ParameterDeclaration> getParameterDeclarations() {
        return Collections.emptyList();
    }

    public Origin getOrigin();

    default public boolean isConstant() {
        return false;
    }

    default public boolean isSection() {
        return false;
    }

    public static interface Origin {
        public int getLine();

        public int getLineCharacterStart();

        public int getLineCharacterEnd();

        public String getTemplateId();

        public String getTemplateGeneratedId();

        default public boolean hasNonGeneratedTemplateId() {
            return !this.getTemplateId().equals(this.getTemplateGeneratedId());
        }

        public Optional<Variant> getVariant();

        default public void appendTo(StringBuilder builder) {
            if (this.hasNonGeneratedTemplateId()) {
                builder.append(" template [").append(this.getTemplateId()).append("] ").append("line ").append(this.getLine());
            }
        }

        default public boolean isSynthetic() {
            return this.getLine() == -1;
        }
    }
}

