/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.stream;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import java.util.function.Predicate;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.SerializeWith;
import org.keycloak.models.sessions.infinispan.changes.SessionEntityWrapper;
import org.keycloak.models.sessions.infinispan.entities.LoginFailureEntity;
import org.keycloak.models.sessions.infinispan.entities.LoginFailureKey;

@SerializeWith(value=ExternalizerImpl.class)
public class UserLoginFailurePredicate
implements Predicate<Map.Entry<LoginFailureKey, SessionEntityWrapper<LoginFailureEntity>>> {
    private final String realm;

    private UserLoginFailurePredicate(String realm) {
        this.realm = realm;
    }

    public static UserLoginFailurePredicate create(String realm) {
        return new UserLoginFailurePredicate(realm);
    }

    @Override
    public boolean test(Map.Entry<LoginFailureKey, SessionEntityWrapper<LoginFailureEntity>> entry) {
        LoginFailureEntity e = entry.getValue().getEntity();
        return this.realm.equals(e.getRealmId());
    }

    public static class ExternalizerImpl
    implements Externalizer<UserLoginFailurePredicate> {
        private static final int VERSION_1 = 1;

        public void writeObject(ObjectOutput output, UserLoginFailurePredicate obj) throws IOException {
            output.writeByte(1);
            MarshallUtil.marshallString((String)obj.realm, (ObjectOutput)output);
        }

        public UserLoginFailurePredicate readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            switch (input.readByte()) {
                case 1: {
                    return this.readObjectVersion1(input);
                }
            }
            throw new IOException("Unknown version");
        }

        public UserLoginFailurePredicate readObjectVersion1(ObjectInput input) throws IOException, ClassNotFoundException {
            UserLoginFailurePredicate res = new UserLoginFailurePredicate(MarshallUtil.unmarshallString((ObjectInput)input));
            return res;
        }
    }
}

