/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.stream;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Map;
import java.util.function.Predicate;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.SerializeWith;
import org.keycloak.models.cache.infinispan.entities.InClient;
import org.keycloak.models.cache.infinispan.entities.Revisioned;

@SerializeWith(value=ExternalizerImpl.class)
public class InClientPredicate
implements Predicate<Map.Entry<String, Revisioned>>,
Serializable {
    private String clientId;

    public static InClientPredicate create() {
        return new InClientPredicate();
    }

    public InClientPredicate client(String id) {
        this.clientId = id;
        return this;
    }

    @Override
    public boolean test(Map.Entry<String, Revisioned> entry) {
        Revisioned value = entry.getValue();
        if (value == null) {
            return false;
        }
        if (!(value instanceof InClient)) {
            return false;
        }
        return this.clientId.equals(((InClient)value).getClientId());
    }

    public static class ExternalizerImpl
    implements Externalizer<InClientPredicate> {
        private static final int VERSION_1 = 1;

        public void writeObject(ObjectOutput output, InClientPredicate obj) throws IOException {
            output.writeByte(1);
            MarshallUtil.marshallString((String)obj.clientId, (ObjectOutput)output);
        }

        public InClientPredicate readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            switch (input.readByte()) {
                case 1: {
                    return this.readObjectVersion1(input);
                }
            }
            throw new IOException("Unknown version");
        }

        public InClientPredicate readObjectVersion1(ObjectInput input) throws IOException, ClassNotFoundException {
            InClientPredicate res = new InClientPredicate();
            res.clientId = MarshallUtil.unmarshallString((ObjectInput)input);
            return res;
        }
    }
}

