/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.logging.Logger;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.Profile;
import org.keycloak.common.Version;
import org.keycloak.common.util.Base64Url;
import org.keycloak.common.util.MimeTypeUtil;
import org.keycloak.common.util.SecretGenerator;
import org.keycloak.cookie.CookieProvider;
import org.keycloak.cookie.CookieType;
import org.keycloak.http.HttpRequest;
import org.keycloak.models.KeycloakSession;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.managers.ApplianceBootstrap;
import org.keycloak.services.util.CacheControlUtil;
import org.keycloak.theme.Theme;
import org.keycloak.theme.freemarker.FreeMarkerProvider;
import org.keycloak.urls.UrlType;

@Provider
@Path(value="/")
public class WelcomeResource {
    protected static final Logger logger = Logger.getLogger(WelcomeResource.class);
    private static final String KEYCLOAK_STATE_CHECKER = "WELCOME_STATE_CHECKER";
    private AtomicBoolean shouldBootstrap;
    @Context
    KeycloakSession session;

    @GET
    @Produces(value={"text/html; charset=utf-8"})
    public Response getWelcomePage() throws URISyntaxException {
        String requestUri = this.session.getContext().getUri().getRequestUri().toString();
        if (!requestUri.endsWith("/")) {
            return Response.seeOther((URI)new URI(requestUri + "/")).build();
        }
        return this.createWelcomePage(null, null);
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/html; charset=utf-8"})
    public Response createUser() {
        HttpRequest request = this.session.getContext().getHttpRequest();
        MultivaluedMap formData = request.getDecodedFormParameters();
        if (!this.shouldBootstrap()) {
            return this.createWelcomePage(null, null);
        }
        if (!this.isLocal()) {
            ServicesLogger.LOGGER.rejectedNonLocalAttemptToCreateInitialUser(this.session.getContext().getConnection().getRemoteAddr());
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        this.csrfCheck((MultivaluedMap<String, String>)formData);
        String username = (String)formData.getFirst((Object)"username");
        String password = (String)formData.getFirst((Object)"password");
        String passwordConfirmation = (String)formData.getFirst((Object)"passwordConfirmation");
        if (username != null) {
            username = username.trim();
        }
        if (username == null || username.length() == 0) {
            return this.createWelcomePage(null, "Username is missing");
        }
        if (password == null || password.length() == 0) {
            return this.createWelcomePage(null, "Password is missing");
        }
        if (!password.equals(passwordConfirmation)) {
            return this.createWelcomePage(null, "Password and confirmation doesn't match");
        }
        this.expireCsrfCookie();
        ApplianceBootstrap applianceBootstrap = new ApplianceBootstrap(this.session);
        applianceBootstrap.createMasterRealmUser(username, password);
        this.shouldBootstrap.set(false);
        ServicesLogger.LOGGER.createdInitialAdminUser(username);
        return this.createWelcomePage("User created", null);
    }

    @GET
    @Path(value="/welcome-content/{path}")
    @Produces(value={"text/html; charset=utf-8"})
    public Response getResource(@PathParam(value="path") String path) {
        try {
            InputStream resource = this.getTheme().getResourceAsStream(path);
            if (resource != null) {
                String contentType = MimeTypeUtil.getContentType((String)path);
                Response.ResponseBuilder builder = Response.ok((Object)resource).type(contentType).cacheControl(CacheControlUtil.getDefaultCacheControl());
                return builder.build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (IOException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private Response createWelcomePage(String successMessage, String errorMessage) {
        try {
            Theme theme = this.getTheme();
            if (Objects.isNull(theme)) {
                logger.error((Object)"Theme is null please check the \"--spi-theme-default\" parameter");
                errorMessage = "The theme is null";
                Response.ResponseBuilder rb = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorMessage).cacheControl(CacheControlUtil.noCache());
                return rb.build();
            }
            boolean bootstrap = this.shouldBootstrap();
            boolean adminConsoleEnabled = WelcomeResource.isAdminConsoleEnabled();
            Properties themeProperties = theme.getProperties();
            boolean redirectToAdmin = Boolean.parseBoolean(themeProperties.getProperty("redirectToAdmin", "false"));
            URI adminUrl = this.session.getContext().getUri(UrlType.ADMIN).getBaseUriBuilder().path("/admin/").build(new Object[0]);
            if (redirectToAdmin && !bootstrap && adminConsoleEnabled && successMessage == null) {
                return Response.status((int)302).location(adminUrl).build();
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            String commonPath = themeProperties.getProperty("common", "common/keycloak");
            map.put("bootstrap", bootstrap);
            map.put("adminConsoleEnabled", adminConsoleEnabled);
            map.put("properties", themeProperties);
            map.put("adminUrl", adminUrl);
            map.put("baseUrl", this.session.getContext().getUri(UrlType.FRONTEND).getBaseUri());
            map.put("productName", "Keycloak");
            map.put("resourcesPath", "resources/" + Version.RESOURCES_VERSION + "/" + theme.getType().toString().toLowerCase() + "/" + theme.getName());
            map.put("resourcesCommonPath", "resources/" + Version.RESOURCES_VERSION + "/" + commonPath);
            boolean isLocal = this.isLocal();
            map.put("localUser", isLocal);
            if (bootstrap) {
                String localAdminUrl = this.session.getContext().getUri(UrlType.LOCAL_ADMIN).getBaseUri().toString();
                String adminCreationMessage = this.getAdminCreationMessage();
                map.put("localAdminUrl", localAdminUrl);
                map.put("adminUserCreationMessage", adminCreationMessage);
                if (isLocal) {
                    String stateChecker = this.setCsrfCookie();
                    map.put("stateChecker", stateChecker);
                }
            }
            if (successMessage != null) {
                map.put("successMessage", successMessage);
            }
            if (errorMessage != null) {
                map.put("errorMessage", errorMessage);
            }
            FreeMarkerProvider freeMarkerUtil = (FreeMarkerProvider)this.session.getProvider(FreeMarkerProvider.class);
            String result = freeMarkerUtil.processTemplate(map, "index.ftl", theme);
            Response.ResponseBuilder rb = Response.status((Response.Status)(errorMessage == null ? Response.Status.OK : Response.Status.BAD_REQUEST)).entity((Object)result).cacheControl(CacheControlUtil.noCache());
            return rb.build();
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private static boolean isAdminConsoleEnabled() {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.ADMIN2);
    }

    private Theme getTheme() {
        try {
            return this.session.theme().getTheme(Theme.Type.WELCOME);
        }
        catch (IOException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    protected String getAdminCreationMessage() {
        return "or set the environment variables KEYCLOAK_ADMIN and KEYCLOAK_ADMIN_PASSWORD before starting the server";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldBootstrap() {
        if (this.shouldBootstrap == null) {
            WelcomeResource welcomeResource = this;
            synchronized (welcomeResource) {
                if (this.shouldBootstrap == null) {
                    this.shouldBootstrap = new AtomicBoolean(new ApplianceBootstrap(this.session).isNoMasterUser());
                }
            }
        }
        return this.shouldBootstrap.get();
    }

    private boolean isLocal() {
        try {
            ClientConnection clientConnection = this.session.getContext().getConnection();
            InetAddress remoteInetAddress = InetAddress.getByName(clientConnection.getRemoteAddr());
            InetAddress localInetAddress = InetAddress.getByName(clientConnection.getLocalAddr());
            HttpRequest request = this.session.getContext().getHttpRequest();
            HttpHeaders headers = request.getHttpHeaders();
            String xForwardedFor = headers.getHeaderString("X-Forwarded-For");
            logger.debugf("Checking WelcomePage. Remote address: %s, Local address: %s, X-Forwarded-For header: %s", (Object)remoteInetAddress.toString(), (Object)localInetAddress.toString(), (Object)xForwardedFor);
            return this.isLocalAddress(remoteInetAddress) && this.isLocalAddress(localInetAddress) && xForwardedFor == null;
        }
        catch (UnknownHostException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private boolean isLocalAddress(InetAddress inetAddress) {
        return inetAddress.isAnyLocalAddress() || inetAddress.isLoopbackAddress();
    }

    private String setCsrfCookie() {
        String stateChecker = Base64Url.encode((byte[])SecretGenerator.getInstance().randomBytes());
        ((CookieProvider)this.session.getProvider(CookieProvider.class)).set(CookieType.WELCOME_CSRF, stateChecker);
        return stateChecker;
    }

    private void expireCsrfCookie() {
        ((CookieProvider)this.session.getProvider(CookieProvider.class)).expire(CookieType.WELCOME_CSRF);
    }

    private void csrfCheck(MultivaluedMap<String, String> formData) {
        String formStateChecker = (String)formData.getFirst((Object)"stateChecker");
        String cookieStateChecker = ((CookieProvider)this.session.getProvider(CookieProvider.class)).get(CookieType.WELCOME_CSRF);
        if (cookieStateChecker == null || !cookieStateChecker.equals(formStateChecker)) {
            throw new ForbiddenException();
        }
    }
}

