/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.component.ComponentModel;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.protocol.LoginProtocolFactory;
import org.keycloak.protocol.oid4vc.OID4VCEnvironmentProviderFactory;
import org.keycloak.protocol.oid4vc.issuance.OID4VCIssuerEndpoint;
import org.keycloak.protocol.oid4vc.issuance.OffsetTimeProvider;
import org.keycloak.protocol.oid4vc.issuance.VCIssuerException;
import org.keycloak.protocol.oid4vc.issuance.mappers.OID4VCSubjectIdMapper;
import org.keycloak.protocol.oid4vc.issuance.mappers.OID4VCTargetRoleMapper;
import org.keycloak.protocol.oid4vc.issuance.mappers.OID4VCUserAttributeMapper;
import org.keycloak.protocol.oid4vc.issuance.signing.VCSigningServiceProviderFactory;
import org.keycloak.protocol.oid4vc.issuance.signing.VerifiableCredentialsSigningService;
import org.keycloak.protocol.oid4vc.model.Format;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.services.managers.AppAuthManager;

public class OID4VCLoginProtocolFactory
implements LoginProtocolFactory,
OID4VCEnvironmentProviderFactory {
    private static final Logger LOGGER = Logger.getLogger(OID4VCLoginProtocolFactory.class);
    public static final String PROTOCOL_ID = "oid4vc";
    private static final String ISSUER_DID_REALM_ATTRIBUTE_KEY = "issuerDid";
    private static final String CODE_LIFESPAN_REALM_ATTRIBUTE_KEY = "preAuthorizedCodeLifespanS";
    private static final int DEFAULT_CODE_LIFESPAN_S = 30;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String CLIENT_ROLES_MAPPER = "client-roles";
    private static final String USERNAME_MAPPER = "username";
    private static final String SUBJECT_ID_MAPPER = "subject-id";
    private static final String EMAIL_MAPPER = "email";
    private static final String LAST_NAME_MAPPER = "last-name";
    private static final String FIRST_NAME_MAPPER = "first-name";
    private Map<String, ProtocolMapperModel> builtins = new HashMap<String, ProtocolMapperModel>();

    public void init(Config.Scope config) {
        this.builtins.put(CLIENT_ROLES_MAPPER, OID4VCTargetRoleMapper.create("id", "client roles"));
        this.builtins.put(SUBJECT_ID_MAPPER, OID4VCSubjectIdMapper.create("subject id", "id"));
        this.builtins.put(USERNAME_MAPPER, OID4VCUserAttributeMapper.create(USERNAME_MAPPER, USERNAME_MAPPER, USERNAME_MAPPER, false));
        this.builtins.put(EMAIL_MAPPER, OID4VCUserAttributeMapper.create(EMAIL_MAPPER, EMAIL_MAPPER, EMAIL_MAPPER, false));
        this.builtins.put(FIRST_NAME_MAPPER, OID4VCUserAttributeMapper.create(FIRST_NAME_MAPPER, "firstName", "firstName", false));
        this.builtins.put(LAST_NAME_MAPPER, OID4VCUserAttributeMapper.create(LAST_NAME_MAPPER, "lastName", "familyName", false));
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public Map<String, ProtocolMapperModel> getBuiltinMappers() {
        return this.builtins;
    }

    private void addServiceFromComponent(Map<Format, VerifiableCredentialsSigningService> signingServices, KeycloakSession keycloakSession, ComponentModel componentModel) {
        ProviderFactory factory = keycloakSession.getKeycloakSessionFactory().getProviderFactory(VerifiableCredentialsSigningService.class, componentModel.getProviderId());
        if (!(factory instanceof VCSigningServiceProviderFactory)) {
            throw new IllegalArgumentException(String.format("The component %s is not a VerifiableCredentialsSigningServiceProviderFactory", componentModel.getProviderId()));
        }
        VCSigningServiceProviderFactory sspf = (VCSigningServiceProviderFactory)factory;
        signingServices.put(sspf.supportedFormat(), (VerifiableCredentialsSigningService)sspf.create(keycloakSession, componentModel));
    }

    public Object createProtocolEndpoint(KeycloakSession keycloakSession, EventBuilder event) {
        EnumMap<Format, VerifiableCredentialsSigningService> signingServices = new EnumMap<Format, VerifiableCredentialsSigningService>(Format.class);
        RealmModel realm = keycloakSession.getContext().getRealm();
        realm.getComponentsStream(realm.getId(), VerifiableCredentialsSigningService.class.getName()).forEach(cm -> this.addServiceFromComponent((Map<Format, VerifiableCredentialsSigningService>)signingServices, keycloakSession, (ComponentModel)cm));
        RealmModel realmModel = keycloakSession.getContext().getRealm();
        String issuerDid = Optional.ofNullable(realmModel.getAttribute(ISSUER_DID_REALM_ATTRIBUTE_KEY)).orElseThrow(() -> new VCIssuerException("No issuer-did  configured."));
        int preAuthorizedCodeLifespan = Optional.ofNullable(realmModel.getAttribute(CODE_LIFESPAN_REALM_ATTRIBUTE_KEY)).map(Integer::valueOf).orElse(30);
        return new OID4VCIssuerEndpoint(keycloakSession, issuerDid, signingServices, new AppAuthManager.BearerTokenAuthenticator(keycloakSession), OBJECT_MAPPER, new OffsetTimeProvider(), preAuthorizedCodeLifespan);
    }

    public void createDefaultClientScopes(RealmModel newRealm, boolean addScopesToExistingClients) {
        LOGGER.debugf("Create default scopes for realm %s", (Object)newRealm.getName());
        ClientScopeModel naturalPersonScope = KeycloakModelUtils.getClientScopeByName((RealmModel)newRealm, (String)"natural_person");
        if (naturalPersonScope == null) {
            LOGGER.debug((Object)"Add natural person scope");
            naturalPersonScope = newRealm.addClientScope(String.format("%s_%s", PROTOCOL_ID, "natural_person"));
            naturalPersonScope.setDescription("OIDC$VP Scope, that adds all properties required for a natural person.");
            naturalPersonScope.setProtocol(PROTOCOL_ID);
            naturalPersonScope.addProtocolMapper(this.builtins.get(SUBJECT_ID_MAPPER));
            naturalPersonScope.addProtocolMapper(this.builtins.get(CLIENT_ROLES_MAPPER));
            naturalPersonScope.addProtocolMapper(this.builtins.get(EMAIL_MAPPER));
            naturalPersonScope.addProtocolMapper(this.builtins.get(FIRST_NAME_MAPPER));
            naturalPersonScope.addProtocolMapper(this.builtins.get(LAST_NAME_MAPPER));
            newRealm.addDefaultClientScope(naturalPersonScope, true);
        }
    }

    public void setupClientDefaults(ClientRepresentation rep, ClientModel newClient) {
    }

    public LoginProtocol create(KeycloakSession session) {
        return null;
    }

    public String getId() {
        return PROTOCOL_ID;
    }
}

