/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.factories.AbstractNamedCacheComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.util.logging.Log;

@DefaultFactoryFor(classes={ClusteringDependentLogic.class})
public class ClusteringDependentLogicFactory
extends AbstractNamedCacheComponentFactory
implements AutoInstantiableFactory {
    @Override
    public Object construct(String componentName) {
        ClusteringDependentLogic.AbstractClusteringDependentLogic cdl;
        CacheMode cacheMode = this.configuration.clustering().cacheMode();
        if (!cacheMode.isClustered()) {
            cdl = new ClusteringDependentLogic.LocalLogic();
        } else if (cacheMode.isInvalidation()) {
            cdl = new ClusteringDependentLogic.InvalidationLogic();
        } else if (cacheMode.isReplicated()) {
            cdl = new ClusteringDependentLogic.ReplicationLogic();
        } else if (cacheMode.isDistributed()) {
            cdl = new ClusteringDependentLogic.DistributionLogic();
        } else {
            throw Log.CONTAINER.factoryCannotConstructComponent(componentName);
        }
        return cdl;
    }
}

