/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.DoubleUnaryOperator;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.Projecting;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.ShiftedProjecting;
import org.openstreetmap.josm.data.projection.datum.Datum;
import org.openstreetmap.josm.data.projection.proj.Proj;
import org.openstreetmap.josm.tools.Utils;

public abstract class AbstractProjection
implements Projection {
    protected Ellipsoid ellps;
    protected Datum datum;
    protected Proj proj;
    protected double x0;
    protected double y0;
    protected double lon0;
    protected double pm;
    protected double k0 = 1.0;
    protected double toMeter = 1.0;
    private volatile ProjectionBounds projectionBoundsBox;

    public final Ellipsoid getEllipsoid() {
        return this.ellps;
    }

    public final Datum getDatum() {
        return this.datum;
    }

    public final Proj getProj() {
        return this.proj;
    }

    public final double getFalseEasting() {
        return this.x0;
    }

    public final double getFalseNorthing() {
        return this.y0;
    }

    public final double getCentralMeridian() {
        return this.lon0;
    }

    public final double getScaleFactor() {
        return this.k0;
    }

    public final double getToMeter() {
        return this.toMeter;
    }

    @Override
    public EastNorth latlon2eastNorth(ILatLon toConvert) {
        LatLon ll = this.datum.fromWGS84(new LatLon(toConvert));
        double[] en = this.proj.project(Utils.toRadians(ll.lat()), Utils.toRadians(LatLon.normalizeLon(ll.lon() - this.lon0 - this.pm)));
        return new EastNorth((this.ellps.a * this.k0 * en[0] + this.x0) / this.toMeter, (this.ellps.a * this.k0 * en[1] + this.y0) / this.toMeter);
    }

    @Override
    public LatLon eastNorth2latlon(EastNorth en) {
        return this.eastNorth2latlon(en, LatLon::normalizeLon);
    }

    @Override
    public LatLon eastNorth2latlonClamped(EastNorth en) {
        LatLon ll = this.eastNorth2latlon(en, lon -> Utils.clamp(lon, -180.0, 180.0));
        Bounds bounds = this.getWorldBoundsLatLon();
        return new LatLon(Utils.clamp(ll.lat(), bounds.getMinLat(), bounds.getMaxLat()), Utils.clamp(ll.lon(), bounds.getMinLon(), bounds.getMaxLon()));
    }

    private LatLon eastNorth2latlon(EastNorth en, DoubleUnaryOperator normalizeLon) {
        double[] latlonRad = this.proj.invproject((en.east() * this.toMeter - this.x0) / this.ellps.a / this.k0, (en.north() * this.toMeter - this.y0) / this.ellps.a / this.k0);
        double lon = Utils.toDegrees(latlonRad[1]) + this.lon0 + this.pm;
        LatLon ll = new LatLon(Utils.toDegrees(latlonRad[0]), normalizeLon.applyAsDouble(lon));
        return this.datum.toWGS84(ll);
    }

    @Override
    public Map<ProjectionBounds, Projecting> getProjectingsForArea(ProjectionBounds area) {
        if (this.proj.lonIsLinearToEast()) {
            Bounds bounds = this.getWorldBoundsLatLon();
            double minEast = this.latlon2eastNorth(bounds.getMin()).east();
            double maxEast = this.latlon2eastNorth(bounds.getMax()).east();
            double dEast = maxEast - minEast;
            if ((area.minEast < minEast || area.maxEast > maxEast) && dEast > 0.0) {
                int minChunk = (int)Math.floor((area.minEast - minEast) / dEast);
                int maxChunk = (int)Math.floor((area.maxEast - minEast) / dEast);
                HashMap<ProjectionBounds, Projecting> ret = new HashMap<ProjectionBounds, Projecting>();
                for (int chunk = minChunk; chunk <= maxChunk; ++chunk) {
                    ret.put(new ProjectionBounds(Math.max(area.minEast, minEast + (double)chunk * dEast), area.minNorth, Math.min(area.maxEast, maxEast + (double)chunk * dEast), area.maxNorth), new ShiftedProjecting(this, new EastNorth((double)(-chunk) * dEast, 0.0)));
                }
                return ret;
            }
        }
        return Collections.singletonMap(area, this);
    }

    @Override
    public double getDefaultZoomInPPD() {
        return 10.0 / this.getMetersPerUnit();
    }

    public abstract Integer getEpsgCode();

    @Override
    public String toCode() {
        return "EPSG:" + this.getEpsgCode();
    }

    protected static final double convertMinuteSecond(double minute, double second) {
        return minute / 60.0 + second / 3600.0;
    }

    protected static final double convertDegreeMinuteSecond(double degree, double minute, double second) {
        return degree + minute / 60.0 + second / 3600.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ProjectionBounds getWorldBoundsBoxEastNorth() {
        ProjectionBounds result = this.projectionBoundsBox;
        if (result == null) {
            AbstractProjection abstractProjection = this;
            synchronized (abstractProjection) {
                result = this.projectionBoundsBox;
                if (result == null) {
                    ProjectionBounds bds = new ProjectionBounds();
                    this.visitOutline(this.getWorldBoundsLatLon(), 1000, bds::extend);
                    this.projectionBoundsBox = bds;
                }
            }
        }
        return this.projectionBoundsBox;
    }

    @Override
    public Projection getBaseProjection() {
        return this;
    }

    @Override
    public void visitOutline(Bounds b, Consumer<EastNorth> visitor) {
        this.visitOutline(b, 100, visitor);
    }

    private void visitOutline(Bounds b, int nPoints, Consumer<EastNorth> visitor) {
        int step;
        double maxlon = b.getMaxLon();
        if (b.crosses180thMeridian()) {
            maxlon += 360.0;
        }
        double spanLon = maxlon - b.getMinLon();
        double spanLat = b.getMaxLat() - b.getMinLat();
        for (step = 0; step < nPoints; ++step) {
            visitor.accept(this.latlon2eastNorth(new LatLon(b.getMinLat(), b.getMinLon() + spanLon * (double)step / (double)nPoints)));
        }
        for (step = 0; step < nPoints; ++step) {
            visitor.accept(this.latlon2eastNorth(new LatLon(b.getMinLat() + spanLat * (double)step / (double)nPoints, maxlon)));
        }
        for (step = 0; step < nPoints; ++step) {
            visitor.accept(this.latlon2eastNorth(new LatLon(b.getMaxLat(), maxlon - spanLon * (double)step / (double)nPoints)));
        }
        for (step = 0; step < nPoints; ++step) {
            visitor.accept(this.latlon2eastNorth(new LatLon(b.getMaxLat() - spanLat * (double)step / (double)nPoints, b.getMinLon())));
        }
    }
}

