/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.ChangeNodesCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.PseudoCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.command.SplitWayCommand;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DefaultNameFormatter;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.RelationToChildReference;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;
import org.openstreetmap.josm.tools.Utils;

public class DeleteCommand
extends Command {
    private static volatile DeletionCallback callback;
    private final Collection<? extends OsmPrimitive> toDelete;
    private final Map<OsmPrimitive, PrimitiveData> clonedPrimitives = new HashMap<OsmPrimitive, PrimitiveData>();

    public static void setDeletionCallback(DeletionCallback deletionCallback) {
        callback = Objects.requireNonNull(deletionCallback);
    }

    public DeleteCommand(Collection<? extends OsmPrimitive> data) {
        this(data.iterator().next().getDataSet(), data);
    }

    public DeleteCommand(OsmPrimitive data) {
        this(Collections.singleton(data));
    }

    public DeleteCommand(DataSet dataset, OsmPrimitive data) {
        this(dataset, Collections.singleton(data));
    }

    public DeleteCommand(DataSet dataset, Collection<? extends OsmPrimitive> data) {
        super(dataset);
        CheckParameterUtil.ensureParameterNotNull(data, "data");
        this.toDelete = data;
        this.checkConsistency();
    }

    private void checkConsistency() {
        if (this.toDelete.isEmpty()) {
            throw new IllegalArgumentException(I18n.tr("At least one object to delete required, got empty collection", new Object[0]));
        }
        for (OsmPrimitive osmPrimitive : this.toDelete) {
            if (osmPrimitive == null) {
                throw new IllegalArgumentException("Primitive to delete must not be null");
            }
            if (osmPrimitive.getDataSet() != null) continue;
            throw new IllegalArgumentException("Primitive to delete must be in a dataset");
        }
    }

    @Override
    public boolean executeCommand() {
        this.ensurePrimitivesAreInDataset();
        for (OsmPrimitive osmPrimitive : this.toDelete) {
            if (osmPrimitive.isDeleted()) {
                throw new IllegalArgumentException(osmPrimitive + " is already deleted");
            }
            this.clonedPrimitives.put(osmPrimitive, osmPrimitive.save());
            if (osmPrimitive instanceof Way) {
                ((Way)osmPrimitive).setNodes((List<Node>)null);
                continue;
            }
            if (!(osmPrimitive instanceof Relation)) continue;
            ((Relation)osmPrimitive).setMembers((List<RelationMember>)null);
        }
        for (OsmPrimitive osmPrimitive : this.toDelete) {
            osmPrimitive.setDeleted(true);
        }
        return true;
    }

    @Override
    public void undoCommand() {
        this.ensurePrimitivesAreInDataset();
        for (OsmPrimitive osmPrimitive : this.toDelete) {
            osmPrimitive.setDeleted(false);
        }
        for (Map.Entry entry : this.clonedPrimitives.entrySet()) {
            ((OsmPrimitive)entry.getKey()).load((PrimitiveData)entry.getValue());
        }
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
    }

    private EnumSet<OsmPrimitiveType> getTypesToDelete() {
        EnumSet<OsmPrimitiveType> typesToDelete = EnumSet.noneOf(OsmPrimitiveType.class);
        for (OsmPrimitive osmPrimitive : this.toDelete) {
            typesToDelete.add(OsmPrimitiveType.from(osmPrimitive));
        }
        return typesToDelete;
    }

    @Override
    public String getDescriptionText() {
        String msg;
        if (this.toDelete.size() == 1) {
            String msg2;
            OsmPrimitive primitive = this.toDelete.iterator().next();
            switch (OsmPrimitiveType.from(primitive)) {
                case NODE: {
                    msg2 = I18n.marktr("Delete node {0}");
                    break;
                }
                case WAY: {
                    msg2 = I18n.marktr("Delete way {0}");
                    break;
                }
                case RELATION: {
                    msg2 = I18n.marktr("Delete relation {0}");
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            return I18n.tr(msg2, primitive.getDisplayName(DefaultNameFormatter.getInstance()));
        }
        EnumSet<OsmPrimitiveType> typesToDelete = this.getTypesToDelete();
        if (typesToDelete.size() > 1) {
            msg = I18n.trn("Delete {0} object", "Delete {0} objects", this.toDelete.size(), this.toDelete.size());
        } else {
            OsmPrimitiveType t = (OsmPrimitiveType)((Object)typesToDelete.iterator().next());
            switch (t) {
                case NODE: {
                    msg = I18n.trn("Delete {0} node", "Delete {0} nodes", this.toDelete.size(), this.toDelete.size());
                    break;
                }
                case WAY: {
                    msg = I18n.trn("Delete {0} way", "Delete {0} ways", this.toDelete.size(), this.toDelete.size());
                    break;
                }
                case RELATION: {
                    msg = I18n.trn("Delete {0} relation", "Delete {0} relations", this.toDelete.size(), this.toDelete.size());
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        return msg;
    }

    @Override
    public Icon getDescriptionIcon() {
        if (this.toDelete.size() == 1) {
            return ImageProvider.get(this.toDelete.iterator().next().getDisplayType());
        }
        EnumSet<OsmPrimitiveType> typesToDelete = this.getTypesToDelete();
        if (typesToDelete.size() > 1) {
            return ImageProvider.get("data", "object");
        }
        return ImageProvider.get((OsmPrimitiveType)((Object)typesToDelete.iterator().next()));
    }

    @Override
    public Collection<PseudoCommand> getChildren() {
        if (this.toDelete.size() == 1) {
            return null;
        }
        ArrayList<PseudoCommand> children = new ArrayList<PseudoCommand>(this.toDelete.size());
        for (OsmPrimitive osmPrimitive : this.toDelete) {
            children.add(new DeleteChildCommand(osmPrimitive));
        }
        return children;
    }

    @Override
    public Collection<? extends OsmPrimitive> getParticipatingPrimitives() {
        return this.toDelete;
    }

    public static Command deleteWithReferences(Collection<? extends OsmPrimitive> selection, boolean silent) {
        if (selection == null || selection.isEmpty()) {
            return null;
        }
        Set<OsmPrimitive> parents = OsmPrimitive.getReferrer(selection);
        parents.addAll(selection);
        if (parents.isEmpty()) {
            return null;
        }
        if (!silent && !callback.checkAndConfirmOutlyingDelete(parents, null)) {
            return null;
        }
        return new DeleteCommand(parents.iterator().next().getDataSet(), parents);
    }

    public static Command deleteWithReferences(Collection<? extends OsmPrimitive> selection) {
        return DeleteCommand.deleteWithReferences(selection, false);
    }

    public static Command delete(Collection<? extends OsmPrimitive> selection) {
        return DeleteCommand.delete(selection, true, false);
    }

    protected static Collection<Node> computeNodesToDelete(Collection<OsmPrimitive> primitivesToDelete) {
        HashSet<Node> nodesToDelete = new HashSet<Node>();
        for (Way way : Utils.filteredCollection(primitivesToDelete, Way.class)) {
            for (Node n : way.getNodes()) {
                if (n.isTagged()) continue;
                List<OsmPrimitive> referringPrimitives = n.getReferrers();
                referringPrimitives.removeAll(primitivesToDelete);
                int count = 0;
                for (OsmPrimitive p : referringPrimitives) {
                    if (p.isDeleted()) continue;
                    ++count;
                }
                if (count != 0) continue;
                nodesToDelete.add(n);
            }
        }
        return nodesToDelete;
    }

    public static Command delete(Collection<? extends OsmPrimitive> selection, boolean alsoDeleteNodesInWay) {
        return DeleteCommand.delete(selection, alsoDeleteNodesInWay, false);
    }

    public static Command delete(Collection<? extends OsmPrimitive> selection, boolean alsoDeleteNodesInWay, boolean silent) {
        if (selection == null || selection.isEmpty()) {
            return null;
        }
        HashSet<OsmPrimitive> primitivesToDelete = new HashSet<OsmPrimitive>(selection);
        SubclassFilteredCollection<? extends OsmPrimitive, Relation> relationsToDelete = Utils.filteredCollection(primitivesToDelete, Relation.class);
        if (!(relationsToDelete.isEmpty() || silent || callback.confirmRelationDeletion(relationsToDelete))) {
            return null;
        }
        if (alsoDeleteNodesInWay) {
            Collection<Node> nodesToDelete = DeleteCommand.computeNodesToDelete(primitivesToDelete);
            primitivesToDelete.addAll(nodesToDelete);
        }
        if (!silent && !callback.checkAndConfirmOutlyingDelete(primitivesToDelete, Utils.filteredCollection(primitivesToDelete, Way.class))) {
            return null;
        }
        Collection waysToBeChanged = primitivesToDelete.stream().flatMap(p -> p.referrers(Way.class)).collect(Collectors.toSet());
        LinkedList<Command> cmds = new LinkedList<Command>();
        for (Way w : waysToBeChanged) {
            Way wnew = new Way(w);
            wnew.removeNodes(new HashSet(Utils.filteredCollection(primitivesToDelete, Node.class)));
            if (wnew.getNodesCount() < 2) {
                primitivesToDelete.add(w);
                continue;
            }
            cmds.add(new ChangeNodesCommand(w, wnew.getNodes()));
        }
        if (!silent) {
            Set<RelationToChildReference> references = RelationToChildReference.getRelationToChildReferences(primitivesToDelete);
            references.removeIf(ref -> ref.getParent().isDeleted());
            if (!references.isEmpty() && !callback.confirmDeletionFromRelation(references)) {
                return null;
            }
        }
        Set relationsToBeChanged = primitivesToDelete.stream().flatMap(p -> p.referrers(Relation.class)).collect(Collectors.toSet());
        for (Relation cur : relationsToBeChanged) {
            Relation rel = new Relation(cur);
            rel.removeMembersFor(primitivesToDelete);
            cmds.add(new ChangeCommand(cur, rel));
        }
        if (!primitivesToDelete.isEmpty()) {
            cmds.add(new DeleteCommand(((OsmPrimitive)primitivesToDelete.iterator().next()).getDataSet(), primitivesToDelete));
        }
        return new SequenceCommand(I18n.tr("Delete", new Object[0]), cmds);
    }

    public static Command deleteWaySegment(WaySegment ws) {
        if (ws.way.getNodesCount() < 3) {
            return DeleteCommand.delete(Collections.singleton(ws.way), false);
        }
        if (ws.way.isClosed()) {
            ArrayList<Node> n = new ArrayList<Node>();
            n.addAll(ws.way.getNodes().subList(ws.lowerIndex + 1, ws.way.getNodesCount() - 1));
            n.addAll(ws.way.getNodes().subList(0, ws.lowerIndex + 1));
            Way wnew = new Way(ws.way);
            wnew.setNodes((List<Node>)n);
            return new ChangeCommand(ws.way, wnew);
        }
        ArrayList<Node> n1 = new ArrayList<Node>();
        ArrayList<Node> n2 = new ArrayList<Node>();
        n1.addAll(ws.way.getNodes().subList(0, ws.lowerIndex + 1));
        n2.addAll(ws.way.getNodes().subList(ws.lowerIndex + 1, ws.way.getNodesCount()));
        Way wnew = new Way(ws.way);
        if (n1.size() < 2) {
            wnew.setNodes((List<Node>)n2);
            return new ChangeCommand(ws.way, wnew);
        }
        if (n2.size() < 2) {
            wnew.setNodes((List<Node>)n1);
            return new ChangeCommand(ws.way, wnew);
        }
        return SplitWayCommand.splitWay(ws.way, Arrays.asList(n1, n2), Collections.emptyList());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.toDelete, this.clonedPrimitives);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        DeleteCommand that = (DeleteCommand)obj;
        return Objects.equals(this.toDelete, that.toDelete) && Objects.equals(this.clonedPrimitives, that.clonedPrimitives);
    }

    public static interface DeletionCallback {
        public boolean checkAndConfirmOutlyingDelete(Collection<? extends OsmPrimitive> var1, Collection<? extends OsmPrimitive> var2);

        public boolean confirmRelationDeletion(Collection<Relation> var1);

        public boolean confirmDeletionFromRelation(Collection<RelationToChildReference> var1);
    }

    private static final class DeleteChildCommand
    implements PseudoCommand {
        private final OsmPrimitive osm;

        private DeleteChildCommand(OsmPrimitive osm) {
            this.osm = osm;
        }

        @Override
        public String getDescriptionText() {
            return I18n.tr("Deleted ''{0}''", this.osm.getDisplayName(DefaultNameFormatter.getInstance()));
        }

        @Override
        public Icon getDescriptionIcon() {
            return ImageProvider.get(this.osm.getDisplayType());
        }

        @Override
        public Collection<? extends OsmPrimitive> getParticipatingPrimitives() {
            return Collections.singleton(this.osm);
        }

        public String toString() {
            return "DeleteChildCommand [osm=" + this.osm + ']';
        }
    }
}

