/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import java.util.Objects;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.packet.AbstractIqBuilder;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.IqBuilder;
import org.jivesoftware.smack.packet.IqData;
import org.jivesoftware.smack.packet.StanzaError;

public final class ErrorIQ
extends IQ {
    public static final String ELEMENT = "error";
    private final IQ request;

    private ErrorIQ(Builder builder, QName childElementQName) {
        super(builder, childElementQName);
        Objects.requireNonNull(builder.getError(), "Must provide an stanza error when building error IQs");
        this.request = builder.request;
    }

    public static ErrorIQ createErrorResponse(IQ request, StanzaError error) {
        Builder builder = new Builder(error, request);
        builder.setError(error);
        return builder.build();
    }

    @Override
    protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder xml) {
        if (this.request == null) {
            return null;
        }
        return this.request.getIQChildElementBuilder(xml);
    }

    public static Builder builder(StanzaError error) {
        return new Builder(error, IqData.EMPTY.ofType(IQ.Type.error));
    }

    public static Builder builder(StanzaError error, IqData iqData) {
        return new Builder(error, iqData);
    }

    public static final class Builder
    extends IqBuilder<Builder, ErrorIQ> {
        private IQ request;

        Builder(StanzaError error, IqData iqData) {
            super(iqData);
            if (iqData.getType() != IQ.Type.error) {
                throw new IllegalArgumentException("Error IQs must be of type 'error'");
            }
            Objects.requireNonNull(error, "Must provide an stanza error when building error IQs");
            this.setError(error);
        }

        Builder(StanzaError error, IQ request) {
            this(error, AbstractIqBuilder.createErrorResponse(request));
            this.request = request;
        }

        @Override
        public Builder getThis() {
            return this;
        }

        @Override
        public ErrorIQ build() {
            QName childElementQname = null;
            if (this.request != null) {
                childElementQname = this.request.getChildElementQName();
            }
            return new ErrorIQ(this, childElementQname);
        }
    }
}

