/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ast extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "\u00e1rabe";
        final String metaValue_hy = "armeniu";
        final String metaValue_ban = "balin\u00e9s";
        final String metaValue_bn = "bengal\u00edn";
        final String metaValue_ka = "xeorxanu";
        final String metaValue_got = "g\u00f3ticu";
        final String metaValue_el = "griegu";
        final String metaValue_he = "hebr\u00e9u";
        final String metaValue_jv = "xavan\u00e9s";
        final String metaValue_ja = "xapon\u00e9s";
        final String metaValue_km = "\u1e25emer";
        final String metaValue_kn = "canar\u00e9s";
        final String metaValue_ko = "coreanu";
        final String metaValue_kpe = "kpelle";
        final String metaValue_lo = "laosianu";
        final String metaValue_la = "llat\u00edn";
        final String metaValue_men = "mende";
        final String metaValue_ml = "malayalam";
        final String metaValue_mn = "mongol";
        final String metaValue_my = "birmanu";
        final String metaValue_nqo = "n\u2019ko";
        final String metaValue_or = "oriya";
        final String metaValue_phn = "feniciu";
        final String metaValue_saz = "saurashtra";
        final String metaValue_si = "cingal\u00e9s";
        final String metaValue_su = "sondan\u00e9s";
        final String metaValue_syr = "siriacu";
        final String metaValue_ta = "tamil";
        final String metaValue_te = "telugu";
        final String metaValue_tl = "tagalog";
        final String metaValue_th = "tailand\u00e9s";
        final String metaValue_bo = "tibetanu";
        final String metaValue_uga = "ugar\u00edticu";
        final String metaValue_vai = "vai";
        final String metaValue_peo = "persa antiguu";
        final String metaValue_ssy = "saho";
        final Object[][] data = new Object[][] {
            { "001", "Mundu" },
            { "002", "\u00c1frica" },
            { "003", "Norteam\u00e9rica" },
            { "005", "Am\u00e9rica del Sur" },
            { "009", "Ocean\u00eda" },
            { "011", "\u00c1frica Occidental" },
            { "013", "Am\u00e9rica Central" },
            { "014", "\u00c1frica Oriental" },
            { "015", "\u00c1frica del Norte" },
            { "017", "\u00c1frica Central" },
            { "018", "\u00c1frica del Sur" },
            { "019", "Am\u00e9rica" },
            { "021", "Am\u00e9rica del Norte" },
            { "029", "Caribe" },
            { "030", "Asia Oriental" },
            { "034", "Asia del Sur" },
            { "035", "Sureste Asi\u00e1ticu" },
            { "039", "Europa del Sur" },
            { "053", "Australasia" },
            { "054", "Melanesia" },
            { "057", "Rex\u00f3n de Micronesia" },
            { "061", "Polinesia" },
            { "142", "Asia" },
            { "143", "Asia Central" },
            { "145", "Asia Occidental" },
            { "150", "Europa" },
            { "151", "Europa Oriental" },
            { "154", "Europa del Norte" },
            { "155", "Europa Occidental" },
            { "419", "Am\u00e9rica Llatina" },
            { "AC", "Islla Ascensi\u00f3n" },
            { "AD", "Andorra" },
            { "AE", "Emiratos \u00c1rabes Xun\u00edos" },
            { "AF", "Afganist\u00e1n" },
            { "AG", "Antigua y Barbuda" },
            { "AI", "Anguila" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "AO", "Angola" },
            { "AQ", "L\u2019Ant\u00e1rtida" },
            { "AR", "Arxentina" },
            { "AS", "Samoa Americana" },
            { "AT", "Austria" },
            { "AU", "Australia" },
            { "AW", "Aruba" },
            { "AX", "Islles Aland" },
            { "AZ", "Azerbaix\u00e1n" },
            { "BA", "Bosnia y Herzegovina" },
            { "BB", "Barbados" },
            { "BD", "Bangladex" },
            { "BE", "B\u00e9lxica" },
            { "BF", "Burkina Fasu" },
            { "BG", "Bulgaria" },
            { "BH", "Ba\u1e25r\u00e9in" },
            { "BI", "Burundi" },
            { "BJ", "Ben\u00edn" },
            { "BL", "San Bartolom\u00e9" },
            { "BM", "Les Bermudes" },
            { "BN", "Brun\u00e9i" },
            { "BO", "Bolivia" },
            { "BQ", "Caribe neerland\u00e9s" },
            { "BR", "Brasil" },
            { "BS", "Les Bahames" },
            { "BT", "But\u00e1n" },
            { "BV", "Islla Bouvet" },
            { "BW", "Botsuana" },
            { "BY", "Bielorrusia" },
            { "BZ", "Belize" },
            { "CA", "Canad\u00e1" },
            { "CC", "Islles Cocos (Keeling)" },
            { "CD", "Congu - Kinxasa" },
            { "CF", "Rep\u00fablica Centroafricana" },
            { "CG", "Congu - Brazzaville" },
            { "CH", "Suiza" },
            { "CI", "Costa de Marfil" },
            { "CK", "Islles Cook" },
            { "CL", "Chile" },
            { "CM", "Camer\u00fan" },
            { "CN", "China" },
            { "CO", "Colombia" },
            { "CP", "Islla Clipperton" },
            { "CR", "Costa Rica" },
            { "CU", "Cuba" },
            { "CV", "Cabu Verde" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Islla Christmas" },
            { "CY", "Xipre" },
            { "CZ", "Chequia" },
            { "DE", "Alema\u00f1a" },
            { "DG", "Diego Garcia" },
            { "DJ", "Xibuti" },
            { "DK", "Dinamarca" },
            { "DM", "Dominica" },
            { "DO", "Rep\u00fablica Dominicana" },
            { "DZ", "Arxelia" },
            { "EA", "Ceuta y Melilla" },
            { "EC", "Ecuador" },
            { "EE", "Estonia" },
            { "EG", "Exiptu" },
            { "EH", "S\u00e1\u1e25ara Occidental" },
            { "ER", "Eritrea" },
            { "ES", "Espa\u00f1a" },
            { "ET", "Etiop\u00eda" },
            { "EU", "Xuni\u00f3n Europea" },
            { "EZ", "Eurozona" },
            { "FI", "Finlandia" },
            { "FJ", "Islles Fixi" },
            { "FK", "Falkland Islands" },
            { "FM", "Micronesia" },
            { "FO", "Islles Feroe" },
            { "FR", "Francia" },
            { "GA", "Gab\u00f3n" },
            { "GB", "Reinu Xun\u00edu" },
            { "GD", "Granada" },
            { "GE", "Xeorxa" },
            { "GF", "Guyana Francesa" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Xibraltar" },
            { "GL", "Groenlandia" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadalupe" },
            { "GQ", "Guinea Ecuatorial" },
            { "GR", "Grecia" },
            { "GS", "Islles Xeorxa del Sur y Sandwich del Sur" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guinea-Bis\u00e1u" },
            { "GY", "Guyana" },
            { "HK", "ARE China de \u1e24ong Kong" },
            { "HM", "Islles Heard y McDonald" },
            { "HN", "Hondures" },
            { "HR", "Croacia" },
            { "HT", "Hait\u00ed" },
            { "HU", "Hungr\u00eda" },
            { "IC", "Islles Canaries" },
            { "ID", "Indonesia" },
            { "IE", "Irlanda" },
            { "IL", "Israel" },
            { "IM", "Islla de Man" },
            { "IN", "India" },
            { "IO", "Territoriu Brit\u00e1nicu del Oc\u00e9anu \u00cdndicu" },
            { "IQ", "Iraq" },
            { "IR", "Ir\u00e1n" },
            { "IS", "Islandia" },
            { "IT", "Italia" },
            { "JE", "Jersey" },
            { "JM", "Xamaica" },
            { "JO", "Xordania" },
            { "JP", "Xap\u00f3n" },
            { "KE", "Kenia" },
            { "KG", "Kirguist\u00e1n" },
            { "KH", "Camboya" },
            { "KI", "Kiribati" },
            { "KM", "Les Comores" },
            { "KN", "Saint Kitts y Nevis" },
            { "KP", "Corea del Norte" },
            { "KR", "Corea del Sur" },
            { "KW", "Kuwait" },
            { "KY", "Islles Caim\u00e1n" },
            { "KZ", "Kazakst\u00e1n" },
            { "LA", "Laos" },
            { "LB", "L\u00edbanu" },
            { "LC", "Santa Lluc\u00eda" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberia" },
            { "LS", "Lesothu" },
            { "LT", "Lituania" },
            { "LU", "Luxemburgu" },
            { "LV", "Letonia" },
            { "LY", "Libia" },
            { "MA", "Marruecos" },
            { "MC", "M\u00f3nacu" },
            { "MD", "Moldavia" },
            { "ME", "Montenegru" },
            { "MF", "Saint Martin" },
            { "MG", "Madagascar" },
            { "MH", "Islles Marshall" },
            { "ML", "Mal\u00ed" },
            { "MM", "Myanmar (Birmania)" },
            { "MN", "Mongolia" },
            { "MO", "ARE China de Mac\u00e1u" },
            { "MP", "Islles Marianes del Norte" },
            { "MQ", "La Martinica" },
            { "MR", "Mauritania" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Mauriciu" },
            { "MV", "Les Maldives" },
            { "MW", "Malaui" },
            { "MX", "M\u00e9xicu" },
            { "MY", "Malasia" },
            { "MZ", "Mozambique" },
            { "NA", "Namibia" },
            { "NC", "Nueva Caledonia" },
            { "NE", "El N\u00edxer" },
            { "NF", "Islla Norfolk" },
            { "NG", "Nixeria" },
            { "NI", "Nicaragua" },
            { "NL", "Pa\u00edses Baxos" },
            { "NO", "Noruega" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Nueva Zelanda" },
            { "OM", "Om\u00e1n" },
            { "PA", "Panam\u00e1" },
            { "PE", "Per\u00fa" },
            { "PF", "Polinesia Francesa" },
            { "PG", "Pap\u00faa Nueva Guinea" },
            { "PH", "Filipines" },
            { "PK", "Paquist\u00e1n" },
            { "PL", "Polonia" },
            { "PM", "Saint Pierre y Miquelon" },
            { "PN", "Islles Pitcairn" },
            { "PR", "Puertu Ricu" },
            { "PS", "Territorios Palestinos" },
            { "PT", "Portugal" },
            { "PW", "Pal\u00e1u" },
            { "PY", "Paragu\u00e1i" },
            { "QA", "Qatar" },
            { "QO", "Ocean\u00eda esterior" },
            { "RE", "Reuni\u00f3n" },
            { "RO", "Ruman\u00eda" },
            { "RS", "Serbia" },
            { "RU", "Rusia" },
            { "RW", "Ruanda" },
            { "SA", "Arabia Saudita" },
            { "SB", "Islles Salom\u00f3n" },
            { "SC", "Les Seixeles" },
            { "SD", "Sud\u00e1n" },
            { "SE", "Suecia" },
            { "SG", "Singapur" },
            { "SH", "Santa Helena" },
            { "SI", "Eslovenia" },
            { "SJ", "Svalbard ya Islla Jan Mayen" },
            { "SK", "Eslovaquia" },
            { "SL", "Sierra Lleona" },
            { "SM", "San Mar\u00edn" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "SR", "Surinam" },
            { "SS", "Sud\u00e1n del Sur" },
            { "ST", "Santu Tom\u00e9 y Pr\u00edncipe" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Siria" },
            { "SZ", "Suazilandia" },
            { "TA", "Trist\u00e1n da Cunha" },
            { "TC", "Islles Turques y Caicos" },
            { "TD", "Chad" },
            { "TF", "Tierres Australes Franceses" },
            { "TG", "Togu" },
            { "TH", "Tailandia" },
            { "TJ", "Taxiquist\u00e1n" },
            { "TK", "Tokel\u00e1u" },
            { "TL", "Timor Oriental" },
            { "TM", "Turkmenist\u00e1n" },
            { "TN", "Tunicia" },
            { "TO", "Tonga" },
            { "TR", "Turqu\u00eda" },
            { "TT", "Trinid\u00e1 y Tobagu" },
            { "TV", "Tuvalu" },
            { "TW", "Taiw\u00e1n" },
            { "TZ", "Tanzania" },
            { "UA", "Ucra\u00edna" },
            { "UG", "Uganda" },
            { "UM", "Islles Perif\u00e9riques Menores de los EE.XX." },
            { "UN", "Naciones Xun\u00edes" },
            { "US", "Estaos Xun\u00edos" },
            { "UY", "Urugu\u00e1i" },
            { "UZ", "Uzbequist\u00e1n" },
            { "VA", "Ciud\u00e1 del Vaticanu" },
            { "VC", "San Vicente y Granadines" },
            { "VE", "Venezuela" },
            { "VG", "Islles V\u00edrxenes Brit\u00e1niques" },
            { "VI", "Islles V\u00edrxenes Americanes" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis y Futuna" },
            { "WS", "Samoa" },
            { "XK", "Kosovu" },
            { "YE", "Yemen" },
            { "YT", "Mayotte" },
            { "ZA", "Sud\u00e1frica" },
            { "ZM", "Zambia" },
            { "ZW", "Zimbabue" },
            { "ZZ", "Rex\u00f3n desconocida" },
            { "aa", "afar" },
            { "ab", "abkhazianu" },
            { "ae", "avestan\u00edn" },
            { "af", "afrikaans" },
            { "ak", "akan" },
            { "am", "amh\u00e1ricu" },
            { "an", "aragon\u00e9s" },
            { "ar", metaValue_ar },
            { "as", "asam\u00e9s" },
            { "av", "av\u00e1ricu" },
            { "ay", "aymara" },
            { "az", "azerbaixanu" },
            { "ba", "bashkir" },
            { "be", "bielorrusu" },
            { "bg", "b\u00falgaru" },
            { "bi", "bislama" },
            { "bm", "bambara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "bret\u00f3n" },
            { "bs", "bosniu" },
            { "ca", "catal\u00e1n" },
            { "ce", "chechenu" },
            { "ch", "chamorro" },
            { "co", "corsu" },
            { "cr", "cree" },
            { "cs", "checu" },
            { "cu", "esl\u00e1vicu eclesi\u00e1sticu" },
            { "cv", "chuvash" },
            { "cy", "gal\u00e9s" },
            { "da", "dan\u00e9s" },
            { "de", "alem\u00e1n" },
            { "dv", "divehi" },
            { "dz", "dzongkha" },
            { "ee", "ewe" },
            { "el", metaValue_el },
            { "en", "ingl\u00e9s" },
            { "eo", "esperanto" },
            { "es", "espa\u00f1ol" },
            { "et", "estoniu" },
            { "eu", "vascu" },
            { "fa", "persa" },
            { "ff", "fulah" },
            { "fi", "finland\u00e9s" },
            { "fj", "fixanu" },
            { "fo", "fero\u00e9s" },
            { "fr", "franc\u00e9s" },
            { "fy", "fris\u00f3n occidental" },
            { "ga", "irland\u00e9s" },
            { "gd", "ga\u00e9licu escoc\u00e9s" },
            { "gl", "gallegu" },
            { "gn", "guaran\u00ed" },
            { "gu", "guyarat\u00ed" },
            { "gv", "man\u00e9s" },
            { "ha", "\u1e25ausa" },
            { "he", metaValue_he },
            { "hi", "hindi" },
            { "ho", "hiri motu" },
            { "hr", "croata" },
            { "ht", "haitianu" },
            { "hu", "h\u00fangaru" },
            { "hy", metaValue_hy },
            { "hz", "herero" },
            { "ia", "interlingua" },
            { "id", "indonesiu" },
            { "ie", "interlingue" },
            { "ig", "igbo" },
            { "ii", "yi de Sichu\u00e1n" },
            { "ik", "inupiaq" },
            { "io", "ido" },
            { "is", "island\u00e9s" },
            { "it", "italianu" },
            { "iu", "inuktitut" },
            { "ja", metaValue_ja },
            { "jv", metaValue_jv },
            { "ka", metaValue_ka },
            { "kg", "kongo" },
            { "ki", "kikuyu" },
            { "kj", "kuanyama" },
            { "kk", "kazaquistan\u00edn" },
            { "kl", "kalaallisut" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "kanuri" },
            { "ks", "cachemir\u00e9s" },
            { "ku", "curdu" },
            { "kv", "komi" },
            { "kw", "c\u00f3rnicu" },
            { "ky", "kirguistan\u00edn" },
            { "la", metaValue_la },
            { "lb", "luxemburgu\u00e9s" },
            { "lg", "ganda" },
            { "li", "limburgu\u00e9s" },
            { "ln", "lingala" },
            { "lo", metaValue_lo },
            { "lt", "lituanu" },
            { "lu", "luba-katanga" },
            { "lv", "let\u00f3n" },
            { "mg", "malgaxe" },
            { "mh", "marshall\u00e9s" },
            { "mi", "maor\u00ed" },
            { "mk", "macedoniu" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "marathi" },
            { "ms", "malayu" },
            { "mt", "malt\u00e9s" },
            { "my", metaValue_my },
            { "na", "nauru" },
            { "nb", "noruegu Bokm\u00e5l" },
            { "nd", "ndebele del norte" },
            { "ne", "nepal\u00e9s" },
            { "ng", "ndonga" },
            { "nl", "neerland\u00e9s" },
            { "nn", "noruegu Nynorsk" },
            { "no", "noruegu" },
            { "nr", "ndebele del sur" },
            { "nv", "navajo" },
            { "ny", "nyanja" },
            { "oc", "occitanu" },
            { "oj", "ojibwa" },
            { "om", "oromo" },
            { "or", metaValue_or },
            { "os", "os\u00e9ticu" },
            { "pa", "punyab\u00ed" },
            { "pi", "pali" },
            { "pl", "polacu" },
            { "ps", "pashtu" },
            { "pt", "portugu\u00e9s" },
            { "qu", "quechua" },
            { "rm", "romanche" },
            { "rn", "rundi" },
            { "ro", "rumanu" },
            { "ru", "rusu" },
            { "rw", "kinyarwanda" },
            { "sa", "s\u00e1nscritu" },
            { "sc", "sardu" },
            { "sd", "sindhi" },
            { "se", "sami del norte" },
            { "sg", "sango" },
            { "sh", "serbo-croata" },
            { "si", metaValue_si },
            { "sk", "eslovacu" },
            { "sl", "eslovenu" },
            { "sm", "samoanu" },
            { "sn", "shona" },
            { "so", "somal\u00edn" },
            { "sq", "albanu" },
            { "sr", "serbiu" },
            { "ss", "swati" },
            { "st", "sotho del sur" },
            { "su", metaValue_su },
            { "sv", "suecu" },
            { "sw", "sua\u1e25ili" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "taxiquistan\u00edn" },
            { "th", metaValue_th },
            { "ti", "tigrinya" },
            { "tk", "turcomanu" },
            { "tl", metaValue_tl },
            { "tn", "tswana" },
            { "to", "tonganu" },
            { "tr", "turcu" },
            { "ts", "tsonga" },
            { "tt", "t\u00e1rtaru" },
            { "tw", "twi" },
            { "ty", "tahitianu" },
            { "ug", "uigur" },
            { "uk", "ucra\u00edn" },
            { "ur", "urdu" },
            { "uz", "uzbequistan\u00edn" },
            { "ve", "venda" },
            { "vi", "vietnam\u00edn" },
            { "vo", "volap\u00fck" },
            { "wa", "val\u00f3n" },
            { "wo", "wolof" },
            { "xh", "xhosa" },
            { "yi", "yiddish" },
            { "yo", "yoruba" },
            { "za", "zhuang" },
            { "zh", "chinu" },
            { "zu", "zul\u00fa" },
            { "ace", "achin\u00e9s" },
            { "ach", "acoli" },
            { "ada", "adangme" },
            { "ady", "adyghe" },
            { "aeb", "\u00e1rabe de T\u00fanez" },
            { "afh", "afrihili" },
            { "agq", "aghem" },
            { "ain", "ainu" },
            { "akk", "acadianu" },
            { "akz", "alabama" },
            { "ale", "aleut" },
            { "aln", "gheg d\u2019Albania" },
            { "alt", "altai del sur" },
            { "ang", "ingl\u00e9s antiguu" },
            { "anp", "angika" },
            { "arc", "aram\u00e9u" },
            { "arn", "mapuche" },
            { "aro", "araona" },
            { "arp", "arapaho" },
            { "arq", "\u00e1rabe d\u2019Arxelia" },
            { "arw", "arawak" },
            { "ary", "\u00e1rabe de Marruecos" },
            { "arz", "\u00e1rabe d\u2019Exiptu" },
            { "asa", "asu" },
            { "ase", "llingua de signos americana" },
            { "ast", "asturianu" },
            { "avk", "kotava" },
            { "awa", "awadhi" },
            { "bal", "baluchi" },
            { "ban", metaValue_ban },
            { "bar", "b\u00e1varu" },
            { "bas", "basaa" },
            { "bax", "bamun" },
            { "bbc", "batak toba" },
            { "bbj", "ghomala" },
            { "bej", "beja" },
            { "bem", "bemba" },
            { "bew", "betawi" },
            { "bez", "bena" },
            { "bfd", "bafut" },
            { "bfq", "badaga" },
            { "bgn", "balochi occidental" },
            { "bho", "bhojpuri" },
            { "bik", "bikol" },
            { "bin", "bini" },
            { "bjn", "banjar" },
            { "bkm", "kom" },
            { "bla", "siksika" },
            { "bpy", "bishnupriya" },
            { "bqi", "bakhtiari" },
            { "bra", "braj" },
            { "brh", "brahui" },
            { "brx", "bodo" },
            { "bss", "akoose" },
            { "bua", "buriat" },
            { "bug", "bugin\u00e9s" },
            { "bum", "bulu" },
            { "byn", "blin" },
            { "byv", "medumba" },
            { "cad", "caddo" },
            { "car", "caribe" },
            { "cay", "cayuga" },
            { "cch", "atsam" },
            { "ceb", "cebuanu" },
            { "cgg", "chiga" },
            { "chb", "chibcha" },
            { "chg", "chagatai" },
            { "chk", "chuuk\u00e9s" },
            { "chm", "mari" },
            { "chn", "x\u00edriga chinook" },
            { "cho", "choctaw" },
            { "chp", "chipewyanu" },
            { "chr", "cheroqui" },
            { "chy", "cheyenne" },
            { "ckb", "kurdu central" },
            { "cop", "c\u00f3pticu" },
            { "cps", "capiznon" },
            { "crh", "turcu de Crimea" },
            { "crs", "franc\u00e9s criollu seselwa" },
            { "csb", "kashubianu" },
            { "dak", "dakota" },
            { "dar", "dargwa" },
            { "dav", "taita" },
            { "del", "delaware" },
            { "den", "slave" },
            { "dgr", "dogrib" },
            { "din", "dinka" },
            { "dje", "zarma" },
            { "doi", "dogri" },
            { "dsb", "baxu sorbiu" },
            { "dtp", "dusun central" },
            { "dua", "duala" },
            { "dum", "neerland\u00e9s mediu" },
            { "dyo", "jola-fonyi" },
            { "dyu", "dyula" },
            { "dzg", "dazaga" },
            { "ebu", "emb\u00fa" },
            { "efi", "efik" },
            { "egl", "emilianu" },
            { "egy", "exipciu antiguu" },
            { "eka", "ekajuk" },
            { "elx", "elamita" },
            { "enm", "ingl\u00e9s mediu" },
            { "esu", "yupik central" },
            { "ewo", "ewondo" },
            { "ext", "estreme\u00f1u" },
            { "fan", "fang" },
            { "fat", "fanti" },
            { "fil", "filip\u00edn" },
            { "fit", "finland\u00e9s de Tornedalen" },
            { "fon", "fon" },
            { "frc", "franc\u00e9s cajun" },
            { "frm", "franc\u00e9s mediu" },
            { "fro", "franc\u00e9s antiguu" },
            { "frp", "arpitanu" },
            { "frr", "fris\u00f3n del norte" },
            { "frs", "fris\u00f3n oriental" },
            { "fur", "friulianu" },
            { "gaa", "ga" },
            { "gag", "gagauz" },
            { "gan", "chinu gan" },
            { "gay", "gayo" },
            { "gba", "gbaya" },
            { "gbz", "dari zoroastrianu" },
            { "gez", "geez" },
            { "gil", "gilbert\u00e9s" },
            { "glk", "gilaki" },
            { "gmh", "altualem\u00e1n mediu" },
            { "goh", "altualem\u00e1n antiguu" },
            { "gom", "goan konkani" },
            { "gon", "gondi" },
            { "gor", "gorontalo" },
            { "got", metaValue_got },
            { "grb", "grebo" },
            { "grc", "griegu antiguu" },
            { "gsw", "alem\u00e1n de Suiza" },
            { "guc", "wayuu" },
            { "gur", "frafra" },
            { "guz", "gusii" },
            { "gwi", "gwich\u02bcin" },
            { "hai", "haida" },
            { "hak", "chinu hakka" },
            { "haw", "hawaianu" },
            { "hif", "hindi de Fiji" },
            { "hil", "hiligaynon" },
            { "hit", "hitita" },
            { "hmn", "hmong" },
            { "hsb", "altu sorbiu" },
            { "hsn", "chinu xiang" },
            { "hup", "hupa" },
            { "iba", "iban" },
            { "ibb", "ibibio" },
            { "ilo", "iloko" },
            { "inh", "ingush" },
            { "izh", "ingrianu" },
            { "jam", "ingl\u00e9s criollu xamaicanu" },
            { "jbo", "lojban" },
            { "jgo", "ngomba" },
            { "jmc", "machame" },
            { "jpr", "xudeo-persa" },
            { "jrb", "xudeo-\u00e1rabe" },
            { "jut", "jutland\u00e9s" },
            { "kaa", "kara-kalpak" },
            { "kab", "kabile\u00f1u" },
            { "kac", "kachin" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "kaw", "kawi" },
            { "kbd", "kabardianu" },
            { "kbl", "kanembu" },
            { "kcg", "tyap" },
            { "kde", "makonde" },
            { "kea", "cabuverdianu" },
            { "ken", "kenyang" },
            { "kfo", "koro" },
            { "kgp", "kaingang" },
            { "kha", "khasi" },
            { "kho", "khotan\u00e9s" },
            { "khq", "koyra chiini" },
            { "khw", "khowar" },
            { "kiu", "kirmanjki" },
            { "kkj", "kako" },
            { "kln", "kalenjin" },
            { "kmb", "kimbundu" },
            { "koi", "komi-permyak" },
            { "kok", "konkani" },
            { "kos", "kosraeanu" },
            { "kpe", metaValue_kpe },
            { "krc", "karachay-balkar" },
            { "kri", "krio" },
            { "krj", "kinaray-a" },
            { "krl", "karelianu" },
            { "kru", "kurukh" },
            { "ksb", "shambala" },
            { "ksf", "bafia" },
            { "ksh", "colonianu" },
            { "kum", "kumyk" },
            { "kut", "kutenai" },
            { "lad", "ladino" },
            { "lag", "langi" },
            { "lah", "lahnda" },
            { "lam", "lamba" },
            { "lez", "lezghianu" },
            { "lfn", "lingua franca nova" },
            { "lij", "ligurianu" },
            { "liv", "livonianu" },
            { "lkt", "lakota" },
            { "lmo", "lombardu" },
            { "lol", "mongo" },
            { "loz", "lozi" },
            { "lrc", "luri del norte" },
            { "ltg", "latgalianu" },
            { "lua", "luba-lulua" },
            { "lui", "luiseno" },
            { "lun", "lunda" },
            { "luo", "luo" },
            { "lus", "mizo" },
            { "luy", "luyia" },
            { "lzh", "chinu lliterariu" },
            { "lzz", "laz" },
            { "mad", "madur\u00e9s" },
            { "maf", "mafa" },
            { "mag", "magahi" },
            { "mai", "maithili" },
            { "mak", "makasar" },
            { "man", "mandingo" },
            { "mas", "mas\u00e1i" },
            { "mde", "maba" },
            { "mdf", "moksha" },
            { "mdr", "mandar" },
            { "men", metaValue_men },
            { "mer", "meru" },
            { "mfe", "morisyen" },
            { "mga", "\u00edrland\u00e9s mediu" },
            { "mgh", "makhuwa-meetto" },
            { "mgo", "meta\u2019" },
            { "mic", "micmac" },
            { "min", "minangkabau" },
            { "mnc", "manch\u00fa" },
            { "mni", "manipuri" },
            { "moh", "mohawk" },
            { "mos", "mossi" },
            { "mrj", "mari occidental" },
            { "mua", "mundang" },
            { "mul", "m\u00faltiples lling\u00fces" },
            { "mus", "creek" },
            { "mwl", "mirand\u00e9s" },
            { "mwr", "marwari" },
            { "mwv", "mentawai" },
            { "mye", "myene" },
            { "myv", "erzya" },
            { "mzn", "mazanderani" },
            { "nan", "chinu min nan" },
            { "nap", "napolitanu" },
            { "naq", "nama" },
            { "nds", "baxu alem\u00e1n" },
            { "new", "newari" },
            { "nia", "nias" },
            { "niu", "niueanu" },
            { "njo", "ao naga" },
            { "nmg", "kwasio" },
            { "nnh", "ngiemboon" },
            { "nog", "nogai" },
            { "non", "noruegu antiguu" },
            { "nov", "novial" },
            { "nqo", metaValue_nqo },
            { "nso", "sotho del norte" },
            { "nus", "nuer" },
            { "nwc", "newari cl\u00e1sicu" },
            { "nym", "nyamwezi" },
            { "nyn", "nyankole" },
            { "nyo", "nyoro" },
            { "nzi", "nzima" },
            { "osa", "osage" },
            { "ota", "turcu otomanu" },
            { "pag", "pangasinan" },
            { "pal", "pahlavi" },
            { "pam", "pampanga" },
            { "pap", "papiamento" },
            { "pau", "palauanu" },
            { "pcd", "p\u00edcaru" },
            { "pcm", "nixerianu simplific\u00e1u" },
            { "pdc", "alem\u00e1n de Pennsylvania" },
            { "pdt", "plautdietsch" },
            { "peo", metaValue_peo },
            { "pfl", "alem\u00e1n palatinu" },
            { "phn", metaValue_phn },
            { "pms", "piamont\u00e9s" },
            { "pnt", "p\u00f3nticu" },
            { "pon", "pohnpeianu" },
            { "prg", "prusianu" },
            { "pro", "provenzal antiguu" },
            { "quc", "k\u02bciche\u02bc" },
            { "qug", "quichua del altiplanu de Chimborazo" },
            { "raj", "rajasthan\u00edn" },
            { "rap", "rapanui" },
            { "rar", "rarotonganu" },
            { "rgn", "roma\u00f1ol" },
            { "rif", "rifianu" },
            { "rof", "rombo" },
            { "rom", "roman\u00ed" },
            { "rtm", "rotumanu" },
            { "rue", "rusyn" },
            { "rug", "roviana" },
            { "rup", "aromanianu" },
            { "rwk", "rwa" },
            { "sad", "sandav\u00e9s" },
            { "sah", "sakha" },
            { "sam", "aram\u00e9u samaritanu" },
            { "saq", "samburu" },
            { "sas", "sasak" },
            { "sat", "santali" },
            { "saz", metaValue_saz },
            { "sba", "ngambay" },
            { "sbp", "sangu" },
            { "scn", "sicilianu" },
            { "sco", "scots" },
            { "sdc", "sardu sassar\u00e9s" },
            { "sdh", "kurdu del sur" },
            { "see", "s\u00e9neca" },
            { "seh", "sena" },
            { "sei", "seri" },
            { "sel", "selkup" },
            { "ses", "koyraboro senni" },
            { "sga", "irland\u00e9s antiguu" },
            { "sgs", "samogitianu" },
            { "shi", "tachelhit" },
            { "shn", "shan" },
            { "shu", "\u00e1rabe chadianu" },
            { "sid", "sidamo" },
            { "sli", "baxu silesianu" },
            { "sly", "selayar\u00e9s" },
            { "sma", "sami del sur" },
            { "smj", "lule sami" },
            { "smn", "inari sami" },
            { "sms", "skolt sami" },
            { "snk", "soninke" },
            { "sog", "sogdianu" },
            { "srn", "sranan tongo" },
            { "srr", "serer" },
            { "ssy", metaValue_ssy },
            { "stq", "fris\u00f3n de Saterland" },
            { "suk", "sukuma" },
            { "sus", "susu" },
            { "sux", "sumeriu" },
            { "swb", "comorianu" },
            { "syc", "siriacu cl\u00e1sicu" },
            { "syr", metaValue_syr },
            { "szl", "silesianu" },
            { "tcy", "tulu" },
            { "tem", "timne" },
            { "teo", "teso" },
            { "ter", "terena" },
            { "tet", "tetum" },
            { "tig", "tigre" },
            { "tiv", "tiv" },
            { "tkl", "tokelau" },
            { "tkr", "tsakhur" },
            { "tlh", "klingon" },
            { "tli", "tlingit" },
            { "tly", "talix\u00edn" },
            { "tmh", "tamashek" },
            { "tog", "tonga nyasa" },
            { "tpi", "tok pisin" },
            { "tru", "turoyo" },
            { "trv", "taroko" },
            { "tsd", "tsakoniu" },
            { "tsi", "tsimshian" },
            { "ttt", "tati musulm\u00e1n" },
            { "tum", "tumbuka" },
            { "tvl", "tuvalu" },
            { "twq", "tasawaq" },
            { "tyv", "tuvinianu" },
            { "tzm", "tamazight del Atles central" },
            { "udm", "udmurt" },
            { "uga", metaValue_uga },
            { "umb", "umbundu" },
            { "und", "llingua desconocida" },
            { "vai", metaValue_vai },
            { "vec", "venecianu" },
            { "vep", "vepsiu" },
            { "vls", "flamencu occidental" },
            { "vmf", "franconianu del Main" },
            { "vot", "v\u00f3ticu" },
            { "vro", "voro" },
            { "vun", "vunjo" },
            { "wae", "walser" },
            { "wal", "wolaytta" },
            { "war", "waray" },
            { "was", "washo" },
            { "wbp", "warlpiri" },
            { "wuu", "chinu wu" },
            { "xal", "calmuco" },
            { "xmf", "mingrelianu" },
            { "xog", "soga" },
            { "yao", "yao" },
            { "yap", "yap\u00e9s" },
            { "yav", "yangben" },
            { "ybb", "yemba" },
            { "yrl", "nheengatu" },
            { "yue", "canton\u00e9s" },
            { "zap", "zapoteca" },
            { "zbl", "simb\u00f3licu Bliss" },
            { "zea", "zeeland\u00e9s" },
            { "zen", "zenaga" },
            { "zgh", "tamazight est\u00e1ndar de Marruecos" },
            { "zun", "zuni" },
            { "zxx", "ensin conten\u00edu lling\u00fc\u00edsticu" },
            { "zza", "zaza" },
            { "Adlm", "adlm" },
            { "Afak", "afaka" },
            { "Aghb", "c\u00e1ucaso-alban\u00e9s" },
            { "Ahom", "ahom" },
            { "Arab", metaValue_ar },
            { "Armi", "aramaicu imperial" },
            { "Armn", metaValue_hy },
            { "Avst", "av\u00e9sticu" },
            { "Bali", metaValue_ban },
            { "Bamu", "bamum" },
            { "Bass", "bassa vah" },
            { "Batk", "batak" },
            { "Beng", metaValue_bn },
            { "Bhks", "bhks" },
            { "Blis", "s\u00edmbolos de Bliss" },
            { "Bopo", "bopomofo" },
            { "Brah", "brahmi" },
            { "Brai", "braille" },
            { "Bugi", "lontara" },
            { "Buhd", "buhid" },
            { "Cakm", "chakma" },
            { "Cans", "sil\u00e1bicu unific\u00e1u de los nativos canadienses" },
            { "Cari", "cariu" },
            { "Cham", "cham" },
            { "Cher", "cheroki" },
            { "Cirt", "cirth" },
            { "Copt", "coptu" },
            { "Cprt", "xipriota" },
            { "Cyrl", "cir\u00edlicu" },
            { "Cyrs", "eslav\u00f3nicu cir\u00edlicu eclesi\u00e1sticu antiguu" },
            { "Deva", "devanagari" },
            { "Dsrt", "alfabetu Deseret" },
            { "Dupl", "taquigraf\u00eda Duploy\u00e9" },
            { "Egyd", "dem\u00f3ticu exipcianu" },
            { "Egyh", "hier\u00e1ticu exipcianu" },
            { "Egyp", "xerogl\u00edficos exipcianos" },
            { "Elba", "elbasan" },
            { "Ethi", "et\u00edope" },
            { "Geok", "khutsuri xeorxanu" },
            { "Geor", metaValue_ka },
            { "Glag", "glagol\u00edticu" },
            { "Goth", metaValue_got },
            { "Gran", "grantha" },
            { "Grek", metaValue_el },
            { "Gujr", "guyarati" },
            { "Guru", "gurmukhi" },
            { "Hanb", "hanb" },
            { "Hang", "hangul" },
            { "Hani", "han" },
            { "Hano", "hanun\u00f3\u2019o" },
            { "Hans", "simplific\u00e1u" },
            { "Hant", "tradicional" },
            { "Hatr", "hatranu" },
            { "Hebr", metaValue_he },
            { "Hira", "\u1e25iragana" },
            { "Hluw", "xerogl\u00edficos anatolios" },
            { "Hmng", "pahawh hmong" },
            { "Hrkt", "silabarios xaponeses" },
            { "Hung", "h\u00fangaru antiguu" },
            { "Inds", "indus" },
            { "Ital", "it\u00e1licu antiguu" },
            { "Jamo", "jamo" },
            { "Java", metaValue_jv },
            { "Jpan", metaValue_ja },
            { "Jurc", "jurchen" },
            { "Kali", "kayah li" },
            { "Kana", "katakana" },
            { "Khar", "kharoshthi" },
            { "Khmr", metaValue_km },
            { "Khoj", "khojki" },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Kpel", metaValue_kpe },
            { "Kthi", "kaithi" },
            { "Lana", "lanna" },
            { "Laoo", metaValue_lo },
            { "Latf", "fraktur llat\u00edn" },
            { "Latg", "ga\u00e9licu llat\u00edn" },
            { "Latn", metaValue_la },
            { "Lepc", "lepcha" },
            { "Limb", "limbu" },
            { "Lina", "llinial A" },
            { "Linb", "llinial B" },
            { "Lisu", "alfabetu de Fraser" },
            { "Loma", "loma" },
            { "Lyci", "liciu" },
            { "Lydi", "lidiu" },
            { "Mahj", "mahajani" },
            { "Mand", "mand\u00e9u" },
            { "Mani", "maniqu\u00e9u" },
            { "Marc", "marc" },
            { "Maya", "xerogl\u00edficos mayes" },
            { "Mend", metaValue_men },
            { "Merc", "mero\u00edticu en cursiva" },
            { "Mero", "mero\u00edticu" },
            { "Mlym", metaValue_ml },
            { "Modi", "modi" },
            { "Mong", metaValue_mn },
            { "Moon", "tipos Moon" },
            { "Mroo", "mro" },
            { "Mtei", "meitei mayek" },
            { "Mult", "multani" },
            { "Mymr", metaValue_my },
            { "Narb", "\u00e1rabe del norte antiguu" },
            { "Nbat", "nabat\u00e9u" },
            { "Newa", "newa" },
            { "Nkgb", "geba del naxi" },
            { "Nkoo", metaValue_nqo },
            { "Nshu", "n\u00fcshu" },
            { "Ogam", "ogham" },
            { "Olck", "ol chiki" },
            { "Orkh", "orkhon" },
            { "Orya", metaValue_or },
            { "Osge", "osge" },
            { "Osma", "osmanya" },
            { "Palm", "palmirenu" },
            { "Pauc", "pau cin hau" },
            { "Perm", "p\u00e9rmicu antiguu" },
            { "Phag", "escritura \u2018Phags-pa" },
            { "Phli", "pahlavi d\u2019inscripciones" },
            { "Phlp", "pahlavi de salteriu" },
            { "Phlv", "pahlavi de llibros" },
            { "Phnx", metaValue_phn },
            { "Plrd", "fon\u00e9ticu de Pollard" },
            { "Prti", "partu d\u2019inscripciones" },
            { "Rjng", "rejang" },
            { "Roro", "rongorongo" },
            { "Runr", "runes" },
            { "Samr", "samaritanu" },
            { "Sara", "sarati" },
            { "Sarb", "\u00e1rabe del sur antiguu" },
            { "Saur", metaValue_saz },
            { "Sgnw", "escritura de signos" },
            { "Shaw", "shavianu" },
            { "Shrd", "sharada" },
            { "Sidd", "siddham" },
            { "Sind", "khudabadi" },
            { "Sinh", metaValue_si },
            { "Sora", "sora sompeng" },
            { "Sund", metaValue_su },
            { "Sylo", "syloti nagri" },
            { "Syrc", metaValue_syr },
            { "Syre", "siriacu estrangelo" },
            { "Syrj", "siriacu occidental" },
            { "Syrn", "siriacu oriental" },
            { "Tagb", "tagbanwa" },
            { "Takr", "takri" },
            { "Tale", "tai le" },
            { "Talu", "tai lue nuevu" },
            { "Taml", metaValue_ta },
            { "Tang", "tangut" },
            { "Tavt", "tai viet" },
            { "Telu", metaValue_te },
            { "Teng", "tengwar" },
            { "Tfng", "tifinagh" },
            { "Tglg", metaValue_tl },
            { "Thaa", "thaana" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Tirh", "tirhuta" },
            { "Ugar", metaValue_uga },
            { "Vaii", metaValue_vai },
            { "Visp", "fala visible" },
            { "Wara", "varang kshiti" },
            { "Wole", "woleai" },
            { "Xpeo", metaValue_peo },
            { "Xsux", "cuneiforme sumeriu acadiu" },
            { "Yiii", "yi" },
            { "Zinh", "hered\u00e1u" },
            { "Zmth", "escritura matem\u00e1tica" },
            { "Zsye", "emoji" },
            { "Zsym", "s\u00edmbolos" },
            { "Zxxx", "non escritu" },
            { "Zyyy", "com\u00fan" },
            { "Zzzz", "escritura desconocida" },
            { "de_AT", "alem\u00e1n d\u2019Austria" },
            { "de_CH", "altualem\u00e1n de Suiza" },
            { "en_AU", "ingl\u00e9s d\u2019Australia" },
            { "en_CA", "ingl\u00e9s de Canad\u00e1" },
            { "en_GB", "ingl\u00e9s de Gran Breta\u00f1a" },
            { "en_US", "ingl\u00e9s d\u2019Estaos Xun\u00edos" },
            { "es_ES", "espa\u00f1ol europ\u00e9u" },
            { "es_MX", "espa\u00f1ol de M\u00e9xicu" },
            { "fr_CA", "franc\u00e9s de Canad\u00e1" },
            { "fr_CH", "franc\u00e9s de Suiza" },
            { "nl_BE", "flamencu" },
            { "pt_BR", "portugu\u00e9s del Brasil" },
            { "pt_PT", "portugu\u00e9s europ\u00e9u" },
            { "ro_MD", "moldavu" },
            { "sw_CD", "sua\u1e25ili del Congu" },
            { "%%1901", "ortograf\u00eda alemana tradicional" },
            { "%%1994", "ortograf\u00eda resiana estandarizada" },
            { "%%1996", "ortograf\u00eda alemana de 1996" },
            { "ar_001", "\u00e1rabe est\u00e1ndar modernu" },
            { "es_419", "espa\u00f1ol d\u2019Am\u00e9rica Llatina" },
            { "key.ca", "calendariu" },
            { "key.cf", "formatu monetariu" },
            { "key.co", "orde de clasificaci\u00f3n" },
            { "key.cu", "moneda" },
            { "key.hc", "ciclu horariu (12 o 24)" },
            { "key.lb", "estilu de saltu de llinia" },
            { "key.ms", "sistema de midida" },
            { "key.nu", "n\u00famberos" },
            { "nds_NL", "baxu sax\u00f3n" },
            { "%%ALUKU", "dialectu aluku" },
            { "%%BARLA", "grupu dialectal barlavento del cabuverdianu" },
            { "%%BISKE", "dialectu San Giorgio/Bila" },
            { "%%BOONT", "boontling" },
            { "%%KKCOR", "ortograf\u00eda com\u00fan" },
            { "%%KSCOR", "ortograf\u00eda est\u00e1ndar" },
            { "%%LIPAW", "el dialectu lipovaz del resianu" },
            { "%%NEDIS", "dialectu natisone" },
            { "%%NJIVA", "dialectu gniva/njiva" },
            { "%%NULIK", "volap\u00fck modernu" },
            { "%%OSOJS", "dialectu oseacco/osojane" },
            { "%%POSIX", "ordenador" },
            { "%%RIGIK", "volap\u00fck cl\u00e1sicu" },
            { "%%ROZAJ", "resianu" },
            { "%%SAAHO", metaValue_ssy },
            { "%%SOLBA", "dialectu stolvizza/solbica" },
            { "%%SOTAV", "grupu dialectal sotavento del cabuverdianu" },
            { "%%UCCOR", "ortograf\u00eda unificada" },
            { "zh_Hans", "chinu simplific\u00e1u" },
            { "zh_Hant", "chinu tradicional" },
            { "%%AO1990", "alcuerdu ortogr\u00e1ficu de 1990 pa la llingua portuguesa" },
            { "%%DAJNKO", "alfabetu dajnko" },
            { "%%EKAVSK", "serbiu con pronunciaci\u00f3n ekaviana" },
            { "%%FONIPA", "fon\u00e9tica IPA" },
            { "%%FONUPA", "fon\u00e9tica UPA" },
            { "%%NDYUKA", "dialectu ndyuka" },
            { "%%PAMAKA", "dialectu pamaka" },
            { "%%PINYIN", "romanizaci\u00f3n pinyin" },
            { "%%SCOUSE", "scouse" },
            { "%%TARASK", "ortograf\u00eda taraskievica" },
            { "%%UCRCOR", "ortograf\u00eda unificada revisada" },
            { "%%UNIFON", "alfabetu fon\u00e9ticu Unifon" },
            { "%%ABL1943", "formulaci\u00f3n ortogr\u00e1fica de 1943" },
            { "%%ALALC97", "romanizacion ALA-LC, edicion de 1997" },
            { "%%AREVELA", "armeniu oriental" },
            { "%%AREVMDA", "armeniu occidental" },
            { "%%BALANKA", "dialectu balanka del anii" },
            { "%%BOHORIC", "alfabetu bohori\u010d" },
            { "%%EMODENG", "ingl\u00e9s modernu primitivu" },
            { "%%HEPBURN", "romanizaci\u00f3n de Hepburn" },
            { "%%METELKO", "alfabetu metelko" },
            { "%%MONOTON", "monot\u00f3nicu" },
            { "%%POLYTON", "polit\u00f3nicu" },
            { "%%REVISED", "ortograf\u00eda revisada" },
            { "%%1606NICT", "\u00faltimu franc\u00e9s mediu fasta 1606" },
            { "%%1694ACAD", "franc\u00e9s modernu primitivu" },
            { "%%1959ACAD", "acad\u00e9micu" },
            { "%%BAKU1926", "alfabetu turcu llatino unific\u00e1u" },
            { "%%COLB1945", "convenci\u00f3n ortogr\u00e1fica brasilanu-portuguesa de 1945" },
            { "%%IJEKAVSK", "serbiu con pronunciaci\u00f3n Ijekaviana" },
            { "%%OXENDICT", "ortograf\u00eda del diccionariu d\u2019ingl\u00e9s d\u2019Oxford" },
            { "%%SCOTLAND", "ingl\u00e9s est\u00e1ndar escoc\u00e9s" },
            { "%%VALENCIA", "valencianu" },
            { "%%WADEGILE", "romanizaci\u00f3n de Wade-Giles" },
            { "type.ca.roc", "calendariu de la Rep\u00fablica de China" },
            { "type.co.eor", "regles d\u2019ordenamientu europees" },
            { "type.hc.h11", "sistema de 12 hores (0\u201311)" },
            { "type.hc.h12", "sistema de 12 hores (1\u201312)" },
            { "type.hc.h23", "sistema de 24 hores (0\u201323)" },
            { "type.hc.h24", "sistema de 24 hores (1\u201324)" },
            { "type.nu.ahom", "n\u00famberos ahom" },
            { "type.nu.arab", "n\u00famberos ar\u00e1bico-\u00edndicos" },
            { "type.nu.armn", "n\u00famberos armenios" },
            { "type.nu.bali", "n\u00famberos balineses" },
            { "type.nu.beng", "n\u00famberos bengalinos" },
            { "type.nu.brah", "n\u00famberos brahmi" },
            { "type.nu.cakm", "n\u00famberos chakma" },
            { "type.nu.cham", "n\u00famberos cham" },
            { "type.nu.cyrl", "n\u00famberos cir\u00edlicos" },
            { "type.nu.deva", "n\u00famberos devanagari" },
            { "type.nu.ethi", "n\u00famberos et\u00edopes" },
            { "type.nu.geor", "n\u00famberos xeorxanos" },
            { "type.nu.grek", "n\u00famberos griegos" },
            { "type.nu.gujr", "n\u00famberos gujarati" },
            { "type.nu.guru", "n\u00famberos gurmukhi" },
            { "type.nu.hans", "n\u00famberos chinos simplificaos" },
            { "type.nu.hant", "n\u00famberos chinos tradicionales" },
            { "type.nu.hebr", "n\u00famberos hebreos" },
            { "type.nu.hmng", "n\u00famberos Pahawh Hmong" },
            { "type.nu.java", "n\u00famberos xavanesos" },
            { "type.nu.jpan", "n\u00famberos xaponeses" },
            { "type.nu.kali", "n\u00famberos Kayah Li" },
            { "type.nu.khmr", "numberaci\u00f3n khmer" },
            { "type.nu.knda", "numberaci\u00f3n kannada" },
            { "type.nu.lana", "numberaci\u00f3n Tai Tham Hora" },
            { "type.nu.laoo", "n\u00famberos laosianos" },
            { "type.nu.latn", "n\u00famberos occidentales" },
            { "type.nu.lepc", "n\u00famberos lepcha" },
            { "type.nu.limb", "n\u00famberos limbu" },
            { "type.nu.mlym", "n\u00famberos malayalam" },
            { "type.nu.modi", "n\u00famberos modi" },
            { "type.nu.mong", "n\u00famberos mongoles" },
            { "type.nu.mroo", "n\u00famberos mro" },
            { "type.nu.mtei", "n\u00famberos Meetei Mayek" },
            { "type.nu.mymr", "n\u00famberos de Myanmar" },
            { "type.nu.nkoo", "n\u00famberos N\u2019Ko" },
            { "type.nu.olck", "n\u00famberos Ol Chiki" },
            { "type.nu.orya", "n\u00famberos odia" },
            { "type.nu.osma", "n\u00famberos osmanya" },
            { "type.nu.saur", "n\u00famberos saurashtra" },
            { "type.nu.shrd", "n\u00famberos sharada" },
            { "type.nu.sind", "n\u00famberos Khudawadi" },
            { "type.nu.sinh", "n\u00famberos Lith cingaleses" },
            { "type.nu.sora", "n\u00famberos Sora Sompeng" },
            { "type.nu.sund", "n\u00famberos sondaneses" },
            { "type.nu.takr", "n\u00famberos takri" },
            { "type.nu.talu", "numberaci\u00f3n Tai Lue nueva" },
            { "type.nu.taml", "n\u00famberos tamil tradicionales" },
            { "type.nu.telu", "n\u00famberos telugu" },
            { "type.nu.thai", "n\u00famberos tailandeses" },
            { "type.nu.tibt", "n\u00famberos tibetanos" },
            { "type.nu.tirh", "n\u00famberos tirhuta" },
            { "type.nu.vaii", "n\u00famberos vai" },
            { "type.nu.wara", "n\u00famberos Warang Citi" },
            { "type.ca.dangi", "calendariu dangi" },
            { "type.co.ducet", "orde de clasificaci\u00f3n Unicode predetermin\u00e1u" },
            { "type.co.emoji", "orde de clasificaci\u00f3n Emoji" },
            { "type.lb.loose", "saltu de llinia relax\u00e1u" },
            { "type.nu.roman", "n\u00famberos romanos" },
            { "type.ca.coptic", "calendariu coptu" },
            { "type.ca.hebrew", "calendariu hebr\u00e9u" },
            { "type.ca.indian", "calendariu nacional indiu" },
            { "type.co.compat", "orde de clasificaci\u00f3n anterior, por compatibilid\u00e1" },
            { "type.co.pinyin", "orde de clasificaci\u00f3n pinyin" },
            { "type.co.search", "gueta xeneral" },
            { "type.co.stroke", "orde de clasificaci\u00f3n pol trazu" },
            { "type.co.unihan", "orde de clasificaci\u00f3n por radical y trazu" },
            { "type.co.zhuyin", "orde de clasificaci\u00f3n zhuyin" },
            { "type.lb.normal", "saltu de llinia normal" },
            { "type.lb.strict", "saltu de llinia estrictu" },
            { "type.ms.metric", "sistema m\u00e9tricu" },
            { "type.ca.chinese", "calendariu chinu" },
            { "type.ca.islamic", "calendariu isl\u00e1micu" },
            { "type.ca.iso8601", "calendariu ISO-8601" },
            { "type.ca.persian", "calendariu persa" },
            { "type.cf.account", "formatu monetariu contable" },
            { "type.co.big5han", "orde de clasificaci\u00f3n chinu tradicional - Big5" },
            { "type.nu.arabext", "n\u00famberos ar\u00e1bico-\u00edndicos estend\u00edos" },
            { "type.nu.armnlow", "n\u00famberos armenios en min\u00fascules" },
            { "type.nu.greklow", "n\u00famberos griegos en min\u00fascules" },
            { "type.nu.hanidec", "n\u00famberos decimales chinos" },
            { "type.nu.hansfin", "n\u00famberos chinos financieros simplificaos" },
            { "type.nu.hantfin", "n\u00famberos chinos financieros tradicionales" },
            { "type.nu.jpanfin", "n\u00famberos financieros xaponeses" },
            { "type.nu.mathdbl", "n\u00famberos matem\u00e1ticos con trazu doble" },
            { "type.nu.tamldec", "n\u00famberos tamil" },
            { "type.ca.buddhist", "calendariu budista" },
            { "type.ca.ethiopic", "calendariu et\u00edope" },
            { "type.ca.japanese", "calendariu xapon\u00e9s" },
            { "type.cf.standard", "formatu monetariu est\u00e1ndar" },
            { "type.co.reformed", "orde de clasificaci\u00f3n reform\u00e1u" },
            { "type.co.searchjl", "gueta por consonante Hangul d\u2019aniciu" },
            { "type.co.standard", "orde de clasificaci\u00f3n est\u00e1ndar" },
            { "type.ms.uksystem", "sistema de midida imperial" },
            { "type.ms.ussystem", "sistema de midida d\u2019EE.XX." },
            { "type.nu.fullwide", "n\u00famberos n\u2019anchu completu" },
            { "type.nu.lanatham", "numberaci\u00f3n Tai Tham Tham" },
            { "type.nu.mathbold", "n\u00famberos matem\u00e1ticos en negrina" },
            { "type.nu.mathmono", "n\u00famberos matem\u00e1ticos monoespaciaos" },
            { "type.nu.mathsanb", "n\u00famberos matem\u00e1ticos Sans-Serif en negrina" },
            { "type.nu.mathsans", "n\u00famberos matem\u00e1ticos Sans-Serif" },
            { "type.nu.mymrshan", "n\u00famberos Shan de Myanmar" },
            { "type.nu.mymrtlng", "n\u00famberos Tai Laing de Myanmar" },
            { "type.nu.romanlow", "n\u00famberos romanos en min\u00fascules" },
            { "type.ca.gregorian", "calendariu gregorianu" },
            { "type.co.gb2312han", "orde de clasificaci\u00f3n chinu simplific\u00e1u - GB2312" },
            { "type.co.phonebook", "orde de clasificaci\u00f3n de llista telef\u00f3nica" },
            { "type.co.dictionary", "orde de clasificaci\u00f3n de diccionariu" },
            { "type.co.traditional", "orde de clasificaci\u00f3n tradicional" },
            { "type.ca.islamic-rgsa", "calendariu isl\u00e1micu (Arabia Saudita, visual)" },
            { "type.ca.islamic-tbla", "calendariu isl\u00e1micu (tabular, \u00e9poca astron\u00f3mica)" },
            { "type.ca.islamic-civil", "calendariu isl\u00e1micu (tabular, \u00e9poca civil)" },
            { "type.ca.islamic-umalqura", "calendariu isl\u00e1micu (Umm al-Qura)" },
            { "type.ca.ethiopic-amete-alem", "calendariu et\u00edope Amete Alem" },
        };
        return data;
    }
}
