/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Shape;
import javax.accessibility.Accessible;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.tree.DefaultTreeCellRenderer;
import sun.tools.jconsole.inspector.XTree;

public class Utilities {
    private static final String windowsLaF = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";

    public static void updateTransparency(JComponent jComponent) {
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        boolean bl = lookAndFeel.getClass().getName().equals(windowsLaF);
        Utilities.setTabbedPaneTransparency(jComponent, bl);
    }

    private static void setTabbedPaneTransparency(JComponent jComponent, boolean bl) {
        for (Component component : jComponent.getComponents()) {
            if (jComponent instanceof JTabbedPane) {
                Utilities.setTransparency((JComponent)component, bl);
                continue;
            }
            if (!(component instanceof JComponent)) continue;
            Utilities.setTabbedPaneTransparency((JComponent)component, bl);
        }
    }

    private static void setTransparency(JComponent jComponent, boolean bl) {
        jComponent.setOpaque(!bl);
        for (Component component : jComponent.getComponents()) {
            if (component instanceof JPanel || component instanceof JSplitPane || component instanceof JScrollPane || component instanceof JViewport || component instanceof JCheckBox) {
                Utilities.setTransparency((JComponent)component, bl);
            }
            if (!(component instanceof XTree)) continue;
            XTree xTree = (XTree)component;
            DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)xTree.getCellRenderer();
            defaultTreeCellRenderer.setBackground(null);
            defaultTreeCellRenderer.setBackgroundNonSelectionColor(new Color(0, 0, 0, 1));
            xTree.setCellRenderer(defaultTreeCellRenderer);
            Utilities.setTransparency((JComponent)component, bl);
        }
    }

    public static JScrollPane newTableScrollPane(JComponent jComponent) {
        return new TableScrollPane(jComponent);
    }

    public static void setAccessibleName(Accessible accessible, String string) {
        accessible.getAccessibleContext().setAccessibleName(string);
    }

    public static void setAccessibleDescription(Accessible accessible, String string) {
        accessible.getAccessibleContext().setAccessibleDescription(string);
    }

    public static Color ensureContrast(Color color, Color color2) {
        double d;
        double d2 = Utilities.getColorBrightness(color);
        if (Math.abs(d2 - (d = Utilities.getColorBrightness(color2))) < 125.0) {
            color = d < 128.0 ? Utilities.setColorBrightness(color, d + 125.0) : Utilities.setColorBrightness(color, d - 125.0);
        }
        return color;
    }

    public static double getColorBrightness(Color color) {
        return (double)color.getRed() * 0.299 + (double)color.getGreen() * 0.587 + (double)color.getBlue() * 0.114;
    }

    private static Color setColorBrightness(Color color, double d) {
        double d2 = (double)color.getRed() * 0.596 - (double)color.getGreen() * 0.275 - (double)color.getBlue() * 0.321;
        double d3 = (double)color.getRed() * 0.212 - (double)color.getGreen() * 0.523 + (double)color.getBlue() * 0.311;
        int n = Math.max(0, Math.min(255, (int)Math.round(d + d2 * 0.956 + d3 * 0.621)));
        int n2 = Math.max(0, Math.min(255, (int)Math.round(d - d2 * 0.272 - d3 * 0.647)));
        int n3 = Math.max(0, Math.min(255, (int)Math.round(d - d2 * 1.105 + d3 * 1.702)));
        return new Color(n, n2, n3);
    }

    private static class TableScrollPane
    extends JScrollPane {
        public TableScrollPane(JComponent jComponent) {
            super(jComponent);
        }

        @Override
        protected void paintBorder(Graphics graphics) {
            Insets insets;
            Border border = this.getBorder();
            if (border != null && (insets = border.getBorderInsets(this)) != null) {
                Shape shape = graphics.getClip();
                graphics.clipRect(0, 0, this.getWidth(), insets.top);
                super.paintBorder(graphics);
                graphics.setClip(shape);
            }
        }
    }
}

