/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.model.classfile;

import org.jd.core.v1.model.classfile.constant.Constant;
import org.jd.core.v1.model.classfile.constant.ConstantClass;
import org.jd.core.v1.model.classfile.constant.ConstantString;
import org.jd.core.v1.model.classfile.constant.ConstantUtf8;
import org.jd.core.v1.model.classfile.constant.ConstantValue;

public class ConstantPool {
    protected Constant[] constants;

    public ConstantPool(Constant[] constants) {
        this.constants = constants;
    }

    public <T extends Constant> T getConstant(int index) {
        return (T)this.constants[index];
    }

    public String getConstantTypeName(int index) {
        ConstantClass cc = (ConstantClass)this.constants[index];
        ConstantUtf8 cutf8 = (ConstantUtf8)this.constants[cc.getNameIndex()];
        return cutf8.getValue();
    }

    public String getConstantString(int index) {
        ConstantString cString = (ConstantString)this.constants[index];
        ConstantUtf8 cutf8 = (ConstantUtf8)this.constants[cString.getStringIndex()];
        return cutf8.getValue();
    }

    public String getConstantUtf8(int index) {
        ConstantUtf8 cutf8 = (ConstantUtf8)this.constants[index];
        return cutf8.getValue();
    }

    public ConstantValue getConstantValue(int index) {
        Constant constant = this.constants[index];
        if (constant != null && constant.getTag() == 8) {
            constant = this.constants[((ConstantString)constant).getStringIndex()];
        }
        return (ConstantValue)constant;
    }

    public String toString() {
        return "ConstantPool";
    }
}

