/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cloudconfig;

import com.jetbrains.cloudconfig.AbstractCloudConfigFileClient;
import com.jetbrains.cloudconfig.Configuration;
import com.jetbrains.cloudconfig.ETagStorage;
import com.jetbrains.cloudconfig.MultiUploadRequest;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class CloudConfigFileClient
extends AbstractCloudConfigFileClient {
    private static final String LINE_FEED = "\r\n";

    public CloudConfigFileClient(String endpoint) {
        super(endpoint);
    }

    public CloudConfigFileClient(String endpoint, Configuration config, ETagStorage eTagStorage) {
        super(endpoint, config);
        this.eTagStorage = eTagStorage;
    }

    public InputStream read(String file) throws IOException {
        return this.read(file, null);
    }

    public void write(String file, InputStream content) throws IOException {
        this.write(file, content, null);
    }

    public OutputStream write(String file) throws IOException {
        final HttpURLConnection connection = this.config.openConnection(this.url(file, null));
        connection.setRequestProperty("Content-Type", "application/octet-stream");
        connection.setRequestMethod("PUT");
        connection.setDoOutput(true);
        OutputStream out = connection.getOutputStream();
        return new BufferedOutputStream(out){
            private final AtomicBoolean closed;
            {
                super(arg0);
                this.closed = new AtomicBoolean(false);
            }

            @Override
            public void close() throws IOException {
                if (this.closed.get() || !this.closed.compareAndSet(false, true)) {
                    return;
                }
                super.close();
                CloudConfigFileClient.this.assertSuccess(connection, 204);
            }
        };
    }

    public void write(String path, MultiUploadRequest request) throws IOException {
        if (request.getUploads().isEmpty()) {
            throw new IllegalArgumentException("Nothing to upload");
        }
        final String boundary = Long.toHexString(System.currentTimeMillis());
        this.upload("PUT", this.url(path, null), (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("Content-Type", "multipart/form-data; boundary=" + boundary);
            }
        }, out -> {
            PrintWriter writer = new PrintWriter(new OutputStreamWriter(out));
            for (Map.Entry<String, InputStream> entry : request.getUploads().entrySet()) {
                String name = entry.getKey();
                InputStream content = entry.getValue();
                writer.append("--").append(boundary).append(LINE_FEED);
                writer.append("Content-Disposition: form-data; name=\"").append(name).append("\"; filename=\"").append(name).append("\"").append(LINE_FEED);
                writer.append("Content-Type: application/octet-stream").append(LINE_FEED);
                writer.append("Content-Transfer-Encoding: binary").append(LINE_FEED);
                writer.append(LINE_FEED);
                writer.flush();
                this.drainStream(content, out);
                writer.append(LINE_FEED);
            }
            writer.append("--").append(boundary).append("--").append(LINE_FEED);
            writer.flush();
        }, (statusCode, headers, stream2) -> {
            Map etags = (Map)GSON.fromJson((Reader)new InputStreamReader(stream2), Map.class);
            for (Map.Entry entry : etags.entrySet()) {
                this.eTagStorage.store((String)entry.getKey(), (String)entry.getValue());
            }
            return null;
        }, 200);
    }

    public void delete(String file) throws IOException {
        this.delete(file, null);
    }

    public List<String> list(String file) throws IOException {
        return this.list(file, null);
    }
}

