/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.lang.properties.BundleNameEvaluator;
import com.intellij.lang.properties.PropertiesFileProcessor;
import com.intellij.lang.properties.PropertiesReferenceManager;
import com.intellij.lang.properties.ResourceBundleManager;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolvingHint;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceBundleReference
extends PsiReferenceBase<PsiElement>
implements PsiPolyVariantReference,
BundleNameEvaluator,
ResolvingHint {
    private static final Function<PropertiesFile, PsiElement> PROPERTIES_FILE_PSI_ELEMENT_FUNCTION = PropertiesFile::getContainingFile;
    private final String myBundleName = this.getValue().replace('/', '.');

    public ResourceBundleReference(PsiElement element) {
        this(element, false);
    }

    public ResourceBundleReference(PsiElement element, boolean soft) {
        super(element, soft);
    }

    public ResourceBundleReference(PsiElement element, TextRange textRange, boolean soft) {
        super(element, textRange, soft);
    }

    public boolean canResolveTo(Class<? extends PsiElement> elementClass) {
        return ReflectionUtil.isAssignable(PsiFile.class, elementClass);
    }

    @Nullable
    public PsiElement resolve() {
        ResolveResult[] resolveResults = this.multiResolve(false);
        return resolveResults.length == 1 ? resolveResults[0].getElement() : null;
    }

    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        PropertiesReferenceManager referenceManager = PropertiesReferenceManager.getInstance(this.myElement.getProject());
        List<PropertiesFile> propertiesFiles = referenceManager.findPropertiesFiles(this.myElement.getResolveScope(), this.myBundleName, this);
        ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults((Collection)ContainerUtil.map(propertiesFiles, PROPERTIES_FILE_PSI_ELEMENT_FUNCTION));
        if (resolveResultArray == null) {
            ResourceBundleReference.$$$reportNull$$$0(0);
        }
        return resolveResultArray;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myBundleName;
        if (string == null) {
            ResourceBundleReference.$$$reportNull$$$0(1);
        }
        return string;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        char packageDelimiter;
        String currentValue;
        int index;
        if (newElementName == null) {
            ResourceBundleReference.$$$reportNull$$$0(2);
        }
        if (((String)newElementName).endsWith(".properties")) {
            newElementName = ((String)newElementName).substring(0, ((String)newElementName).lastIndexOf(".properties"));
        }
        if ((index = (currentValue = this.getValue()).lastIndexOf(packageDelimiter = this.getPackageDelimiter())) != -1) {
            newElementName = currentValue.substring(0, index) + packageDelimiter + (String)newElementName;
        }
        return super.handleElementRename((String)newElementName);
    }

    private char getPackageDelimiter() {
        return this.getValue().indexOf(47) != -1 ? (char)'/' : '.';
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            ResourceBundleReference.$$$reportNull$$$0(3);
        }
        if (!(element instanceof PropertiesFile)) {
            throw new IncorrectOperationException();
        }
        String name = ResourceBundleManager.getInstance(element.getProject()).getFullName((PropertiesFile)element);
        return name != null ? super.handleElementRename(name) : element;
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        String name;
        if (element == null) {
            ResourceBundleReference.$$$reportNull$$$0(4);
        }
        return element instanceof PropertiesFile && (name = ResourceBundleManager.getInstance(element.getProject()).getFullName((PropertiesFile)element)) != null && name.equals(this.myBundleName);
    }

    public Object @NotNull [] getVariants() {
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)this.getElement().getProject());
        PropertiesReferenceManager referenceManager = PropertiesReferenceManager.getInstance(this.getElement().getProject());
        HashSet bundleNames = new HashSet();
        SmartList variants = new SmartList();
        PropertiesFileProcessor processor = (arg_0, arg_1) -> ResourceBundleReference.lambda$getVariants$0(bundleNames, projectFileIndex, (List)variants, arg_0, arg_1);
        referenceManager.processPropertiesFiles(this.myElement.getResolveScope(), processor, this);
        Object[] objectArray = variants.toArray(LookupElement.EMPTY_ARRAY);
        if (objectArray == null) {
            ResourceBundleReference.$$$reportNull$$$0(5);
        }
        return objectArray;
    }

    @Override
    public String evaluateBundleName(PsiFile psiFile) {
        return BundleNameEvaluator.DEFAULT.evaluateBundleName(psiFile);
    }

    private static /* synthetic */ boolean lambda$getVariants$0(Set bundleNames, ProjectFileIndex projectFileIndex, List variants, String baseName, PropertiesFile propertiesFile) {
        if (!bundleNames.add(baseName)) {
            return true;
        }
        LookupElementBuilder builder = LookupElementBuilder.create((String)baseName).withIcon(AllIcons.Nodes.ResourceBundle);
        boolean isInContent = projectFileIndex.isInContent(propertiesFile.getVirtualFile());
        variants.add(isInContent ? PrioritizedLookupElement.withPriority((LookupElement)builder, (double)Double.MAX_VALUE) : builder);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/properties/ResourceBundleReference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/properties/ResourceBundleReference";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

