/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import com.google.inject.util.Providers;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.codehaus.plexus.ComponentDescriptorBeanModule;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.MutablePlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.PlexusLifecycleManager;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.classworlds.realm.DuplicateRealmException;
import org.codehaus.plexus.classworlds.realm.NoSuchRealmException;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextMapAdapter;
import org.codehaus.plexus.context.DefaultContext;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.LoggerManager;
import org.codehaus.plexus.logging.console.ConsoleLoggerManager;
import org.sonatype.guice.bean.binders.MergedModule;
import org.sonatype.guice.bean.binders.ParameterKeys;
import org.sonatype.guice.bean.binders.WireModule;
import org.sonatype.guice.bean.locators.DefaultBeanLocator;
import org.sonatype.guice.bean.locators.EntryListAdapter;
import org.sonatype.guice.bean.locators.EntryMapAdapter;
import org.sonatype.guice.bean.locators.MutableBeanLocator;
import org.sonatype.guice.bean.reflect.DeferredClass;
import org.sonatype.guice.bean.reflect.DeferredProvider;
import org.sonatype.guice.bean.reflect.LoadedClass;
import org.sonatype.guice.bean.reflect.URLClassSpace;
import org.sonatype.guice.plexus.binders.PlexusAnnotatedBeanModule;
import org.sonatype.guice.plexus.binders.PlexusBeanManager;
import org.sonatype.guice.plexus.binders.PlexusBindingModule;
import org.sonatype.guice.plexus.binders.PlexusXmlBeanModule;
import org.sonatype.guice.plexus.config.Hints;
import org.sonatype.guice.plexus.config.PlexusBean;
import org.sonatype.guice.plexus.config.PlexusBeanConverter;
import org.sonatype.guice.plexus.config.PlexusBeanLocator;
import org.sonatype.guice.plexus.config.PlexusBeanModule;
import org.sonatype.guice.plexus.converters.PlexusDateTypeConverter;
import org.sonatype.guice.plexus.converters.PlexusXmlBeanConverter;
import org.sonatype.guice.plexus.locators.ClassRealmUtils;
import org.sonatype.guice.plexus.locators.DefaultPlexusBeanLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultPlexusContainer
implements MutablePlexusContainer {
    private static final String DEFAULT_REALM_NAME = "plexus.core";
    private static final LoggerManager CONSOLE_LOGGER_MANAGER;
    final Set<String> realmIds = new HashSet<String>();
    final Map<ClassRealm, List<ComponentDescriptor<?>>> descriptorMap = new ConcurrentHashMap();
    final ThreadLocal<ClassRealm> lookupRealm = new ThreadLocal();
    final MutableBeanLocator qualifiedBeanLocator = new DefaultBeanLocator();
    final Context context;
    final Map<String, String> variables;
    final ClassRealm containerRealm;
    final PlexusLifecycleManager lifecycleManager;
    final PlexusBeanLocator plexusBeanLocator;
    private final String componentVisibility;
    private final boolean isClassPathScanningEnabled;
    private final boolean isClassPathCachingEnabled;
    private final boolean isAutoWiringEnabled;
    private final Module setupModule = new SetupModule();
    private final Module loggerModule = new LoggerModule();
    private LoggerManager loggerManager = CONSOLE_LOGGER_MANAGER;
    private Logger logger;
    private boolean disposing;

    public DefaultPlexusContainer() throws PlexusContainerException {
        this(new DefaultContainerConfiguration());
    }

    public DefaultPlexusContainer(ContainerConfiguration configuration) throws PlexusContainerException {
        this(configuration, new Module[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultPlexusContainer(ContainerConfiguration configuration, Module ... customModules) throws PlexusContainerException {
        URL plexusXml = this.lookupPlexusXml(configuration);
        this.context = new DefaultContext(configuration.getContext());
        this.context.put("plexus", this);
        this.variables = new ContextMapAdapter(this.context);
        this.containerRealm = this.lookupContainerRealm(configuration);
        this.lifecycleManager = new PlexusLifecycleManager(this, this.context);
        this.componentVisibility = configuration.getComponentVisibility();
        this.isClassPathScanningEnabled = configuration.getClassPathScanning();
        this.isClassPathCachingEnabled = configuration.getClassPathCaching();
        this.isAutoWiringEnabled = configuration.getAutoWiring();
        this.plexusBeanLocator = new DefaultPlexusBeanLocator(this.qualifiedBeanLocator, this.componentVisibility);
        this.realmIds.add(this.containerRealm.getId());
        this.setLookupRealm(this.containerRealm);
        ArrayList<PlexusBeanModule> beanModules = new ArrayList<PlexusBeanModule>();
        URLClassSpace space = new URLClassSpace(this.containerRealm);
        beanModules.add(new PlexusXmlBeanModule(space, this.variables, plexusXml));
        if (this.isClassPathScanningEnabled) {
            beanModules.add(new PlexusAnnotatedBeanModule(space, this.variables, this.isClassPathCachingEnabled));
        } else {
            beanModules.add(new PlexusAnnotatedBeanModule(null, this.variables, false));
        }
        try {
            this.addPlexusInjector(beanModules, new BootModule(customModules));
        }
        catch (RuntimeException e) {
            try {
                this.dispose();
            }
            finally {
                throw e;
            }
        }
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public Object lookup(String role) throws ComponentLookupException {
        return this.lookup(role, "");
    }

    @Override
    public Object lookup(String role, String hint) throws ComponentLookupException {
        return this.lookup(null, role, hint);
    }

    @Override
    public <T> T lookup(Class<T> role) throws ComponentLookupException {
        return this.lookup(role, "");
    }

    @Override
    public <T> T lookup(Class<T> role, String hint) throws ComponentLookupException {
        return this.lookup(role, null, hint);
    }

    @Override
    public <T> T lookup(Class<T> type, String role, String hint) throws ComponentLookupException {
        try {
            return (T)this.locate(role, type, hint).iterator().next().getValue();
        }
        catch (Throwable e) {
            throw new ComponentLookupException(e, null != role ? role : type.getName(), hint);
        }
    }

    @Override
    public List<Object> lookupList(String role) throws ComponentLookupException {
        return new EntryListAdapter(this.locate(role, null, new String[0]));
    }

    @Override
    public <T> List<T> lookupList(Class<T> role) throws ComponentLookupException {
        return new EntryListAdapter(this.locate(null, role, new String[0]));
    }

    @Override
    public Map<String, Object> lookupMap(String role) throws ComponentLookupException {
        return new EntryMapAdapter<String, Object>(this.locate(role, null, new String[0]));
    }

    @Override
    public <T> Map<String, T> lookupMap(Class<T> role) throws ComponentLookupException {
        return new EntryMapAdapter(this.locate(null, role, new String[0]));
    }

    @Override
    public boolean hasComponent(Class<?> role) {
        return this.hasComponent((Class)role, "");
    }

    public boolean hasComponent(Class role, String hint) {
        return this.hasComponent(role, (String)null, hint);
    }

    public boolean hasComponent(Class type, String role, String hint) {
        return this.hasPlexusBeans(this.locate(role, type, hint));
    }

    @Override
    public void addComponent(Object component, String role) {
        try {
            this.addComponent(component, component.getClass().getClassLoader().loadClass(role), "default");
        }
        catch (ClassNotFoundException e) {
            throw new TypeNotPresentException(role, e);
        }
    }

    @Override
    public <T> void addComponent(final T component, final Class<?> role, final String hint) {
        this.qualifiedBeanLocator.add(Guice.createInjector(new AbstractModule(){

            protected void configure() {
                if (Hints.isDefaultHint(hint)) {
                    this.bind(role).toInstance(component);
                } else {
                    this.bind(role).annotatedWith(Names.named(hint)).toInstance(component);
                }
            }
        }));
    }

    @Override
    public <T> void addComponentDescriptor(ComponentDescriptor<T> descriptor) {
        List<ComponentDescriptor<?>> descriptors;
        ClassRealm realm = descriptor.getRealm();
        if (null == realm) {
            realm = this.containerRealm;
            descriptor.setRealm(realm);
        }
        if (null == (descriptors = this.descriptorMap.get(realm))) {
            descriptors = new ArrayList();
            this.descriptorMap.put(realm, descriptors);
        }
        descriptors.add(descriptor);
        if (this.containerRealm == realm) {
            this.discoverComponents(this.containerRealm);
        }
    }

    @Override
    public ComponentDescriptor<?> getComponentDescriptor(String role, String hint) {
        return this.getComponentDescriptor(null, role, hint);
    }

    @Override
    public <T> ComponentDescriptor<T> getComponentDescriptor(Class<T> type, String role, String hint) {
        PlexusBean<T> bean;
        Iterator<PlexusBean<T>> i = this.locate(role, type, hint).iterator();
        if (i.hasNext() && (bean = i.next()).getImplementationClass() != null) {
            return this.newComponentDescriptor(role, bean);
        }
        return null;
    }

    public List getComponentDescriptorList(String role) {
        return this.getComponentDescriptorList(null, role);
    }

    @Override
    public <T> List<ComponentDescriptor<T>> getComponentDescriptorList(Class<T> type, String role) {
        ArrayList<ComponentDescriptor<T>> tempList = new ArrayList<ComponentDescriptor<T>>();
        for (PlexusBean<T> bean : this.locate(role, type, new String[0])) {
            tempList.add(this.newComponentDescriptor(role, bean));
        }
        return tempList;
    }

    public Map getComponentDescriptorMap(String role) {
        return this.getComponentDescriptorMap(null, role);
    }

    @Override
    public <T> Map<String, ComponentDescriptor<T>> getComponentDescriptorMap(Class<T> type, String role) {
        LinkedHashMap<String, ComponentDescriptor<T>> tempMap = new LinkedHashMap<String, ComponentDescriptor<T>>();
        for (PlexusBean<T> bean : this.locate(role, type, new String[0])) {
            tempMap.put((String)bean.getKey(), this.newComponentDescriptor(role, bean));
        }
        return tempMap;
    }

    @Override
    public List<ComponentDescriptor<?>> discoverComponents(ClassRealm realm) {
        try {
            ArrayList<PlexusBeanModule> beanModules = new ArrayList<PlexusBeanModule>();
            URLClassSpace space = new URLClassSpace(realm);
            List<ComponentDescriptor<?>> descriptors = this.descriptorMap.remove(realm);
            if (null != descriptors) {
                beanModules.add(new ComponentDescriptorBeanModule(space, descriptors));
            }
            if (this.realmIds.add(realm.getId())) {
                beanModules.add(new PlexusXmlBeanModule(space, this.variables));
                if (this.isClassPathScanningEnabled) {
                    beanModules.add(new PlexusAnnotatedBeanModule(space, this.variables, this.isClassPathCachingEnabled));
                }
            }
            if (!beanModules.isEmpty()) {
                this.addPlexusInjector(beanModules, new Module[0]);
            }
        }
        catch (Throwable e) {
            this.getLogger().warn(realm.toString(), e);
        }
        return null;
    }

    public void addPlexusInjector(List<PlexusBeanModule> beanModules, Module ... customModules) {
        ArrayList<Module> modules = new ArrayList<Module>();
        modules.add(this.setupModule);
        Collections.addAll(modules, customModules);
        modules.add(new PlexusBindingModule((PlexusBeanManager)this.lifecycleManager, beanModules));
        modules.add(this.loggerModule);
        Guice.createInjector(this.isAutoWiringEnabled ? new WireModule(modules) : new MergedModule(modules));
    }

    @Override
    public ClassWorld getClassWorld() {
        return this.containerRealm.getWorld();
    }

    @Override
    public ClassRealm getContainerRealm() {
        return this.containerRealm;
    }

    @Override
    public ClassRealm setLookupRealm(ClassRealm realm) {
        ClassRealm oldRealm = this.lookupRealm.get();
        this.lookupRealm.set(realm);
        return oldRealm;
    }

    @Override
    public ClassRealm getLookupRealm() {
        return this.lookupRealm.get();
    }

    @Override
    public ClassRealm createChildRealm(String id) {
        try {
            return this.containerRealm.createChildRealm(id);
        }
        catch (DuplicateRealmException e1) {
            try {
                return this.getClassWorld().getRealm(id);
            }
            catch (NoSuchRealmException e2) {
                return null;
            }
        }
    }

    @Override
    public synchronized LoggerManager getLoggerManager() {
        return this.loggerManager;
    }

    @Override
    @Inject(optional=true)
    public synchronized void setLoggerManager(LoggerManager loggerManager) {
        this.loggerManager = null != loggerManager ? loggerManager : CONSOLE_LOGGER_MANAGER;
        this.logger = null;
    }

    @Override
    public synchronized Logger getLogger() {
        if (null == this.logger) {
            this.logger = this.loggerManager.getLoggerForComponent(PlexusContainer.class.getName(), null);
        }
        return this.logger;
    }

    @Override
    public void release(Object component) {
        this.lifecycleManager.unmanage(component);
    }

    @Override
    public void releaseAll(Map<String, ?> components) {
        for (Object o : components.values()) {
            this.release(o);
        }
    }

    @Override
    public void releaseAll(List<?> components) {
        for (Object o : components) {
            this.release(o);
        }
    }

    @Override
    public void dispose() {
        this.disposing = true;
        this.lifecycleManager.unmanage();
        this.containerRealm.setParentRealm(null);
        this.qualifiedBeanLocator.clear();
    }

    private ClassRealm lookupContainerRealm(ContainerConfiguration configuration) throws PlexusContainerException {
        ClassRealm realm;
        block5: {
            realm = configuration.getRealm();
            if (null == realm) {
                ClassWorld world = configuration.getClassWorld();
                if (null == world) {
                    world = new ClassWorld(DEFAULT_REALM_NAME, Thread.currentThread().getContextClassLoader());
                }
                try {
                    realm = world.getRealm(DEFAULT_REALM_NAME);
                }
                catch (NoSuchRealmException e) {
                    Iterator realmIterator = world.getRealms().iterator();
                    if (!realmIterator.hasNext()) break block5;
                    realm = (ClassRealm)realmIterator.next();
                }
            }
        }
        if (null == realm) {
            throw new PlexusContainerException("Missing container class realm: plexus.core");
        }
        return realm;
    }

    private URL lookupPlexusXml(ContainerConfiguration configuration) {
        String configurationPath;
        URL url = configuration.getContainerConfigurationURL();
        if (null == url && null != (configurationPath = configuration.getContainerConfiguration())) {
            File file;
            int index;
            for (index = 0; index < configurationPath.length() && configurationPath.charAt(index) == '/'; ++index) {
            }
            url = this.getClass().getClassLoader().getResource(configurationPath.substring(index));
            if (null == url && (file = new File(configurationPath)).isFile()) {
                try {
                    url = file.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
            }
            if (null == url) {
                this.getLogger().debug("Missing container configuration: " + configurationPath);
            }
        }
        return url;
    }

    private <T> Iterable<PlexusBean<T>> locate(String role, Class<T> type, String ... hints) {
        if (this.disposing) {
            return Collections.EMPTY_LIST;
        }
        String[] canonicalHints = Hints.canonicalHints(hints);
        if (null == role || null != type && type.getName().equals(role)) {
            return this.plexusBeanLocator.locate(TypeLiteral.get(type), canonicalHints);
        }
        HashSet<Class> candidates = new HashSet<Class>();
        for (ClassRealm realm : this.getVisibleRealms()) {
            try {
                Iterable beans;
                Class clazz = realm.loadClass(role);
                if (!candidates.add(clazz) || !this.hasPlexusBeans(beans = this.plexusBeanLocator.locate(TypeLiteral.get(clazz), canonicalHints))) continue;
                return beans;
            }
            catch (Throwable e) {
            }
        }
        return Collections.EMPTY_LIST;
    }

    private Collection<ClassRealm> getVisibleRealms() {
        Set<String> visibleNames;
        Object[] realms = this.getClassWorld().getRealms().toArray();
        LinkedHashSet<ClassRealm> visibleRealms = new LinkedHashSet<ClassRealm>(realms.length);
        ClassRealm currentLookupRealm = this.getLookupRealm();
        if (null != currentLookupRealm) {
            visibleRealms.add(currentLookupRealm);
        }
        if ("realm".equals(this.componentVisibility) && !(visibleNames = ClassRealmUtils.visibleRealmNames(ClassRealmUtils.contextRealm())).isEmpty()) {
            for (int i = realms.length - 1; i >= 0; --i) {
                ClassRealm r = (ClassRealm)realms[i];
                if (!visibleNames.contains(r.toString())) continue;
                visibleRealms.add(r);
            }
            return visibleRealms;
        }
        for (int i = realms.length - 1; i >= 0; --i) {
            visibleRealms.add((ClassRealm)realms[i]);
        }
        return visibleRealms;
    }

    private <T> boolean hasPlexusBeans(Iterable<PlexusBean<T>> beans) {
        Iterator<PlexusBean<T>> i = beans.iterator();
        return i.hasNext() && i.next().getImplementationClass() != null;
    }

    private <T> ComponentDescriptor<T> newComponentDescriptor(String role, PlexusBean<T> bean) {
        ComponentDescriptor cd = new ComponentDescriptor();
        cd.setRole(role);
        cd.setRoleHint((String)bean.getKey());
        cd.setImplementationClass(bean.getImplementationClass());
        cd.setDescription(bean.getDescription());
        return cd;
    }

    static {
        System.setProperty("guice.disable.misplaced.annotation.check", "true");
        CONSOLE_LOGGER_MANAGER = new ConsoleLoggerManager();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class LoggerProvider
    implements DeferredProvider<Logger> {
        LoggerProvider() {
        }

        @Override
        public Logger get() {
            return DefaultPlexusContainer.this.getLogger();
        }

        @Override
        public DeferredClass<Logger> getImplementationClass() {
            return new LoadedClass<Logger>(this.get().getClass());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class LoggerManagerProvider
    implements DeferredProvider<LoggerManager> {
        LoggerManagerProvider() {
        }

        @Override
        public LoggerManager get() {
            return DefaultPlexusContainer.this.getLoggerManager();
        }

        @Override
        public DeferredClass<LoggerManager> getImplementationClass() {
            return new LoadedClass<LoggerManager>(this.get().getClass());
        }
    }

    final class LoggerModule
    extends AbstractModule {
        final LoggerManagerProvider loggerManagerProvider;
        final LoggerProvider loggerProvider;

        LoggerModule() {
            this.loggerManagerProvider = new LoggerManagerProvider();
            this.loggerProvider = new LoggerProvider();
        }

        protected void configure() {
            this.bind(LoggerManager.class).toProvider(this.loggerManagerProvider);
            this.bind(Logger.class).toProvider(this.loggerProvider);
        }
    }

    final class SetupModule
    extends AbstractModule {
        final PlexusDateTypeConverter dateConverter = new PlexusDateTypeConverter();
        final PlexusXmlBeanConverter beanConverter = new PlexusXmlBeanConverter();

        SetupModule() {
        }

        protected void configure() {
            this.bind(Context.class).toInstance(DefaultPlexusContainer.this.context);
            this.bind(ParameterKeys.PROPERTIES).toInstance(DefaultPlexusContainer.this.variables);
            this.install(this.dateConverter);
            this.bind(MutableBeanLocator.class).toInstance(DefaultPlexusContainer.this.qualifiedBeanLocator);
            this.bind(PlexusBeanConverter.class).toInstance(this.beanConverter);
            this.bind(PlexusBeanLocator.class).toInstance(DefaultPlexusContainer.this.plexusBeanLocator);
            this.bind(PlexusBeanManager.class).toInstance(DefaultPlexusContainer.this.lifecycleManager);
            this.bind(PlexusContainer.class).to(MutablePlexusContainer.class);
            this.bind(MutablePlexusContainer.class).to(DefaultPlexusContainer.class);
            this.bind(DefaultPlexusContainer.class).toProvider(Providers.of(DefaultPlexusContainer.this));
        }
    }

    final class BootModule
    extends AbstractModule {
        private final Module[] customBootModules;

        BootModule(Module[] customBootModules) {
            this.customBootModules = customBootModules;
        }

        protected void configure() {
            this.requestInjection(DefaultPlexusContainer.this);
            for (Module m : this.customBootModules) {
                this.install(m);
            }
        }
    }
}

