/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.js.ast;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsClassModel;
import org.jetbrains.kotlin.js.backend.ast.JsCompositeBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsImportedModule;
import org.jetbrains.kotlin.js.backend.ast.JsLocation;
import org.jetbrains.kotlin.js.backend.ast.JsLocationWithEmbeddedSource;
import org.jetbrains.kotlin.js.backend.ast.JsLocationWithSource;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameBinding;
import org.jetbrains.kotlin.js.backend.ast.JsProgram;
import org.jetbrains.kotlin.js.backend.ast.JsProgramFragment;
import org.jetbrains.kotlin.js.backend.ast.JsRootScope;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.protobuf.CodedInputStream;
import org.jetbrains.kotlin.protobuf.ProtocolStringList;
import org.jetbrains.kotlin.serialization.js.ast.JsAstDeserializerBase;
import org.jetbrains.kotlin.serialization.js.ast.JsAstProtoBuf;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0013H\u0002J\u0010\u0010\r\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0015H\u0002J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0014R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/serialization/js/ast/JsAstDeserializer;", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstDeserializerBase;", "program", "Lorg/jetbrains/kotlin/js/backend/ast/JsProgram;", "sourceRoots", "", "Ljava/io/File;", "<init>", "(Lorg/jetbrains/kotlin/js/backend/ast/JsProgram;Ljava/lang/Iterable;)V", "scope", "Lorg/jetbrains/kotlin/js/backend/ast/JsRootScope;", "getScope", "()Lorg/jetbrains/kotlin/js/backend/ast/JsRootScope;", "deserialize", "Lorg/jetbrains/kotlin/js/backend/ast/JsProgramFragment;", "input", "Ljava/io/InputStream;", "proto", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$Chunk;", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$Fragment;", "Lorg/jetbrains/kotlin/js/backend/ast/JsClassModel;", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$ClassModel;", "embedSources", "Lorg/jetbrains/kotlin/js/backend/ast/JsLocationWithSource;", "deserializedLocation", "Lorg/jetbrains/kotlin/js/backend/ast/JsLocation;", "file", "", "js.serializer"})
@SourceDebugExtension(value={"SMAP\nJsAstDeserializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsAstDeserializer.kt\norg/jetbrains/kotlin/serialization/js/ast/JsAstDeserializer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,127:1\n1#2:128\n1557#3:129\n1628#3,3:130\n1557#3:133\n1628#3,3:134\n1187#3,2:137\n1261#3,4:139\n1557#3:143\n1628#3,3:144\n1187#3,2:147\n1261#3,4:149\n1557#3:153\n1628#3,3:154\n1187#3,2:157\n1261#3,4:159\n1863#3,2:163\n1628#3,3:165\n1557#3:168\n1628#3,3:169\n295#3,2:172\n*S KotlinDebug\n*F\n+ 1 JsAstDeserializer.kt\norg/jetbrains/kotlin/serialization/js/ast/JsAstDeserializer\n*L\n40#1:129\n40#1:130,3\n53#1:133\n53#1:134,3\n61#1:137,2\n61#1:139,4\n75#1:143\n75#1:144,3\n79#1:147,2\n79#1:149,4\n81#1:153\n81#1:154,3\n82#1:157,2\n82#1:159,4\n100#1:163,2\n110#1:165,3\n119#1:168\n119#1:169,3\n120#1:172,2\n*E\n"})
public final class JsAstDeserializer
extends JsAstDeserializerBase {
    @NotNull
    private final Iterable<File> sourceRoots;
    @NotNull
    private final JsRootScope scope;

    public JsAstDeserializer(@NotNull JsProgram program, @NotNull Iterable<? extends File> sourceRoots) {
        Intrinsics.checkNotNullParameter((Object)program, (String)"program");
        Intrinsics.checkNotNullParameter(sourceRoots, (String)"sourceRoots");
        this.sourceRoots = sourceRoots;
        this.scope = new JsRootScope(program);
    }

    @Override
    @NotNull
    public JsRootScope getScope() {
        return this.scope;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final JsProgramFragment deserialize(@NotNull InputStream input) {
        void $this$deserialize_u24lambda_u240;
        CodedInputStream codedInputStream;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        CodedInputStream codedInputStream2 = codedInputStream = CodedInputStream.newInstance((InputStream)input);
        JsAstDeserializer jsAstDeserializer = this;
        boolean bl = false;
        $this$deserialize_u24lambda_u240.setRecursionLimit(4096);
        JsAstProtoBuf.Chunk chunk = JsAstProtoBuf.Chunk.parseFrom(codedInputStream);
        Intrinsics.checkNotNullExpressionValue((Object)chunk, (String)"parseFrom(...)");
        return jsAstDeserializer.deserialize(chunk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final JsProgramFragment deserialize(@NotNull JsAstProtoBuf.Chunk proto) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        Object object = this.getStringTable();
        ProtocolStringList protocolStringList = proto.getStringTable().getEntryList();
        Intrinsics.checkNotNullExpressionValue((Object)protocolStringList, (String)"getEntryList(...)");
        CollectionsKt.addAll((Collection)object, (Iterable)((Iterable)protocolStringList));
        object = this.getNameTable();
        List<JsAstProtoBuf.Name> list = proto.getNameTable().getEntryList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getEntryList(...)");
        CollectionsKt.addAll((Collection)object, (Iterable)list);
        object = this.getNameCache();
        Iterable $this$map$iv = this.getNameTable();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            JsAstProtoBuf.Name name = (JsAstProtoBuf.Name)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(null);
        }
        Iterable iterable2 = (List)destination$iv$iv;
        CollectionsKt.addAll((Collection)object, (Iterable)iterable2);
        try {
            JsAstProtoBuf.Fragment fragment = proto.getFragment();
            Intrinsics.checkNotNullExpressionValue((Object)fragment, (String)"getFragment(...)");
            object = this.deserialize(fragment);
            return object;
        }
        finally {
            this.getStringTable().clear();
            this.getNameTable().clear();
            this.getNameCache().clear();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final JsProgramFragment deserialize(JsAstProtoBuf.Fragment proto) {
        void $this$associateTo$iv$iv;
        void $this$mapTo$iv$iv;
        Object object;
        void $this$mapTo$iv$iv2;
        Object element$iv$iv2;
        void $this$associateTo$iv$iv2;
        Object object2;
        Object object3;
        void $this$mapTo$iv$iv3;
        JsScope jsScope = this.getScope();
        String string = proto.getPackageFqn();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPackageFqn(...)");
        JsProgramFragment fragment = new JsProgramFragment(jsScope, string);
        Map<JsName, JsClassModel> map = fragment.getImportedModules();
        List<JsAstProtoBuf.ImportedModule> list = proto.getImportedModuleList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getImportedModuleList(...)");
        Iterator<JsNameBinding> $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$map$iv), (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            JsExpression jsExpression;
            void importedModuleProto;
            object3 = (JsAstProtoBuf.ImportedModule)item$iv$iv;
            object2 = destination$iv$iv;
            boolean bl = false;
            String string2 = this.deserializeString(importedModuleProto.getExternalNameId());
            JsName jsName = this.deserializeName(importedModuleProto.getInternalNameId());
            if (importedModuleProto.hasPlainReference()) {
                JsAstProtoBuf.Expression expression2 = importedModuleProto.getPlainReference();
                Intrinsics.checkNotNullExpressionValue((Object)expression2, (String)"getPlainReference(...)");
                jsExpression = this.deserialize(expression2);
            } else {
                jsExpression = null;
            }
            object2.add(new JsImportedModule(string2, jsName, jsExpression, null, 8, null));
        }
        $this$map$iv = (List)destination$iv$iv;
        CollectionsKt.addAll((Collection)((Object)map), (Iterable)((Object)$this$map$iv));
        map = fragment.getImports();
        List<JsAstProtoBuf.Import> list2 = proto.getImportEntryList();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getImportEntryList(...)");
        Object $this$associate$iv = list2;
        boolean $i$f$associate = false;
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv2 : $this$associateTo$iv$iv2) {
            Map bl = destination$iv$iv2;
            JsAstProtoBuf.Import importProto = (JsAstProtoBuf.Import)element$iv$iv2;
            boolean bl2 = false;
            String string3 = this.deserializeString(importProto.getSignatureId());
            JsAstProtoBuf.Expression expression3 = importProto.getExpression();
            Intrinsics.checkNotNullExpressionValue((Object)expression3, (String)"getExpression(...)");
            importProto = TuplesKt.to((Object)string3, (Object)this.deserialize(expression3));
            bl.put(importProto.getFirst(), importProto.getSecond());
        }
        $this$associate$iv = destination$iv$iv2;
        map.putAll((Map<JsName, JsClassModel>)$this$associate$iv);
        if (proto.hasDeclarationBlock()) {
            List<JsStatement> list3 = fragment.getDeclarationBlock().getStatements();
            Intrinsics.checkNotNullExpressionValue(list3, (String)"getStatements(...)");
            map = list3;
            JsAstProtoBuf.CompositeBlock compositeBlock = proto.getDeclarationBlock();
            Intrinsics.checkNotNullExpressionValue((Object)compositeBlock, (String)"getDeclarationBlock(...)");
            List<JsStatement> list4 = this.deserializeCompositeBlock(compositeBlock).getStatements();
            Intrinsics.checkNotNullExpressionValue(list4, (String)"getStatements(...)");
            CollectionsKt.addAll((Collection)((Object)map), (Iterable)list4);
        }
        if (proto.hasInitializerBlock()) {
            List<JsStatement> list5 = fragment.getInitializerBlock().getStatements();
            Intrinsics.checkNotNullExpressionValue(list5, (String)"getStatements(...)");
            map = list5;
            JsAstProtoBuf.CompositeBlock compositeBlock = proto.getInitializerBlock();
            Intrinsics.checkNotNullExpressionValue((Object)compositeBlock, (String)"getInitializerBlock(...)");
            List<JsStatement> list6 = this.deserializeCompositeBlock(compositeBlock).getStatements();
            Intrinsics.checkNotNullExpressionValue(list6, (String)"getStatements(...)");
            CollectionsKt.addAll((Collection)((Object)map), (Iterable)list6);
        }
        if (proto.hasExportBlock()) {
            List<JsStatement> list7 = fragment.getExportBlock().getStatements();
            Intrinsics.checkNotNullExpressionValue(list7, (String)"getStatements(...)");
            map = list7;
            JsAstProtoBuf.CompositeBlock compositeBlock = proto.getExportBlock();
            Intrinsics.checkNotNullExpressionValue((Object)compositeBlock, (String)"getExportBlock(...)");
            List<JsStatement> list8 = this.deserializeCompositeBlock(compositeBlock).getStatements();
            Intrinsics.checkNotNullExpressionValue(list8, (String)"getStatements(...)");
            CollectionsKt.addAll((Collection)((Object)map), (Iterable)list8);
        }
        map = fragment.getNameBindings();
        List<JsAstProtoBuf.NameBinding> list9 = proto.getNameBindingList();
        Intrinsics.checkNotNullExpressionValue(list9, (String)"getNameBindingList(...)");
        $this$map$iv = list9;
        $i$f$map = false;
        Iterable capacity$iv22 = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$map$iv), (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void nameBindingProto;
            element$iv$iv2 = (JsAstProtoBuf.NameBinding)item$iv$iv;
            object2 = destination$iv$iv;
            boolean bl = false;
            object2.add(new JsNameBinding(this.deserializeString(nameBindingProto.getSignatureId()), this.deserializeName(nameBindingProto.getNameId())));
        }
        $this$map$iv = (List)destination$iv$iv;
        CollectionsKt.addAll((Collection)((Object)map), (Iterable)((Object)$this$map$iv));
        map = fragment.getClasses();
        List<JsAstProtoBuf.ClassModel> list10 = proto.getClassModelList();
        Intrinsics.checkNotNullExpressionValue(list10, (String)"getClassModelList(...)");
        $this$associate$iv = list10;
        $i$f$associate = false;
        int capacity$iv32 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        destination$iv$iv = new LinkedHashMap(capacity$iv32);
        $i$f$associateTo = false;
        for (Object element$iv$iv2 : $this$associateTo$iv$iv2) {
            Map bl = destination$iv$iv;
            JsAstProtoBuf.ClassModel clsProto = (JsAstProtoBuf.ClassModel)element$iv$iv2;
            boolean bl3 = false;
            Intrinsics.checkNotNull((Object)clsProto);
            JsClassModel it = this.deserialize(clsProto);
            boolean bl4 = false;
            object = TuplesKt.to((Object)it.getName(), (Object)it);
            bl.put(object.getFirst(), object.getSecond());
        }
        $this$associate$iv = destination$iv$iv;
        map.putAll((Map<JsName, JsClassModel>)$this$associate$iv);
        List<JsAstProtoBuf.Expression> list11 = proto.getModuleExpressionList();
        Intrinsics.checkNotNullExpressionValue(list11, (String)"getModuleExpressionList(...)");
        $this$map$iv = list11;
        $i$f$map = false;
        Iterable capacity$iv32 = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$map$iv), (int)10));
        $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            element$iv$iv2 = (JsAstProtoBuf.Expression)item$iv$iv;
            object2 = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            object2.add(this.deserialize((JsAstProtoBuf.Expression)it));
        }
        List moduleExpressions = (List)destination$iv$iv;
        $this$map$iv = fragment.getInlineModuleMap();
        List<JsAstProtoBuf.InlineModule> list12 = proto.getInlineModuleList();
        Intrinsics.checkNotNullExpressionValue(list12, (String)"getInlineModuleList(...)");
        Object $this$associate$iv2 = list12;
        boolean $i$f$associate2 = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv2, (int)10)), (int)16);
        Iterable $i$f$mapTo2 = $this$associate$iv2;
        Map destination$iv$iv3 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo2 = false;
        for (Object element$iv$iv3 : $this$associateTo$iv$iv) {
            object = destination$iv$iv3;
            JsAstProtoBuf.InlineModule inlineModuleProto = (JsAstProtoBuf.InlineModule)element$iv$iv3;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)this.deserializeString(inlineModuleProto.getSignatureId()), moduleExpressions.get(inlineModuleProto.getExpressionId()));
            object.put(pair.getFirst(), pair.getSecond());
        }
        $this$associate$iv2 = destination$iv$iv3;
        $this$map$iv.putAll($this$associate$iv2);
        for (JsNameBinding nameBinding : fragment.getNameBindings()) {
            if (!fragment.getImports().containsKey(nameBinding.getKey())) continue;
            MetadataProperties.setImported(nameBinding.getName(), true);
        }
        if (proto.hasTestsInvocation()) {
            JsAstProtoBuf.Statement statement = proto.getTestsInvocation();
            Intrinsics.checkNotNullExpressionValue((Object)statement, (String)"getTestsInvocation(...)");
            fragment.setTests(this.deserialize(statement));
        }
        if (proto.hasMainInvocation()) {
            JsAstProtoBuf.Statement statement = proto.getMainInvocation();
            Intrinsics.checkNotNullExpressionValue((Object)statement, (String)"getMainInvocation(...)");
            fragment.setMainFunction(this.deserialize(statement));
        }
        List<JsAstProtoBuf.InlinedLocalDeclarations> list13 = proto.getInlinedLocalDeclarationsList();
        Intrinsics.checkNotNullExpressionValue(list13, (String)"getInlinedLocalDeclarationsList(...)");
        Iterable $this$forEach$iv = list13;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JsAstProtoBuf.InlinedLocalDeclarations it = (JsAstProtoBuf.InlinedLocalDeclarations)element$iv;
            boolean bl = false;
            Map<String, JsCompositeBlock> map2 = fragment.getInlinedLocalDeclarations();
            object3 = this.deserializeString(it.getTag());
            JsAstProtoBuf.CompositeBlock compositeBlock = it.getBlock();
            Intrinsics.checkNotNullExpressionValue((Object)compositeBlock, (String)"getBlock(...)");
            JsCompositeBlock jsCompositeBlock = this.deserializeCompositeBlock(compositeBlock);
            map2.put((String)object3, jsCompositeBlock);
        }
        return fragment;
    }

    /*
     * WARNING - void declaration
     */
    private final JsClassModel deserialize(JsAstProtoBuf.ClassModel proto) {
        void $this$mapTo$iv;
        JsClassModel jsClassModel;
        JsName superName = proto.hasSuperNameId() ? this.deserializeName(proto.getSuperNameId()) : null;
        JsClassModel $this$deserialize_u24lambda_u2411 = jsClassModel = new JsClassModel(this.deserializeName(proto.getNameId()), superName);
        boolean bl = false;
        List<Integer> list = proto.getInterfaceNameIdList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getInterfaceNameIdList(...)");
        Iterable iterable = list;
        Collection destination$iv = $this$deserialize_u24lambda_u2411.getInterfaces();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            Integer n = (Integer)item$iv;
            Collection collection = destination$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(this.deserializeName(it.intValue()));
        }
        if (proto.hasPostDeclarationBlock()) {
            List<JsStatement> list2 = $this$deserialize_u24lambda_u2411.getPostDeclarationBlock().getStatements();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getStatements(...)");
            iterable = list2;
            JsAstProtoBuf.CompositeBlock compositeBlock = proto.getPostDeclarationBlock();
            Intrinsics.checkNotNullExpressionValue((Object)compositeBlock, (String)"getPostDeclarationBlock(...)");
            List<JsStatement> list3 = this.deserializeCompositeBlock(compositeBlock).getStatements();
            Intrinsics.checkNotNullExpressionValue(list3, (String)"getStatements(...)");
            CollectionsKt.addAll((Collection)iterable, (Iterable)list3);
        }
        return jsClassModel;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    protected JsLocationWithSource embedSources(@NotNull JsLocation deserializedLocation, @NotNull String file) {
        Object v0;
        block2: {
            void $this$firstOrNull$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)deserializedLocation, (String)"deserializedLocation");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Iterable<File> iterable = this.sourceRoots;
            boolean $i$f$map = false;
            Iterator iterator2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                File file2 = (File)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new File((File)it, file));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                File it = (File)element$iv;
                boolean bl = false;
                if (!it.exists()) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        File contentFile = v0;
        return contentFile != null ? (JsLocationWithSource)new JsLocationWithEmbeddedSource(deserializedLocation, null, (Function0<? extends Reader>)((Function0)() -> JsAstDeserializer.embedSources$lambda$14(contentFile))) : null;
    }

    private static final Reader embedSources$lambda$14(File $contentFile) {
        return new InputStreamReader((InputStream)new FileInputStream($contentFile), "UTF-8");
    }
}

