/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi2ir.generators;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi2ir.generators.BodyGenerator;
import org.jetbrains.kotlin.psi2ir.generators.FunctionGenerator;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorKt;
import org.jetbrains.kotlin.psi2ir.generators.StatementGenerator;
import org.jetbrains.kotlin.psi2ir.generators.StatementGeneratorExtension;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/psi2ir/generators/LocalFunctionGenerator;", "Lorg/jetbrains/kotlin/psi2ir/generators/StatementGeneratorExtension;", "statementGenerator", "Lorg/jetbrains/kotlin/psi2ir/generators/StatementGenerator;", "<init>", "(Lorg/jetbrains/kotlin/psi2ir/generators/StatementGenerator;)V", "generateLambda", "Lorg/jetbrains/kotlin/ir/IrStatement;", "ktLambda", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "generateFunction", "ktFun", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "generateFunctionDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "ir.psi2ir"})
public final class LocalFunctionGenerator
extends StatementGeneratorExtension {
    public LocalFunctionGenerator(@NotNull StatementGenerator statementGenerator) {
        Intrinsics.checkNotNullParameter((Object)statementGenerator, (String)"statementGenerator");
        super(statementGenerator);
    }

    @NotNull
    public final IrStatement generateLambda(@NotNull KtLambdaExpression ktLambda) {
        Intrinsics.checkNotNullParameter((Object)ktLambda, (String)"ktLambda");
        KtFunctionLiteral ktFunctionLiteral = ktLambda.getFunctionLiteral();
        Intrinsics.checkNotNullExpressionValue((Object)ktFunctionLiteral, (String)"getFunctionLiteral(...)");
        KtFunctionLiteral ktFun = ktFunctionLiteral;
        IrType lambdaExpressionType = this.toIrType(GeneratorKt.getTypeInferredByFrontendOrFail(this, (KtExpression)ktLambda));
        BodyGenerator loopResolver = this.getContext().getLanguageVersionSettings().supportsFeature(LanguageFeature.BreakContinueInInlineLambdas) && BindingContextUtilsKt.isInlineableFunctionLiteral((KtExpression)ktLambda, this.getContext().getBindingContext()) ? this.getStatementGenerator().getBodyGenerator() : null;
        IrSimpleFunction irLambdaFunction = new FunctionGenerator(this.getContext()).generateLambdaFunctionDeclaration(ktFun, loopResolver);
        return (IrStatement)BuildersKt.IrFunctionExpressionImpl((int)ktLambda.getStartOffset(), (int)PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)ktLambda)), (IrType)lambdaExpressionType, (IrSimpleFunction)irLambdaFunction, (IrStatementOrigin)((IrStatementOrigin)IrStatementOrigin.Companion.getLAMBDA()));
    }

    @NotNull
    public final IrStatement generateFunction(@NotNull KtNamedFunction ktFun) {
        Intrinsics.checkNotNullParameter((Object)ktFun, (String)"ktFun");
        IrSimpleFunction irFun = this.generateFunctionDeclaration(ktFun);
        if (ktFun.getName() != null) {
            return (IrStatement)irFun;
        }
        IrType funExpressionType = this.toIrType(GeneratorKt.getTypeInferredByFrontendOrFail(this, (KtExpression)ktFun));
        return (IrStatement)BuildersKt.IrFunctionExpressionImpl((int)PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)ktFun)), (int)PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)ktFun)), (IrType)funExpressionType, (IrSimpleFunction)irFun, (IrStatementOrigin)((IrStatementOrigin)IrStatementOrigin.Companion.getANONYMOUS_FUNCTION()));
    }

    private final IrSimpleFunction generateFunctionDeclaration(KtNamedFunction ktFun) {
        return new FunctionGenerator(this.getContext()).generateFunctionDeclaration(ktFun, this.getContext().getLanguageVersionSettings().supportsFeature(LanguageFeature.BreakContinueInInlineLambdas) && BindingContextUtilsKt.isInlineableFunctionLiteral((KtExpression)ktFun, this.getContext().getBindingContext()) ? this.getStatementGenerator().getBodyGenerator() : null, (IrDeclarationOrigin)IrDeclarationOrigin.Companion.getLOCAL_FUNCTION());
    }
}

