/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.runtime.structure;

import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.runtime.structure.ReflectJavaType;
import org.jetbrains.kotlin.load.java.structure.JavaAnnotation;
import org.jetbrains.kotlin.load.java.structure.JavaWildcardType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0003\u001a\u00020\u0004X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\u0004\u0018\u00010\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/descriptors/runtime/structure/ReflectJavaWildcardType;", "Lorg/jetbrains/kotlin/descriptors/runtime/structure/ReflectJavaType;", "Lorg/jetbrains/kotlin/load/java/structure/JavaWildcardType;", "reflectType", "Ljava/lang/reflect/WildcardType;", "<init>", "(Ljava/lang/reflect/WildcardType;)V", "getReflectType", "()Ljava/lang/reflect/WildcardType;", "bound", "getBound", "()Lorg/jetbrains/kotlin/descriptors/runtime/structure/ReflectJavaType;", "isExtends", "", "()Z", "annotations", "", "Lorg/jetbrains/kotlin/load/java/structure/JavaAnnotation;", "getAnnotations", "()Ljava/util/Collection;", "isDeprecatedInJavaDoc", "descriptors.runtime"})
@SourceDebugExtension(value={"SMAP\nReflectJavaWildcardType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReflectJavaWildcardType.kt\norg/jetbrains/kotlin/descriptors/runtime/structure/ReflectJavaWildcardType\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,45:1\n1#2:46\n*E\n"})
public final class ReflectJavaWildcardType
extends ReflectJavaType
implements JavaWildcardType {
    @NotNull
    private final WildcardType reflectType;
    @NotNull
    private final Collection<JavaAnnotation> annotations;
    private final boolean isDeprecatedInJavaDoc;

    public ReflectJavaWildcardType(@NotNull WildcardType reflectType) {
        Intrinsics.checkNotNullParameter((Object)reflectType, (String)"reflectType");
        this.reflectType = reflectType;
        this.annotations = CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    protected WildcardType getReflectType() {
        return this.reflectType;
    }

    @Nullable
    public ReflectJavaType getBound() {
        ReflectJavaType reflectJavaType;
        Object[] upperBounds = this.getReflectType().getUpperBounds();
        Object[] lowerBounds = this.getReflectType().getLowerBounds();
        if (upperBounds.length > 1 || lowerBounds.length > 1) {
            throw new UnsupportedOperationException("Wildcard types with many bounds are not yet supported: " + this.getReflectType());
        }
        if (lowerBounds.length == 1) {
            Intrinsics.checkNotNull((Object)lowerBounds);
            Object object = ArraysKt.single((Object[])lowerBounds);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"single(...)");
            reflectJavaType = ReflectJavaType.Factory.create((Type)object);
        } else if (upperBounds.length == 1) {
            Intrinsics.checkNotNull((Object)upperBounds);
            Type ub = (Type)ArraysKt.single((Object[])upperBounds);
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)ub, Object.class)) {
                Intrinsics.checkNotNull((Object)ub);
                reflectJavaType = ReflectJavaType.Factory.create(ub);
            } else {
                reflectJavaType = null;
            }
        } else {
            reflectJavaType = null;
        }
        return reflectJavaType;
    }

    public boolean isExtends() {
        Type[] typeArray = this.getReflectType().getUpperBounds();
        Intrinsics.checkNotNullExpressionValue((Object)typeArray, (String)"getUpperBounds(...)");
        return !Intrinsics.areEqual((Object)ArraysKt.firstOrNull((Object[])typeArray), Object.class);
    }

    @NotNull
    public Collection<JavaAnnotation> getAnnotations() {
        return this.annotations;
    }

    public boolean isDeprecatedInJavaDoc() {
        return this.isDeprecatedInJavaDoc;
    }
}

