/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.onboarding.gradle;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.onboarding.gradle.BuildProcessSatisfactionSurveyState;

@State(name="BuildProcessSatisfactionSurveyStore", storages={@Storage(value="kotlin-onboarding.xml")})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0001\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\t\u001a\u00020\u0002H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016J\r\u0010\r\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u000eJ\r\u0010\u000f\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u0010J\r\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0013R\u001a\u0010\u0004\u001a\u00020\u0002X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/onboarding/gradle/BuildProcessSatisfactionSurveyStore;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jetbrains/kotlin/onboarding/gradle/BuildProcessSatisfactionSurveyState;", "()V", "currentState", "getCurrentState$kotlin_onboarding_gradle", "()Lorg/jetbrains/kotlin/onboarding/gradle/BuildProcessSatisfactionSurveyState;", "setCurrentState$kotlin_onboarding_gradle", "(Lorg/jetbrains/kotlin/onboarding/gradle/BuildProcessSatisfactionSurveyState;)V", "getState", "loadState", "", "state", "recordBuild", "recordBuild$kotlin_onboarding_gradle", "recordSurveyShown", "recordSurveyShown$kotlin_onboarding_gradle", "shouldShowDialog", "", "shouldShowDialog$kotlin_onboarding_gradle", "Companion", "kotlin.onboarding.gradle"})
@ApiStatus.Internal
public final class BuildProcessSatisfactionSurveyStore
implements PersistentStateComponent<BuildProcessSatisfactionSurveyState> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private BuildProcessSatisfactionSurveyState currentState = new BuildProcessSatisfactionSurveyState();
    public static final int MINIMUM_BUILDS_BEFORE_SURVEY = 3;
    private static final Duration MINIMUM_DURATION_SINCE_FIRST_BUILD = Duration.ofDays(14L);

    @NotNull
    public BuildProcessSatisfactionSurveyState getState() {
        return this.currentState;
    }

    @NotNull
    public final BuildProcessSatisfactionSurveyState getCurrentState$kotlin_onboarding_gradle() {
        return this.currentState;
    }

    public final void setCurrentState$kotlin_onboarding_gradle(@NotNull BuildProcessSatisfactionSurveyState buildProcessSatisfactionSurveyState) {
        Intrinsics.checkNotNullParameter((Object)((Object)buildProcessSatisfactionSurveyState), (String)"<set-?>");
        this.currentState = buildProcessSatisfactionSurveyState;
    }

    public void loadState(@NotNull BuildProcessSatisfactionSurveyState state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        this.currentState = state;
    }

    public final void recordSurveyShown$kotlin_onboarding_gradle() {
        this.getState().setUserSawSurvey(true);
    }

    public final void recordBuild$kotlin_onboarding_gradle() {
        Instant currentTime = Instant.now();
        if (currentTime.compareTo(Instant.ofEpochSecond(this.currentState.getNextCountedGradleBuild())) >= 0) {
            BuildProcessSatisfactionSurveyState buildProcessSatisfactionSurveyState = this.currentState;
            int n = buildProcessSatisfactionSurveyState.getDaysWithGradleBuilds();
            buildProcessSatisfactionSurveyState.setDaysWithGradleBuilds(n + 1);
            this.currentState.setNextCountedGradleBuild(currentTime.plus(Duration.ofDays(1L)).getEpochSecond());
        }
        this.currentState.setLastKotlinGradleBuildTime(currentTime.getEpochSecond());
        if (this.currentState.getFirstKotlinGradleBuildTime() == 0L) {
            this.currentState.setFirstKotlinGradleBuildTime(currentTime.getEpochSecond());
        }
    }

    public final boolean shouldShowDialog$kotlin_onboarding_gradle() {
        BuildProcessSatisfactionSurveyState state = this.currentState;
        if (state.getUserSawSurvey() || state.getFirstKotlinGradleBuildTime() == 0L || state.getDaysWithGradleBuilds() < 3) {
            return false;
        }
        return Duration.between(Instant.ofEpochSecond(state.getFirstKotlinGradleBuildTime()), Instant.now()).compareTo(MINIMUM_DURATION_SINCE_FIRST_BUILD) >= 0;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/onboarding/gradle/BuildProcessSatisfactionSurveyStore$Companion;", "", "()V", "MINIMUM_BUILDS_BEFORE_SURVEY", "", "MINIMUM_DURATION_SINCE_FIRST_BUILD", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "getMINIMUM_DURATION_SINCE_FIRST_BUILD$kotlin_onboarding_gradle", "()Ljava/time/Duration;", "getInstance", "Lorg/jetbrains/kotlin/onboarding/gradle/BuildProcessSatisfactionSurveyStore;", "kotlin.onboarding.gradle"})
    @SourceDebugExtension(value={"SMAP\nBuildProcessSatisfactionSurveyStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildProcessSatisfactionSurveyStore.kt\norg/jetbrains/kotlin/onboarding/gradle/BuildProcessSatisfactionSurveyStore$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,73:1\n40#2,3:74\n*S KotlinDebug\n*F\n+ 1 BuildProcessSatisfactionSurveyStore.kt\norg/jetbrains/kotlin/onboarding/gradle/BuildProcessSatisfactionSurveyStore$Companion\n*L\n39#1:74,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final Duration getMINIMUM_DURATION_SINCE_FIRST_BUILD$kotlin_onboarding_gradle() {
            return MINIMUM_DURATION_SINCE_FIRST_BUILD;
        }

        @NotNull
        public final BuildProcessSatisfactionSurveyStore getInstance() {
            boolean $i$f$service = false;
            Class<BuildProcessSatisfactionSurveyStore> serviceClass$iv = BuildProcessSatisfactionSurveyStore.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (BuildProcessSatisfactionSurveyStore)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

