/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.nj2k.printing;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.nj2k.ExpressionsKt;
import org.jetbrains.kotlin.nj2k.UtilsKt;
import org.jetbrains.kotlin.nj2k.printing.PrintingUtilsKt;
import org.jetbrains.kotlin.nj2k.tree.JKArgument;
import org.jetbrains.kotlin.nj2k.tree.JKArgumentList;
import org.jetbrains.kotlin.nj2k.tree.JKCallExpressionImpl;
import org.jetbrains.kotlin.nj2k.tree.JKElement;
import org.jetbrains.kotlin.nj2k.tree.JKExpression;
import org.jetbrains.kotlin.nj2k.tree.JKLambdaExpression;
import org.jetbrains.kotlin.nj2k.tree.JKMethod;
import org.jetbrains.kotlin.nj2k.tree.JKNewExpression;
import org.jetbrains.kotlin.nj2k.tree.JKParameter;
import org.jetbrains.kotlin.nj2k.types.TypesUtilsKt;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\n\u0010\u0007\u001a\u00020\u0002*\u00020\u0002\u001a\f\u0010\b\u001a\u00020\u0004*\u00020\tH\u0002\u001a\f\u0010\n\u001a\u00020\u0004*\u00020\u000bH\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"javaFunctionalTypes", "", "", "canMoveLambdaOutsideParentheses", "", "argumentList", "Lorg/jetbrains/kotlin/nj2k/tree/JKArgumentList;", "escapedAsQualifiedName", "hasFunctionalType", "Lorg/jetbrains/kotlin/psi/KtParameter;", "isFunctionalType", "Lcom/intellij/psi/PsiType;", "kotlin.j2k.shared"})
@SourceDebugExtension(value={"SMAP\nprintingUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 printingUtils.kt\norg/jetbrains/kotlin/nj2k/printing/PrintingUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,104:1\n1549#2:105\n1620#2,3:106\n1774#2,4:109\n*S KotlinDebug\n*F\n+ 1 printingUtils.kt\norg/jetbrains/kotlin/nj2k/printing/PrintingUtilsKt\n*L\n19#1:105\n19#1:106,3\n27#1:109,4\n*E\n"})
public final class PrintingUtilsKt {
    @NotNull
    private static final Set<String> javaFunctionalTypes;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String escapedAsQualifiedName(@NotNull String $this$escapedAsQualifiedName) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$escapedAsQualifiedName, (String)"<this>");
        char[] cArray = new char[]{'.'};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)$this$escapedAsQualifiedName, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(UtilsKt.escaped((String)it));
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)".", null, null, (int)0, null, (Function1)escapedAsQualifiedName.2.INSTANCE, (int)30, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean canMoveLambdaOutsideParentheses(@NotNull JKArgumentList argumentList2) {
        KtParameter lastParameter;
        PsiMethod method;
        Object object;
        boolean bl;
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)argumentList2, (String)"argumentList");
        List<JKArgument> arguments2 = argumentList2.getArguments();
        Iterable $this$count$iv = arguments2;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            return false;
        }
        int count$iv22 = 0;
        for (Object element$iv : $this$count$iv) {
            JKArgument it = (JKArgument)element$iv;
            boolean bl3 = false;
            if (!(it.getValue() instanceof JKLambdaExpression) || ++count$iv22 >= 0) continue;
            CollectionsKt.throwCountOverflow();
        }
        int n = count$iv22;
        if (n != 1) {
            return false;
        }
        JKArgument jKArgument = (JKArgument)CollectionsKt.lastOrNull(arguments2);
        JKExpression count$iv22 = jKArgument != null ? jKArgument.getValue() : null;
        if (!(count$iv22 instanceof JKLambdaExpression)) return false;
        JKLambdaExpression jKLambdaExpression = (JKLambdaExpression)count$iv22;
        if (jKLambdaExpression == null) {
            return false;
        }
        JKLambdaExpression lambda2 = jKLambdaExpression;
        JKElement call2 = argumentList2.getParent();
        if (!(call2 instanceof JKCallExpressionImpl) && !(call2 instanceof JKNewExpression)) {
            return false;
        }
        JKCallExpressionImpl jKCallExpressionImpl = call2 instanceof JKCallExpressionImpl ? (JKCallExpressionImpl)call2 : null;
        if (jKCallExpressionImpl != null) {
            if (jKCallExpressionImpl.getCanMoveLambdaOutsideParentheses()) {
                return true;
            }
            bl2 = false;
        } else {
            bl2 = false;
        }
        if (bl2) return true;
        JKNewExpression jKNewExpression = call2 instanceof JKNewExpression ? (JKNewExpression)call2 : null;
        if (jKNewExpression != null) {
            if (jKNewExpression.getCanMoveLambdaOutsideParentheses()) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) {
            return true;
        }
        if (ExpressionsKt.isPresent(lambda2.getFunctionalType())) {
            return false;
        }
        PsiElement callPsi = ExpressionsKt.getPsi(call2);
        if (callPsi instanceof PsiMethodCallExpression) {
            object = ((PsiMethodCallExpression)callPsi).resolveMethod();
        } else if (callPsi instanceof PsiNewExpression) {
            object = ((PsiNewExpression)callPsi).resolveMethod();
        } else {
            if (!(call2 instanceof JKCallExpressionImpl)) return false;
            object = ((JKCallExpressionImpl)call2).getIdentifier().getTarget();
        }
        PsiMethod psiMethod2 = method = object;
        if (psiMethod2 instanceof KtNamedFunction) {
            boolean bl4;
            List list2 = ((KtNamedFunction)method).getValueParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getValueParameters(...)");
            lastParameter = (KtParameter)CollectionsKt.lastOrNull((List)list2);
            if (((KtNamedFunction)method).getValueParameters().size() != arguments2.size()) return false;
            KtParameter ktParameter = lastParameter;
            if (ktParameter != null) {
                if (ktParameter.isVarArg()) {
                    return false;
                }
                bl4 = false;
            } else {
                bl4 = false;
            }
            if (bl4) return false;
            KtParameter ktParameter2 = lastParameter;
            if (ktParameter2 == null) return false;
            if (!PrintingUtilsKt.hasFunctionalType(ktParameter2)) return false;
            return true;
        }
        if (psiMethod2 instanceof PsiMethod) {
            boolean bl5;
            PsiParameter[] psiParameterArray = method.getParameterList().getParameters();
            Intrinsics.checkNotNullExpressionValue((Object)psiParameterArray, (String)"getParameters(...)");
            lastParameter = (PsiParameter)ArraysKt.lastOrNull((Object[])psiParameterArray);
            if (method.getParameterList().getParametersCount() != arguments2.size()) return false;
            KtParameter ktParameter = lastParameter;
            if (ktParameter != null) {
                if (ktParameter.isVarArgs()) {
                    return false;
                }
                bl5 = false;
            } else {
                bl5 = false;
            }
            if (bl5) return false;
            KtParameter ktParameter4 = lastParameter;
            ktParameter4 = ktParameter4;
            if (ktParameter3 == null) return false;
            PsiType psiType = ktParameter4.getType();
            ktParameter4 = psiType;
            if (psiType == null) return false;
            if (!PrintingUtilsKt.isFunctionalType((PsiType)ktParameter4)) return false;
            return true;
        }
        if (!(psiMethod2 instanceof JKMethod)) return false;
        if (((JKMethod)method).getParameters().size() != arguments2.size()) return false;
        if (((JKParameter)CollectionsKt.last(((JKMethod)method).getParameters())).isVarArgs()) return false;
        return true;
    }

    private static final boolean isFunctionalType(PsiType $this$isFunctionalType) {
        if (TypesUtilsKt.isKotlinFunctionalType($this$isFunctionalType)) {
            return true;
        }
        String string = $this$isFunctionalType.getCanonicalText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalText(...)");
        String fqn2 = StringsKt.substringBefore$default((String)string, (String)"<", null, (int)2, null);
        return javaFunctionalTypes.contains(fqn2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean hasFunctionalType(KtParameter $this$hasFunctionalType) {
        if ($this$hasFunctionalType.isLambdaParameter()) return true;
        if ($this$hasFunctionalType.isFunctionTypeParameter()) return true;
        KtTypeReference ktTypeReference = $this$hasFunctionalType.getTypeReference();
        String string = ktTypeReference != null ? ktTypeReference.getText() : null;
        if (string == null) {
            string = "";
        }
        if (!StringsKt.contains$default((CharSequence)string, (CharSequence)") -> ", (boolean)false, (int)2, null)) return false;
        return true;
    }

    static {
        Object[] objectArray = new String[]{"java.util.function.BiConsumer", "java.util.function.BiFunction", "java.util.function.BinaryOperator", "java.util.function.Consumer", "java.util.function.Function", "java.util.function.Predicate", "java.util.function.Supplier", "java.util.function.UnaryOperator"};
        javaFunctionalTypes = SetsKt.setOf((Object[])objectArray);
    }
}

