/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.vfilefinder;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.ID;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.vfilefinder.KotlinBuiltInsMetadataIndex;
import org.jetbrains.kotlin.idea.vfilefinder.KotlinClassFileIndex;
import org.jetbrains.kotlin.idea.vfilefinder.KotlinMetadataFileIndex;
import org.jetbrains.kotlin.idea.vfilefinder.KotlinMetadataFilePackageIndex;
import org.jetbrains.kotlin.idea.vfilefinder.KotlinStdlibIndexKt;
import org.jetbrains.kotlin.load.kotlin.VirtualFileFinder;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0016J&\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\b2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/vfilefinder/IdeVirtualFileFinder;", "Lorg/jetbrains/kotlin/load/kotlin/VirtualFileFinder;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "(Lcom/intellij/psi/search/GlobalSearchScope;)V", "findBuiltInsData", "Ljava/io/InputStream;", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "findMetadata", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "findMetadataTopLevelClassesInPackage", "", "", "findSourceOrBinaryVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "findVirtualFileWithHeader", "fqName", "key", "Lcom/intellij/util/indexing/ID;", "Ljava/lang/Void;", "hasMetadataPackage", "", "Companion", "kotlin.base.project-structure"})
@SourceDebugExtension(value={"SMAP\nIdeVirtualFileFinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeVirtualFileFinder.kt\norg/jetbrains/kotlin/idea/vfilefinder/IdeVirtualFileFinder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,58:1\n1#2:59\n*E\n"})
public final class IdeVirtualFileFinder
extends VirtualFileFinder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GlobalSearchScope scope;
    @NotNull
    private static final Logger LOG;

    public IdeVirtualFileFinder(@NotNull GlobalSearchScope scope2) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        this.scope = scope2;
        if (!Intrinsics.areEqual((Object)this.scope, (Object)GlobalSearchScope.EMPTY_SCOPE) && this.scope.getProject() == null) {
            LOG.warn("Scope with null project " + this.scope);
        }
    }

    @Nullable
    public InputStream findMetadata(@NotNull ClassId classId) {
        InputStream inputStream;
        Object object;
        block5: {
            block4: {
                VirtualFile virtualFile2;
                Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
                object = this.findVirtualFileWithHeader(classId.asSingleFqName(), KotlinMetadataFileIndex.Companion.getNAME());
                if (object == null) break block4;
                VirtualFile it = virtualFile2 = object;
                boolean bl = false;
                object = it.exists() ? virtualFile2 : null;
                if (object != null) break block5;
            }
            return null;
        }
        VirtualFile file2 = object;
        try {
            inputStream = file2.getInputStream();
        }
        catch (FileNotFoundException e) {
            inputStream = null;
        }
        return inputStream;
    }

    @Nullable
    public Set<String> findMetadataTopLevelClassesInPackage(@NotNull FqName packageFqName) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        return null;
    }

    public boolean hasMetadataPackage(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        return KotlinStdlibIndexKt.hasSomethingInPackage(KotlinMetadataFilePackageIndex.Companion.getNAME(), fqName2, this.scope);
    }

    @Nullable
    public InputStream findBuiltInsData(@NotNull FqName packageFqName) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        VirtualFile virtualFile2 = this.findVirtualFileWithHeader(packageFqName, KotlinBuiltInsMetadataIndex.Companion.getNAME());
        return virtualFile2 != null ? virtualFile2.getInputStream() : null;
    }

    @Nullable
    public VirtualFile findSourceOrBinaryVirtualFile(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        return this.findVirtualFileWithHeader(classId);
    }

    @Nullable
    public VirtualFile findVirtualFileWithHeader(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        return this.findVirtualFileWithHeader(classId.asSingleFqName(), KotlinClassFileIndex.Companion.getNAME());
    }

    private final VirtualFile findVirtualFileWithHeader(FqName fqName2, ID<FqName, Void> key) {
        Iterator iterator2 = FileBasedIndex.getInstance().getContainingFilesIterator(key, (Object)fqName2, this.scope);
        Intrinsics.checkNotNullExpressionValue((Object)iterator2, (String)"getContainingFilesIterator(...)");
        Iterator iterator3 = iterator2;
        return iterator3.hasNext() ? (VirtualFile)iterator3.next() : null;
    }

    static {
        Logger logger = Logger.getInstance(IdeVirtualFileFinder.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/vfilefinder/IdeVirtualFileFinder$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "kotlin.base.project-structure"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

