/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.search.ideaExtensions;

import com.intellij.codeInsight.highlighting.JavaReadWriteAccessDetector;
import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.elements.KtLightMethod;
import org.jetbrains.kotlin.idea.references.ReadWriteAccessCheckerKt;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.resolve.references.ReferenceAccess;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006H\u0016J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006H\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/search/ideaExtensions/KotlinReadWriteAccessDetector;", "Lcom/intellij/codeInsight/highlighting/ReadWriteAccessDetector;", "()V", "getExpressionAccess", "Lcom/intellij/codeInsight/highlighting/ReadWriteAccessDetector$Access;", "expression", "Lcom/intellij/psi/PsiElement;", "getReferenceAccess", "referencedElement", "reference", "Lcom/intellij/psi/PsiReference;", "isDeclarationWriteAccess", "", "element", "isReadWriteAccessible", "Companion", "kotlin.base.analysis"})
@SourceDebugExtension(value={"SMAP\nKotlinReadWriteAccessDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinReadWriteAccessDetector.kt\norg/jetbrains/kotlin/idea/search/ideaExtensions/KotlinReadWriteAccessDetector\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,60:1\n146#2:61\n*S KotlinDebug\n*F\n+ 1 KotlinReadWriteAccessDetector.kt\norg/jetbrains/kotlin/idea/search/ideaExtensions/KotlinReadWriteAccessDetector\n*L\n33#1:61\n*E\n"})
public final class KotlinReadWriteAccessDetector
extends ReadWriteAccessDetector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final KotlinReadWriteAccessDetector INSTANCE = new KotlinReadWriteAccessDetector();

    public boolean isReadWriteAccessible(@NotNull PsiElement element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return element3 instanceof KtVariableDeclaration || element3 instanceof KtParameter;
    }

    public boolean isDeclarationWriteAccess(@NotNull PsiElement element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return this.isReadWriteAccessible(element3);
    }

    @NotNull
    public ReadWriteAccessDetector.Access getReferenceAccess(@NotNull PsiElement referencedElement, @NotNull PsiReference reference2) {
        Intrinsics.checkNotNullParameter((Object)referencedElement, (String)"referencedElement");
        Intrinsics.checkNotNullParameter((Object)reference2, (String)"reference");
        if (!this.isReadWriteAccessible(referencedElement)) {
            return ReadWriteAccessDetector.Access.Read;
        }
        PsiElement refTarget = reference2.resolve();
        if (refTarget instanceof KtLightMethod) {
            KtNamedDeclaration ktNamedDeclaration;
            KtDeclaration origin = (KtDeclaration)((KtLightMethod)refTarget).getKotlinOrigin();
            if (origin instanceof KtPropertyAccessor) {
                PsiElement $this$getNonStrictParentOfType$iv = (PsiElement)origin;
                boolean $i$f$getNonStrictParentOfType = false;
                ktNamedDeclaration = (KtNamedDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtProperty.class, (boolean)false);
            } else if (origin instanceof KtProperty ? true : origin instanceof KtParameter) {
                Intrinsics.checkNotNull((Object)origin, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNamedDeclaration");
                ktNamedDeclaration = (KtNamedDeclaration)origin;
            } else {
                ktNamedDeclaration = null;
            }
            if (ktNamedDeclaration == null) {
                return ReadWriteAccessDetector.Access.ReadWrite;
            }
            KtNamedDeclaration declaration2 = ktNamedDeclaration;
            String string = ((KtLightMethod)refTarget).getName();
            String string2 = declaration2.getName();
            Intrinsics.checkNotNull((Object)string2);
            if (Intrinsics.areEqual((Object)string, (Object)JvmAbi.getterName((String)string2))) {
                return ReadWriteAccessDetector.Access.Read;
            }
            String string3 = declaration2.getName();
            Intrinsics.checkNotNull((Object)string3);
            if (Intrinsics.areEqual((Object)string, (Object)JvmAbi.setterName((String)string3))) {
                return ReadWriteAccessDetector.Access.Write;
            }
            return ReadWriteAccessDetector.Access.ReadWrite;
        }
        PsiElement psiElement2 = reference2.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getElement(...)");
        return this.getExpressionAccess(psiElement2);
    }

    @NotNull
    public ReadWriteAccessDetector.Access getExpressionAccess(@NotNull PsiElement expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (!(expression2 instanceof KtExpression)) {
            ReadWriteAccessDetector.Access access = new JavaReadWriteAccessDetector().getExpressionAccess(expression2);
            Intrinsics.checkNotNullExpressionValue((Object)access, (String)"getExpressionAccess(...)");
            return access;
        }
        return switch (WhenMappings.$EnumSwitchMapping$0[ReadWriteAccessCheckerKt.readWriteAccess((KtExpression)((KtExpression)expression2), (boolean)true).ordinal()]) {
            case 1 -> ReadWriteAccessDetector.Access.Read;
            case 2 -> ReadWriteAccessDetector.Access.Write;
            case 3 -> ReadWriteAccessDetector.Access.ReadWrite;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/search/ideaExtensions/KotlinReadWriteAccessDetector$Companion;", "", "()V", "INSTANCE", "Lorg/jetbrains/kotlin/idea/search/ideaExtensions/KotlinReadWriteAccessDetector;", "getINSTANCE", "()Lorg/jetbrains/kotlin/idea/search/ideaExtensions/KotlinReadWriteAccessDetector;", "kotlin.base.analysis"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KotlinReadWriteAccessDetector getINSTANCE() {
            return INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ReferenceAccess.values().length];
            try {
                nArray[ReferenceAccess.READ.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReferenceAccess.WRITE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReferenceAccess.READ_WRITE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

