/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.search;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiNamedElement;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiUtils;
import org.jetbrains.kotlin.idea.search.ExpectActualSupport;
import org.jetbrains.kotlin.idea.search.ideaExtensions.KotlinReferencesSearchOptions;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\tJ\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\f2\u0006\u0010\r\u001a\u00020\tJ\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000f*\u00020\t2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\f\u0010\u0012\u001a\u0004\u0018\u00010\t*\u00020\t\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/search/ExpectActualUtils;", "", "()V", "getElementToSearch", "Lcom/intellij/psi/PsiNamedElement;", "kotlinOptions", "Lorg/jetbrains/kotlin/idea/search/ideaExtensions/KotlinReferencesSearchOptions;", "unwrappedElement", "liftToExpected", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "declaration", "withExpectedActuals", "", "classOrObject", "actualsForExpected", "", "module", "Lcom/intellij/openapi/module/Module;", "expectedDeclarationIfAny", "kotlin.base.analysis"})
public final class ExpectActualUtils {
    @NotNull
    public static final ExpectActualUtils INSTANCE = new ExpectActualUtils();

    private ExpectActualUtils() {
    }

    @Nullable
    public final KtDeclaration expectedDeclarationIfAny(@NotNull KtDeclaration $this$expectedDeclarationIfAny) {
        Intrinsics.checkNotNullParameter((Object)$this$expectedDeclarationIfAny, (String)"<this>");
        Project project2 = $this$expectedDeclarationIfAny.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        return ExpectActualSupport.Companion.getInstance(project2).expectedDeclarationIfAny($this$expectedDeclarationIfAny);
    }

    @NotNull
    public final Set<KtDeclaration> actualsForExpected(@NotNull KtDeclaration $this$actualsForExpected, @Nullable Module module2) {
        Intrinsics.checkNotNullParameter((Object)$this$actualsForExpected, (String)"<this>");
        Project project2 = $this$actualsForExpected.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        return ExpectActualSupport.Companion.getInstance(project2).actualsForExpected($this$actualsForExpected, module2);
    }

    public static /* synthetic */ Set actualsForExpected$default(ExpectActualUtils expectActualUtils, KtDeclaration ktDeclaration, Module module2, int n, Object object) {
        if ((n & 1) != 0) {
            module2 = null;
        }
        return expectActualUtils.actualsForExpected(ktDeclaration, module2);
    }

    @Nullable
    public final KtDeclaration liftToExpected(@NotNull KtDeclaration declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        if (declaration2 instanceof KtParameter) {
            KtDeclarationWithBody ktDeclarationWithBody = ((KtParameter)declaration2).getOwnerFunction();
            KtCallableDeclaration ktCallableDeclaration2 = ktDeclarationWithBody instanceof KtCallableDeclaration ? (KtCallableDeclaration)ktDeclarationWithBody : null;
            if (ktCallableDeclaration2 == null) {
                return null;
            }
            KtCallableDeclaration function2 = ktCallableDeclaration2;
            int index = function2.getValueParameters().indexOf(declaration2);
            KtDeclaration ktDeclaration = this.liftToExpected((KtDeclaration)function2);
            Object object = ktDeclaration instanceof KtCallableDeclaration ? (KtCallableDeclaration)ktDeclaration : null;
            return (KtDeclaration)(object != null && (object = object.getValueParameters()) != null ? (KtParameter)CollectionsKt.getOrNull((List)object, (int)index) : null);
        }
        return KotlinPsiUtils.isExpectDeclaration(declaration2) ? declaration2 : this.expectedDeclarationIfAny(declaration2);
    }

    @NotNull
    public final List<KtDeclaration> withExpectedActuals(@NotNull KtDeclaration classOrObject) {
        Intrinsics.checkNotNullParameter((Object)classOrObject, (String)"classOrObject");
        KtDeclaration ktDeclaration = this.liftToExpected(classOrObject);
        if (ktDeclaration == null) {
            return CollectionsKt.listOf((Object)classOrObject);
        }
        KtDeclaration expect = ktDeclaration;
        Set actuals = ExpectActualUtils.actualsForExpected$default(this, expect, null, 1, null);
        return CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)expect), (Iterable)actuals);
    }

    @NotNull
    public final PsiNamedElement getElementToSearch(@NotNull KotlinReferencesSearchOptions kotlinOptions, @NotNull PsiNamedElement unwrappedElement) {
        PsiNamedElement psiNamedElement;
        KtDeclaration ktDeclaration;
        Intrinsics.checkNotNullParameter((Object)kotlinOptions, (String)"kotlinOptions");
        Intrinsics.checkNotNullParameter((Object)unwrappedElement, (String)"unwrappedElement");
        if ((kotlinOptions.getSearchForExpectedUsages() && unwrappedElement instanceof KtDeclaration && PsiUtilsKt.hasActualModifier((KtModifierListOwner)((KtModifierListOwner)unwrappedElement)) ? ((ktDeclaration = this.expectedDeclarationIfAny((KtDeclaration)unwrappedElement)) instanceof PsiNamedElement ? (PsiNamedElement)ktDeclaration : null) : (psiNamedElement = null)) == null) {
            psiNamedElement = unwrappedElement;
        }
        return psiNamedElement;
    }
}

