/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.rename;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewTypeLocation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.refactoring.rename.KotlinRenameRefactoringSupport;
import org.jetbrains.kotlin.idea.refactoring.rename.LostDefaultValuesInOverridingFunctionUsageInfo;
import org.jetbrains.kotlin.idea.refactoring.rename.UnresolvableConventionViolationUsageInfo;
import org.jetbrains.kotlin.idea.references.AbstractKtReference;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000j\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a4\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0016\u0010\t\u001a\u0012\u0012\b\b\u0001\u0012\u0004\u0018\u00010\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u001a\"\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u0010\u001a>\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0018\u0010\u0017\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0010\u0012\u0004\u0012\u00020\u00060\u0018\u001a%\u0010\u0019\u001a\t\u0018\u00010\u000b\u00a2\u0006\u0002\b\u001a2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u0010H\u0002\u001aA\u0010\u001b\u001a\u0002H\u001c\"\u0004\b\u0000\u0010\u001c2\b\b\u0001\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u000e\b\u0004\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u001c0\"H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010#\u001a\f\u0010$\u001a\u00020\u0006*\u00020\u0002H\u0002\u001a&\u0010%\u001a\u0004\u0018\u00010&*\u00020\b2\u0016\u0010\t\u001a\u0012\u0012\b\b\u0001\u0012\u0004\u0018\u00010\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002\u001a\f\u0010'\u001a\u00020\u001f*\u00020\u0012H\u0002\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006("}, d2={"useScopeForRename", "Lcom/intellij/psi/search/SearchScope;", "Lorg/jetbrains/kotlin/psi/KtParameter;", "getUseScopeForRename", "(Lorg/jetbrains/kotlin/psi/KtParameter;)Lcom/intellij/psi/search/SearchScope;", "checkConflictsAndReplaceUsageInfos", "", "element", "Lcom/intellij/psi/PsiElement;", "allRenames", "", "", "result", "", "Lcom/intellij/usageView/UsageInfo;", "checkSuperMethods", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "deepestSuperMethods", "checkSuperMethodsWithPopup", "editor", "Lcom/intellij/openapi/editor/Editor;", "action", "Lkotlin/Function1;", "getRenameBaseTitle", "Lcom/intellij/openapi/util/NlsContexts$DialogMessage;", "runProcessWithProgressSynchronously", "T", "progressTitle", "canBeCancelled", "", "project", "Lcom/intellij/openapi/project/Project;", "Lkotlin/Function0;", "(Ljava/lang/String;ZLcom/intellij/openapi/project/Project;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "dropDefaultValue", "getOverriddenFunctionWithDefaultValues", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "isAbstract", "kotlin.refactorings.common"})
@SourceDebugExtension(value={"SMAP\ncommonRenameUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 commonRenameUtils.kt\norg/jetbrains/kotlin/idea/refactoring/rename/CommonRenameUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n*L\n1#1,214:1\n1603#2,9:215\n1855#2:224\n1856#2:226\n1612#2:227\n800#2,11:228\n288#2:239\n1747#2,3:240\n289#2:243\n1603#2,9:245\n1855#2:254\n1856#2:256\n1612#2:257\n1747#2,3:258\n1747#2,3:261\n1#3:225\n1#3:255\n73#4:244\n73#4:264\n*S KotlinDebug\n*F\n+ 1 commonRenameUtils.kt\norg/jetbrains/kotlin/idea/refactoring/rename/CommonRenameUtilsKt\n*L\n106#1:215,9\n106#1:224\n106#1:226\n106#1:227\n110#1:228,11\n111#1:239\n111#1:240,3\n111#1:243\n146#1:245,9\n146#1:254\n146#1:256\n146#1:257\n147#1:258,3\n148#1:261,3\n106#1:225\n146#1:255\n138#1:244\n180#1:264\n*E\n"})
public final class CommonRenameUtilsKt {
    @NotNull
    public static final SearchScope getUseScopeForRename(@NotNull KtParameter $this$useScopeForRename) {
        KtFunction owner;
        Intrinsics.checkNotNullParameter((Object)$this$useScopeForRename, (String)"<this>");
        KtDeclarationWithBody ktDeclarationWithBody = $this$useScopeForRename.getOwnerFunction();
        KtFunction ktFunction = owner = ktDeclarationWithBody instanceof KtFunction ? (KtFunction)ktDeclarationWithBody : null;
        Object object = ktFunction != null ? ktFunction.getUseScope() : null;
        if (object == null) {
            SearchScope searchScope2 = $this$useScopeForRename.getUseScope();
            object = searchScope2;
            Intrinsics.checkNotNullExpressionValue((Object)searchScope2, (String)"getUseScope(...)");
        }
        return object;
    }

    public static final <T> T runProcessWithProgressSynchronously(@NlsContexts.DialogMessage @NotNull String progressTitle, boolean canBeCancelled, @NotNull Project project2, @NotNull Function0<? extends T> action2) {
        Intrinsics.checkNotNullParameter((Object)progressTitle, (String)"progressTitle");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        boolean $i$f$runProcessWithProgressSynchronously = false;
        return (T)ProgressManager.getInstance().runProcessWithProgressSynchronously(new ThrowableComputable(action2){
            final /* synthetic */ Function0<T> $action;
            {
                this.$action = $action;
            }

            public final T compute() {
                return (T)this.$action.invoke();
            }
        }, progressTitle, canBeCancelled, project2);
    }

    public static final void checkConflictsAndReplaceUsageInfos(@NotNull PsiElement element3, @NotNull Map<? extends PsiElement, String> allRenames, @NotNull List<UsageInfo> result2) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter(allRenames, (String)"allRenames");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        KtNamedFunction ktNamedFunction = CommonRenameUtilsKt.getOverriddenFunctionWithDefaultValues(element3, allRenames);
        if (ktNamedFunction != null) {
            KtNamedFunction baseFunction = ktNamedFunction;
            boolean bl = false;
            collection = result2;
            PsiElement psiElement2 = LightClassUtilsKt.getUnwrapped((PsiElement)element3);
            Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNamedFunction");
            collection.add(new LostDefaultValuesInOverridingFunctionUsageInfo((KtNamedFunction)psiElement2, baseFunction));
        }
        ListIterator<UsageInfo> usageIterator = result2.listIterator();
        while (usageIterator.hasNext()) {
            PsiElement referencedElement;
            PsiElement refElement2;
            AbstractKtReference ref;
            UsageInfo bl = usageIterator.next();
            MoveRenameUsageInfo moveRenameUsageInfo = bl instanceof MoveRenameUsageInfo ? (MoveRenameUsageInfo)bl : null;
            if (moveRenameUsageInfo == null) continue;
            MoveRenameUsageInfo usageInfo = moveRenameUsageInfo;
            collection = usageInfo.getReference();
            AbstractKtReference abstractKtReference = collection instanceof AbstractKtReference ? (AbstractKtReference)collection : null;
            if (abstractKtReference == null || (ref = abstractKtReference).canRename() || usageInfo.getElement() == null || usageInfo.getReferencedElement() == null) continue;
            usageIterator.set((UsageInfo)new UnresolvableConventionViolationUsageInfo(refElement2, referencedElement));
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static final KtNamedFunction getOverriddenFunctionWithDefaultValues(PsiElement $this$getOverriddenFunctionWithDefaultValues, Map<? extends PsiElement, String> allRenames) {
        Object element$iv;
        Object v2;
        boolean bl;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$mapNotNull$iv = allRenames.keySet();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo22 = false;
        Iterable $this$forEach$iv$iv$iv = iterable;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            PsiElement it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl2 = false;
            PsiElement it = (PsiElement)element$iv$iv;
            boolean bl3 = false;
            PsiElement psiElement2 = it;
            if ((psiElement2 != null ? LightClassUtilsKt.getUnwrapped((PsiElement)psiElement2) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List elementsToRename = (List)destination$iv$iv;
        PsiElement psiElement3 = LightClassUtilsKt.getUnwrapped((PsiElement)$this$getOverriddenFunctionWithDefaultValues);
        if (!(psiElement3 instanceof KtNamedFunction)) return null;
        KtNamedFunction ktNamedFunction = (KtNamedFunction)psiElement3;
        if (ktNamedFunction == null) {
            return null;
        }
        KtNamedFunction function2 = ktNamedFunction;
        List<PsiElement> overridenFunctions = KotlinRenameRefactoringSupport.Companion.getInstance().getAllOverridenFunctions(function2);
        Iterable iterable2 = overridenFunctions;
        boolean $i$f$filterIsInstance = false;
        Iterable $i$f$mapNotNullTo22 = iterable2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof KtNamedFunction)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        Iterable iterable3 = (List)destination$iv$iv2;
        boolean $i$f$firstOrNull = false;
        Iterator iterator3 = iterable3.iterator();
        do {
            if (!iterator3.hasNext()) {
                v2 = null;
                return v2;
            }
            element$iv = iterator3.next();
            KtNamedFunction it = (KtNamedFunction)element$iv;
            boolean bl5 = false;
            if (!elementsToRename.contains(it)) {
                boolean bl6;
                block10: {
                    List list2 = it.getValueParameters();
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getValueParameters(...)");
                    Iterable $this$any$iv = list2;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl6 = false;
                    } else {
                        for (Object element$iv2 : $this$any$iv) {
                            KtParameter it2 = (KtParameter)element$iv2;
                            boolean bl7 = false;
                            if (!it2.hasDefaultValue()) continue;
                            bl6 = true;
                            break block10;
                        }
                        bl6 = false;
                    }
                }
                if (bl6) {
                    bl = true;
                    continue;
                }
            }
            bl = false;
        } while (!bl);
        v2 = element$iv;
        return v2;
    }

    private static final void dropDefaultValue(KtParameter $this$dropDefaultValue) {
        PsiElement psiElement2 = $this$dropDefaultValue.getEqualsToken();
        if (psiElement2 == null) {
            return;
        }
        PsiElement from = psiElement2;
        KtExpression ktExpression = $this$dropDefaultValue.getDefaultValue();
        PsiElement to2 = ktExpression == null ? from : (PsiElement)ktExpression;
        $this$dropDefaultValue.deleteChildRange(from, to2);
    }

    private static final boolean isAbstract(KtNamedDeclaration $this$isAbstract) {
        boolean bl;
        if ($this$isAbstract.hasModifier(KtTokens.ABSTRACT_KEYWORD)) {
            bl = true;
        } else {
            KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)$this$isAbstract));
            KtClass ktClass2 = ktClassOrObject instanceof KtClass ? (KtClass)ktClassOrObject : null;
            boolean bl2 = ktClass2 != null ? ktClass2.isInterface() : false;
            bl = !bl2 ? false : ($this$isAbstract instanceof KtProperty ? ((KtProperty)$this$isAbstract).getInitializer() == null && ((KtProperty)$this$isAbstract).getDelegate() == null && ((KtProperty)$this$isAbstract).getAccessors().isEmpty() : ($this$isAbstract instanceof KtNamedFunction ? !((KtNamedFunction)$this$isAbstract).hasBody() : false));
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static final void checkSuperMethodsWithPopup(@NotNull KtNamedDeclaration declaration2, @NotNull List<? extends PsiElement> deepestSuperMethods2, @NotNull Editor editor2, @NotNull Function1<? super List<? extends PsiElement>, Unit> action2) {
        boolean bl;
        boolean hasJavaMethods;
        int kindIndex;
        String title;
        block15: {
            boolean bl2;
            List unwrappedSupers;
            block14: {
                void $this$mapNotNullTo$iv$iv;
                int n;
                Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                Intrinsics.checkNotNullParameter(deepestSuperMethods2, (String)"deepestSuperMethods");
                Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                Intrinsics.checkNotNullParameter(action2, (String)"action");
                if (deepestSuperMethods2.isEmpty()) {
                    action2.invoke((Object)CollectionsKt.listOf((Object)declaration2));
                    return;
                }
                String string = CommonRenameUtilsKt.getRenameBaseTitle(declaration2, deepestSuperMethods2);
                if (string == null) {
                    action2.invoke((Object)CollectionsKt.listOf((Object)declaration2));
                    return;
                }
                title = string;
                boolean $i$f$isUnitTestMode = false;
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    action2.invoke(deepestSuperMethods2);
                    return;
                }
                KtNamedDeclaration ktNamedDeclaration = declaration2;
                if (ktNamedDeclaration instanceof KtNamedFunction) {
                    n = 1;
                } else if (ktNamedDeclaration instanceof KtProperty ? true : ktNamedDeclaration instanceof KtParameter) {
                    n = 2;
                } else {
                    return;
                }
                kindIndex = n;
                Iterable $this$mapNotNull$iv = deepestSuperMethods2;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    PsiNamedElement it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl3 = false;
                    PsiElement it = (PsiElement)element$iv$iv;
                    boolean bl4 = false;
                    if (LightClassUtilsKt.getNamedUnwrappedElement((PsiElement)it) == null) continue;
                    boolean bl5 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                unwrappedSupers = (List)destination$iv$iv;
                Iterable $this$any$iv = unwrappedSupers;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        PsiNamedElement it = (PsiNamedElement)element$iv;
                        boolean bl6 = false;
                        if (!(it instanceof PsiMethod)) continue;
                        bl2 = true;
                        break block14;
                    }
                    bl2 = false;
                }
            }
            hasJavaMethods = bl2;
            Iterable $this$any$iv = unwrappedSupers;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PsiNamedElement it = (PsiNamedElement)element$iv;
                    boolean bl7 = false;
                    if (!(it instanceof KtNamedDeclaration)) continue;
                    bl = true;
                    break block15;
                }
                bl = false;
            }
        }
        boolean hasKtMembers = bl;
        int superKindIndex = hasJavaMethods && hasKtMembers ? 3 : (hasJavaMethods ? 4 : kindIndex);
        Object[] element$iv = new Object[]{superKindIndex + (deepestSuperMethods2.size() > 1 ? 10 : 0)};
        String renameBase = KotlinBundle.message((String)"rename.base.0", (Object[])element$iv);
        Object[] objectArray = new Object[]{kindIndex};
        String renameCurrent = KotlinBundle.message((String)"rename.only.current.0", (Object[])objectArray);
        objectArray = new String[]{renameBase, renameCurrent};
        JBPopupFactory.getInstance().createPopupChooserBuilder(CollectionsKt.listOf((Object[])objectArray)).setTitle(title).setMovable(false).setResizable(false).setRequestFocus(true).setItemChosenCallback(arg_0 -> CommonRenameUtilsKt.checkSuperMethodsWithPopup$lambda$7((Function1)new Function1<String, Unit>(renameBase, deepestSuperMethods2, declaration2, action2){
            final /* synthetic */ String $renameBase;
            final /* synthetic */ List<PsiElement> $deepestSuperMethods;
            final /* synthetic */ KtNamedDeclaration $declaration;
            final /* synthetic */ Function1<List<? extends PsiElement>, Unit> $action;
            {
                this.$renameBase = $renameBase;
                this.$deepestSuperMethods = $deepestSuperMethods;
                this.$declaration = $declaration;
                this.$action = $action;
                super(1);
            }

            public final void invoke(@Nullable String value2) {
                if (value2 == null) {
                    return;
                }
                List chosenElements = Intrinsics.areEqual((Object)value2, (Object)this.$renameBase) ? CollectionsKt.plus((Collection)this.$deepestSuperMethods, (Object)this.$declaration) : CollectionsKt.listOf((Object)this.$declaration);
                this.$action.invoke((Object)chosenElements);
            }
        }, arg_0)).createPopup().showInBestPositionFor(editor2);
    }

    @NotNull
    public static final List<PsiElement> checkSuperMethods(@NotNull KtNamedDeclaration declaration2, @NotNull List<? extends PsiElement> deepestSuperMethods2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter(deepestSuperMethods2, (String)"deepestSuperMethods");
        if (deepestSuperMethods2.isEmpty()) {
            return CollectionsKt.listOf((Object)declaration2);
        }
        String string = CommonRenameUtilsKt.getRenameBaseTitle(declaration2, deepestSuperMethods2);
        if (string == null) {
            return CollectionsKt.listOf((Object)declaration2);
        }
        String title = string;
        boolean $i$f$isUnitTestMode = false;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return deepestSuperMethods2;
        }
        int exitCode = Messages.showYesNoCancelDialog((Project)declaration2.getProject(), (String)title, (String)IdeBundle.message((String)"title.warning", (Object[])new Object[0]), (String)KotlinBundle.message((String)"button.rename.base", (Object[])new Object[0]), (String)KotlinBundle.message((String)"button.rename.current", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon());
        return switch (exitCode) {
            case 0 -> deepestSuperMethods2;
            case 1 -> CollectionsKt.listOf((Object)declaration2);
            default -> CollectionsKt.emptyList();
        };
    }

    private static final String getRenameBaseTitle(KtNamedDeclaration declaration2, List<? extends PsiElement> deepestSuperMethods2) {
        PsiElement superMethod = (PsiElement)CollectionsKt.first(deepestSuperMethods2);
        PsiElement psiElement2 = superMethod;
        Pair pair = psiElement2 instanceof PsiMember ? TuplesKt.to((Object)((PsiMember)superMethod).getContainingClass(), (Object)((PsiMember)superMethod).hasModifierProperty("abstract")) : (psiElement2 instanceof KtNamedDeclaration ? TuplesKt.to((Object)KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)superMethod)), (Object)CommonRenameUtilsKt.isAbstract((KtNamedDeclaration)superMethod)) : null);
        if (pair == null) {
            return null;
        }
        Pair pair2 = pair;
        PsiElement superClass = (PsiElement)pair2.component1();
        boolean isAbstract = (Boolean)pair2.component2();
        if (superClass == null) {
            return null;
        }
        Object[] objectArray = new Object[4];
        String string = declaration2.getName();
        if (string == null) {
            string = "";
        }
        objectArray[0] = string;
        objectArray[1] = isAbstract ? 1 : 2;
        Intrinsics.checkNotNullExpressionValue((Object)ElementDescriptionUtil.getElementDescription((PsiElement)superMethod, (ElementDescriptionLocation)((ElementDescriptionLocation)UsageViewTypeLocation.INSTANCE)), (String)"getElementDescription(...)");
        Intrinsics.checkNotNullExpressionValue((Object)SymbolPresentationUtil.getSymbolPresentableText((PsiElement)superClass), (String)"getSymbolPresentableText(...)");
        return KotlinBundle.message((String)"rename.declaration.title.0.implements.1.2.of.3", (Object[])objectArray);
    }

    private static final void checkSuperMethodsWithPopup$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$dropDefaultValue(KtParameter $receiver) {
        CommonRenameUtilsKt.dropDefaultValue($receiver);
    }
}

