/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.inline;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiReference;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiUtils;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.refactoring.KotlinCommonRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.inline.AbstractKotlinInlinePropertyDialog;
import org.jetbrains.kotlin.idea.refactoring.inline.AbstractKotlinInlinePropertyProcessor;
import org.jetbrains.kotlin.idea.refactoring.inline.KotlinInlineActionHandler;
import org.jetbrains.kotlin.idea.refactoring.inline.codeInliner.InlineUtilsKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J.\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H$J\"\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J$\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/inline/AbstractKotlinInlinePropertyHandler;", "Lorg/jetbrains/kotlin/idea/refactoring/inline/KotlinInlineActionHandler;", "withPrompt", "", "(Z)V", "helpId", "", "getHelpId", "()Ljava/lang/String;", "refactoringName", "getRefactoringName", "getWithPrompt", "()Z", "canInlineKotlinElement", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "createInlinePropertyDialog", "Lorg/jetbrains/kotlin/idea/refactoring/inline/AbstractKotlinInlinePropertyDialog;", "declaration", "Lorg/jetbrains/kotlin/psi/KtProperty;", "reference", "Lcom/intellij/psi/PsiReference;", "assignmentToDelete", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "editor", "Lcom/intellij/openapi/editor/Editor;", "inlineKotlinElement", "", "project", "Lcom/intellij/openapi/project/Project;", "performRefactoring", "kotlin.refactorings.common"})
@SourceDebugExtension(value={"SMAP\nAbstractKotlinInlinePropertyHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractKotlinInlinePropertyHandler.kt\norg/jetbrains/kotlin/idea/refactoring/inline/AbstractKotlinInlinePropertyHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n*L\n1#1,87:1\n1#2:88\n73#3:89\n*S KotlinDebug\n*F\n+ 1 AbstractKotlinInlinePropertyHandler.kt\norg/jetbrains/kotlin/idea/refactoring/inline/AbstractKotlinInlinePropertyHandler\n*L\n70#1:89\n*E\n"})
public abstract class AbstractKotlinInlinePropertyHandler
extends KotlinInlineActionHandler {
    private final boolean withPrompt;

    public AbstractKotlinInlinePropertyHandler(boolean withPrompt) {
        this.withPrompt = withPrompt;
    }

    public /* synthetic */ AbstractKotlinInlinePropertyHandler(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        this(bl);
    }

    protected final boolean getWithPrompt() {
        return this.withPrompt;
    }

    @Override
    @NotNull
    public String getHelpId() {
        return "refactoring.inlineVariable";
    }

    @Override
    @NotNull
    public String getRefactoringName() {
        return KotlinBundle.message((String)"title.inline.property", (Object[])new Object[0]);
    }

    @Override
    public boolean canInlineKotlinElement(@NotNull KtElement element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return element3 instanceof KtProperty && ((KtProperty)element3).getName() != null;
    }

    @Override
    public void inlineKotlinElement(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtElement element3) {
        KtPropertyAccessor setter;
        Object object;
        KtPropertyAccessor it;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        KtProperty declaration2 = (KtProperty)element3;
        if (!this.checkSources(project2, editor2, element3)) {
            return;
        }
        if (!((KtProperty)element3).hasBody()) {
            String message2;
            if (KotlinCommonRefactoringUtilKt.isAbstract((KtDeclaration)element3)) {
                var6_5 = new Object[]{this.getRefactoringName()};
                v0 = KotlinBundle.message((String)"refactoring.cannot.be.applied.to.abstract.declaration", (Object[])var6_5);
            } else if (KotlinPsiUtils.isExpectDeclaration((KtDeclaration)element3)) {
                var6_5 = new Object[]{this.getRefactoringName()};
                v0 = KotlinBundle.message((String)"refactoring.cannot.be.applied.to.expect.declaration", (Object[])var6_5);
            } else {
                v0 = message2 = null;
            }
            if (message2 != null) {
                this.showErrorHint(project2, editor2, message2);
                return;
            }
        }
        KtPropertyAccessor ktPropertyAccessor = declaration2.getGetter();
        if (ktPropertyAccessor != null) {
            KtPropertyAccessor ktPropertyAccessor2;
            it = ktPropertyAccessor2 = ktPropertyAccessor;
            boolean bl = false;
            object = it.hasBody() ? ktPropertyAccessor2 : null;
        } else {
            object = null;
        }
        KtPropertyAccessor getter = object;
        KtPropertyAccessor ktPropertyAccessor3 = declaration2.getSetter();
        if (ktPropertyAccessor3 != null) {
            KtPropertyAccessor it2 = it = ktPropertyAccessor3;
            boolean bl = false;
            v4 = it2.hasBody() ? it : null;
        } else {
            v4 = setter = null;
        }
        if ((getter != null || setter != null) && declaration2.getInitializer() != null) {
            this.showErrorHint(project2, editor2, KotlinBundle.message((String)"cannot.inline.property.with.accessor.s.and.backing.field", (Object[])new Object[0]));
            return;
        }
        KtBinaryExpression assignmentToDelete = null;
        if (getter == null && setter == null) {
            AbstractKotlinInlinePropertyProcessor.Initializer initializer2 = AbstractKotlinInlinePropertyProcessor.Companion.extractInitialization(declaration2).getInitializerOrShowErrorHint(project2, editor2);
            if (initializer2 == null) {
                return;
            }
            AbstractKotlinInlinePropertyProcessor.Initializer initializer3 = initializer2;
            assignmentToDelete = initializer3.getAssignment();
        }
        this.performRefactoring(declaration2, assignmentToDelete, editor2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void performRefactoring(KtProperty declaration2, KtBinaryExpression assignmentToDelete, Editor editor2) {
        Editor editor3 = editor2;
        PsiReference reference2 = editor3 != null ? InlineUtilsKt.findSimpleNameReference(editor3) : null;
        AbstractKotlinInlinePropertyDialog dialog2 = this.createInlinePropertyDialog(declaration2, reference2, assignmentToDelete, editor2);
        if (this.withPrompt) {
            boolean $i$f$isUnitTestMode = false;
            if (!ApplicationManager.getApplication().isUnitTestMode() && dialog2.shouldBeShown()) {
                dialog2.show();
                return;
            }
        }
        try {
            dialog2.doAction();
            return;
        }
        finally {
            dialog2.close(0, true);
        }
    }

    @NotNull
    protected abstract AbstractKotlinInlinePropertyDialog createInlinePropertyDialog(@NotNull KtProperty var1, @Nullable PsiReference var2, @Nullable KtBinaryExpression var3, @Nullable Editor var4);

    public AbstractKotlinInlinePropertyHandler() {
        this(false, 1, null);
    }
}

