/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.ReportingClassSubstitutor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.quickfix.QuickFixWithDelegateFactoryKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\f\u001a\u00020\bH\u0016J\f\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0016J\b\u0010\u000f\u001a\u00020\bH\u0016J%\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0096\u0002J\"\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\t\u001a\u00020\nH\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\b8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/QuickFixWithDelegateFactory;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "Lcom/intellij/openapi/diagnostic/ReportingClassSubstitutor;", "delegateFactory", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)V", "delegate", "familyName", "", "startInWriteAction", "", "text", "getFamilyName", "getSubstitutedClass", "Ljava/lang/Class;", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "isAvailable", "kotlin.idea"})
public class QuickFixWithDelegateFactory
implements IntentionAction,
ReportingClassSubstitutor {
    @Nullable
    private final IntentionAction delegate;
    @Nls
    @NotNull
    private final String familyName;
    @Nls
    @NotNull
    private final String text;
    private final boolean startInWriteAction;

    public QuickFixWithDelegateFactory(@NotNull Function0<? extends IntentionAction> delegateFactory) {
        Intrinsics.checkNotNullParameter(delegateFactory, (String)"delegateFactory");
        IntentionAction intentionAction = this.delegate = (IntentionAction)delegateFactory.invoke();
        String string = intentionAction != null ? intentionAction.getFamilyName() : null;
        if (string == null) {
            string = "";
        }
        this.familyName = string;
        IntentionAction intentionAction2 = this.delegate;
        String string2 = intentionAction2 != null ? intentionAction2.getText() : null;
        if (string2 == null) {
            string2 = "";
        }
        this.text = string2;
        this.startInWriteAction = this.delegate != null && this.delegate.startInWriteAction();
    }

    @NotNull
    public Class<?> getSubstitutedClass() {
        Object object = this.delegate;
        if (object == null || (object = object.getClass()) == null) {
            object = this.getClass();
        }
        return object;
    }

    @NotNull
    public String getFamilyName() {
        return this.familyName;
    }

    @NotNull
    public String getText() {
        return this.text;
    }

    public boolean isAvailable(@NotNull Project project2, @Nullable Editor editor2, @NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        IntentionAction intentionAction = this.delegate;
        return intentionAction != null ? intentionAction.isAvailable(project2, editor2, file2) : false;
    }

    public boolean startInWriteAction() {
        return this.startInWriteAction;
    }

    public void invoke(@NotNull Project project2, @Nullable Editor editor2, @Nullable PsiFile file2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
            return;
        }
        IntentionAction intentionAction = this.delegate;
        if (intentionAction == null) {
            return;
        }
        IntentionAction action2 = intentionAction;
        boolean bl2 = bl = QuickFixWithDelegateFactoryKt.detectPriority(action2) == QuickFixWithDelegateFactoryKt.detectPriority(this);
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Incorrect priority of QuickFixWithDelegateFactory wrapper for " + action2.getClass().getName();
            throw new AssertionError((Object)string);
        }
        action2.invoke(project2, editor2, file2);
    }
}

