/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.projectView;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.AbstractPsiBasedNode;
import com.intellij.ide.projectView.impl.nodes.FileNodeWithNestedFileNodes;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.decompiler.psi.file.KtClsFile;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtilKt;
import org.jetbrains.kotlin.idea.base.projectStructure.LibrarySourceScopeService;
import org.jetbrains.kotlin.idea.projectView.KtFileTreeNodeKt;
import org.jetbrains.kotlin.idea.projectView.KtInternalFileTreeNode;
import org.jetbrains.kotlin.idea.stubindex.KotlinFileFacadeFqNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinJvmNameAnnotationIndex;
import org.jetbrains.kotlin.load.kotlin.PackagePartClassUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFileAnnotationList;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B1\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0010\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\n\u00a2\u0006\u0002\u0010\fJ\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0014J\u0012\u0010\u001a\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\nH\u0014J\u0012\u0010\u001b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\nH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014R#\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u0018\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/projectView/KtInternalFileTreeNode;", "Lcom/intellij/ide/projectView/impl/nodes/AbstractPsiBasedNode;", "Lorg/jetbrains/kotlin/asJava/classes/KtLightClass;", "Lcom/intellij/ide/projectView/impl/nodes/FileNodeWithNestedFileNodes;", "project", "Lcom/intellij/openapi/project/Project;", "lightClass", "viewSettings", "Lcom/intellij/ide/projectView/ViewSettings;", "nestedFileNodes", "", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/asJava/classes/KtLightClass;Lcom/intellij/ide/projectView/ViewSettings;Ljava/util/Collection;)V", "navigatablePsiElement", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lorg/jetbrains/kotlin/psi/KtElement;", "getNavigatablePsiElement", "()Lcom/intellij/psi/SmartPsiElementPointer;", "navigatablePsiElement$delegate", "Lkotlin/Lazy;", "canRepresent", "", "element", "", "extractPsiFromValue", "Lcom/intellij/psi/PsiElement;", "getChildrenImpl", "getNestedFileNodes", "updateImpl", "", "data", "Lcom/intellij/ide/projectView/PresentationData;", "kotlin.base.project-structure"})
public final class KtInternalFileTreeNode
extends AbstractPsiBasedNode<KtLightClass>
implements FileNodeWithNestedFileNodes {
    @NotNull
    private final Collection<AbstractTreeNode<?>> nestedFileNodes;
    @NotNull
    private final Lazy navigatablePsiElement$delegate;

    public KtInternalFileTreeNode(@Nullable Project project2, @NotNull KtLightClass lightClass, @NotNull ViewSettings viewSettings, @NotNull Collection<? extends AbstractTreeNode<?>> nestedFileNodes) {
        Intrinsics.checkNotNullParameter((Object)lightClass, (String)"lightClass");
        Intrinsics.checkNotNullParameter((Object)viewSettings, (String)"viewSettings");
        Intrinsics.checkNotNullParameter(nestedFileNodes, (String)"nestedFileNodes");
        super(project2, (Object)lightClass, viewSettings);
        this.nestedFileNodes = nestedFileNodes;
        this.navigatablePsiElement$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SmartPsiElementPointer<KtElement>>(this){
            final /* synthetic */ KtInternalFileTreeNode this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final SmartPsiElementPointer<KtElement> invoke() {
                SmartPsiElementPointer smartPsiElementPointer;
                KtFile file2;
                KtFile ktFile2;
                KtLightClass ktLightClass = (KtLightClass)this.this$0.getValue();
                Object object = ktLightClass != null ? ktLightClass.getNavigationElement() : null;
                KtClsFile ktClsFile = object instanceof KtClsFile ? (KtClsFile)object : null;
                KtClsFile ktClsFile2 = ktClsFile;
                VirtualFile virtualFile2 = ktClsFile2 != null && (ktClsFile2 = ktClsFile2.getContainingFile()) != null ? ktClsFile2.getVirtualFile() : null;
                if (virtualFile2 == null) {
                    return null;
                }
                VirtualFile virtualFile3 = virtualFile2;
                Project prj = this.this$0.getProject();
                String string = virtualFile3.getNameWithoutExtension();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNameWithoutExtension(...)");
                String baseName = string;
                SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)prj);
                Intrinsics.checkNotNull((Object)prj);
                List<GlobalSearchScope> scopes2 = LibrarySourceScopeService.Companion.getInstance(prj).targetClassFilesToSourcesScopes(virtualFile3, prj);
                if (scopes2.isEmpty()) {
                    return null;
                }
                GlobalSearchScope globalSearchScope = GlobalSearchScope.union((Collection)scopes2);
                Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"union(...)");
                GlobalSearchScope scope2 = globalSearchScope;
                FqName originalPackageName = ktClsFile.getPackageFqName();
                SmartList filesFromFacade = new SmartList();
                KotlinJvmNameAnnotationIndex.Helper.processElements(StringsKt.substringBefore$default((String)baseName, (String)"__", null, (int)2, null), prj, scope2, arg_0 -> navigatablePsiElement.2.invoke$lambda$0((Function1)new Function1<KtAnnotationEntry, Boolean>((SmartList<KtFile>)filesFromFacade, originalPackageName){
                    final /* synthetic */ SmartList<KtFile> $filesFromFacade;
                    final /* synthetic */ FqName $originalPackageName;
                    {
                        this.$filesFromFacade = $filesFromFacade;
                        this.$originalPackageName = $originalPackageName;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(KtAnnotationEntry it) {
                        block1: {
                            ProgressManager.checkCanceled();
                            Intrinsics.checkNotNull((Object)it);
                            PsiElement $this$parentOfType_u24default$iv = (PsiElement)it;
                            boolean withSelf$iv = false;
                            boolean $i$f$parentOfType = false;
                            if (PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, KtFileAnnotationList.class, (boolean)true) == null) break block1;
                            KtFile ktFile2 = it.getContainingKtFile();
                            SmartList<KtFile> smartList = this.$originalPackageName;
                            KtFile ktFile3 = ktFile2;
                            boolean bl = false;
                            Object object = Intrinsics.areEqual((Object)ktFile3.getPackageFqName(), (Object)smartList) ? ktFile2 : null;
                            if (object != null) {
                                ktFile2 = object;
                                smartList = this.$filesFromFacade;
                                KtFile p0 = ktFile2;
                                boolean bl2 = false;
                                smartList.add((Object)p0);
                            }
                        }
                        return true;
                    }
                }, arg_0));
                String partShortName = StringsKt.substringAfter$default((String)baseName, (String)"__", null, (int)2, null);
                if (StringsKt.contains$default((CharSequence)baseName, (CharSequence)"__", (boolean)false, (int)2, null)) {
                    for (KtFile ktFile3 : filesFromFacade) {
                        Intrinsics.checkNotNull((Object)ktFile3);
                        if (!JvmFileClassUtilKt.isJvmMultifileClassFile((KtFile)ktFile3)) continue;
                        String string2 = ktFile3.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                        if (!Intrinsics.areEqual((Object)PackagePartClassUtils.getFilePartShortName((String)string2), (Object)partShortName)) continue;
                        return smartPointerManager.createSmartPsiElementPointer((PsiElement)ktFile3);
                    }
                }
                if ((ktFile2 = (KtFile)CollectionsKt.singleOrNull((List)((List)filesFromFacade))) == null) {
                    KtInternalFileTreeNode $this$invoke_u24lambda_u241 = this.this$0;
                    boolean bl = false;
                    FqName fqName2 = originalPackageName.child(Name.identifier((String)baseName));
                    Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"child(...)");
                    FqName fqName3 = fqName2;
                    String string3 = fqName3.asString();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"asString(...)");
                    ktFile2 = (KtFile)CollectionsKt.singleOrNull((Iterable)KotlinFileFacadeFqNameIndex.Helper.get(string3, prj, scope2));
                }
                KtFile ktFile4 = file2 = ktFile2;
                if (ktFile4 != null) {
                    KtFile ktFile5 = ktFile4;
                    Intrinsics.checkNotNull((Object)smartPointerManager);
                    SmartPointerManager smartPointerManager2 = smartPointerManager;
                    KtElement p0 = (KtElement)ktFile5;
                    boolean bl = false;
                    smartPsiElementPointer = smartPointerManager2.createSmartPsiElementPointer((PsiElement)p0);
                } else {
                    smartPsiElementPointer = null;
                }
                return smartPsiElementPointer;
            }

            private static final boolean invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (Boolean)$tmp0.invoke(p0);
            }
        }));
    }

    private final SmartPsiElementPointer<KtElement> getNavigatablePsiElement() {
        Lazy lazy = this.navigatablePsiElement$delegate;
        return (SmartPsiElementPointer)lazy.getValue();
    }

    @Nullable
    protected PsiElement extractPsiFromValue() {
        KtElement ktElement = this.getNavigatablePsiElement();
        return ktElement != null && (ktElement = (KtElement)ktElement.getElement()) != null ? (PsiElement)ktElement : (PsiElement)this.getValue();
    }

    @NotNull
    public Collection<AbstractTreeNode<?>> getNestedFileNodes() {
        return this.nestedFileNodes;
    }

    @NotNull
    protected Collection<AbstractTreeNode<?>> getChildrenImpl() {
        Collection<AbstractPsiBasedNode<? extends KtDeclaration>> members2;
        Collection<AbstractPsiBasedNode<? extends KtDeclaration>> collection;
        if (!this.getSettings().isShowMembers()) {
            return this.nestedFileNodes;
        }
        PsiElement psiElement2 = this.extractPsiFromValue();
        KtFile ktFile2 = psiElement2 instanceof KtFile ? (KtFile)psiElement2 : null;
        if (ktFile2 != null) {
            ViewSettings viewSettings = this.getSettings();
            Intrinsics.checkNotNullExpressionValue((Object)viewSettings, (String)"getSettings(...)");
            collection = KtFileTreeNodeKt.toDeclarationsNodes(ktFile2, viewSettings);
        } else {
            collection = null;
        }
        Collection<AbstractPsiBasedNode<? extends KtDeclaration>> collection2 = members2 = collection;
        return collection2 == null || collection2.isEmpty() ? this.nestedFileNodes : (Collection)CollectionsKt.plus(this.nestedFileNodes, (Iterable)members2);
    }

    public boolean canRepresent(@Nullable Object element3) {
        if (super.canRepresent(element3)) {
            return true;
        }
        PsiElement value2 = this.extractPsiFromValue();
        PsiElement psiElement2 = element3 instanceof PsiElement ? (PsiElement)element3 : null;
        VirtualFile elementVirtualFile = psiElement2 != null && (psiElement2 = psiElement2.getNavigationElement()) != null && (psiElement2 = psiElement2.getContainingFile()) != null ? psiElement2.getVirtualFile() : null;
        PsiElement psiElement3 = value2;
        VirtualFile virtualFile2 = psiElement3 != null && (psiElement3 = psiElement3.getContainingFile()) != null ? psiElement3.getVirtualFile() : null;
        return Intrinsics.areEqual((Object)elementVirtualFile, (Object)virtualFile2);
    }

    protected void updateImpl(@NotNull PresentationData data) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            KtLightClass ktLightClass = (KtLightClass)this.getValue();
            if (ktLightClass == null) break block0;
            KtLightClass it = ktLightClass;
            boolean bl = false;
            data.setPresentableText(it.getName());
        }
    }
}

