/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.refactoring.move.ui;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.RowLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KMutableProperty0;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.core.PackageUtilsKt;
import org.jetbrains.kotlin.idea.k2.refactoring.move.descriptor.K2MoveDescriptor;
import org.jetbrains.kotlin.idea.k2.refactoring.move.descriptor.K2MoveSourceDescriptor;
import org.jetbrains.kotlin.idea.k2.refactoring.move.descriptor.K2MoveTargetDescriptor;
import org.jetbrains.kotlin.idea.k2.refactoring.move.ui.K2MoveSourceModel;
import org.jetbrains.kotlin.idea.k2.refactoring.move.ui.K2MoveTargetModel;
import org.jetbrains.kotlin.idea.k2.refactoring.move.ui.MoveUiUtilKt;
import org.jetbrains.kotlin.idea.refactoring.KotlinCommonRefactoringSettings;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u001e2\u00020\u0001:\u0004\u001e\u001f !B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u001b\u001a\u00020\u0004J\b\u0010\u001c\u001a\u00020\u001dH&R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0011\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u0016\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0012\u0010\u0017\u001a\u00020\u0018X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u0082\u0001\u0002\"#\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel;", "", "()V", "inSourceRoot", "", "getInSourceRoot", "()Z", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "searchForText", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel$Setting;", "getSearchForText", "()Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel$Setting;", "searchInComments", "getSearchInComments", "searchReferences", "getSearchReferences", "source", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveSourceModel;", "getSource", "()Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveSourceModel;", "target", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveTargetModel;", "getTarget", "()Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveTargetModel;", "isValidRefactoring", "toDescriptor", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveDescriptor;", "Companion", "Declarations", "Files", "Setting", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel$Declarations;", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel$Files;", "kotlin.refactorings.move.k2"})
@SourceDebugExtension(value={"SMAP\nK2MoveModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 K2MoveModel.kt\norg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,274:1\n1549#2:275\n1620#2,3:276\n*S KotlinDebug\n*F\n+ 1 K2MoveModel.kt\norg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel\n*L\n58#1:275\n58#1:276,3\n*E\n"})
public abstract class K2MoveModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Setting searchForText = Setting.SEARCH_FOR_TEXT;
    @NotNull
    private final Setting searchInComments = Setting.SEARCH_IN_COMMENTS;
    @NotNull
    private final Setting searchReferences = Setting.SEARCH_REFERENCES;

    private K2MoveModel() {
    }

    @NotNull
    public abstract Project getProject();

    @NotNull
    public abstract K2MoveSourceModel<?> getSource();

    @NotNull
    public abstract K2MoveTargetModel getTarget();

    @NotNull
    public final Setting getSearchForText() {
        return this.searchForText;
    }

    @NotNull
    public final Setting getSearchInComments() {
        return this.searchInComments;
    }

    public abstract boolean getInSourceRoot();

    @NotNull
    public final Setting getSearchReferences() {
        return this.searchReferences;
    }

    @NotNull
    public abstract K2MoveDescriptor toDescriptor();

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isValidRefactoring() {
        void $this$mapTo$iv$iv;
        if (this.getSource().getElements().isEmpty()) {
            return false;
        }
        if (this.getTarget() instanceof K2MoveTargetModel.File) {
            K2MoveTargetModel k2MoveTargetModel = this.getTarget();
            Intrinsics.checkNotNull((Object)k2MoveTargetModel, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.idea.k2.refactoring.move.ui.K2MoveTargetModel.File");
            if (!MoveUiUtilKt.isValidKotlinFile(((K2MoveTargetModel.File)k2MoveTargetModel).getFileName())) {
                return false;
            }
        }
        Iterable $this$map$iv = this.getSource().getElements();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PsiElement psiElement2 = (PsiElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getContainingFile());
        }
        Set files2 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        if (files2.size() != 1) return true;
        Object object = CollectionsKt.single((Iterable)files2);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        if (K2MoveModel.isValidRefactoring$isTargetFile((KtFile)object, this)) return false;
        return true;
    }

    private static final boolean isValidRefactoring$isTargetFile(KtFile $this$isValidRefactoring_u24isTargetFile, K2MoveModel this$0) {
        boolean bl;
        K2MoveTargetModel k2MoveTargetModel = this$0.getTarget();
        K2MoveTargetModel.File file2 = k2MoveTargetModel instanceof K2MoveTargetModel.File ? (K2MoveTargetModel.File)k2MoveTargetModel : null;
        if (file2 != null) {
            K2MoveTargetModel.File fileTarget = file2;
            boolean bl2 = false;
            bl = Intrinsics.areEqual((Object)$this$isValidRefactoring_u24isTargetFile.getContainingDirectory(), (Object)fileTarget.getDirectory()) && Intrinsics.areEqual((Object)$this$isValidRefactoring_u24isTargetFile.getPackageFqName(), (Object)fileTarget.getPkgName()) && Intrinsics.areEqual((Object)$this$isValidRefactoring_u24isTargetFile.getName(), (Object)fileTarget.getFileName());
        } else {
            bl = false;
        }
        return bl;
    }

    public /* synthetic */ K2MoveModel(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J3\u0010\u0007\u001a\u0004\u0018\u00010\b2\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n2\b\u0010\f\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fJ \u0010\u0010\u001a\u0010\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00120\u00120\u0011*\b\u0012\u0004\u0012\u00020\u000b0\u0011H\u0002R\u0014\u0010\u0003\u001a\u00020\u00048CX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel$Companion;", "", "()V", "MOVE_DECLARATIONS", "", "getMOVE_DECLARATIONS", "()Ljava/lang/String;", "create", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel;", "elements", "", "Lcom/intellij/psi/PsiElement;", "targetContainer", "editor", "Lcom/intellij/openapi/editor/Editor;", "([Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/editor/Editor;)Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel;", "fileElements", "", "Lcom/intellij/psi/PsiFileSystemItem;", "kotlin.jvm.PlatformType", "kotlin.refactorings.move.k2"})
    @SourceDebugExtension(value={"SMAP\nK2MoveModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 K2MoveModel.kt\norg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 5 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,274:1\n1549#2:275\n1620#2,3:276\n1747#2,2:282\n1749#2:285\n1747#2,3:286\n1747#2,3:289\n288#2,2:292\n1360#2:296\n1446#2,2:297\n800#2,11:299\n1448#2,3:310\n1747#2,3:313\n1726#2,3:316\n3792#3:279\n4307#3,2:280\n67#4:284\n20#5,2:294\n*S KotlinDebug\n*F\n+ 1 K2MoveModel.kt\norg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel$Companion\n*L\n162#1:275\n162#1:276,3\n201#1:282,2\n201#1:285\n209#1:286,3\n221#1:289,3\n237#1:292,2\n246#1:296\n246#1:297,2\n248#1:299,11\n246#1:310,3\n183#1:313,3\n189#1:316,3\n171#1:279\n171#1:280,2\n201#1:284\n240#1:294,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nls
        private final String getMOVE_DECLARATIONS() {
            return KotlinBundle.message((String)"text.move.declarations", (Object[])new Object[0]);
        }

        /*
         * WARNING - void declaration
         */
        private final List<PsiFileSystemItem> fileElements(List<? extends PsiElement> $this$fileElements) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = $this$fileElements;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PsiElement psiElement2 = (PsiElement)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it instanceof PsiDirectory ? (PsiFileSystemItem)it : (PsiFileSystemItem)it.getContainingFile());
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final K2MoveModel create(@NotNull PsiElement[] elements2, @Nullable PsiElement targetContainer, @Nullable Editor editor2) {
            K2MoveModel k2MoveModel;
            boolean bl;
            String message2;
            boolean $i$f$any;
            Iterable $this$any$iv;
            List elementsToMove;
            PsiElement psiElement2;
            PsiElement project2;
            block44: {
                boolean bl2;
                block43: {
                    Iterator $this$filterTo$iv$iv;
                    Intrinsics.checkNotNullParameter((Object)elements2, (String)"elements");
                    PsiElement psiElement3 = (PsiElement)ArraysKt.firstOrNull((Object[])elements2);
                    if (psiElement3 == null || (psiElement3 = psiElement3.getProject()) == null) {
                        throw new IllegalStateException("Elements not part of project".toString());
                    }
                    project2 = psiElement3;
                    PsiElement[] $this$filter$iv = elements2;
                    boolean $i$f$filter = false;
                    PsiElement[] psiElementArray = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    int n = ((void)$this$filterTo$iv$iv).length;
                    for (int j = 0; j < n; ++j) {
                        boolean bl3;
                        void element$iv$iv;
                        void elem = element$iv$iv = $this$filterTo$iv$iv[j];
                        boolean bl4 = false;
                        void var16_42 = elem;
                        if (var16_42 instanceof PsiDirectory ? true : var16_42 instanceof PsiFile) {
                            bl3 = true;
                        } else {
                            PsiElement container;
                            psiElement2 = new PsiElement[]{Reflection.getOrCreateKotlinClass(PsiFile.class), Reflection.getOrCreateKotlinClass(KtNamedDeclaration.class)};
                            if (PsiTreeUtilKt.parentOfTypes$default((PsiElement)elem, (KClass[])psiElement2, (boolean)false, (int)2, null) == null) {
                                throw new IllegalStateException("Element not in Kotlin file".toString());
                            }
                            bl3 = !ArraysKt.contains((Object[])elements2, (Object)container);
                        }
                        if (!bl3) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    elementsToMove = (List)destination$iv$iv;
                    $this$any$iv = elementsToMove;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            void $this$parentOfType$iv;
                            PsiElement it = (PsiElement)element$iv;
                            boolean bl5 = false;
                            PsiElement psiElement4 = it;
                            boolean withSelf$iv = false;
                            boolean $i$f$parentOfType = false;
                            boolean bl6 = PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, KtNamedDeclaration.class, (boolean)true) != null;
                            if (!bl6) continue;
                            bl2 = true;
                            break block43;
                        }
                        bl2 = false;
                    }
                }
                if (bl2) {
                    message2 = RefactoringBundle.getCannotRefactorMessage((String)KotlinBundle.message((String)"text.move.declaration.no.support.for.nested.declarations", (Object[])new Object[0]));
                    CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor2, (String)message2, (String)this.getMOVE_DECLARATIONS(), null);
                    return null;
                }
                $this$any$iv = elementsToMove;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        PsiElement it = (PsiElement)element$iv;
                        boolean bl7 = false;
                        if (!(it instanceof KtEnumEntry)) continue;
                        bl = true;
                        break block44;
                    }
                    bl = false;
                }
            }
            if (bl) {
                message2 = RefactoringBundle.getCannotRefactorMessage((String)KotlinBundle.message((String)"text.move.declaration.no.support.for.enums", (Object[])new Object[0]));
                CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor2, (String)message2, (String)this.getMOVE_DECLARATIONS(), null);
                return null;
            }
            if (org.jetbrains.kotlin.idea.k2.refactoring.move.ui.K2MoveModel$Companion.create$isMultiFileMove(elementsToMove) && targetContainer != null && !(targetContainer instanceof PsiDirectory)) {
                message2 = RefactoringBundle.getCannotRefactorMessage((String)KotlinBundle.message((String)"text.move.file.no.support.for.file.target", (Object[])new Object[0]));
                CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor2, (String)message2, (String)this.getMOVE_DECLARATIONS(), null);
                return null;
            }
            if (org.jetbrains.kotlin.idea.k2.refactoring.move.ui.K2MoveModel$Companion.create$isMultiFileMove(elementsToMove)) {
                boolean bl8;
                block45: {
                    $this$any$iv = elementsToMove;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl8 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            PsiElement it = (PsiElement)element$iv;
                            boolean bl9 = false;
                            if (!(it instanceof KtNamedDeclaration && !org.jetbrains.kotlin.idea.k2.refactoring.move.ui.K2MoveModel$Companion.create$isSingleClassContainer(it))) continue;
                            bl8 = true;
                            break block45;
                        }
                        bl8 = false;
                    }
                }
                if (bl8) {
                    message2 = RefactoringBundle.getCannotRefactorMessage((String)KotlinBundle.message((String)"text.move.declaration.no.support.for.multi.file", (Object[])new Object[0]));
                    CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor2, (String)message2, (String)this.getMOVE_DECLARATIONS(), null);
                    return null;
                }
            }
            boolean inSourceRoot = org.jetbrains.kotlin.idea.k2.refactoring.move.ui.K2MoveModel$Companion.create$inSourceRoot((Project)project2, targetContainer, elementsToMove);
            if (targetContainer instanceof PsiDirectory || org.jetbrains.kotlin.idea.k2.refactoring.move.ui.K2MoveModel$Companion.create$isMultiFileMove(elementsToMove)) {
                K2MoveTargetModel.SourceDirectory sourceDirectory;
                K2MoveSourceModel.FileSource source = new K2MoveSourceModel.FileSource(CollectionsKt.toSet((Iterable)this.fileElements(elementsToMove)));
                if (targetContainer instanceof PsiDirectory) {
                    FqName pkg = PackageUtilsKt.getFqNameWithImplicitPrefixOrRoot((PsiDirectory)targetContainer);
                    sourceDirectory = new K2MoveTargetModel.SourceDirectory(pkg, (PsiDirectory)targetContainer);
                } else {
                    KtFile ktFile2;
                    Object v11;
                    PsiDirectory directory;
                    block47: {
                        PsiFile it;
                        Object v7;
                        block46: {
                            Iterable $this$firstOrNull$iv = elementsToMove;
                            boolean $i$f$firstOrNull = false;
                            for (Object element$iv : $this$firstOrNull$iv) {
                                PsiElement it2 = (PsiElement)element$iv;
                                boolean bl10 = false;
                                if (!(it2.getContainingFile() != null)) continue;
                                v7 = element$iv;
                                break block46;
                            }
                            v7 = null;
                        }
                        PsiElement psiElement5 = v7;
                        Object object = it = psiElement5 != null ? psiElement5.getContainingFile() : null;
                        if (it == null) {
                            throw new IllegalStateException("No default target found".toString());
                        }
                        PsiFile file2 = it;
                        PsiDirectory psiDirectory = file2.getContainingDirectory();
                        if (psiDirectory == null) {
                            throw new IllegalStateException("No default target found".toString());
                        }
                        directory = psiDirectory;
                        Iterable $this$firstIsInstanceOrNull$iv = elementsToMove;
                        boolean $i$f$firstIsInstanceOrNull = false;
                        for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                            if (!(element$iv instanceof KtFile)) continue;
                            v11 = element$iv;
                            break block47;
                        }
                        v11 = null;
                    }
                    if ((ktFile2 = (KtFile)v11) == null || (ktFile2 = ktFile2.getContainingKtFile()) == null || (ktFile2 = ktFile2.getPackageFqName()) == null) {
                        ktFile2 = FqName.ROOT;
                    }
                    KtFile pkgName = ktFile2;
                    Intrinsics.checkNotNull((Object)pkgName);
                    sourceDirectory = new K2MoveTargetModel.SourceDirectory((FqName)pkgName, directory);
                }
                K2MoveTargetModel.SourceDirectory target2 = sourceDirectory;
                k2MoveModel = new Files((Project)project2, source, target2, inSourceRoot);
            } else if (targetContainer instanceof KtFile || org.jetbrains.kotlin.idea.k2.refactoring.move.ui.K2MoveModel$Companion.create$isSingleClassContainer(targetContainer) || org.jetbrains.kotlin.idea.k2.refactoring.move.ui.K2MoveModel$Companion.create$isSingleFileMove(elementsToMove)) {
                K2MoveTargetModel.File file3;
                PsiFile targetFile2;
                void $this$flatMapTo$iv$iv;
                Iterable $this$flatMap$iv = elementsToMove;
                boolean $i$f$flatMap = false;
                Iterable directory = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    List list2;
                    PsiElement elem = (PsiElement)element$iv$iv;
                    boolean bl11 = false;
                    psiElement2 = elem;
                    if (psiElement2 instanceof KtFile) {
                        void $this$filterIsInstanceTo$iv$iv;
                        Iterable $this$filterIsInstance$iv = ((KtFile)elem).getDeclarations();
                        boolean $i$f$filterIsInstance = false;
                        Iterable iterable = $this$filterIsInstance$iv;
                        Collection destination$iv$iv2 = new ArrayList();
                        boolean $i$f$filterIsInstanceTo = false;
                        for (Object element$iv$iv2 : $this$filterIsInstanceTo$iv$iv) {
                            if (!(element$iv$iv2 instanceof KtNamedDeclaration)) continue;
                            destination$iv$iv2.add(element$iv$iv2);
                        }
                        list2 = (List)destination$iv$iv2;
                    } else if (psiElement2 instanceof KtNamedDeclaration) {
                        list2 = CollectionsKt.listOf((Object)elem);
                    } else {
                        throw new IllegalStateException("Element to move should be a file or declaration".toString());
                    }
                    Iterable list$iv$iv = list2;
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                Set elementsFromFiles = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                K2MoveSourceModel.ElementSource source = new K2MoveSourceModel.ElementSource(elementsFromFiles);
                PsiElement psiElement6 = targetContainer;
                Object object = targetFile2 = psiElement6 != null ? psiElement6.getContainingFile() : null;
                if (targetFile2 instanceof KtFile) {
                    file3 = K2MoveTargetModel.Companion.File((KtFile)targetFile2);
                } else {
                    Object object2;
                    KtElement firstElem;
                    Object object3 = CollectionsKt.firstOrNull((List)elementsToMove);
                    Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtElement");
                    KtElement element$iv$iv = firstElem = (KtElement)object3;
                    if (element$iv$iv instanceof KtFile) {
                        object2 = ((KtFile)firstElem).getName();
                    } else if (element$iv$iv instanceof KtNamedDeclaration) {
                        LanguageFileType languageFileType = KotlinLanguage.INSTANCE.getAssociatedFileType();
                        object2 = ((KtNamedDeclaration)firstElem).getName() + "." + (languageFileType != null ? languageFileType.getDefaultExtension() : null);
                    } else {
                        throw new IllegalStateException("Element to move should be a file or declaration".toString());
                    }
                    Object $this$firstIsInstanceOrNull$iv = object2;
                    Intrinsics.checkNotNull((Object)$this$firstIsInstanceOrNull$iv);
                    Object fileName = $this$firstIsInstanceOrNull$iv;
                    KtFile ktFile3 = firstElem.getContainingKtFile();
                    Intrinsics.checkNotNullExpressionValue((Object)ktFile3, (String)"getContainingKtFile(...)");
                    KtFile containingFile = ktFile3;
                    PsiDirectory psiDirectory = containingFile.getContainingDirectory();
                    if (psiDirectory == null) {
                        throw new IllegalStateException("No directory found".toString());
                    }
                    PsiDirectory psiDirectory2 = psiDirectory;
                    file3 = new K2MoveTargetModel.File((String)fileName, containingFile.getPackageFqName(), psiDirectory2);
                }
                K2MoveTargetModel.File target3 = file3;
                k2MoveModel = new Declarations((Project)project2, source, target3, inSourceRoot);
            } else {
                throw new IllegalStateException("Unsupported move operation".toString());
            }
            return k2MoveModel;
        }

        public static /* synthetic */ K2MoveModel create$default(Companion companion, PsiElement[] psiElementArray, PsiElement psiElement2, Editor editor2, int n, Object object) {
            if ((n & 4) != 0) {
                editor2 = null;
            }
            return companion.create(psiElementArray, psiElement2, editor2);
        }

        private static final boolean create$inSourceRoot(Project project2, PsiElement $targetContainer, List<? extends PsiElement> declarations2) {
            boolean bl;
            ProjectFileIndex fileIndex2;
            block6: {
                ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)project2);
                Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getInstance(...)");
                fileIndex2 = projectFileIndex;
                Iterable $this$any$iv = CollectionsKt.toSet((Iterable)Companion.fileElements(declarations2));
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        PsiFileSystemItem it = (PsiFileSystemItem)element$iv;
                        boolean bl2 = false;
                        if (!(!fileIndex2.isInSourceContent(it.getVirtualFile()))) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return false;
            }
            if ($targetContainer == null || $targetContainer instanceof PsiDirectory) {
                return true;
            }
            PsiFile psiFile2 = $targetContainer.getContainingFile();
            Object object = psiFile2 != null ? psiFile2.getVirtualFile() : null;
            if (object == null) {
                return false;
            }
            VirtualFile targetFile2 = object;
            return fileIndex2.isInSourceContent(targetFile2);
        }

        private static final boolean create$isSingleFileMove(List<? extends PsiElement> movedElements) {
            boolean bl;
            block3: {
                Iterable $this$all$iv = movedElements;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        PsiElement it = (PsiElement)element$iv;
                        boolean bl2 = false;
                        if (it instanceof KtNamedDeclaration) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
            }
            return bl || CollectionsKt.singleOrNull(movedElements) instanceof KtFile;
        }

        private static final boolean create$isMultiFileMove(List<? extends PsiElement> movedElements) {
            return CollectionsKt.toSet((Iterable)Companion.fileElements(movedElements)).size() > 1;
        }

        private static final boolean create$isSingleClassContainer(PsiElement $this$create_u24isSingleClassContainer) {
            if (!($this$create_u24isSingleClassContainer instanceof KtClassOrObject)) {
                return false;
            }
            PsiElement psiElement2 = ((KtClassOrObject)$this$create_u24isSingleClassContainer).getParent();
            KtFile ktFile2 = psiElement2 instanceof KtFile ? (KtFile)psiElement2 : null;
            if (ktFile2 == null) {
                return false;
            }
            KtFile file2 = ktFile2;
            return Intrinsics.areEqual((Object)$this$create_u24isSingleClassContainer, (Object)CollectionsKt.singleOrNull((List)file2.getDeclarations()));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel$Declarations;", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel;", "project", "Lcom/intellij/openapi/project/Project;", "source", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveSourceModel$ElementSource;", "target", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveTargetModel$File;", "inSourceRoot", "", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveSourceModel$ElementSource;Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveTargetModel$File;Z)V", "getInSourceRoot", "()Z", "getProject", "()Lcom/intellij/openapi/project/Project;", "getSource", "()Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveSourceModel$ElementSource;", "getTarget", "()Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveTargetModel$File;", "toDescriptor", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveDescriptor;", "kotlin.refactorings.move.k2"})
    public static final class Declarations
    extends K2MoveModel {
        @NotNull
        private final Project project;
        @NotNull
        private final K2MoveSourceModel.ElementSource source;
        @NotNull
        private final K2MoveTargetModel.File target;
        private final boolean inSourceRoot;

        public Declarations(@NotNull Project project2, @NotNull K2MoveSourceModel.ElementSource source, @NotNull K2MoveTargetModel.File target2, boolean inSourceRoot) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
            super(null);
            this.project = project2;
            this.source = source;
            this.target = target2;
            this.inSourceRoot = inSourceRoot;
        }

        @Override
        @NotNull
        public Project getProject() {
            return this.project;
        }

        @NotNull
        public K2MoveSourceModel.ElementSource getSource() {
            return this.source;
        }

        @Override
        @NotNull
        public K2MoveTargetModel.File getTarget() {
            return this.target;
        }

        @Override
        public boolean getInSourceRoot() {
            return this.inSourceRoot;
        }

        @Override
        @NotNull
        public K2MoveDescriptor toDescriptor() {
            K2MoveSourceDescriptor.ElementSource srcDescr = this.getSource().toDescriptor();
            K2MoveTargetDescriptor.File targetDescr = this.getTarget().toDescriptor();
            boolean searchReferences2 = this.getInSourceRoot() ? this.getSearchReferences().getState() : false;
            return new K2MoveDescriptor.Declarations(this.getProject(), srcDescr, targetDescr, this.getSearchForText().getState(), searchReferences2, this.getSearchInComments().getState());
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel$Files;", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel;", "project", "Lcom/intellij/openapi/project/Project;", "source", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveSourceModel$FileSource;", "target", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveTargetModel$SourceDirectory;", "inSourceRoot", "", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveSourceModel$FileSource;Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveTargetModel$SourceDirectory;Z)V", "getInSourceRoot", "()Z", "getProject", "()Lcom/intellij/openapi/project/Project;", "getSource", "()Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveSourceModel$FileSource;", "getTarget", "()Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveTargetModel$SourceDirectory;", "toDescriptor", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveDescriptor;", "kotlin.refactorings.move.k2"})
    public static final class Files
    extends K2MoveModel {
        @NotNull
        private final Project project;
        @NotNull
        private final K2MoveSourceModel.FileSource source;
        @NotNull
        private final K2MoveTargetModel.SourceDirectory target;
        private final boolean inSourceRoot;

        public Files(@NotNull Project project2, @NotNull K2MoveSourceModel.FileSource source, @NotNull K2MoveTargetModel.SourceDirectory target2, boolean inSourceRoot) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
            super(null);
            this.project = project2;
            this.source = source;
            this.target = target2;
            this.inSourceRoot = inSourceRoot;
        }

        @Override
        @NotNull
        public Project getProject() {
            return this.project;
        }

        @NotNull
        public K2MoveSourceModel.FileSource getSource() {
            return this.source;
        }

        @Override
        @NotNull
        public K2MoveTargetModel.SourceDirectory getTarget() {
            return this.target;
        }

        @Override
        public boolean getInSourceRoot() {
            return this.inSourceRoot;
        }

        @Override
        @NotNull
        public K2MoveDescriptor toDescriptor() {
            K2MoveSourceDescriptor.FileSource srcDescr = this.getSource().toDescriptor();
            K2MoveTargetDescriptor.SourceDirectory targetDescr = this.getTarget().toDescriptor();
            boolean searchReferences2 = this.getInSourceRoot() ? this.getSearchReferences().getState() : false;
            return new K2MoveDescriptor.Files(this.getProject(), srcDescr, targetDescr, this.getSearchForText().getState(), searchReferences2, this.getSearchInComments().getState());
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0014\b\u0002\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u0018\u0010\u0006\u001a\u00020\u0007X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0013\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel$Setting;", "", "text", "", "Lcom/intellij/openapi/util/NlsContexts$Checkbox;", "(Ljava/lang/String;ILjava/lang/String;)V", "state", "", "getState", "()Z", "setState", "(Z)V", "createComboBox", "", "panel", "Lcom/intellij/ui/dsl/builder/Panel;", "SEARCH_FOR_TEXT", "SEARCH_IN_COMMENTS", "SEARCH_REFERENCES", "kotlin.refactorings.move.k2"})
    public static final abstract class Setting
    extends Enum<Setting> {
        @NotNull
        private final String text;
        public static final /* enum */ Setting SEARCH_FOR_TEXT = new SEARCH_FOR_TEXT("SEARCH_FOR_TEXT", 0);
        public static final /* enum */ Setting SEARCH_IN_COMMENTS = new SEARCH_IN_COMMENTS("SEARCH_IN_COMMENTS", 1);
        public static final /* enum */ Setting SEARCH_REFERENCES = new SEARCH_REFERENCES("SEARCH_REFERENCES", 2);
        private static final /* synthetic */ Setting[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Setting(String text2) {
            this.text = text2;
        }

        public abstract boolean getState();

        public abstract void setState(boolean var1);

        public final void createComboBox(@NotNull Panel panel2) {
            Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
            Panel.row$default((Panel)panel2, null, (Function1)((Function1)new Function1<Row, Unit>(this){
                final /* synthetic */ Setting this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull Row $this$row) {
                    Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                    ButtonKt.bindSelected((Cell)$this$row.checkBox(Setting.access$getText$p(this.this$0)), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)((Object)this.this$0)){

                        @Nullable
                        public Object get() {
                            return ((Setting)((Object)this.receiver)).getState();
                        }

                        public void set(@Nullable Object value2) {
                            ((Setting)((Object)this.receiver)).setState((Boolean)value2);
                        }
                    }));
                }
            }), (int)1, null).layout(RowLayout.PARENT_GRID);
        }

        public static Setting[] values() {
            return (Setting[])$VALUES.clone();
        }

        public static Setting valueOf(String value2) {
            return Enum.valueOf(Setting.class, value2);
        }

        @NotNull
        public static EnumEntries<Setting> getEntries() {
            return $ENTRIES;
        }

        public static final /* synthetic */ String access$getText$p(Setting $this) {
            return $this.text;
        }

        public /* synthetic */ Setting(String $enum$name, int $enum$ordinal, String text2, DefaultConstructorMarker $constructor_marker) {
            this(text2);
        }

        static {
            $VALUES = settingArray = new Setting[]{Setting.SEARCH_FOR_TEXT, Setting.SEARCH_IN_COMMENTS, Setting.SEARCH_REFERENCES};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c6\u0001\u0018\u00002\u00020\u0001R$\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00038V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel$Setting$SEARCH_FOR_TEXT;", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel$Setting;", "value", "", "state", "getState", "()Z", "setState", "(Z)V", "kotlin.refactorings.move.k2"})
        static final class SEARCH_FOR_TEXT
        extends Setting {
            /*
             * WARNING - void declaration
             */
            SEARCH_FOR_TEXT() {
                void var1_1;
            }

            @Override
            public boolean getState() {
                return KotlinCommonRefactoringSettings.Companion.getInstance().getMOVE_SEARCH_FOR_TEXT();
            }

            @Override
            public void setState(boolean value2) {
                KotlinCommonRefactoringSettings.Companion.getInstance().setMOVE_SEARCH_FOR_TEXT(value2);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c6\u0001\u0018\u00002\u00020\u0001R$\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00038V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel$Setting$SEARCH_IN_COMMENTS;", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel$Setting;", "value", "", "state", "getState", "()Z", "setState", "(Z)V", "kotlin.refactorings.move.k2"})
        static final class SEARCH_IN_COMMENTS
        extends Setting {
            /*
             * WARNING - void declaration
             */
            SEARCH_IN_COMMENTS() {
                void var1_1;
            }

            @Override
            public boolean getState() {
                return KotlinCommonRefactoringSettings.Companion.getInstance().getMOVE_SEARCH_IN_COMMENTS();
            }

            @Override
            public void setState(boolean value2) {
                KotlinCommonRefactoringSettings.Companion.getInstance().setMOVE_SEARCH_IN_COMMENTS(value2);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c6\u0001\u0018\u00002\u00020\u0001R$\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00038V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel$Setting$SEARCH_REFERENCES;", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel$Setting;", "value", "", "state", "getState", "()Z", "setState", "(Z)V", "kotlin.refactorings.move.k2"})
        static final class SEARCH_REFERENCES
        extends Setting {
            /*
             * WARNING - void declaration
             */
            SEARCH_REFERENCES() {
                void var1_1;
            }

            @Override
            public boolean getState() {
                return KotlinCommonRefactoringSettings.Companion.getInstance().getMOVE_SEARCH_REFERENCES();
            }

            @Override
            public void setState(boolean value2) {
                KotlinCommonRefactoringSettings.Companion.getInstance().setMOVE_SEARCH_REFERENCES(value2);
            }
        }
    }
}

